/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.stegonaut;

import com.leon.saintsdragons.server.entity.dragons.stegonaut.Stegonaut;
import java.util.EnumSet;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.minecraft.class_5534;

public class StegonautLeaveWaterGoal
extends class_1352 {
    private static final int NEARBY_SEARCH_RADIUS = 6;
    private static final int RANDOM_SEARCH_ATTEMPTS = 12;
    private static final int PATH_RECHECK_DELAY = 20;
    private final Stegonaut drake;
    private final double moveSpeed;
    private class_243 targetPosition;
    private int pathCooldown;
    private boolean forcedStandDuringEscape;

    public StegonautLeaveWaterGoal(Stegonaut drake, double moveSpeed) {
        this.drake = drake;
        this.moveSpeed = moveSpeed;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18407));
    }

    public boolean method_6264() {
        if (!this.drake.method_5816()) {
            return false;
        }
        this.targetPosition = this.findDryLand();
        return this.targetPosition != null;
    }

    public boolean method_6266() {
        if (!this.drake.method_5816()) {
            return false;
        }
        if (this.targetPosition == null) {
            return false;
        }
        return !this.drake.method_5942().method_6357();
    }

    public void method_6269() {
        this.pathCooldown = 0;
        this.forcedStandDuringEscape = false;
        if (this.drake.method_24345()) {
            this.forcedStandDuringEscape = true;
            this.drake.method_24346(false);
        }
        this.moveToTarget();
    }

    public void method_6270() {
        this.drake.method_5942().method_6340();
        this.targetPosition = null;
        if (this.forcedStandDuringEscape) {
            this.drake.refreshCommandState();
        }
    }

    public void method_6268() {
        if (this.targetPosition == null) {
            return;
        }
        this.drake.method_5988().method_6230(this.targetPosition.field_1352, this.targetPosition.field_1351, this.targetPosition.field_1350, 45.0f, 45.0f);
        if (--this.pathCooldown <= 0) {
            if (!this.drake.method_5942().method_6337(this.targetPosition.field_1352, this.targetPosition.field_1351, this.targetPosition.field_1350, this.moveSpeed)) {
                this.targetPosition = this.findDryLand();
                if (this.targetPosition != null) {
                    this.drake.method_5942().method_6337(this.targetPosition.field_1352, this.targetPosition.field_1351, this.targetPosition.field_1350, this.moveSpeed);
                }
            }
            this.pathCooldown = 20;
        }
        if (this.drake.field_5976 && this.drake.method_5799()) {
            this.drake.method_18799(this.drake.method_18798().method_1031(0.0, 0.08, 0.0));
        }
    }

    private void moveToTarget() {
        if (this.targetPosition != null) {
            this.drake.method_5942().method_6337(this.targetPosition.field_1352, this.targetPosition.field_1351, this.targetPosition.field_1350, this.moveSpeed);
        }
    }

    private class_243 findDryLand() {
        class_243 nearby = this.searchNearbyDryLand();
        if (nearby != null) {
            return nearby;
        }
        return this.findRandomDryLand();
    }

    private class_243 searchNearbyDryLand() {
        class_1937 level = this.drake.method_37908();
        class_2338 origin = this.drake.method_24515();
        class_243 originCenter = class_243.method_24953((class_2382)origin);
        class_2338 bestCandidate = null;
        double bestDistance = Double.MAX_VALUE;
        for (int radius = 1; radius <= 6; ++radius) {
            int horizontalRadius = radius;
            for (class_2338 pos : class_2338.method_10097((class_2338)origin.method_10069(-horizontalRadius, -1, -horizontalRadius), (class_2338)origin.method_10069(horizontalRadius, 2, horizontalRadius))) {
                double distance;
                int dx = Math.abs(pos.method_10263() - origin.method_10263());
                int dz = Math.abs(pos.method_10260() - origin.method_10260());
                if (dx > radius || dz > radius || !this.isDryDestination(level, pos) || !((distance = pos.method_10268(originCenter.field_1352, originCenter.field_1351, originCenter.field_1350)) < bestDistance)) continue;
                bestDistance = distance;
                bestCandidate = pos.method_10062();
            }
            if (bestCandidate == null) continue;
            return class_243.method_24955(bestCandidate);
        }
        return null;
    }

    private class_243 findRandomDryLand() {
        class_1937 level = this.drake.method_37908();
        class_243 candidate = null;
        for (int attempts = 0; attempts < 12; ++attempts) {
            class_2338 blockPos;
            candidate = class_5534.method_31527((class_1314)this.drake, (int)24, (int)7);
            if (candidate == null || !this.isDryDestination(level, blockPos = class_2338.method_49638((class_2374)candidate))) continue;
            return class_243.method_24955((class_2382)blockPos);
        }
        class_2338 columnExit = this.climbColumnToFindAir();
        return columnExit != null ? class_243.method_24955((class_2382)columnExit) : null;
    }

    private class_2338 climbColumnToFindAir() {
        class_1937 level = this.drake.method_37908();
        class_2338.class_2339 cursor = this.drake.method_24515().method_25503();
        while (level.method_8316((class_2338)cursor).method_15767(class_3486.field_15517) && cursor.method_10264() < level.method_31600()) {
            cursor.method_10098(class_2350.field_11036);
        }
        if (level.method_8316((class_2338)cursor).method_15767(class_3486.field_15517)) {
            return null;
        }
        if (!this.isDryDestination(level, (class_2338)cursor)) {
            cursor.method_10098(class_2350.field_11036);
            if (!this.isDryDestination(level, (class_2338)cursor)) {
                return null;
            }
        }
        return cursor.method_10062();
    }

    private boolean isDryDestination(class_1937 level, class_2338 pos) {
        if (!level.method_8477(pos)) {
            return false;
        }
        if (!level.method_22347(pos)) {
            return false;
        }
        if (!level.method_8316(pos).method_15769()) {
            return false;
        }
        class_2338 below = pos.method_10074();
        class_2680 belowState = level.method_8320(below);
        if (!level.method_8316(below).method_15769()) {
            return false;
        }
        if (!belowState.method_26206((class_1922)level, below, class_2350.field_11036)) {
            return false;
        }
        class_2338 above = pos.method_10084();
        if (!(level.method_8477(above) && level.method_22347(above) && level.method_8316(above).method_15769())) {
            return false;
        }
        class_2338 twoAbove = above.method_10084();
        if (!level.method_8477(twoAbove)) {
            return true;
        }
        return level.method_22347(twoAbove) && level.method_8316(twoAbove).method_15769();
    }
}

