/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.stegonaut;

import com.leon.saintsdragons.server.entity.dragons.stegonaut.Stegonaut;
import com.leon.saintsdragons.server.entity.sleep.DragonRestManager;
import com.leon.saintsdragons.server.entity.sleep.DragonRestState;
import java.util.EnumSet;
import net.minecraft.class_1352;

public class StegonautSleepGoal
extends class_1352 {
    private final Stegonaut drake;
    private int retryCooldown;

    public StegonautSleepGoal(Stegonaut drake) {
        this.drake = drake;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18407));
    }

    public boolean method_6264() {
        boolean isNight;
        if (this.retryCooldown > 0) {
            --this.retryCooldown;
            return false;
        }
        if (this.drake.getRestManager().isResting()) {
            return true;
        }
        if (this.drake.method_24345()) {
            return false;
        }
        if (this.drake.isDying() || this.drake.method_5782()) {
            return false;
        }
        if (this.drake.method_5968() != null || this.drake.method_6510()) {
            return false;
        }
        long dayTime = this.drake.method_37908().method_8532() % 24000L;
        boolean bl = isNight = dayTime >= 13000L && dayTime < 23000L;
        if (!isNight) {
            return false;
        }
        if (this.drake.consumeDayNapQueued()) {
            return true;
        }
        return this.drake.method_6051().method_43057() < 0.001f;
    }

    public boolean method_6266() {
        boolean safeToRest = this.drake.method_5968() == null && !this.drake.method_6510();
        long dayTime = this.drake.method_37908().method_8532() % 24000L;
        boolean isNight = dayTime >= 13000L && dayTime < 23000L;
        return this.drake.getRestManager().isResting() && safeToRest && isNight;
    }

    public void method_6269() {
        DragonRestManager restManager = this.drake.getRestManager();
        if (restManager.isResting()) {
            return;
        }
        if (this.drake.consumeDayNapQueued()) {
            int napDuration = 1200 + this.drake.method_6051().method_43048(1200);
            this.drake.startNap();
            restManager.startRest(napDuration);
        } else {
            restManager.startRest(Integer.MAX_VALUE);
        }
        this.drake.method_24346(true);
        this.drake.method_5942().method_6340();
    }

    public void method_6268() {
        long dayTime;
        if (this.drake.method_37908().field_9236) {
            return;
        }
        DragonRestManager restManager = this.drake.getRestManager();
        DragonRestState state = restManager.getCurrentState();
        this.drake.method_5942().method_6340();
        this.drake.method_18800(0.0, this.drake.method_18798().field_1351, 0.0);
        if (!(state != DragonRestState.SITTING_DOWN && state != DragonRestState.SITTING || this.drake.method_24345())) {
            this.drake.method_24346(true);
        }
        boolean isNight = (dayTime = this.drake.method_37908().method_8532() % 24000L) >= 13000L && dayTime < 23000L;
        switch (state) {
            case SITTING_DOWN: {
                if (restManager.getStateTimer() <= 35) break;
                restManager.advanceState();
                break;
            }
            case SITTING: {
                if (restManager.getStateTimer() <= 10) break;
                restManager.advanceState();
                this.drake.startSleepEnter();
                break;
            }
            case FALLING_ASLEEP: {
                if ((!this.drake.method_6113() || this.drake.isSleepTransitioning()) && restManager.getStateTimer() <= 50) break;
                restManager.advanceState();
                break;
            }
            case SLEEPING: {
                boolean shouldWake;
                restManager.incrementRestingTicks();
                boolean bl = shouldWake = !isNight || restManager.getRestingTicks() >= restManager.getRestDuration();
                if (!shouldWake) break;
                restManager.advanceState();
                this.drake.startSleepExit();
                this.drake.method_24346(true);
                break;
            }
            case WAKING_UP: {
                if (restManager.getStateTimer() <= 45) break;
                restManager.advanceState();
                this.drake.method_24346(true);
                break;
            }
            case SITTING_AFTER: {
                if (restManager.getStateTimer() <= 10) break;
                restManager.advanceState();
                this.drake.method_24346(false);
                break;
            }
            case STANDING_UP: {
                if (restManager.getStateTimer() <= 30) break;
                restManager.advanceState();
                break;
            }
        }
        restManager.tick();
    }

    public void method_6270() {
        DragonRestManager restManager = this.drake.getRestManager();
        if (restManager.isResting() && restManager.getCurrentState() != DragonRestState.STANDING_UP) {
            if (this.drake.method_6113() || this.drake.isSleepTransitioning()) {
                this.drake.startSleepExit();
            }
            this.drake.method_24346(false);
            restManager.stopRest();
        }
        this.retryCooldown = 200 + this.drake.method_6051().method_43048(201);
    }

    public boolean method_6267() {
        return true;
    }
}

