/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.navigation;

import com.leon.saintsdragons.server.ai.navigation.DragonAmphibiousNodeEvaluator;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_13;
import net.minecraft.class_1308;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_5766;
import net.minecraft.class_7;
import org.jetbrains.annotations.NotNull;

public class DragonAmphibiousNavigation
extends class_5766 {
    private static final double MIN_PROGRESS_SQR = 0.12249999999999998;
    private static final int PROGRESS_TICKS = 20;
    private class_243 lastProgressSample = class_243.field_1353;
    private int lastProgressTick;
    private int stalledRepaths;

    public DragonAmphibiousNavigation(class_1308 mob, class_1937 level) {
        super(mob, level);
        this.method_6354(true);
        this.lastProgressSample = this.method_6347();
        this.lastProgressTick = this.field_6684.field_6012;
    }

    @NotNull
    protected class_13 method_6336(int maxVisitedNodes) {
        this.field_6678 = new DragonAmphibiousNodeEvaluator();
        return new class_13(this.field_6678, maxVisitedNodes);
    }

    public boolean method_6333(@NotNull class_2338 pos) {
        if (!this.field_6677.method_8316(pos).method_15769()) {
            return true;
        }
        class_2680 state = this.field_6677.method_8320(pos);
        if (state.method_26215()) {
            class_2680 below = this.field_6677.method_8320(pos.method_10074());
            return !below.method_26215() || !below.method_26227().method_15769();
        }
        return super.method_6333(pos);
    }

    protected void method_6339() {
        class_11 currentPath = this.field_6681;
        if (currentPath == null || currentPath.method_46()) {
            return;
        }
        class_243 entityPos = this.method_6347();
        this.tryAdvanceSameY(currentPath, entityPos);
        this.tryShortcut(currentPath, entityPos);
        if (currentPath.method_46()) {
            return;
        }
        class_243 target = currentPath.method_49((class_1297)this.field_6684);
        if (target == null) {
            return;
        }
        float reach = Math.max(0.8f, this.field_6684.method_17681() * 0.5f);
        if (entityPos.method_1025(target) < (double)(reach * reach)) {
            currentPath.method_44();
            if (currentPath.method_46()) {
                return;
            }
            target = currentPath.method_49((class_1297)this.field_6684);
            if (target == null) {
                return;
            }
        }
        this.field_6684.method_5962().method_6239(target.field_1352, target.field_1351, target.field_1350, this.field_6668);
        this.monitorProgress(entityPos, target);
    }

    private void tryAdvanceSameY(class_11 path, class_243 entityPos) {
        int next = path.method_39();
        int limit = path.method_38();
        double yFloor = Math.floor(entityPos.field_1351);
        for (int lastSameY = next; lastSameY < limit && (double)path.method_40((int)lastSameY).field_39 == yFloor; ++lastSameY) {
        }
        for (int i = lastSameY - 1; i > next; --i) {
            class_243 candidate = path.method_47((class_1297)this.field_6684, i);
            if (!this.hasLineOfSight(entityPos, candidate)) continue;
            path.method_42(i);
            return;
        }
    }

    private void tryShortcut(class_11 path, class_243 entityPos) {
        int max;
        int next = path.method_39();
        for (int i = max = Math.min(next + 6, path.method_38() - 1); i > next; --i) {
            class_243 candidate = path.method_47((class_1297)this.field_6684, i);
            if (!(candidate.method_1025(entityPos) <= 16.0) || !this.hasLineOfSight(entityPos, candidate)) continue;
            path.method_42(i);
            return;
        }
    }

    private void monitorProgress(class_243 entityPos, class_243 target) {
        if (this.field_6684.field_6012 - this.lastProgressTick < 20) {
            return;
        }
        if (entityPos.method_1025(this.lastProgressSample) < 0.12249999999999998) {
            this.method_6356();
            ++this.stalledRepaths;
            if (this.stalledRepaths >= 2) {
                this.nudgeSideways(entityPos, target);
                this.stalledRepaths = 0;
            }
        } else {
            this.stalledRepaths = 0;
        }
        this.lastProgressSample = entityPos;
        this.lastProgressTick = this.field_6684.field_6012;
    }

    private void nudgeSideways(class_243 current, class_243 target) {
        class_243 direction = target.method_1020(current);
        if (direction.method_1027() <= 1.0E-4) {
            return;
        }
        class_243 flatDir = new class_243(direction.field_1352, 0.0, direction.field_1350);
        if (flatDir.method_1027() <= 1.0E-4) {
            return;
        }
        class_243 perpendicular = new class_243(-flatDir.field_1350, 0.0, flatDir.field_1352).method_1029();
        double offset = Math.max(1.5, (double)this.field_6684.method_17681());
        double side = this.field_6684.method_6051().method_43056() ? offset : -offset;
        class_2338 sidePos = class_2338.method_49637((double)(current.field_1352 + perpendicular.field_1352 * side), (double)current.field_1351, (double)(current.field_1350 + perpendicular.field_1350 * side));
        if (this.method_6333(sidePos)) {
            this.method_6337((double)sidePos.method_10263() + 0.5, sidePos.method_10264(), (double)sidePos.method_10260() + 0.5, Math.max(1.0, this.field_6668));
        }
    }

    private boolean hasLineOfSight(class_243 from, class_243 to) {
        if (this.field_6678 == null) {
            return false;
        }
        class_243 delta = to.method_1020(from);
        double maxT = delta.method_1033();
        if (maxT < 1.0E-6) {
            return true;
        }
        double dx = delta.field_1352 / maxT;
        double dy = delta.field_1351 / maxT;
        double dz = delta.field_1350 / maxT;
        int currentX = class_3532.method_15357((double)from.field_1352);
        int currentY = class_3532.method_15357((double)from.field_1351);
        int currentZ = class_3532.method_15357((double)from.field_1350);
        double nextX = this.computeNextBoundary(from.field_1352, dx);
        double nextY = this.computeNextBoundary(from.field_1351, dy);
        double nextZ = this.computeNextBoundary(from.field_1350, dz);
        double deltaX = dx == 0.0 ? Double.POSITIVE_INFINITY : 1.0 / Math.abs(dx);
        double deltaY = dy == 0.0 ? Double.POSITIVE_INFINITY : 1.0 / Math.abs(dy);
        double deltaZ = dz == 0.0 ? Double.POSITIVE_INFINITY : 1.0 / Math.abs(dz);
        double t = 0.0;
        while (t <= maxT) {
            class_7 type = this.field_6678.method_25((class_1922)this.field_6677, currentX, currentY, currentZ, this.field_6684);
            float malus = this.field_6684.method_5944(type);
            if (malus < 0.0f || malus >= 8.0f || type == class_7.field_3 || type == class_7.field_17) {
                return false;
            }
            if (nextX < nextY) {
                if (nextX < nextZ) {
                    currentX += dx > 0.0 ? 1 : -1;
                    t = nextX;
                    nextX += deltaX;
                    continue;
                }
                currentZ += dz > 0.0 ? 1 : -1;
                t = nextZ;
                nextZ += deltaZ;
                continue;
            }
            if (nextY < nextZ) {
                currentY += dy > 0.0 ? 1 : -1;
                t = nextY;
                nextY += deltaY;
                continue;
            }
            currentZ += dz > 0.0 ? 1 : -1;
            t = nextZ;
            nextZ += deltaZ;
        }
        return true;
    }

    private double computeNextBoundary(double start, double direction) {
        if (direction == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        double boundary = direction > 0.0 ? (double)(class_3532.method_15357((double)start) + 1) : (double)class_3532.method_15357((double)start);
        return (boundary - start) / direction;
    }

    public void method_6340() {
        super.method_6340();
        this.stalledRepaths = 0;
        this.lastProgressSample = this.method_6347();
        this.lastProgressTick = this.field_6684.field_6012;
    }
}

