/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.navigation;

import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.interfaces.DragonFlightCapable;
import com.leon.saintsdragons.util.DragonMathUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1335;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class DragonFlightMoveHelper
extends class_1335 {
    private final DragonFlightCapable dragon;
    private final class_1308 mob;
    private float speedFactor = 1.0f;
    private final float maxYawChange;
    private final float maxPitchChange;
    private final float speedFactorMin;
    private final float speedFactorMax;
    private final float speedTransitionRate;
    private final double accelerationCap;
    private final double velocityBlendRate;

    public DragonFlightMoveHelper(DragonFlightCapable dragon) {
        this(dragon, DragonFlightMoveHelper.getDefaultParameters());
    }

    public DragonFlightMoveHelper(DragonFlightCapable dragon, FlightParameters params) {
        super((class_1308)dragon);
        this.dragon = dragon;
        this.mob = (class_1308)dragon;
        this.maxYawChange = params.maxYawChange;
        this.maxPitchChange = params.maxPitchChange;
        this.speedFactorMin = params.speedFactorMin;
        this.speedFactorMax = params.speedFactorMax;
        this.speedTransitionRate = params.speedTransitionRate;
        this.accelerationCap = params.accelerationCap;
        this.velocityBlendRate = params.velocityBlendRate;
    }

    private static FlightParameters getDefaultParameters() {
        return new FlightParameters(4.0f, 8.0f, 0.5f, 3.2f, 0.15f, 0.22, 0.16);
    }

    public void method_6240() {
        if (this.field_6374 != class_1335.class_1336.field_6378) {
            return;
        }
        if (this.dragon.isHovering() || this.dragon.isLanding()) {
            this.handleHoveringMovement();
        } else {
            this.handleGlidingMovement();
        }
    }

    private void handleGlidingMovement() {
        DragonEntity baseDragon;
        boolean isFlying;
        float targetSpeedFactor;
        double totalDist;
        if (this.mob.field_5976) {
            this.mob.method_36456(this.mob.method_36454() + 180.0f);
            this.speedFactor = this.speedFactorMin;
            this.mob.method_5942().method_6340();
            return;
        }
        float distX = (float)(this.field_6370 - this.mob.method_23317());
        float distY = (float)(this.field_6369 - this.mob.method_23318());
        float distZ = (float)(this.field_6367 - this.mob.method_23321());
        double horizontalDist = Math.sqrt(distX * distX + distZ * distZ);
        if (horizontalDist > 1.0E-6) {
            double yFractionReduction = 1.0 - (double)class_3532.method_15379((float)(distY * 0.7f)) / horizontalDist;
            distX = (float)((double)distX * yFractionReduction);
            distZ = (float)((double)distZ * yFractionReduction);
            horizontalDist = Math.sqrt(distX * distX + distZ * distZ);
        }
        if ((totalDist = Math.sqrt(distX * distX + distZ * distZ + distY * distY)) < 1.0E-6) {
            this.field_6374 = class_1335.class_1336.field_6377;
            return;
        }
        float currentYaw = this.mob.method_36454();
        float desiredYaw = (float)class_3532.method_15349((double)distZ, (double)distX) * 57.295776f;
        float wrappedCurrentYaw = class_3532.method_15393((float)(currentYaw + 90.0f));
        float wrappedDesiredYaw = class_3532.method_15393((float)desiredYaw);
        this.mob.method_36456(class_3532.method_15388((float)wrappedCurrentYaw, (float)wrappedDesiredYaw, (float)this.maxYawChange) - 90.0f);
        this.mob.field_6283 = this.mob.method_36454();
        float desiredPitch = (float)(-(class_3532.method_15349((double)(-distY), (double)horizontalDist) * 57.2957763671875));
        this.mob.method_36457(class_3532.method_15388((float)this.mob.method_36455(), (float)desiredPitch, (float)this.maxPitchChange));
        float yawDifference = Math.abs(class_3532.method_15393((float)(this.mob.method_36454() - currentYaw)));
        if (yawDifference < 3.0f) {
            targetSpeedFactor = this.speedFactorMax;
        } else {
            float turnSeverity = class_3532.method_15363((float)(yawDifference / 15.0f), (float)0.0f, (float)1.0f);
            targetSpeedFactor = DragonMathUtil.lerpSmooth(0.6f, this.speedFactorMax, 1.0f - turnSeverity, DragonMathUtil.EasingFunction.EASE_OUT_SINE);
        }
        float distScale = class_3532.method_15363((float)((float)(totalDist / 45.0) + 0.35f), (float)0.35f, (float)1.0f);
        targetSpeedFactor *= distScale;
        class_1309 target = this.mob.method_5968();
        DragonFlightCapable dragonFlightCapable = this.dragon;
        boolean bl = isFlying = dragonFlightCapable instanceof DragonEntity && (baseDragon = (DragonEntity)((Object)dragonFlightCapable)).method_6581();
        if (isFlying && target != null && target.method_5805()) {
            targetSpeedFactor *= 1.12f;
        }
        if (this.isLineObstructed(this.mob.method_19538(), new class_243(this.field_6370, this.field_6369, this.field_6367))) {
            targetSpeedFactor *= 0.5f;
        }
        this.speedFactor = class_3532.method_15363((float)class_3532.method_15348((float)this.speedFactor, (float)targetSpeedFactor, (float)this.speedTransitionRate), (float)this.speedFactorMin, (float)this.speedFactorMax);
        class_243 dir = new class_243((double)distX, (double)distY, (double)distZ).method_1021(1.0 / totalDist);
        class_243 motion = this.mob.method_18798();
        class_243 targetVel = dir.method_1021((double)this.speedFactor);
        class_243 delta = targetVel.method_1020(motion).method_1021(this.velocityBlendRate);
        double accelCap = this.accelerationCap;
        if (this.isLineObstructed(this.mob.method_19538(), new class_243(this.field_6370, this.field_6369, this.field_6367))) {
            accelCap *= 0.6;
            delta = delta.method_1021(0.6);
        }
        delta = DragonFlightMoveHelper.clampPerAxis(delta, accelCap);
        class_243 blended = motion.method_1019(delta);
        this.mob.method_18799(blended);
    }

    private void handleHoveringMovement() {
        float yawErr;
        class_1309 target = this.mob.method_5968();
        if (target != null && this.mob.method_5858((class_1297)target) < 1600.0 && (yawErr = DragonMathUtil.yawErrorToTarget((class_1297)this.mob, (class_1297)target)) > 4.0f) {
            DragonMathUtil.smoothLookAt((class_1309)this.mob, (class_1297)target, 10.0f, 10.0f);
        }
        if (this.field_6374 == class_1335.class_1336.field_6378) {
            class_243 targetVec = new class_243(this.field_6370 - this.mob.method_23317(), this.field_6369 - this.mob.method_23318(), this.field_6367 - this.mob.method_23321());
            double distance = targetVec.method_1033();
            if (this.checkCollisions(targetVec = targetVec.method_1029(), class_3532.method_15384((double)distance))) {
                this.mob.method_18799(this.mob.method_18798().method_1019(targetVec.method_1021(0.1)));
            } else {
                this.field_6374 = class_1335.class_1336.field_6377;
            }
        }
    }

    private boolean checkCollisions(class_243 direction, int steps) {
        class_238 boundingBox = this.mob.method_5829();
        for (int i = 1; i < steps; ++i) {
            boundingBox = boundingBox.method_997(direction);
            if (this.mob.method_37908().method_8587((class_1297)this.mob, boundingBox)) continue;
            return false;
        }
        return true;
    }

    private static class_243 clampPerAxis(class_243 v, double cap) {
        double cx = class_3532.method_15350((double)v.field_1352, (double)(-cap), (double)cap);
        double cy = class_3532.method_15350((double)v.field_1351, (double)(-cap), (double)cap);
        double cz = class_3532.method_15350((double)v.field_1350, (double)(-cap), (double)cap);
        return new class_243(cx, cy, cz);
    }

    private boolean isLineObstructed(class_243 from, class_243 to) {
        class_3965 hit = this.mob.method_37908().method_17742(new class_3959(from, to, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.mob));
        return hit.method_17783() != class_239.class_240.field_1333;
    }

    public boolean hasGivenUp() {
        return this.field_6374 == class_1335.class_1336.field_6377;
    }

    public static class FlightParameters {
        public final float maxYawChange;
        public final float maxPitchChange;
        public final float speedFactorMin;
        public final float speedFactorMax;
        public final float speedTransitionRate;
        public final double accelerationCap;
        public final double velocityBlendRate;

        public FlightParameters(float maxYawChange, float maxPitchChange, float speedFactorMin, float speedFactorMax, float speedTransitionRate, double accelerationCap, double velocityBlendRate) {
            this.maxYawChange = maxYawChange;
            this.maxPitchChange = maxPitchChange;
            this.speedFactorMin = speedFactorMin;
            this.speedFactorMax = speedFactorMax;
            this.speedTransitionRate = speedTransitionRate;
            this.accelerationCap = accelerationCap;
            this.velocityBlendRate = velocityBlendRate;
        }
    }
}

