/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.navigation;

import com.leon.saintsdragons.server.ai.navigation.DragonPathFinder;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_13;
import net.minecraft.class_1308;
import net.minecraft.class_14;
import net.minecraft.class_1409;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_7;
import org.jetbrains.annotations.NotNull;

public class DragonPathNavigateGround
extends class_1409 {
    public DragonPathNavigateGround(class_1308 mob, class_1937 world) {
        super(mob, world);
    }

    @NotNull
    protected class_13 method_6336(int maxVisitedNodes) {
        this.field_6678 = new class_14();
        this.field_6678.method_15(true);
        return new DragonPathFinder(this.field_6678, maxVisitedNodes);
    }

    protected void method_6339() {
        class_11 path = Objects.requireNonNull(this.field_6681);
        class_243 entityPos = this.method_6347();
        int pathLength = path.method_38();
        for (int i = path.method_39(); i < path.method_38(); ++i) {
            if ((double)path.method_40((int)i).field_39 == Math.floor(entityPos.field_1351)) continue;
            pathLength = i;
            break;
        }
        class_243 base = entityPos.method_1031((double)(-this.field_6684.method_17681() * 0.5f), 0.0, (double)(-this.field_6684.method_17681() * 0.5f));
        class_243 max = base.method_1031((double)this.field_6684.method_17681(), (double)this.field_6684.method_17682(), (double)this.field_6684.method_17681());
        if (this.tryShortcut(path, new class_243(this.field_6684.method_23317(), this.field_6684.method_23318(), this.field_6684.method_23321()), pathLength, base, max) && (this.isAt(path, 0.5f) || this.atElevationChange(path) && this.isAt(path, this.field_6684.method_17681() * 0.5f))) {
            path.method_42(path.method_39() + 1);
        }
        this.method_6346(entityPos);
    }

    private boolean isAt(class_11 path, float threshold) {
        class_243 pathPos = path.method_49((class_1297)this.field_6684);
        return class_3532.method_15379((float)((float)(this.field_6684.method_23317() - pathPos.field_1352))) < threshold && class_3532.method_15379((float)((float)(this.field_6684.method_23321() - pathPos.field_1350))) < threshold && Math.abs(this.field_6684.method_23318() - pathPos.field_1351) < 1.0;
    }

    private boolean atElevationChange(class_11 path) {
        int curr = path.method_39();
        int end = Math.min(path.method_38(), curr + class_3532.method_15386((float)(this.field_6684.method_17681() * 0.5f)) + 1);
        int currY = path.method_40((int)curr).field_39;
        for (int i = curr + 1; i < end; ++i) {
            if (path.method_40((int)i).field_39 == currY) continue;
            return true;
        }
        return false;
    }

    private boolean tryShortcut(class_11 path, class_243 entityPos, int pathLength, class_243 base, class_243 max) {
        int i = pathLength;
        while (--i > path.method_39()) {
            class_243 vec = path.method_47((class_1297)this.field_6684, i).method_1020(entityPos);
            if (!this.sweep(vec, base, max)) continue;
            path.method_42(i);
            return false;
        }
        return true;
    }

    private boolean sweep(class_243 vec, class_243 base, class_243 max) {
        float distance = (float)vec.method_1033();
        if (distance < 1.0E-8f) {
            return true;
        }
        if (distance < 3.0f) {
            return true;
        }
        return true;
    }

    protected boolean method_26338(@Nonnull class_7 pathType) {
        if (pathType == class_7.field_18) {
            return false;
        }
        if (pathType == class_7.field_14) {
            return false;
        }
        return pathType != class_7.field_7;
    }
}

