/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.command;

import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.handler.DragonAllyManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class DragonAllyCommand {
    private static final SuggestionProvider<class_2168> DRAGON_SUGGESTIONS = (context, builder) -> {
        class_2168 source = (class_2168)context.getSource();
        return class_2172.method_9264(source.method_9225().method_18467(DragonEntity.class, source.method_9228() != null ? source.method_9228().method_5829().method_1014(50.0) : class_238.method_30048((class_243)source.method_9222(), (double)100.0, (double)100.0, (double)100.0)).stream().filter(dragon -> dragon.method_6181() && source.method_9228() instanceof class_1657 && dragon.method_6171((class_1309)((class_1657)source.method_9228()))).map(dragon -> String.valueOf(dragon.method_5628())), (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"dragonally").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"drake", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"username", (ArgumentType)StringArgumentType.string()).executes(DragonAllyCommand::addAlly))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"drake", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"username", (ArgumentType)StringArgumentType.string()).executes(DragonAllyCommand::removeAlly))))).then(class_2170.method_9247((String)"list").then(class_2170.method_9244((String)"drake", (ArgumentType)class_2186.method_9309()).executes(DragonAllyCommand::listAllies)))).then(class_2170.method_9247((String)"clear").then(class_2170.method_9244((String)"drake", (ArgumentType)class_2186.method_9309()).executes(DragonAllyCommand::clearAllies))));
    }

    private static int addAlly(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        Collection entities = class_2186.method_9317(context, (String)"drake");
        String username = StringArgumentType.getString(context, (String)"username");
        int successCount = 0;
        for (class_1297 entity : entities) {
            if (entity instanceof DragonEntity) {
                DragonEntity dragon = (DragonEntity)entity;
                DragonAllyManager.AllyResult result = dragon.allyManager.addAlly(username);
                class_5250 message = class_2561.method_43469((String)"saintsdragons.command.ally.add.result", (Object[])new Object[]{dragon.method_5476(), username, result.getMessage()});
                source.method_9226(() -> DragonAllyCommand.lambda$addAlly$4((class_2561)message), false);
                if (!result.isSuccess()) continue;
                ++successCount;
                continue;
            }
            source.method_9213((class_2561)class_2561.method_43469((String)"saintsdragons.command.ally.not_dragon", (Object[])new Object[]{entity.method_5476()}));
        }
        return successCount;
    }

    private static int removeAlly(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        Collection entities = class_2186.method_9317(context, (String)"drake");
        String username = StringArgumentType.getString(context, (String)"username");
        int successCount = 0;
        for (class_1297 entity : entities) {
            if (entity instanceof DragonEntity) {
                DragonEntity dragon = (DragonEntity)entity;
                DragonAllyManager.AllyResult result = dragon.allyManager.removeAlly(username);
                class_5250 message = class_2561.method_43469((String)"saintsdragons.command.ally.remove.result", (Object[])new Object[]{dragon.method_5476(), username, result.getMessage()});
                source.method_9226(() -> DragonAllyCommand.lambda$removeAlly$5((class_2561)message), false);
                if (!result.isSuccess()) continue;
                ++successCount;
                continue;
            }
            source.method_9213((class_2561)class_2561.method_43469((String)"saintsdragons.command.ally.not_dragon", (Object[])new Object[]{entity.method_5476()}));
        }
        return successCount;
    }

    private static int listAllies(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        Collection entities = class_2186.method_9317(context, (String)"drake");
        for (class_1297 entity : entities) {
            if (entity instanceof DragonEntity) {
                DragonEntity dragon = (DragonEntity)entity;
                List<String> allies = dragon.allyManager.getAllyUsernames();
                class_5250 header = class_2561.method_43469((String)"saintsdragons.command.ally.list.header", (Object[])new Object[]{dragon.method_5476(), allies.size(), dragon.allyManager.getMaxAllies()});
                source.method_9226(() -> DragonAllyCommand.lambda$listAllies$6((class_2561)header), false);
                if (allies.isEmpty()) {
                    source.method_9226(() -> class_2561.method_43471((String)"saintsdragons.command.ally.list.empty"), false);
                    continue;
                }
                for (String ally : allies) {
                    source.method_9226(() -> class_2561.method_43470((String)("  - " + ally)), false);
                }
                continue;
            }
            source.method_9213((class_2561)class_2561.method_43469((String)"saintsdragons.command.ally.not_dragon", (Object[])new Object[]{entity.method_5476()}));
        }
        return entities.size();
    }

    private static int clearAllies(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        Collection entities = class_2186.method_9317(context, (String)"drake");
        int successCount = 0;
        for (class_1297 entity : entities) {
            if (entity instanceof DragonEntity) {
                DragonEntity dragon = (DragonEntity)entity;
                dragon.allyManager.clearAllies();
                class_5250 message = class_2561.method_43469((String)"saintsdragons.command.ally.clear.success", (Object[])new Object[]{dragon.method_5476()});
                source.method_9226(() -> DragonAllyCommand.lambda$clearAllies$9((class_2561)message), false);
                ++successCount;
                continue;
            }
            source.method_9213((class_2561)class_2561.method_43469((String)"saintsdragons.command.ally.not_dragon", (Object[])new Object[]{entity.method_5476()}));
        }
        return successCount;
    }

    private static /* synthetic */ class_2561 lambda$clearAllies$9(class_2561 message) {
        return message;
    }

    private static /* synthetic */ class_2561 lambda$listAllies$6(class_2561 header) {
        return header;
    }

    private static /* synthetic */ class_2561 lambda$removeAlly$5(class_2561 message) {
        return message;
    }

    private static /* synthetic */ class_2561 lambda$addAlly$4(class_2561 message) {
        return message;
    }
}

