/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability;

import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import java.util.Random;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public abstract class DragonAbility<T extends class_1309> {
    private final DragonAbilitySection[] sectionTrack;
    protected int cooldownMax;
    private final DragonAbilityType<T, ? extends DragonAbility<T>> abilityType;
    private final T user;
    private int ticksInUse;
    private int ticksInSection;
    private int currentSectionIndex;
    private boolean isUsing;
    private int cooldownTimer;
    protected Random rand;
    protected RawAnimation activeAnimation;

    public DragonAbility(DragonAbilityType<T, ? extends DragonAbility<T>> abilityType, T user, DragonAbilitySection[] sectionTrack, int cooldownMax) {
        this.abilityType = abilityType;
        this.user = user;
        this.sectionTrack = sectionTrack;
        this.cooldownMax = cooldownMax;
        this.rand = new Random();
    }

    public DragonAbility(DragonAbilityType<T, ? extends DragonAbility<T>> abilityType, T user, DragonAbilitySection[] sectionTrack) {
        this(abilityType, user, sectionTrack, 0);
    }

    public void start() {
        if (this.user instanceof DragonAbilityEntity) {
            ((DragonAbilityEntity)this.user).setActiveAbility(this);
        }
        this.ticksInUse = 0;
        this.ticksInSection = 0;
        this.currentSectionIndex = 0;
        this.isUsing = true;
        this.beginSection(this.getSectionTrack()[0]);
    }

    public void tick() {
        if (this.isUsing()) {
            if (this.getUser().method_6034() && !this.canContinueUsing()) {
                this.interrupt();
                return;
            }
            this.tickUsing();
            ++this.ticksInUse;
            ++this.ticksInSection;
            DragonAbilitySection section = this.getCurrentSection();
            if (section instanceof DragonAbilitySection.AbilitySectionInstant) {
                this.nextSection();
            } else if (section instanceof DragonAbilitySection.AbilitySectionDuration) {
                DragonAbilitySection.AbilitySectionDuration sectionDuration = (DragonAbilitySection.AbilitySectionDuration)section;
                if (this.ticksInSection > sectionDuration.duration) {
                    this.nextSection();
                }
            }
        } else {
            this.tickNotUsing();
            if (this.getCooldownTimer() > 0) {
                --this.cooldownTimer;
            }
        }
    }

    public void end() {
        this.ticksInUse = 0;
        this.ticksInSection = 0;
        this.isUsing = false;
        this.cooldownTimer = this.getMaxCooldown();
        this.currentSectionIndex = 0;
        if (this.user instanceof DragonAbilityEntity) {
            ((DragonAbilityEntity)this.user).setActiveAbility(null);
        }
    }

    public void interrupt() {
        this.end();
    }

    public void complete() {
        this.end();
    }

    public void playAnimation(RawAnimation animation) {
        this.activeAnimation = animation;
        if (this.user instanceof DragonAbilityEntity) {
            ((DragonAbilityEntity)this.user).playDragonAnimation(animation);
        }
    }

    public <E extends GeoEntity> PlayState animationPredicate(AnimationState<E> e) {
        if (this.activeAnimation == null || this.activeAnimation.getAnimationStages().isEmpty()) {
            return PlayState.STOP;
        }
        e.getController().setAnimation(this.activeAnimation);
        return PlayState.CONTINUE;
    }

    public void nextSection() {
        this.jumpToSection(this.currentSectionIndex + 1);
    }

    public void jumpToSection(int sectionIndex) {
        this.endSection(this.getCurrentSection());
        this.currentSectionIndex = sectionIndex;
        this.ticksInSection = 0;
        if (this.currentSectionIndex >= this.getSectionTrack().length) {
            this.complete();
        } else {
            this.beginSection(this.getCurrentSection());
        }
    }

    public boolean isOverlayAbility() {
        return false;
    }

    public void tickUsing() {
    }

    public void tickNotUsing() {
    }

    protected void beginSection(DragonAbilitySection section) {
    }

    protected void endSection(DragonAbilitySection section) {
    }

    public boolean canUse() {
        return !this.isUsing() && this.cooldownTimer == 0;
    }

    public boolean tryAbility() {
        return true;
    }

    protected boolean canContinueUsing() {
        return true;
    }

    public boolean damageInterrupts() {
        return false;
    }

    public boolean isUsing() {
        return this.isUsing;
    }

    public T getUser() {
        return this.user;
    }

    public class_1937 getLevel() {
        return this.user.method_37908();
    }

    public int getTicksInUse() {
        return this.ticksInUse;
    }

    public int getTicksInSection() {
        return this.ticksInSection;
    }

    public int getCooldownTimer() {
        return this.cooldownTimer;
    }

    public DragonAbilitySection getCurrentSection() {
        if (this.currentSectionIndex >= this.getSectionTrack().length) {
            return null;
        }
        return this.getSectionTrack()[this.currentSectionIndex];
    }

    public int getCurrentSectionIndex() {
        return this.currentSectionIndex;
    }

    public DragonAbilitySection[] getSectionTrack() {
        return this.sectionTrack;
    }

    public int getMaxCooldown() {
        return this.cooldownMax;
    }

    public DragonAbilityType<T, ? extends DragonAbility<T>> getAbilityType() {
        return this.abilityType;
    }

    public boolean isAnimating() {
        return this.isUsing();
    }

    public static interface DragonAbilityEntity {
        public void setActiveAbility(DragonAbility<?> var1);

        public DragonAbility<?> getActiveAbility();

        public void playDragonAnimation(RawAnimation var1);

        public DragonAbilityType<?, ?>[] getDragonAbilities();
    }
}

