/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.cindervane;

import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.dragons.cindervane.Cindervane;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_5134;

public class CindervaneBiteAbility
extends DragonAbility<Cindervane> {
    private static final float BASE_DAMAGE = 12.0f;
    private static final double BASE_RANGE = 10.0;
    private static final double RIDDEN_RANGE_BONUS = 10.0;
    private static final double AIR_RANGE_BONUS = 0.6;
    private static final double HIT_ANGLE_COS = Math.cos(Math.toRadians(75.0));
    private static final DragonAbilitySection[] TRACK = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.STARTUP, 5), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.ACTIVE, 2), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.RECOVERY, 5)};
    private boolean appliedHit;

    public CindervaneBiteAbility(DragonAbilityType<Cindervane, CindervaneBiteAbility> type, Cindervane user) {
        super(type, user, TRACK, 15);
    }

    @Override
    protected void beginSection(DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            Cindervane dragon = (Cindervane)this.getUser();
            dragon.triggerAnim("actions", "bite");
            this.appliedHit = false;
        }
    }

    @Override
    public void tickUsing() {
        DragonAbilitySection section = this.getCurrentSection();
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.ACTIVE && !this.appliedHit) {
            class_1309 currentTarget;
            Cindervane dragon = (Cindervane)this.getUser();
            List<class_1309> targets = this.selectTargets();
            if (targets.isEmpty() && (currentTarget = dragon.method_5968()) != null && currentTarget.method_5805() && !dragon.isAlly((class_1297)currentTarget)) {
                targets = List.of(currentTarget);
            }
            for (class_1309 target : targets) {
                this.applyHit(dragon, target);
            }
            this.appliedHit = true;
        }
    }

    private void applyHit(Cindervane dragon, class_1309 target) {
        double value;
        float damage = 12.0f;
        class_1324 attackAttr = dragon.method_5996(class_5134.field_23721);
        if (attackAttr != null && (value = attackAttr.method_6194()) > 0.0) {
            damage = (float)value;
        }
        class_1282 source = dragon.method_37908().method_48963().method_48812((class_1309)dragon);
        target.method_5643(source, damage);
        class_243 push = dragon.method_5720().method_1021(0.3);
        target.method_5762(push.field_1352, dragon.method_6581() ? 0.15 : 0.05, push.field_1350);
    }

    private List<class_1309> selectTargets() {
        Cindervane dragon = (Cindervane)this.getUser();
        double range = 10.0;
        if (dragon.method_5642() != null) {
            range += 10.0;
        }
        if (dragon.method_6581()) {
            range += 0.6;
        }
        class_243 origin = dragon.getMouthPosition();
        class_243 look = dragon.method_5720().method_1029();
        class_243 end = origin.method_1019(look.method_1021(range));
        class_238 sweep = new class_238(origin, end).method_1009(1.2, 1.0, 1.2);
        List candidates = dragon.method_37908().method_8390(class_1309.class, sweep, entity -> entity != dragon && entity.method_5805() && entity.method_6102() && !dragon.isAlly((class_1297)entity));
        double effectiveRange = range;
        ArrayList<class_1309> results = new ArrayList<class_1309>();
        candidates.stream().map(entity -> {
            double closeEnough;
            class_243 center = entity.method_5829().method_1005();
            class_243 toward = center.method_1020(origin);
            double distanceSqr = toward.method_1027();
            if (distanceSqr < 1.0E-6) {
                return new TargetScore((class_1309)entity, 1.0, 0.0);
            }
            class_243 dir = toward.method_1029();
            double dot = dir.method_1026(look);
            if (dot < HIT_ANGLE_COS && (closeEnough = center.method_1025(origin)) > effectiveRange * effectiveRange * 0.64) {
                return null;
            }
            return new TargetScore((class_1309)entity, dot, distanceSqr);
        }).filter(Objects::nonNull).sorted(Comparator.comparingDouble(TargetScore::dot).reversed().thenComparingDouble(TargetScore::distanceSqr)).map(TargetScore::entity).forEach(entity -> {
            if (!results.contains(entity)) {
                results.add((class_1309)entity);
            }
        });
        return results;
    }

    private record TargetScore(class_1309 entity, double dot, double distanceSqr) {
    }
}

