/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.cindervane;

import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.dragons.cindervane.Cindervane;
import java.util.HashSet;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

public class CindervaneFireBodyAbility
extends DragonAbility<Cindervane> {
    private static final DragonAbilitySection[] TRACK = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.STARTUP, 1), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.ACTIVE, 1000)};
    private static final double AURA_RADIUS = 3.5;
    private static final double AURA_VERTICAL = 2.5;
    private static final float BASE_DAMAGE = 3.0f;
    private static final int FIRE_SECONDS = 4;
    private static final int ALLY_FIRE_RESIST_TICKS = 60;
    private static final int ALLY_DAMAGE_RESIST_TICKS = 40;
    private int activeTicks;

    public CindervaneFireBodyAbility(DragonAbilityType<Cindervane, CindervaneFireBodyAbility> type, Cindervane user) {
        super(type, user, TRACK, 40);
    }

    @Override
    public boolean isOverlayAbility() {
        return true;
    }

    @Override
    protected void beginSection(DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            this.activeTicks = 0;
            ((Cindervane)this.getUser()).setBreathingFire(true);
            class_1937 level = this.getLevel();
            level.method_8396(null, ((Cindervane)this.getUser()).method_24515(), class_3417.field_15013, ((Cindervane)this.getUser()).method_5634(), 1.2f, 1.0f + ((Cindervane)this.getUser()).method_6051().method_43057() * 0.2f);
        } else if (section.sectionType == DragonAbilitySection.AbilitySectionType.ACTIVE) {
            ((Cindervane)this.getUser()).setBreathingFire(true);
        }
    }

    @Override
    protected void endSection(DragonAbilitySection section) {
        if (section != null && section.sectionType == DragonAbilitySection.AbilitySectionType.ACTIVE) {
            ((Cindervane)this.getUser()).setBreathingFire(false);
        }
    }

    @Override
    public void interrupt() {
        ((Cindervane)this.getUser()).setBreathingFire(false);
        super.interrupt();
    }

    @Override
    protected boolean canContinueUsing() {
        Cindervane dragon = (Cindervane)this.getUser();
        if (!dragon.method_5805() || dragon.method_31481()) {
            return false;
        }
        return !dragon.method_5816();
    }

    @Override
    public void tickUsing() {
        Cindervane dragon = (Cindervane)this.getUser();
        class_1937 level = dragon.method_37908();
        if (!level.field_9236) {
            ++this.activeTicks;
            this.applyFireAura((class_3218)level, dragon);
            if (this.activeTicks % 20 == 0) {
                level.method_8396(null, dragon.method_24515(), class_3417.field_14970, dragon.method_5634(), 0.6f, 0.9f + dragon.method_6051().method_43057() * 0.2f);
            }
        }
    }

    private void applyFireAura(class_3218 level, Cindervane dragon) {
        class_243 center = dragon.method_19538().method_1031(0.0, (double)dragon.method_17682() * 0.5, 0.0);
        class_238 area = dragon.method_5829().method_1009(3.5, 2.5, 3.5);
        this.protectAllies(level, dragon, area);
        HashSet<class_1309> hitThisTick = new HashSet<class_1309>();
        for (class_1309 target : level.method_8390(class_1309.class, area, e -> e != dragon && e.method_5805() && e.method_6102() && !dragon.isAlly((class_1297)e))) {
            if (!hitThisTick.add(target)) continue;
            float damage = 3.0f;
            target.method_5643(level.method_48963().method_48833(), damage);
            target.method_5639(4);
            class_243 pushDir = target.method_19538().method_1020(center);
            if (!(pushDir.method_1027() > 1.0E-4)) continue;
            pushDir = pushDir.method_1029().method_1021(0.15);
            target.method_5762(pushDir.field_1352, 0.05, pushDir.field_1350);
        }
        class_5819 rng = dragon.method_6051();
        for (int i = 0; i < 12; ++i) {
            double angle = rng.method_43058() * (Math.PI * 2);
            double radius = 0.5 + rng.method_43058() * 3.0;
            double height = rng.method_43058() * 2.5;
            class_243 sample = center.method_1031(Math.cos(angle) * radius, -1.25 + height, Math.sin(angle) * radius);
            this.spawnParticles(level, sample);
            this.maybeIgnite(level, sample, dragon);
        }
    }

    private void spawnParticles(class_3218 level, class_243 sample) {
        double spread = 0.6;
        int flameCount = 12;
        int emberCount = 9;
        int smokeCount = 6;
        level.method_14199((class_2394)class_2398.field_11240, sample.field_1352, sample.field_1351, sample.field_1350, flameCount, spread, spread * 0.6, spread, 0.05);
        level.method_14199((class_2394)class_2398.field_27783, sample.field_1352, sample.field_1351, sample.field_1350, emberCount, spread * 0.4, spread * 0.25, spread * 0.4, 0.02);
        level.method_14199((class_2394)class_2398.field_11239, sample.field_1352, sample.field_1351, sample.field_1350, 3, spread * 0.2, spread * 0.2, spread * 0.2, 0.07);
        level.method_14199((class_2394)class_2398.field_11237, sample.field_1352, sample.field_1351, sample.field_1350, smokeCount, spread * 0.8, spread * 0.4, spread * 0.8, 0.0);
    }

    private void maybeIgnite(class_3218 level, class_243 sample, Cindervane dragon) {
        if (dragon.method_6051().method_43057() > 0.12f) {
            return;
        }
        class_2338 pos = class_2338.method_49637((double)sample.field_1352, (double)(sample.field_1351 - 0.5), (double)sample.field_1350);
        if (!level.method_8477(pos) || !level.method_22347(pos)) {
            return;
        }
        class_2338 below = pos.method_10074();
        class_2680 belowState = level.method_8320(below);
        if (belowState.method_26215()) {
            return;
        }
        if (class_2246.field_10036.method_9564().method_26184((class_4538)level, pos) && belowState.method_26206((class_1922)level, below, class_2350.field_11036)) {
            level.method_8652(pos, class_2246.field_10036.method_9564(), 11);
        }
    }

    private void protectAllies(class_3218 level, Cindervane dragon, class_238 area) {
        class_238 expanded = area.method_1009(1.5, 0.75, 1.5);
        for (class_1309 ally : level.method_8390(class_1309.class, expanded, entity -> entity != dragon && entity.method_5805() && dragon.isAlly((class_1297)entity))) {
            ally.method_6092(new class_1293(class_1294.field_5918, 60, 0, true, false, false));
            ally.method_6092(new class_1293(class_1294.field_5907, 40, 4, true, false, false));
            ally.method_20803(0);
        }
    }
}

