/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.cindervane;

import com.leon.saintsdragons.common.registry.ModSounds;
import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.dragons.cindervane.Cindervane;
import net.minecraft.class_243;
import net.minecraft.class_3419;

public class CindervaneRoarAbility
extends DragonAbility<Cindervane> {
    private static final DragonAbilitySection[] TRACK = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.STARTUP, 6), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.ACTIVE, 30), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.RECOVERY, 10)};
    private static final int SOUND_DELAY_TICKS = 3;
    private boolean soundQueued = false;

    public CindervaneRoarAbility(DragonAbilityType<Cindervane, CindervaneRoarAbility> type, Cindervane user) {
        super(type, user, TRACK, 20);
    }

    @Override
    protected void beginSection(DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            Cindervane dragon = (Cindervane)this.getUser();
            String trigger = dragon.method_6581() ? "roar_air" : "roar_ground";
            dragon.triggerAnim("actions", trigger);
            this.soundQueued = true;
        }
    }

    @Override
    protected void endSection(DragonAbilitySection section) {
        if (section != null && section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            this.soundQueued = false;
        }
    }

    @Override
    public void tickUsing() {
        DragonAbilitySection section = this.getCurrentSection();
        if (section == null) {
            return;
        }
        Cindervane dragon = (Cindervane)this.getUser();
        if (!dragon.method_37908().field_9236) {
            dragon.triggerScreenShake(0.6f);
        }
        if (this.soundQueued && section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP && this.getTicksInSection() >= 3) {
            if (!dragon.method_37908().field_9236) {
                class_243 mouth = dragon.getMouthPosition();
                boolean flying = dragon.method_6581();
                float basePitch = flying ? 1.05f : 0.9f;
                float pitch = basePitch + dragon.method_6051().method_43057() * 0.05f;
                dragon.method_37908().method_43128(null, mouth.field_1352, mouth.field_1351, mouth.field_1350, ModSounds.CINDERVANE_ROAR.get(), class_3419.field_15254, 1.5f, pitch);
            }
            this.soundQueued = false;
        }
    }
}

