/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.cindervane;

import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.dragons.cindervane.Cindervane;
import com.leon.saintsdragons.server.entity.effect.cindervane.CindervaneMagmaBlockEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;

public class CindervaneVolleyAbility
extends DragonAbility<Cindervane> {
    private static final DragonAbilitySection[] TRACK = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.STARTUP, 3), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.ACTIVE, 20), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.RECOVERY, 5)};
    private static final int MAX_VOLLEYS = 3;
    private static final int BLOCKS_PER_VOLLEY = 3;
    private static final int VOLLEY_INTERVAL_TICKS = 10;
    private static final int COOLDOWN_TICKS = 5;
    private static final int MAGMA_BLOCK_LIFETIME = 200;
    private static final double SPAWN_FORWARD_OFFSET = 5.0;
    private static final double SPAWN_VERTICAL_OFFSET = 1.5;
    private static final double VELOCITY_DOWN = -0.15;
    private static final double VELOCITY_FORWARD = 0.55;
    private static final double MAGMA_IMPACT_RADIUS = 7.0;
    private static final float IMPACT_DAMAGE = 20.0f;
    private int ticksSinceVolley;
    private int volleysFired;

    public CindervaneVolleyAbility(DragonAbilityType<Cindervane, CindervaneVolleyAbility> type, Cindervane user) {
        super(type, user, TRACK, 5);
    }

    @Override
    protected void beginSection(DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            this.ticksSinceVolley = 10;
            this.volleysFired = 0;
            ((Cindervane)this.getUser()).triggerAnim("actions", "magma_blast");
            class_1937 level = this.getLevel();
            level.method_8396(null, ((Cindervane)this.getUser()).method_24515(), class_3417.field_14970, ((Cindervane)this.getUser()).method_5634(), 1.4f, 0.8f + ((Cindervane)this.getUser()).method_6051().method_43057() * 0.2f);
        }
    }

    @Override
    public void tickUsing() {
        DragonAbilitySection section = this.getCurrentSection();
        if (section == null || section.sectionType != DragonAbilitySection.AbilitySectionType.ACTIVE) {
            return;
        }
        ++this.ticksSinceVolley;
        if (this.ticksSinceVolley >= 10 && this.volleysFired < 3) {
            this.ticksSinceVolley = 0;
            this.fireVolley();
            ++this.volleysFired;
        }
        if (this.volleysFired >= 3 && this.ticksSinceVolley >= 10) {
            this.nextSection();
        }
    }

    private void fireVolley() {
        Cindervane dragon = (Cindervane)this.getUser();
        class_1937 class_19372 = dragon.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 server = (class_3218)class_19372;
        class_243 mouth = dragon.computeMouthOrigin(1.0f).method_1031(0.0, 1.5, 0.0);
        float baseYaw = dragon.field_6241;
        float basePitch = dragon.method_36455();
        for (int i = 0; i < 3; ++i) {
            float yawOffset = (float)(i - 1) * 9.5f + (dragon.method_6051().method_43057() - 0.5f) * 6.0f;
            float pitchOffset = (dragon.method_6051().method_43057() - 0.5f) * 4.0f;
            float yaw = baseYaw + yawOffset;
            float pitch = basePitch + pitchOffset;
            class_243 direction = class_243.method_1030((float)pitch, (float)yaw).method_1029();
            class_243 spawnPos = mouth.method_1019(direction.method_1021(5.0));
            CindervaneMagmaBlockEntity block = new CindervaneMagmaBlockEntity((class_1937)server, spawnPos, dragon, 7.0, 20.0f, 200);
            block.method_18799(direction.method_1021(0.55).method_1031(0.0, -0.15, 0.0));
            server.method_8649((class_1297)block);
        }
    }
}

