/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.nulljaw;

import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.dragons.nulljaw.Nulljaw;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5134;

public class NulljawBite2Ability
extends DragonAbility<Nulljaw> {
    private static final float BASE_DAMAGE = 50.0f;
    private static final double BASE_RANGE = 5.5;
    private static final double RIDDEN_RANGE_BONUS = 0.5;
    private static final double SWIM_RANGE_BONUS = 2.0;
    private static final double BITE_ANGLE_DEG = 95.0;
    private static final double BITE_SWIPE_HORIZONTAL = 4.5;
    private static final double BITE_SWIPE_HORIZONTAL_RIDDEN = 2.0;
    private static final double BITE_SWIPE_VERTICAL = 4.5;
    private static final DragonAbilitySection[] TRACK = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.STARTUP, 5), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.ACTIVE, 6), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.RECOVERY, 6)};
    private boolean appliedHit;

    public NulljawBite2Ability(DragonAbilityType<Nulljaw, NulljawBite2Ability> type, Nulljaw user) {
        super(type, user, TRACK, 15);
    }

    @Override
    public boolean tryAbility() {
        return ((Nulljaw)this.getUser()).isPhaseTwoActive();
    }

    @Override
    protected void beginSection(DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            Nulljaw dragon = (Nulljaw)this.getUser();
            dragon.triggerAnim("action", "bite2");
            this.appliedHit = false;
        }
    }

    @Override
    public void tickUsing() {
        DragonAbilitySection section = this.getCurrentSection();
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.ACTIVE && !this.appliedHit) {
            Nulljaw dragon = (Nulljaw)this.getUser();
            List<class_1309> targets = this.findAllTargetsInCone();
            for (class_1309 target : targets) {
                this.applyHit(dragon, target);
            }
            this.appliedHit = true;
        }
    }

    private void applyHit(Nulljaw dragon, class_1309 target) {
        double value;
        float damage = 50.0f;
        class_1324 attackAttr = dragon.method_5996(class_5134.field_23721);
        if (attackAttr != null && (value = attackAttr.method_6194()) > 0.0) {
            damage = (float)(value * 1.1);
        }
        class_1282 source = dragon.method_37908().method_48963().method_48812((class_1309)dragon);
        target.method_5643(source, damage);
        class_243 push = dragon.method_5720().method_1021(0.35);
        target.method_5762(push.field_1352, dragon.method_5681() ? 0.2 : 0.08, push.field_1350);
    }

    private double getEffectiveRange() {
        Nulljaw dragon = (Nulljaw)this.getUser();
        double range = 5.5;
        if (dragon.method_5642() != null) {
            range += 0.5;
        }
        if (dragon.method_5681()) {
            range += 2.0;
        }
        return range;
    }

    private List<class_1309> findAllTargetsInCone() {
        Nulljaw dragon = (Nulljaw)this.getUser();
        class_243 mouth = dragon.getMouthPosition();
        class_243 look = dragon.method_5720().method_1029();
        boolean ridden = dragon.method_5642() != null;
        double effectiveRange = this.getEffectiveRange();
        double horizontalInflate = ridden ? 2.0 : 4.5;
        class_238 forwardSweep = new class_238(mouth, mouth.method_1019(look.method_1021(effectiveRange))).method_1009(horizontalInflate, 4.5, horizontalInflate);
        List candidates = dragon.method_37908().method_8390(class_1309.class, forwardSweep, e -> e != dragon && e.method_5805() && e.method_6102() && !dragon.isAlly((class_1297)e));
        double cosLimit = Math.cos(Math.toRadians(95.0));
        ArrayList<class_1309> validTargets = new ArrayList<class_1309>();
        for (class_1309 e2 : candidates) {
            boolean goodAngle;
            class_243 dir;
            double dot;
            class_243 toward;
            double len;
            double distToAabb = NulljawBite2Ability.distancePointToAABB(mouth, e2.method_5829());
            if (distToAabb > effectiveRange + 0.4 || (len = (toward = NulljawBite2Ability.closestPointOnAABB(mouth, e2.method_5829()).method_1020(mouth)).method_1033()) <= 1.0E-4 || (dot = (dir = toward.method_1021(1.0 / len)).method_1026(look)) <= 0.0) continue;
            boolean veryClose = distToAabb < effectiveRange * 0.35;
            boolean bl = goodAngle = dot >= cosLimit;
            if (ridden) {
                boolean bl2 = goodAngle = goodAngle || dot >= cosLimit * 0.75;
            }
            if (!veryClose && !goodAngle) continue;
            validTargets.add(e2);
        }
        return validTargets;
    }

    private static double distancePointToAABB(class_243 p, class_238 box) {
        double dx = Math.max(Math.max(box.field_1323 - p.field_1352, 0.0), p.field_1352 - box.field_1320);
        double dy = Math.max(Math.max(box.field_1322 - p.field_1351, 0.0), p.field_1351 - box.field_1325);
        double dz = Math.max(Math.max(box.field_1321 - p.field_1350, 0.0), p.field_1350 - box.field_1324);
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    private static class_243 closestPointOnAABB(class_243 p, class_238 box) {
        double cx = class_3532.method_15350((double)p.field_1352, (double)box.field_1323, (double)box.field_1320);
        double cy = class_3532.method_15350((double)p.field_1351, (double)box.field_1322, (double)box.field_1325);
        double cz = class_3532.method_15350((double)p.field_1350, (double)box.field_1321, (double)box.field_1324);
        return new class_243(cx, cy, cz);
    }
}

