/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.nulljaw;

import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.dragons.nulljaw.Nulljaw;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5134;

public class NulljawClawAbility
extends DragonAbility<Nulljaw> {
    private static final float BASE_DAMAGE = 12.0f;
    private static final double BASE_RANGE = 5.0;
    private static final double RIDDEN_RANGE_BONUS = 1.5;
    private static final double CLAW_ANGLE_DEG = 100.0;
    private static final double CLAW_SWIPE_HORIZONTAL = 4.0;
    private static final double CLAW_SWIPE_HORIZONTAL_RIDDEN = 3.0;
    private static final double CLAW_SWIPE_VERTICAL = 4.0;
    private static final double BLOCK_BREAK_RANGE = 6.0;
    private static final double BLOCK_BREAK_WIDTH = 3.0;
    private static final double BLOCK_BREAK_HEIGHT = 4.0;
    private static final DragonAbilitySection[] TRACK = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.STARTUP, 1), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.ACTIVE, 2), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.RECOVERY, 2)};
    private boolean appliedHit;
    private final boolean useLeftClaw;

    public NulljawClawAbility(DragonAbilityType<Nulljaw, NulljawClawAbility> type, Nulljaw user) {
        super(type, user, TRACK, 3);
        this.useLeftClaw = user.shouldUseLeftClaw();
        user.toggleClawSide();
    }

    @Override
    public boolean tryAbility() {
        return ((Nulljaw)this.getUser()).isPhaseTwoActive();
    }

    @Override
    public boolean isOverlayAbility() {
        return true;
    }

    @Override
    protected void beginSection(DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            Nulljaw dragon = (Nulljaw)this.getUser();
            String animName = this.useLeftClaw ? "claw_left" : "claw_right";
            dragon.triggerAnim("action", animName);
            this.appliedHit = false;
        }
    }

    @Override
    public void tickUsing() {
        DragonAbilitySection section = this.getCurrentSection();
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.ACTIVE && !this.appliedHit) {
            Nulljaw dragon = (Nulljaw)this.getUser();
            List<class_1309> targets = this.findAllTargets();
            for (class_1309 target : targets) {
                this.applyHit(dragon, target);
            }
            if (dragon.method_5782()) {
                this.breakBlocksInPath(dragon);
            }
            this.appliedHit = true;
        }
    }

    private void applyHit(Nulljaw dragon, class_1309 target) {
        double value;
        float damage = 12.0f;
        class_1324 attackAttr = dragon.method_5996(class_5134.field_23721);
        if (attackAttr != null && (value = attackAttr.method_6194()) > 0.0) {
            damage = (float)(value * 1.2);
        }
        class_1282 source = dragon.method_37908().method_48963().method_48812((class_1309)dragon);
        target.method_5643(source, damage);
    }

    private void breakBlocksInPath(Nulljaw dragon) {
        class_1937 class_19372 = dragon.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 server = (class_3218)class_19372;
        class_243 mouth = dragon.getMouthPosition();
        class_243 look = dragon.method_5720().method_1029();
        class_243 start = mouth;
        class_243 end = mouth.method_1019(look.method_1021(6.0));
        class_238 breakArea = new class_238(start, end).method_1009(3.0, 4.0, 3.0);
        class_2338 minPos = new class_2338((int)Math.floor(breakArea.field_1323), (int)Math.floor(breakArea.field_1322), (int)Math.floor(breakArea.field_1321));
        class_2338 maxPos = new class_2338((int)Math.ceil(breakArea.field_1320), (int)Math.ceil(breakArea.field_1325), (int)Math.ceil(breakArea.field_1324));
        class_2338.class_2339 cursor = new class_2338.class_2339();
        for (int x = minPos.method_10263(); x <= maxPos.method_10263(); ++x) {
            for (int y = minPos.method_10264(); y <= maxPos.method_10264(); ++y) {
                for (int z = minPos.method_10260(); z <= maxPos.method_10260(); ++z) {
                    class_2680 state;
                    cursor.method_10103(x, y, z);
                    if (!server.method_8477((class_2338)cursor) || (state = server.method_8320((class_2338)cursor)).method_26215() || !this.canBreakBlock(state)) continue;
                    server.method_8651((class_2338)cursor, true, (class_1297)dragon);
                }
            }
        }
    }

    private boolean canBreakBlock(class_2680 state) {
        if (state.method_51176()) {
            return false;
        }
        float hardness = state.method_26214((class_1922)((Nulljaw)this.getUser()).method_37908(), class_2338.field_10980);
        if (hardness < 0.0f) {
            return false;
        }
        return hardness <= 30.0f;
    }

    private double getEffectiveRange() {
        Nulljaw dragon = (Nulljaw)this.getUser();
        double range = 5.0;
        if (dragon.method_5642() != null) {
            range += 1.5;
        }
        return range;
    }

    private List<class_1309> findAllTargets() {
        Nulljaw dragon = (Nulljaw)this.getUser();
        class_243 mouth = dragon.getMouthPosition();
        class_243 look = dragon.method_5720().method_1029();
        boolean ridden = dragon.method_5642() != null;
        double effectiveRange = this.getEffectiveRange();
        double horizontalInflate = ridden ? 3.0 : 4.0;
        class_238 forwardSweep = new class_238(mouth, mouth.method_1019(look.method_1021(effectiveRange))).method_1009(horizontalInflate, 4.0, horizontalInflate);
        List candidates = dragon.method_37908().method_8390(class_1309.class, forwardSweep, e -> e != dragon && e.method_5805() && e.method_6102() && !dragon.isAlly((class_1297)e));
        double cosLimit = Math.cos(Math.toRadians(100.0));
        ArrayList<class_1309> validTargets = new ArrayList<class_1309>();
        for (class_1309 e2 : candidates) {
            boolean goodAngle;
            class_243 dir;
            double dot;
            class_243 toward;
            double len;
            double distToAabb = NulljawClawAbility.distancePointToAABB(mouth, e2.method_5829());
            if (distToAabb > effectiveRange + 0.5 || (len = (toward = NulljawClawAbility.closestPointOnAABB(mouth, e2.method_5829()).method_1020(mouth)).method_1033()) <= 1.0E-4 || (dot = (dir = toward.method_1021(1.0 / len)).method_1026(look)) <= 0.0) continue;
            boolean veryClose = distToAabb < effectiveRange * 0.4;
            boolean bl = goodAngle = dot >= cosLimit;
            if (ridden) {
                boolean bl2 = goodAngle = goodAngle || dot >= cosLimit * 0.7;
            }
            if (!veryClose && !goodAngle) continue;
            validTargets.add(e2);
        }
        return validTargets;
    }

    private static double distancePointToAABB(class_243 p, class_238 box) {
        double dx = Math.max(Math.max(box.field_1323 - p.field_1352, 0.0), p.field_1352 - box.field_1320);
        double dy = Math.max(Math.max(box.field_1322 - p.field_1351, 0.0), p.field_1351 - box.field_1325);
        double dz = Math.max(Math.max(box.field_1321 - p.field_1350, 0.0), p.field_1350 - box.field_1324);
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    private static class_243 closestPointOnAABB(class_243 p, class_238 box) {
        double cx = class_3532.method_15350((double)p.field_1352, (double)box.field_1323, (double)box.field_1320);
        double cy = class_3532.method_15350((double)p.field_1351, (double)box.field_1322, (double)box.field_1325);
        double cz = class_3532.method_15350((double)p.field_1350, (double)box.field_1321, (double)box.field_1324);
        return new class_243(cx, cy, cz);
    }
}

