/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.nulljaw;

import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.dragons.nulljaw.Nulljaw;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5134;

public class NulljawHornGoreAbility
extends DragonAbility<Nulljaw> {
    private static final float GORE_DAMAGE = 16.0f;
    private static final double GORE_RANGE = 7.0;
    private static final double GORE_RANGE_RIDDEN = 8.5;
    private static final double GORE_ANGLE_DEG = 90.0;
    private static final DragonAbilitySection[] TRACK = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.STARTUP, 5), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.ACTIVE, 6), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.RECOVERY, 6)};
    private final Set<Integer> hitIdsThisUse = new HashSet<Integer>();

    public NulljawHornGoreAbility(DragonAbilityType<Nulljaw, NulljawHornGoreAbility> type, Nulljaw user) {
        super(type, user, TRACK, 3);
    }

    @Override
    protected void beginSection(DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            ((Nulljaw)this.getUser()).triggerAnim("action", "horn_gore");
            this.hitIdsThisUse.clear();
        } else if (section.sectionType == DragonAbilitySection.AbilitySectionType.ACTIVE) {
            // empty if block
        }
    }

    @Override
    public void tickUsing() {
        DragonAbilitySection section = this.getCurrentSection();
        if (section == null) {
            return;
        }
        if (section.sectionType != DragonAbilitySection.AbilitySectionType.ACTIVE) {
            return;
        }
        List<class_1309> candidates = this.findTargets();
        ArrayList<class_1309> newHits = new ArrayList<class_1309>();
        for (class_1309 le : candidates) {
            if (!this.hitIdsThisUse.add(le.method_5628())) continue;
            newHits.add(le);
        }
        if (!newHits.isEmpty()) {
            for (class_1309 le : newHits) {
                this.applyGore(le);
            }
        }
    }

    private List<class_1309> findTargets() {
        Nulljaw dragon = (Nulljaw)this.getUser();
        class_243 head = dragon.getHeadPosition();
        class_243 look = dragon.method_5720().method_1029();
        boolean ridden = dragon.method_5642() != null;
        double range = ridden ? 8.5 : 7.0;
        class_238 broad = dragon.method_5829().method_1009(range, range, range);
        List candidates = dragon.method_37908().method_8390(class_1309.class, broad, e -> e != dragon && e.method_5805() && e.method_6102() && !this.isAllied(dragon, (class_1297)e));
        double cosLimit = Math.cos(Math.toRadians(90.0));
        ArrayList<class_1309> hits = new ArrayList<class_1309>();
        for (class_1309 e2 : candidates) {
            boolean angleOk;
            class_243 toward;
            double len;
            double dist = NulljawHornGoreAbility.distancePointToAABB(head, e2.method_5829());
            if (dist > range + 0.4 || (len = (toward = e2.method_5829().method_1005().method_1020(head)).method_1033()) < 1.0E-4) continue;
            double dot = toward.method_1029().method_1026(look);
            boolean close = dist < range * 0.6;
            boolean bl = angleOk = dot >= cosLimit;
            if (ridden) {
                double bodyDist = NulljawHornGoreAbility.distancePointToAABB(e2.method_19538(), dragon.method_5829());
                boolean bl2 = angleOk = angleOk || dot >= cosLimit * 0.7 || bodyDist <= range;
            }
            if (!close && !angleOk) continue;
            hits.add(e2);
        }
        return hits;
    }

    private void applyGore(class_1309 target) {
        Nulljaw dragon = (Nulljaw)this.getUser();
        class_1282 src = dragon.method_37908().method_48963().method_48812((class_1309)dragon);
        float damageMultiplier = dragon.isPhaseTwoActive() ? 1.3f : 1.0f;
        float armorPenetration = dragon.isPhaseTwoActive() ? 5.0f : 3.0f;
        float armor = (float)target.method_26825(class_5134.field_23724);
        float toughness = (float)target.method_26825(class_5134.field_23725);
        float desiredPostArmor = NulljawHornGoreAbility.damageAfterArmor(16.0f * damageMultiplier, Math.max(0.0f, armor - armorPenetration), toughness);
        float rawToDeal = NulljawHornGoreAbility.solveRawDamageForPostArmor(desiredPostArmor, armor, toughness);
        target.method_5643(src, rawToDeal);
        class_243 look = dragon.method_5720().method_1029();
        double strength = dragon.isPhaseTwoActive() ? 3.5 : 2.0;
        target.method_6005((double)((float)strength), -look.field_1352, -look.field_1350);
        class_243 dv = target.method_18798();
        float verticalLift = dragon.isPhaseTwoActive() ? 0.9f : 0.5f;
        target.method_18800(dv.field_1352, Math.max(dv.field_1351, (double)verticalLift), dv.field_1350);
    }

    private static float damageAfterArmor(float damage, float armor, float toughness) {
        float f = 2.0f + toughness / 4.0f;
        float reduction = class_3532.method_15363((float)(armor - damage / f), (float)(armor * 0.2f), (float)20.0f);
        return damage * (1.0f - reduction / 25.0f);
    }

    private static float solveRawDamageForPostArmor(float desiredPostArmor, float armor, float toughness) {
        float lo = 0.0f;
        float hi = Math.max(desiredPostArmor + 16.0f, 16.0f);
        for (int i = 0; i < 8 && NulljawHornGoreAbility.damageAfterArmor(hi, armor, toughness) < desiredPostArmor; ++i) {
            hi *= 2.0f;
        }
        for (int it = 0; it < 20; ++it) {
            float mid = (lo + hi) * 0.5f;
            float val = NulljawHornGoreAbility.damageAfterArmor(mid, armor, toughness);
            if (val < desiredPostArmor) {
                lo = mid;
                continue;
            }
            hi = mid;
        }
        return (lo + hi) * 0.5f;
    }

    private static double distancePointToAABB(class_243 p, class_238 box) {
        double dx = Math.max(Math.max(box.field_1323 - p.field_1352, 0.0), p.field_1352 - box.field_1320);
        double dy = Math.max(Math.max(box.field_1322 - p.field_1351, 0.0), p.field_1351 - box.field_1325);
        double dz = Math.max(Math.max(box.field_1321 - p.field_1350, 0.0), p.field_1350 - box.field_1324);
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    private boolean isAllied(Nulljaw dragon, class_1297 other) {
        return dragon.isAlly(other);
    }
}

