/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.nulljaw;

import com.leon.saintsdragons.common.registry.ModSounds;
import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.dragons.nulljaw.Nulljaw;
import net.minecraft.class_3419;

public class NulljawPhaseShiftAbility
extends DragonAbility<Nulljaw> {
    private static final int TRANSITION_DURATION = 127;
    private static final int LOCK_DURATION = 150;
    private static final int[] SHAKE_TICKS = new int[]{43, 63, 83};
    private static final float[] SHAKE_INTENSITIES = new float[]{0.95f, 0.85f, 0.75f};
    private final boolean enteringPhaseTwo;
    private boolean phaseToggleApplied;
    private int nextShakeIndex;
    private static final DragonAbilitySection[] TRACK_ENTER_PHASE2 = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.STARTUP, 127), new DragonAbilitySection.AbilitySectionInstant(DragonAbilitySection.AbilitySectionType.ACTIVE), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.RECOVERY, 10)};
    private static final DragonAbilitySection[] TRACK_EXIT_PHASE2 = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionInstant(DragonAbilitySection.AbilitySectionType.ACTIVE)};

    public NulljawPhaseShiftAbility(DragonAbilityType<Nulljaw, NulljawPhaseShiftAbility> type, Nulljaw user) {
        super(type, user, user.isPhaseTwoActive() ? TRACK_EXIT_PHASE2 : TRACK_ENTER_PHASE2, 0);
        this.enteringPhaseTwo = !user.isPhaseTwoActive();
        this.phaseToggleApplied = false;
        this.nextShakeIndex = 0;
    }

    @Override
    public boolean isOverlayAbility() {
        return !this.enteringPhaseTwo;
    }

    @Override
    public boolean canUse() {
        if (!((Nulljaw)this.getUser()).method_24828() || ((Nulljaw)this.getUser()).method_5799()) {
            return false;
        }
        return super.canUse();
    }

    @Override
    protected void beginSection(DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            if (this.enteringPhaseTwo) {
                ((Nulljaw)this.getUser()).lockRiderControls(150);
                ((Nulljaw)this.getUser()).lockAbilities(150);
            }
            this.phaseToggleApplied = false;
            this.nextShakeIndex = 0;
            ((Nulljaw)this.getUser()).triggerAnim("action", "phase2");
        } else if (section.sectionType == DragonAbilitySection.AbilitySectionType.ACTIVE) {
            if (this.enteringPhaseTwo) {
                if (!this.phaseToggleApplied) {
                    ((Nulljaw)this.getUser()).setPhaseTwoActive(true, true);
                    this.phaseToggleApplied = true;
                }
            } else {
                boolean newPhase = !((Nulljaw)this.getUser()).isPhaseTwoActive();
                ((Nulljaw)this.getUser()).setPhaseTwoActive(newPhase, true);
                if (!newPhase) {
                    ((Nulljaw)this.getUser()).triggerAnim("action", "phase1");
                    ((Nulljaw)this.getUser()).lockRiderControls(60);
                    if (!this.getLevel().field_9236) {
                        this.getLevel().method_43128(null, ((Nulljaw)this.getUser()).method_23317(), ((Nulljaw)this.getUser()).method_23318(), ((Nulljaw)this.getUser()).method_23321(), ModSounds.NULLJAW_PHASE1.get(), class_3419.field_15254, 1.4f, 0.9f + ((Nulljaw)this.getUser()).method_6051().method_43057() * 0.2f);
                    }
                }
            }
        }
    }

    @Override
    public void tickUsing() {
        DragonAbilitySection section = this.getCurrentSection();
        if (section == null) {
            return;
        }
        if (this.enteringPhaseTwo && section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            int ticks = this.getTicksInSection();
            while (this.nextShakeIndex < SHAKE_TICKS.length && ticks >= SHAKE_TICKS[this.nextShakeIndex]) {
                if (!((Nulljaw)this.getUser()).method_37908().field_9236) {
                    float intensity = SHAKE_INTENSITIES[this.nextShakeIndex];
                    ((Nulljaw)this.getUser()).triggerScreenShake(intensity);
                }
                if (!this.phaseToggleApplied) {
                    ((Nulljaw)this.getUser()).setPhaseTwoActive(true, true);
                    this.phaseToggleApplied = true;
                }
                ++this.nextShakeIndex;
            }
        }
    }
}

