/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.nulljaw;

import com.leon.saintsdragons.common.registry.ModSounds;
import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.dragons.nulljaw.Nulljaw;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5134;

public class NulljawRoarAbility
extends DragonAbility<Nulljaw> {
    private static final DragonAbilitySection[] TRACK = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.STARTUP, 6), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.ACTIVE, 85), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.RECOVERY, 9)};
    private static final int SOUND_DELAY_TICKS = 3;
    private static final int ROAR_TOTAL_TICKS = 100;
    private static final int FIRST_SWIPE_TICK = 16;
    private static final int SECOND_SWIPE_TICK = 26;
    private static final int THIRD_SWIPE_TICK = 33;
    private static final int FOURTH_SWIPE_TICK = 43;
    private static final int FIFTH_SWIPE_TICK = 49;
    private static final int SIXTH_SWIPE_TICK = 60;
    private static final int SEVENTH_SWIPE_TICK = 89;
    private static final float BASE_CLAW_DAMAGE = 12.0f;
    private static final double CLAW_RANGE = 5.0;
    private static final double CLAW_RANGE_RIDDEN_BONUS = 1.5;
    private static final double CLAW_HORIZONTAL = 4.0;
    private static final double CLAW_HORIZONTAL_RIDDEN = 3.0;
    private static final double CLAW_VERTICAL = 4.0;
    private static final double CLAW_ANGLE_DEG = 100.0;
    private boolean soundQueued = false;
    private boolean[] swipesApplied = new boolean[7];

    public NulljawRoarAbility(DragonAbilityType<Nulljaw, NulljawRoarAbility> type, Nulljaw user) {
        super(type, user, TRACK, 20);
    }

    @Override
    protected void beginSection(DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            Nulljaw dragon = (Nulljaw)this.getUser();
            String trigger = dragon.isPhaseTwoActive() ? "roar2" : "roar";
            dragon.triggerAnim("action", trigger);
            this.soundQueued = true;
            dragon.lockAbilities(100);
        }
    }

    @Override
    protected void endSection(DragonAbilitySection section) {
        if (section != null && section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            this.soundQueued = false;
        }
    }

    @Override
    public void tickUsing() {
        DragonAbilitySection section = this.getCurrentSection();
        if (section == null) {
            return;
        }
        Nulljaw dragon = (Nulljaw)this.getUser();
        if (this.soundQueued && section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP && this.getTicksInSection() >= 3) {
            if (!dragon.method_37908().field_9236) {
                class_243 mouth = dragon.getMouthPosition();
                boolean phaseTwo = dragon.isPhaseTwoActive();
                float basePitch = phaseTwo ? 0.8f : 1.0f;
                float volume = phaseTwo ? 1.8f : 1.4f;
                float pitch = basePitch + dragon.method_6051().method_43057() * 0.1f;
                dragon.method_37908().method_43128(null, mouth.field_1352, mouth.field_1351, mouth.field_1350, ModSounds.NULLJAW_ROAR.get(), class_3419.field_15254, volume, pitch);
            }
            this.soundQueued = false;
        }
        if (!dragon.isPhaseTwoActive() && this.getTicksInUse() >= 3 && !dragon.method_37908().field_9236) {
            dragon.triggerScreenShake(0.8f);
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.ACTIVE && !dragon.method_37908().field_9236 && dragon.isPhaseTwoActive()) {
            int ticks = this.getTicksInSection();
            if (!this.swipesApplied[0] && ticks >= 16) {
                this.applyRoarSwipe(dragon, 1);
                this.swipesApplied[0] = true;
            }
            if (!this.swipesApplied[1] && ticks >= 26) {
                this.applyRoarSwipe(dragon, 2);
                this.swipesApplied[1] = true;
            }
            if (!this.swipesApplied[2] && ticks >= 33) {
                this.applyRoarSwipe(dragon, 3);
                this.swipesApplied[2] = true;
            }
            if (!this.swipesApplied[3] && ticks >= 43) {
                this.applyRoarSwipe(dragon, 4);
                this.swipesApplied[3] = true;
            }
            if (!this.swipesApplied[4] && ticks >= 49) {
                this.applyRoarSwipe(dragon, 5);
                this.swipesApplied[4] = true;
            }
            if (!this.swipesApplied[5] && ticks >= 60) {
                this.applyRoarSwipe(dragon, 6);
                this.swipesApplied[5] = true;
            }
            if (!this.swipesApplied[6] && ticks >= 89) {
                this.applyRoarSwipe(dragon, 7);
                if (!dragon.method_37908().field_9236) {
                    dragon.triggerScreenShake(1.0f);
                }
                this.swipesApplied[6] = true;
            }
        }
    }

    private void applyRoarSwipe(Nulljaw dragon, int swipeNumber) {
        List<class_1309> targets;
        float swipeIntensity = 0.8f;
        if (!dragon.method_37908().field_9236) {
            dragon.triggerScreenShake(swipeIntensity);
        }
        if ((targets = this.findClawTargets(dragon)).isEmpty()) {
            return;
        }
        float damageMultiplier = swipeNumber == 7 ? 2.0f : 1.0f;
        float damage = this.computeClawDamage(dragon) * damageMultiplier;
        class_1282 source = dragon.method_37908().method_48963().method_48812((class_1309)dragon);
        class_243 push = dragon.method_5720().method_1021(0.5);
        for (class_1309 target : targets) {
            target.method_5643(source, damage);
            target.method_5762(push.field_1352, 0.15, push.field_1350);
        }
    }

    private float computeClawDamage(Nulljaw dragon) {
        double value;
        float damage = 12.0f;
        class_1324 attack = dragon.method_5996(class_5134.field_23721);
        if (attack != null && (value = attack.method_6194()) > 0.0) {
            damage = (float)(value * 1.2);
        }
        return damage;
    }

    private List<class_1309> findClawTargets(Nulljaw dragon) {
        class_243 origin = dragon.getMouthPosition();
        class_243 forward = dragon.method_5720().method_1029();
        boolean ridden = dragon.method_5642() != null;
        double range = 5.0 + (ridden ? 1.5 : 0.0);
        double horizontal = ridden ? 3.0 : 4.0;
        class_238 sweep = new class_238(origin, origin.method_1019(forward.method_1021(range))).method_1009(horizontal, 4.0, horizontal);
        List candidates = dragon.method_37908().method_8390(class_1309.class, sweep, entity -> entity != dragon && entity.method_5805() && entity.method_6102() && !dragon.isAlly((class_1297)entity));
        double cosLimit = Math.cos(Math.toRadians(100.0));
        ArrayList<class_1309> valid = new ArrayList<class_1309>();
        for (class_1309 candidate : candidates) {
            boolean goodAngle;
            class_243 dir;
            double dot;
            class_243 toward;
            double len;
            double distance = NulljawRoarAbility.distancePointToAABB(origin, candidate.method_5829());
            if (distance > range + 0.5 || (len = (toward = NulljawRoarAbility.closestPointOnAABB(origin, candidate.method_5829()).method_1020(origin)).method_1033()) <= 1.0E-4 || (dot = (dir = toward.method_1021(1.0 / len)).method_1026(forward)) <= 0.0) continue;
            boolean veryClose = distance < range * 0.4;
            boolean bl = goodAngle = dot >= cosLimit;
            if (ridden) {
                boolean bl2 = goodAngle = goodAngle || dot >= cosLimit * 0.7;
            }
            if (!veryClose && !goodAngle) continue;
            valid.add(candidate);
        }
        return valid;
    }

    private static double distancePointToAABB(class_243 point, class_238 box) {
        double dx = Math.max(Math.max(box.field_1323 - point.field_1352, 0.0), point.field_1352 - box.field_1320);
        double dy = Math.max(Math.max(box.field_1322 - point.field_1351, 0.0), point.field_1351 - box.field_1325);
        double dz = Math.max(Math.max(box.field_1321 - point.field_1350, 0.0), point.field_1350 - box.field_1324);
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    private static class_243 closestPointOnAABB(class_243 point, class_238 box) {
        double cx = class_3532.method_15350((double)point.field_1352, (double)box.field_1323, (double)box.field_1320);
        double cy = class_3532.method_15350((double)point.field_1351, (double)box.field_1322, (double)box.field_1325);
        double cz = class_3532.method_15350((double)point.field_1350, (double)box.field_1321, (double)box.field_1324);
        return new class_243(cx, cy, cz);
    }
}

