/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.raevyx;

import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.conductivity.ElectricalConductivityState;
import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class RaevyxBeamAbility
extends DragonAbility<Raevyx> {
    private static final DragonAbilitySection[] TRACK = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.STARTUP, 20), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.ACTIVE, 400)};
    private boolean hasBeamFired = false;
    private boolean beamStartPlayed = false;
    private boolean beamLoopActive = false;

    public RaevyxBeamAbility(DragonAbilityType<Raevyx, RaevyxBeamAbility> type, Raevyx user) {
        super(type, user, TRACK, 0);
    }

    @Override
    protected void beginSection(DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            this.hasBeamFired = false;
            this.beamLoopActive = false;
            this.beamStartPlayed = true;
            Raevyx wyvern = (Raevyx)this.getUser();
            wyvern.setBeaming(false);
            wyvern.triggerAnim("action", "lightning_beam_start");
        } else if (section.sectionType == DragonAbilitySection.AbilitySectionType.ACTIVE) {
            Raevyx wyvern = (Raevyx)this.getUser();
            wyvern.setBeaming(true);
            wyvern.triggerAnim("action", "lightning_beaming");
            this.beamLoopActive = true;
            if (!this.hasBeamFired) {
                this.fireBeamOnce();
                this.hasBeamFired = true;
            }
        }
    }

    @Override
    protected void endSection(DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.ACTIVE) {
            Raevyx wyvern = (Raevyx)this.getUser();
            wyvern.setBeaming(false);
            this.triggerBeamStop(wyvern);
            this.hasBeamFired = false;
        }
    }

    @Override
    public void interrupt() {
        Raevyx wyvern = (Raevyx)this.getUser();
        wyvern.setBeaming(false);
        this.triggerBeamStop(wyvern);
        this.hasBeamFired = false;
        super.interrupt();
    }

    @Override
    public void tickUsing() {
        DragonAbilitySection section = this.getCurrentSection();
        if (section == null || section.sectionType != DragonAbilitySection.AbilitySectionType.ACTIVE) {
            return;
        }
        Raevyx wyvern = (Raevyx)this.getUser();
        if (wyvern.method_37908().field_9236) {
            return;
        }
        this.updateBeamPositions(wyvern);
        class_1309 tgt = wyvern.method_5968();
        if (tgt != null && tgt.method_5805()) {
            double dx = tgt.method_23317() - wyvern.method_23317();
            double dz = tgt.method_23321() - wyvern.method_23321();
            float targetYaw = (float)(Math.atan2(dz, dx) * 57.29577951308232) - 90.0f;
            float currentYaw = wyvern.method_36454();
            float yawErr = class_3532.method_15381((float)currentYaw, (float)targetYaw);
            if (Math.abs(yawErr) > 3.5f) {
                float base = 2.5f;
                float scale = 0.1f;
                float max = wyvern.method_6581() ? 7.0f : 6.0f;
                float step = class_3532.method_15363((float)(base + Math.abs(yawErr) * scale), (float)base, (float)max);
                float newYaw = class_3532.method_15388((float)currentYaw, (float)targetYaw, (float)step);
                wyvern.method_36456(newYaw);
                wyvern.field_6283 = wyvern.method_36454();
            }
        }
        class_243 start = wyvern.getBeamStartPosition();
        class_243 end = wyvern.getBeamEndPosition();
        if (start != null && end != null) {
            this.damageAlongBeam(wyvern, start, end);
        }
    }

    private void triggerBeamStop(Raevyx wyvern) {
        if (this.beamLoopActive || this.beamStartPlayed) {
            wyvern.triggerAnim("action", "lightning_beam_stop");
        }
        this.beamLoopActive = false;
        this.beamStartPlayed = false;
    }

    private void fireBeamOnce() {
        Raevyx wyvern = (Raevyx)this.getUser();
        this.updateBeamPositions(wyvern);
        class_243 start = wyvern.getBeamStartPosition();
        class_243 end = wyvern.getBeamEndPosition();
        if (start != null && end != null) {
            this.damageAlongBeam(wyvern, start, end);
        }
    }

    private void updateBeamPositions(Raevyx wyvern) {
        class_243 start = wyvern.computeHeadMouthOrigin(1.0f);
        wyvern.setBeamStartPosition(start);
        class_243 aimDir = wyvern.refreshBeamAimDirection(start, true);
        if (aimDir == null) {
            aimDir = class_243.method_1030((float)wyvern.method_36455(), (float)wyvern.field_6241).method_1029();
        }
        double MAX_DISTANCE = 128.0;
        class_243 tentativeEnd = start.method_1019(aimDir.method_1021(128.0));
        class_3965 hit = wyvern.method_37908().method_17742(new class_3959(start, tentativeEnd, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)wyvern));
        class_243 end = hit.method_17783() != class_239.class_240.field_1333 ? hit.method_17784() : tentativeEnd;
        wyvern.setBeamEndPosition(end);
    }

    private void damageAlongBeam(Raevyx wyvern, class_243 start, class_243 end) {
        class_1937 class_19372 = wyvern.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 server = (class_3218)class_19372;
        double STEP = 1.0;
        double BASE_RADIUS = 1.2;
        float BASE_DAMAGE = 35.0f;
        ElectricalConductivityState conductivity = wyvern.getConductivityState();
        double RADIUS = 1.2 * conductivity.rangeMultiplier();
        float DAMAGE = 35.0f * conductivity.damageMultiplier() * wyvern.getDamageMultiplier();
        class_243 delta = end.method_1020(start);
        double len = delta.method_1033();
        if (len < 1.0E-4) {
            return;
        }
        class_243 dir = delta.method_1021(1.0 / len);
        HashSet<class_1309> hitThisBeam = new HashSet<class_1309>();
        for (double d = 0.0; d <= len; d += 1.0) {
            class_243 p = start.method_1019(dir.method_1021(d));
            class_238 aabb = new class_238(p, p).method_1014(RADIUS);
            List list = server.method_8390(class_1309.class, aabb, e -> e != wyvern && e.method_5805() && e.method_6102() && !this.isAllied(wyvern, (class_1297)e));
            for (class_1309 le : list) {
                if (!hitThisBeam.add(le)) continue;
                le.method_5643(wyvern.method_37908().method_48963().method_48809(), DAMAGE);
                class_243 away = le.method_19538().method_1020(p).method_1029();
                le.method_5762(away.field_1352 * 0.15, 0.08, away.field_1350 * 0.15);
            }
        }
    }

    private boolean isAllied(Raevyx wyvern, class_1297 other) {
        return wyvern.isAlly(other);
    }
}

