/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.raevyx;

import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.conductivity.ElectricalConductivityState;
import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import com.leon.saintsdragons.server.entity.effect.raevyx.RaevyxLightningChainEntity;
import com.leon.saintsdragons.util.DragonMathUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1675;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3966;

public class RaevyxBiteAbility
extends DragonAbility<Raevyx> {
    private static final float BITE_DAMAGE = 15.0f;
    private static final double BITE_RANGE = 4.6;
    private static final double BITE_RANGE_RIDDEN = 8.0;
    private static final double BITE_ANGLE_DEG = 85.0;
    private static final double BITE_SWIPE_HORIZONTAL = 2.5;
    private static final double BITE_SWIPE_HORIZONTAL_RIDDEN = 2.5;
    private static final double BITE_SWIPE_VERTICAL = 2.5;
    private static final float CHAIN_DAMAGE_BASE = 10.0f;
    private static final double CHAIN_RADIUS = 7.0;
    private static final int CHAIN_JUMPS = 5;
    private static final float CHAIN_FALLOFF = 0.75f;
    private static final DragonAbilitySection[] TRACK = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.STARTUP, 3), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.ACTIVE, 2), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.RECOVERY, 3)};
    private boolean didHitThisActive = false;

    public RaevyxBiteAbility(DragonAbilityType<Raevyx, RaevyxBiteAbility> type, Raevyx user) {
        super(type, user, TRACK, 3);
    }

    @Override
    protected void beginSection(DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            ((Raevyx)this.getUser()).triggerAnim("action", "lightning_bite");
            this.didHitThisActive = false;
        }
    }

    @Override
    public void tickUsing() {
        DragonAbilitySection section = this.getCurrentSection();
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.ACTIVE && !this.didHitThisActive) {
            double d;
            class_1309 t;
            class_1309 primary = this.findPrimaryTarget();
            if (primary == null && (t = ((Raevyx)this.getUser()).method_5968()) != null && t.method_5805() && (d = (double)t.method_5739(this.getUser())) <= 5.2) {
                primary = t;
            }
            if (primary == null) {
                boolean ridden = ((Raevyx)this.getUser()).method_5642() != null;
                primary = this.raycastTargetAlongMouth(ridden ? 7.5 : 5.5, ridden ? 2.0 : 1.0);
            }
            if (primary != null) {
                this.bitePrimary(primary);
                this.chainFrom(primary);
            }
            this.didHitThisActive = true;
        }
    }

    private class_1309 findPrimaryTarget() {
        Raevyx wyvern = (Raevyx)this.getUser();
        class_243 mouth = wyvern.getMouthPosition();
        class_243 look = wyvern.method_5720().method_1029();
        boolean ridden = wyvern.method_5642() != null;
        double effectiveRange = ridden ? 8.0 : 4.6;
        double horizontalInflate = ridden ? 2.5 : 2.5;
        class_238 forwardSweep = new class_238(mouth, mouth.method_1019(look.method_1021(effectiveRange))).method_1009(horizontalInflate, 2.5, horizontalInflate);
        List candidates = wyvern.method_37908().method_8390(class_1309.class, forwardSweep, e -> e != wyvern && e.method_5805() && e.method_6102() && !this.isAllied(wyvern, (class_1297)e));
        double cosLimit = Math.cos(Math.toRadians(85.0));
        class_1309 best = null;
        double bestDist = Double.MAX_VALUE;
        for (class_1309 e2 : candidates) {
            boolean goodAngle;
            class_243 dir;
            double dot;
            class_243 toward;
            double len;
            double distToAabb = RaevyxBiteAbility.distancePointToAABB(mouth, e2.method_5829());
            if (distToAabb > effectiveRange + 0.4 || (len = (toward = RaevyxBiteAbility.closestPointOnAABB(mouth, e2.method_5829()).method_1020(mouth)).method_1033()) <= 1.0E-4 || (dot = (dir = toward.method_1021(1.0 / len)).method_1026(look)) <= 0.0) continue;
            boolean veryClose = distToAabb < effectiveRange * 0.35;
            boolean bl = goodAngle = dot >= cosLimit;
            if (ridden) {
                boolean bl2 = goodAngle = goodAngle || dot >= cosLimit * 0.75;
            }
            if (!veryClose && !goodAngle || !(distToAabb < bestDist)) continue;
            bestDist = distToAabb;
            best = e2;
        }
        return best;
    }

    private void bitePrimary(class_1309 primary) {
        Raevyx wyvern = (Raevyx)this.getUser();
        class_1282 src = wyvern.method_37908().method_48963().method_48812((class_1309)wyvern);
        float mult = wyvern.getDamageMultiplier();
        primary.method_5643(src, 15.0f * mult);
        wyvern.noteAggroFrom(primary);
    }

    private void chainFrom(class_1309 start) {
        class_1309 next;
        Raevyx wyvern = (Raevyx)this.getUser();
        ElectricalConductivityState conductivity = wyvern.getConductivityState();
        HashSet<class_1309> hit = new HashSet<class_1309>();
        hit.add(start);
        class_1309 current = start;
        float damage = 10.0f;
        for (int i = 0; i < 5 && (next = this.findNearestChainTarget(current, hit, conductivity)) != null; ++i) {
            float mult = wyvern.getDamageMultiplier();
            next.method_5643(wyvern.method_37908().method_48963().method_48809(), damage * mult * conductivity.damageMultiplier());
            wyvern.noteAggroFrom(next);
            this.spawnArc(current.method_19538().method_1031(0.0, (double)current.method_17682() * 0.5, 0.0), next.method_19538().method_1031(0.0, (double)next.method_17682() * 0.5, 0.0), conductivity);
            hit.add(next);
            current = next;
            damage *= 0.75f;
        }
    }

    private static double distancePointToAABB(class_243 p, class_238 box) {
        double dx = Math.max(Math.max(box.field_1323 - p.field_1352, 0.0), p.field_1352 - box.field_1320);
        double dy = Math.max(Math.max(box.field_1322 - p.field_1351, 0.0), p.field_1351 - box.field_1325);
        double dz = Math.max(Math.max(box.field_1321 - p.field_1350, 0.0), p.field_1350 - box.field_1324);
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    private static class_243 closestPointOnAABB(class_243 p, class_238 box) {
        double cx = class_3532.method_15350((double)p.field_1352, (double)box.field_1323, (double)box.field_1320);
        double cy = class_3532.method_15350((double)p.field_1351, (double)box.field_1322, (double)box.field_1325);
        double cz = class_3532.method_15350((double)p.field_1350, (double)box.field_1321, (double)box.field_1324);
        return new class_243(cx, cy, cz);
    }

    private class_1309 raycastTargetAlongMouth(double maxDistance, double inflateRadius) {
        class_1297 class_12972;
        Raevyx wyvern = (Raevyx)this.getUser();
        class_243 start = wyvern.getMouthPosition();
        class_243 look = wyvern.method_5720().method_1029();
        class_243 end = start.method_1019(look.method_1021(maxDistance));
        class_238 sweep = new class_238(start, end).method_1014(inflateRadius);
        class_3966 hit = class_1675.method_37226((class_1937)wyvern.method_37908(), (class_1297)wyvern, (class_243)start, (class_243)end, (class_238)sweep, e -> {
            if (!(e instanceof class_1309)) return false;
            class_1309 le = (class_1309)e;
            if (e == wyvern) return false;
            if (!e.method_5805()) return false;
            if (!le.method_6102()) return false;
            if (this.isAllied(wyvern, (class_1297)e)) return false;
            return true;
        }, (float)((float)(maxDistance * maxDistance)));
        if (hit != null && (class_12972 = hit.method_17782()) instanceof class_1309) {
            class_1309 le = (class_1309)class_12972;
            return le;
        }
        return null;
    }

    private class_1309 findNearestChainTarget(class_1309 origin, Set<class_1309> exclude, ElectricalConductivityState conductivity) {
        Raevyx wyvern = (Raevyx)this.getUser();
        double rangeMult = conductivity.rangeMultiplier();
        List<class_1309> nearby = DragonMathUtil.getEntitiesNearby((class_1297)origin, class_1309.class, 7.0 * rangeMult);
        class_1309 best = null;
        double bestDist = Double.MAX_VALUE;
        for (class_1309 e : nearby) {
            double d;
            if (e == wyvern || exclude.contains(e) || !e.method_5805() || !e.method_6102() || this.isAllied(wyvern, (class_1297)e) || !((d = e.method_5858((class_1297)origin)) < bestDist) || !wyvern.method_5985().method_6369((class_1297)e)) continue;
            bestDist = d;
            best = e;
        }
        return best;
    }

    private boolean isAllied(Raevyx wyvern, class_1297 other) {
        return wyvern.isAlly(other);
    }

    private void spawnArc(class_243 from, class_243 to, ElectricalConductivityState conductivity) {
        class_1937 class_19372 = this.getLevel();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 server = (class_3218)class_19372;
        Raevyx wyvern = (Raevyx)this.getUser();
        float damage = 10.0f * wyvern.getDamageMultiplier() * conductivity.damageMultiplier();
        RaevyxLightningChainEntity lightningEntity = new RaevyxLightningChainEntity((class_1937)server, from, to, damage, 1.2f, (class_1309)wyvern, false);
        server.method_8649((class_1297)lightningEntity);
    }
}

