/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.raevyx;

import com.leon.saintsdragons.common.particle.raevyx.RaevyxLightningStormData;
import com.leon.saintsdragons.common.registry.ModSounds;
import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class RaevyxRoarAbility
extends DragonAbility<Raevyx> {
    private static final DragonAbilitySection[] TRACK = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.STARTUP, 6), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.ACTIVE, 28), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.RECOVERY, 12)};
    private boolean roarQueued = false;
    private static final int ROAR_DELAY_TICKS = 3;
    private static final int ROAR_TOTAL_TICKS = 69;
    private int strikesLeft = 0;
    private int strikeCooldown = 0;
    private List<Integer> targetIds = Collections.emptyList();
    private int targetCursor = 0;

    public RaevyxRoarAbility(DragonAbilityType<Raevyx, RaevyxRoarAbility> type, Raevyx user) {
        super(type, user, TRACK, 40);
    }

    @Override
    protected void beginSection(DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            boolean flying = ((Raevyx)this.getUser()).method_6581();
            String trigger = flying ? "roar_air" : "roar_ground";
            ((Raevyx)this.getUser()).triggerAnim("action", trigger);
            this.roarQueued = true;
            if (!((Raevyx)this.getUser()).method_6581()) {
                ((Raevyx)this.getUser()).lockTakeoff(69);
            }
            this.selectLightningTargets();
            int count = this.targetIds.size();
            boolean isSupercharged = ((Raevyx)this.getUser()).isSupercharged();
            this.strikesLeft = count > 1 ? Math.min(6, Math.max(3, count * 2)) : 2 + ((Raevyx)this.getUser()).method_6051().method_43048(2);
            if (isSupercharged) {
                this.strikesLeft *= 2;
            }
            this.strikeCooldown = 0;
        }
    }

    @Override
    public void tickUsing() {
        DragonAbilitySection section = this.getCurrentSection();
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP && this.roarQueued && this.getTicksInSection() >= 3 && !((Raevyx)this.getUser()).method_37908().field_9236) {
            Raevyx dragon = (Raevyx)this.getUser();
            float pitch = 0.9f + dragon.method_6051().method_43057() * 0.15f;
            dragon.method_5783(ModSounds.RAEVYX_ROAR.get(), 1.4f, pitch);
            this.roarQueued = false;
        }
        if (!((Raevyx)this.getUser()).method_37908().field_9236) {
            ((Raevyx)this.getUser()).triggerScreenShake(1.0f);
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.ACTIVE && this.strikesLeft > 0 && !((Raevyx)this.getUser()).method_37908().field_9236) {
            if (this.strikeCooldown > 0) {
                --this.strikeCooldown;
            } else {
                this.spawnLightningStrike();
                --this.strikesLeft;
                this.strikeCooldown = 6 + ((Raevyx)this.getUser()).method_6051().method_43048(6);
            }
        }
    }

    private void selectLightningTargets() {
        Raevyx dragon = (Raevyx)this.getUser();
        class_1309 rider = dragon.method_5642();
        LinkedHashSet<Integer> ids = new LinkedHashSet<Integer>();
        class_1937 class_19372 = dragon.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 server = (class_3218)class_19372;
            class_238 box = dragon.method_5829().method_1014(24.0);
            List chasers = server.method_8390(class_1308.class, box, m -> {
                class_1309 t = m.method_5968();
                return m.method_5805() && (t == dragon || rider != null && t == rider);
            });
            chasers.sort(Comparator.comparingDouble(m -> m.method_5858((class_1297)dragon)));
            for (class_1308 m2 : chasers) {
                ids.add(m2.method_5628());
            }
        }
        if (dragon.method_37908() instanceof class_3218) {
            List<class_1309> recent = dragon.getRecentAggro();
            recent.sort(Comparator.comparingDouble(e -> e.method_5858((class_1297)dragon)));
            for (class_1309 le : recent) {
                if (le == null || !le.method_5805()) continue;
                ids.add(le.method_5628());
            }
            class_1309 ct = dragon.method_5968();
            if (ct != null && ct.method_5805()) {
                ids.add(ct.method_5628());
            }
        }
        this.targetIds = new ArrayList<Integer>();
        int added = 0;
        for (Integer id : ids) {
            this.targetIds.add(id);
            if (++added < 6) continue;
            break;
        }
        this.targetCursor = 0;
    }

    private void spawnLightningStrike() {
        Raevyx dragon = (Raevyx)this.getUser();
        class_1937 class_19372 = dragon.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 server = (class_3218)class_19372;
        class_1309 target = this.nextValidTarget(server);
        if (target == null) {
            return;
        }
        double ox = (dragon.method_6051().method_43058() - 0.5) * 2.0;
        double oz = (dragon.method_6051().method_43058() - 0.5) * 2.0;
        double x = target.method_23317() + ox;
        double z = target.method_23321() + oz;
        double y = target.method_23318();
        class_1538 bolt = (class_1538)class_1299.field_6112.method_5883((class_1937)server);
        if (bolt != null) {
            bolt.method_24203(x, y, z);
            class_1309 owner = dragon.method_35057();
            if (owner instanceof class_3222) {
                class_3222 sp = (class_3222)owner;
                bolt.method_6961(sp);
            }
            server.method_8649((class_1297)bolt);
        }
        this.spawnElectrocuteArcs(server, target);
        RaevyxRoarAbility.applyStun(target);
    }

    private void spawnElectrocuteArcs(class_3218 server, class_1309 target) {
        Raevyx dragon = (Raevyx)this.getUser();
        Random rnd = new Random(dragon.method_6051().method_43055());
        boolean female = dragon.isFemale();
        class_243 center = target.method_19538().method_1031(0.0, (double)target.method_17682() * 0.5, 0.0);
        double radius = Math.max(target.method_5829().method_17939(), target.method_5829().method_17941()) * 0.6;
        int count = 6 + dragon.method_6051().method_43048(5);
        for (int i = 0; i < count; ++i) {
            class_243 a = RaevyxRoarAbility.randomUnit(rnd).method_1021(radius * (0.4 + rnd.nextDouble() * 0.6));
            class_243 b = RaevyxRoarAbility.randomUnit(rnd).method_1021(radius * (0.4 + rnd.nextDouble() * 0.6));
            class_243 from = center.method_1019(a);
            class_243 to = center.method_1019(b);
            this.spawnRoarArc(server, from, to, female);
        }
    }

    private void spawnRoarArc(class_3218 server, class_243 from, class_243 to, boolean female) {
        class_243 delta = to.method_1020(from);
        int steps = Math.max(2, (int)(delta.method_1033() * 4.0));
        class_243 step = delta.method_1021(1.0 / (double)steps);
        class_243 pos = from;
        class_243 dir = step.method_1029();
        float size = 0.8f;
        for (int i = 0; i <= steps; ++i) {
            server.method_14199((class_2394)new RaevyxLightningStormData(size, female), pos.field_1352, pos.field_1351, pos.field_1350, 1, dir.field_1352, dir.field_1351, dir.field_1350, 0.0);
            pos = pos.method_1019(step);
        }
    }

    private static class_243 randomUnit(Random rnd) {
        double u = rnd.nextDouble();
        double v = rnd.nextDouble();
        double theta = Math.PI * 2 * u;
        double z = 2.0 * v - 1.0;
        double r = Math.sqrt(1.0 - z * z);
        return new class_243(r * Math.cos(theta), z, r * Math.sin(theta));
    }

    private static void applyStun(class_1309 target) {
        int durationTicks = 30;
        target.method_6092(new class_1293(class_1294.field_5909, 30, 5, false, true));
        target.method_6092(new class_1293(class_1294.field_5911, 30, 0, false, true));
        target.method_6092(new class_1293(class_1294.field_5919, Math.min(30, 20), 0, false, true));
    }

    private class_1309 nextValidTarget(class_3218 server) {
        int n = this.targetIds != null ? this.targetIds.size() : 0;
        for (int i = 0; i < n; ++i) {
            class_1309 le;
            int idx = (this.targetCursor + i) % n;
            class_1297 e = server.method_8469(this.targetIds.get(idx).intValue());
            if (!(e instanceof class_1309) || !(le = (class_1309)e).method_5805()) continue;
            this.targetCursor = (idx + 1) % n;
            return le;
        }
        return null;
    }
}

