/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.stegonaut;

import com.leon.saintsdragons.common.item.StegonautBinderItem;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.dragons.stegonaut.Stegonaut;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_6025;

public final class StegonautBinderAbility {
    private static final double BUFF_RANGE = 8.0;
    private static final int BUFF_DURATION_TICKS = 40;
    private static final int BUFF_AMPLIFIER = 2;
    private static final int ABSORPTION_AMPLIFIER = 1;
    private static final Map<class_5321<class_1937>, Set<UUID>> ACTIVE_BUFF_TARGETS = new HashMap<class_5321<class_1937>, Set<UUID>>();

    private StegonautBinderAbility() {
    }

    public static void updateAllPortableBuffs(class_3218 level) {
        HashSet<UUID> currentTargets = new HashSet<UUID>();
        for (class_1657 player : level.method_18456()) {
            if (!player.method_5805() || !StegonautBinderAbility.hasBoundDrakeBinder(player)) continue;
            StegonautBinderAbility.applyPortableResistanceBuffs(level, player, currentTargets);
        }
        Set previousTargets = ACTIVE_BUFF_TARGETS.getOrDefault(level.method_27983(), Collections.emptySet());
        if (!previousTargets.isEmpty()) {
            for (UUID uuid : previousTargets) {
                class_1297 entity;
                if (currentTargets.contains(uuid) || !((entity = level.method_14190(uuid)) instanceof class_1309)) continue;
                class_1309 livingEntity = (class_1309)entity;
                livingEntity.method_6016(class_1294.field_5907);
                livingEntity.method_6016(class_1294.field_5898);
            }
        }
        ACTIVE_BUFF_TARGETS.put((class_5321<class_1937>)level.method_27983(), currentTargets);
    }

    private static void applyPortableResistanceBuffs(class_3218 level, class_1657 player, Set<UUID> currentTargets) {
        StegonautBinderAbility.applyBuffsToEntity((class_1309)player, currentTargets);
        List nearbyEntities = level.method_8390(class_1309.class, player.method_5829().method_1014(8.0), entity -> entity != player && StegonautBinderAbility.isEligibleForPortableBuff(entity, player));
        for (class_1309 entity2 : nearbyEntities) {
            StegonautBinderAbility.applyBuffsToEntity(entity2, currentTargets);
        }
    }

    private static boolean hasBoundDrakeBinder(class_1657 player) {
        if (StegonautBinderAbility.findBoundDrakeBinderInList((class_2371<class_1799>)player.method_31548().field_7547)) {
            return true;
        }
        if (StegonautBinderAbility.findBoundDrakeBinderInList((class_2371<class_1799>)player.method_31548().field_7544)) {
            return true;
        }
        return StegonautBinderAbility.findBoundDrakeBinderInList((class_2371<class_1799>)player.method_31548().field_7548);
    }

    private static boolean findBoundDrakeBinderInList(class_2371<class_1799> stacks) {
        for (class_1799 item : stacks) {
            if (item.method_7960() || !(item.method_7909() instanceof StegonautBinderItem) || !StegonautBinderItem.isBound(item)) continue;
            return StegonautBinderItem.getBoundDrakeUUID(item) != null;
        }
        return false;
    }

    private static boolean isEligibleForPortableBuff(class_1309 entity, class_1657 player) {
        class_6025 ownable;
        class_1309 owner;
        if (!entity.method_5805()) {
            return false;
        }
        if (entity instanceof class_1657) {
            return true;
        }
        if (entity instanceof DragonEntity) {
            DragonEntity dragon = (DragonEntity)entity;
            return dragon.method_6181() && dragon.method_6171((class_1309)player);
        }
        if (entity instanceof Stegonaut) {
            Stegonaut drake = (Stegonaut)entity;
            return drake.method_6181() && drake.allyManager.isAlly(player);
        }
        if (entity instanceof class_6025 && (owner = (ownable = (class_6025)entity).method_35057()) instanceof class_1657) {
            class_1657 ownerPlayer = (class_1657)owner;
            return ownerPlayer.method_5667().equals(player.method_5667());
        }
        return false;
    }

    private static void applyBuffsToEntity(class_1309 entity, Set<UUID> currentTargets) {
        class_1293 resistanceEffect = new class_1293(class_1294.field_5907, 40, 2, false, false, false);
        class_1293 absorptionEffect = new class_1293(class_1294.field_5898, 40, 1, false, false, false);
        entity.method_6092(resistanceEffect);
        entity.method_6092(absorptionEffect);
        currentTargets.add(entity.method_5667());
    }
}

