/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.stegonaut;

import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.dragons.stegonaut.Stegonaut;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_6025;

public class StegonautPassiveBuffAbility {
    private static final double BUFF_RANGE = 8.0;
    private static final int UPDATE_INTERVAL = 20;
    private static final int BUFF_DURATION_TICKS = 40;
    private static final int RESISTANCE_AMPLIFIER = 0;
    private static final int ABSORPTION_AMPLIFIER = 0;
    private final Stegonaut drake;
    private final class_1937 level;
    private int tickCounter = 0;
    private Set<UUID> buffedEntityIds = new HashSet<UUID>();

    public StegonautPassiveBuffAbility(Stegonaut drake) {
        this.drake = drake;
        this.level = drake.method_37908();
    }

    public void tick() {
        class_1937 class_19372 = this.level;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        if (++this.tickCounter < 20) {
            return;
        }
        this.tickCounter = 0;
        if (!this.drake.method_5805()) {
            this.clearTrackedBuffs(serverLevel);
            return;
        }
        this.applyBuffs(serverLevel);
    }

    private void applyBuffs(class_3218 serverLevel) {
        List nearbyEntities = serverLevel.method_8390(class_1309.class, this.drake.method_5829().method_1014(8.0), this::isEligibleForBuff);
        HashSet<UUID> currentNearby = new HashSet<UUID>();
        for (class_1309 entity : nearbyEntities) {
            this.applyResistance(entity);
            this.applyAbsorption(entity);
            currentNearby.add(entity.method_5667());
        }
        if (!this.buffedEntityIds.isEmpty()) {
            for (UUID uuid : new HashSet<UUID>(this.buffedEntityIds)) {
                class_1297 entity;
                if (currentNearby.contains(uuid) || !((entity = serverLevel.method_14190(uuid)) instanceof class_1309)) continue;
                class_1309 livingEntity = (class_1309)entity;
                livingEntity.method_6016(class_1294.field_5907);
                livingEntity.method_6016(class_1294.field_5898);
            }
        }
        this.buffedEntityIds = currentNearby;
    }

    private boolean isEligibleForBuff(class_1309 entity) {
        class_6025 ownable;
        class_1309 owner;
        if (entity == this.drake || !entity.method_5805()) {
            return false;
        }
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            return this.isPlayerEligible(player);
        }
        if (entity instanceof DragonEntity) {
            DragonEntity dragon = (DragonEntity)entity;
            return this.isDragonEligible(dragon);
        }
        if (entity instanceof class_6025 && (owner = (ownable = (class_6025)entity).method_35057()) instanceof class_1657) {
            class_1657 ownerPlayer = (class_1657)owner;
            if (!this.drake.method_6181()) {
                return false;
            }
            class_1309 drakeOwner = this.drake.method_35057();
            if (drakeOwner instanceof class_1657) {
                class_1657 drakeOwnerPlayer = (class_1657)drakeOwner;
                if (drakeOwnerPlayer.method_5667().equals(ownerPlayer.method_5667())) {
                    return true;
                }
                return this.drake.allyManager.isAlly(ownerPlayer);
            }
        }
        return false;
    }

    private boolean isPlayerEligible(class_1657 player) {
        if (!this.drake.method_6181()) {
            return false;
        }
        class_1309 owner = this.drake.method_35057();
        if (!(owner instanceof class_1657)) {
            return false;
        }
        class_1657 ownerPlayer = (class_1657)owner;
        if (ownerPlayer.method_5667().equals(player.method_5667())) {
            return true;
        }
        return this.drake.allyManager.isAlly(player);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isDragonEligible(DragonEntity dragon) {
        if (!this.drake.method_6181()) {
            return false;
        }
        class_1309 owner = this.drake.method_35057();
        if (!(owner instanceof class_1657)) return false;
        class_1657 ownerPlayer = (class_1657)owner;
        if (dragon.method_6171((class_1309)ownerPlayer)) {
            return true;
        }
        if (!(dragon instanceof Stegonaut)) return false;
        Stegonaut alliedDrake = (Stegonaut)dragon;
        if (!alliedDrake.allyManager.isAlly(ownerPlayer)) return false;
        return true;
    }

    private void applyResistance(class_1309 entity) {
        entity.method_6092(new class_1293(class_1294.field_5907, 40, 0, false, false, true));
    }

    private void applyAbsorption(class_1309 entity) {
        entity.method_6092(new class_1293(class_1294.field_5898, 40, 0, false, false, true));
    }

    public void cleanup() {
        class_1937 class_19372 = this.level;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.clearTrackedBuffs(serverLevel);
        } else {
            this.buffedEntityIds.clear();
        }
    }

    private void clearTrackedBuffs(class_3218 serverLevel) {
        for (UUID uuid : this.buffedEntityIds) {
            class_1297 entity = serverLevel.method_14190(uuid);
            if (!(entity instanceof class_1309)) continue;
            class_1309 livingEntity = (class_1309)entity;
            livingEntity.method_6016(class_1294.field_5907);
            livingEntity.method_6016(class_1294.field_5898);
        }
        this.buffedEntityIds.clear();
    }

    public static double getBuffRange() {
        return 8.0;
    }

    public static int getResistanceAmplifier() {
        return 0;
    }

    public static int getAbsorptionAmplifier() {
        return 0;
    }
}

