/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.base;

import com.leon.saintsdragons.common.network.DragonAnimTickets;
import com.leon.saintsdragons.common.registry.DragonType;
import com.leon.saintsdragons.common.registry.Element;
import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.base.DragonGender;
import com.leon.saintsdragons.server.entity.controller.DragonBodyControl;
import com.leon.saintsdragons.server.entity.controller.DragonLookControl;
import com.leon.saintsdragons.server.entity.handler.DragonAllyManager;
import com.leon.saintsdragons.server.entity.handler.DragonCombatHandler;
import com.leon.saintsdragons.server.entity.interfaces.DragonSoundProfile;
import com.leon.saintsdragons.util.math.SmoothValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1330;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_6025;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class DragonEntity
extends class_1321
implements GeoEntity {
    protected static final class_2940<Integer> DATA_COMMAND = class_2945.method_12791(DragonEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Float> DATA_SIT_PROGRESS = class_2945.method_12791(DragonEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Byte> DATA_GENDER = class_2945.method_12791(DragonEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Float> DATA_BODY_DEVIATION = class_2945.method_12791(DragonEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> DATA_PITCH_DEVIATION = class_2945.method_12791(DragonEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> DATA_YAW_VELOCITY = class_2945.method_12791(DragonEntity.class, (class_2941)class_2943.field_13320);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private DragonAbility<?> activeAbility = null;
    public final DragonCombatHandler combatManager;
    public final DragonAllyManager allyManager;
    public float sitProgress = 0.0f;
    public float prevSitProgress = 0.0f;
    private boolean dying = false;
    private boolean genderInitialized = false;
    private boolean isRespawning = false;
    protected int skipRespawnTicks = 0;
    public final SmoothValue bodyRotDeviation = SmoothValue.rotation(0.0);
    public final SmoothValue xRotDeviation = SmoothValue.rotation(0.0);
    public final SmoothValue yawVelocity = SmoothValue.rotation(0.0);
    private float clientTailDragVelocity = 0.0f;
    private boolean isRideable = false;

    protected DragonEntity(class_1299<? extends class_1321> entityType, class_1937 level) {
        super(entityType, level);
        this.combatManager = new DragonCombatHandler(this);
        this.allyManager = new DragonAllyManager(this);
        this.field_6206 = new DragonLookControl<DragonEntity>(this);
    }

    protected @NotNull class_1330 method_5963() {
        return new DragonBodyControl((class_1308)this, this.getBodyTurnSpeed());
    }

    protected float getBodyTurnSpeed() {
        return 0.6f;
    }

    protected void setRideable() {
        this.isRideable = true;
    }

    public boolean isRideableDragon() {
        return this.isRideable;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_COMMAND, (Object)0);
        this.field_6011.method_12784(DATA_SIT_PROGRESS, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(DATA_GENDER, (Object)DragonGender.MALE.getId());
        this.field_6011.method_12784(DATA_BODY_DEVIATION, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(DATA_PITCH_DEVIATION, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(DATA_YAW_VELOCITY, (Object)Float.valueOf(0.0f));
    }

    public float smoothTailDragVelocity(float targetDegrees) {
        this.clientTailDragVelocity = class_3532.method_16439((float)0.15f, (float)this.clientTailDragVelocity, (float)targetDegrees);
        return this.clientTailDragVelocity;
    }

    public void resetTailDragVelocity() {
        this.clientTailDragVelocity = 0.0f;
    }

    public DragonGender getGender() {
        return DragonGender.fromId((Byte)this.field_6011.method_12789(DATA_GENDER));
    }

    public void setGender(@Nullable DragonGender gender) {
        DragonGender resolved = gender == null ? DragonGender.MALE : gender;
        this.field_6011.method_12778(DATA_GENDER, (Object)resolved.getId());
        this.genderInitialized = true;
    }

    public boolean isFemale() {
        return this.getGender() == DragonGender.FEMALE;
    }

    public void setFemale(boolean female) {
        this.setGender(female ? DragonGender.FEMALE : DragonGender.MALE);
    }

    public boolean hasGender() {
        return this.genderInitialized;
    }

    protected void ensureGenderInitialized() {
        class_1937 level = this.method_37908();
        if (level != null && level.field_9236) {
            return;
        }
        if (!this.genderInitialized) {
            this.setGender(this.field_5974.method_43056() ? DragonGender.FEMALE : DragonGender.MALE);
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public abstract void registerControllers(AnimatableManager.ControllerRegistrar var1);

    public void syncAnimState(int groundState, int flightMode) {
        if (this.method_37908().field_9236) {
            return;
        }
        this.setAnimData(DragonAnimTickets.GROUND_STATE, groundState);
        this.setAnimData(DragonAnimTickets.FLIGHT_MODE, flightMode);
    }

    @NotNull
    public class_1315 method_5943(@NotNull class_5425 levelAccessor, @NotNull class_1266 difficulty, class_3730 reason, @Nullable class_1315 spawnData, @Nullable class_2487 spawnTag) {
        class_2338 safePos;
        class_1315 data = super.method_5943(levelAccessor, difficulty, reason, spawnData, spawnTag);
        this.ensureGenderInitialized();
        if (this.method_6109() && reason == class_3730.field_16465 && (safePos = this.findSafeBabySpawnPos((class_1936)levelAccessor, this.method_24515())) != null && (double)safePos.method_10264() < this.method_23318()) {
            this.method_5808(this.method_23317(), safePos.method_10264(), this.method_23321(), this.method_36454(), this.method_36455());
        }
        return data;
    }

    public <T extends DragonEntity> DragonAbility<T> getActiveAbility() {
        return this.activeAbility;
    }

    public void setActiveAbility(DragonAbility<?> ability) {
        this.activeAbility = ability;
    }

    public boolean canUseAbility() {
        return this.combatManager.canUseAbility();
    }

    public boolean areAbilitiesLocked() {
        return this.combatManager.isGlobalCooldownActive();
    }

    public void lockAbilities(int ticks) {
        this.combatManager.lockGlobalCooldown(ticks);
    }

    public <T extends DragonEntity> void tryActivateAbility(DragonAbilityType<T, ?> abilityType) {
        if (abilityType == null || this.method_37908().field_9236) {
            return;
        }
        this.combatManager.tryUseAbility(abilityType);
    }

    public Map<String, VocalEntry> getVocalEntries() {
        return Collections.emptyMap();
    }

    public DragonSoundProfile getSoundProfile() {
        return DragonSoundProfile.EMPTY;
    }

    protected DragonAbilityType<?, ?> getHurtAbilityType() {
        return null;
    }

    protected void onSuccessfulDamage(class_1282 source, float amount) {
        if (this.method_37908().field_9236 || this.isDying()) {
            return;
        }
        DragonAbilityType<?, ?> hurtAbility = this.getHurtAbilityType();
        if (hurtAbility != null) {
            this.combatManager.tryUseAbility(hurtAbility);
        }
    }

    protected class_3414 method_6011(@NotNull class_1282 source) {
        return null;
    }

    protected class_3414 method_6002() {
        return null;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
    }

    public boolean method_5679(@NotNull class_1282 source) {
        DragonType dragonType = this.getDragonType();
        if (dragonType != null && dragonType.getElementalProfile().isImmuneTo(source)) {
            return true;
        }
        return super.method_5679(source);
    }

    public boolean method_5753() {
        DragonType dragonType = this.getDragonType();
        if (dragonType != null && dragonType.getElement() == Element.FIRE) {
            return true;
        }
        return super.method_5753();
    }

    public boolean method_5643(@NotNull class_1282 source, float amount) {
        boolean result;
        DragonType dragonType = this.getDragonType();
        if (dragonType != null) {
            float multiplier = dragonType.getElementalProfile().getDamageMultiplier(source);
            amount *= multiplier;
            if (multiplier == 0.0f) {
                return false;
            }
        }
        if (result = super.method_5643(source, amount)) {
            this.onSuccessfulDamage(source, amount);
        }
        return result;
    }

    @Nullable
    public DragonType getDragonType() {
        return DragonType.fromEntity(this);
    }

    public abstract DragonAbilityType<?, ?> getPrimaryAttackAbility();

    public DragonAbilityType<?, ?> getRoaringAbility() {
        return null;
    }

    public DragonAbilityType<?, ?> getChannelingAbility() {
        return null;
    }

    public boolean isDying() {
        return this.dying;
    }

    public void onDeathAbilityStarted() {
    }

    public int getDeathAnimationDurationTicks() {
        return 62;
    }

    protected final void beginStandardDeathSequence(DragonAbilityType<?, ?> deathAbility) {
        if (this.method_37908().field_9236 || this.dying) {
            return;
        }
        this.method_5684(true);
        this.dying = true;
        if (!this.canUseAbility()) {
            this.combatManager.forceEndActiveAbility();
        }
        this.tryActivateAbilityUnchecked(deathAbility);
    }

    protected final void completeStandardDeathSequence() {
        this.dying = false;
        this.method_5684(false);
    }

    private void tryActivateAbilityUnchecked(DragonAbilityType<?, ?> type) {
        this.combatManager.tryUseAbility(type);
    }

    protected final boolean handleLethalDamage(class_1282 source, float amount, DragonAbilityType<?, ?> deathAbility) {
        if (this.method_37908().field_9236 || this.dying) {
            return false;
        }
        if (this.method_6032() - amount > 0.0f) {
            return false;
        }
        this.beginStandardDeathSequence(deathAbility);
        boolean abilityStarted = this.combatManager.isAbilityActive(deathAbility);
        if (!abilityStarted) {
            this.completeStandardDeathSequence();
            return false;
        }
        return true;
    }

    protected final void registerBiteSoundKey(AnimationController<?> controller, String speciesId) {
        controller.triggerableAnim("bite", RawAnimation.begin().thenPlay("animation." + speciesId + ".bite"));
    }

    public boolean isStayOrSitMuted() {
        return false;
    }

    public boolean isSleepTransitioning() {
        return false;
    }

    public boolean method_6581() {
        return false;
    }

    public boolean isRunning() {
        return false;
    }

    public boolean isWalking() {
        return false;
    }

    public boolean isActuallyRunning() {
        return false;
    }

    public double getCachedHorizontalSpeed() {
        return 0.0;
    }

    public boolean areRiderControlsLocked() {
        return false;
    }

    public class_243 getClientLocatorPosition(String locator) {
        return null;
    }

    public float maxSitTicks() {
        return 15.0f;
    }

    public float getSitProgress() {
        return ((Float)this.field_6011.method_12789(DATA_SIT_PROGRESS)).floatValue();
    }

    public boolean isGoingUp() {
        return false;
    }

    public void setGoingUp(boolean goingUp) {
    }

    public boolean isGoingDown() {
        return false;
    }

    public void setGoingDown(boolean goingDown) {
    }

    public class_1657 getRidingPlayer() {
        class_1309 class_13092 = this.method_5642();
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            return player;
        }
        return null;
    }

    protected void tickAbilities() {
        if (!this.method_37908().field_9236) {
            this.combatManager.tick();
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.skipRespawnTicks > 0) {
            --this.skipRespawnTicks;
        }
        this.tickAbilities();
        if (this.method_37908().field_9236) {
            this.updateRotationDeviations();
        } else {
            this.updateServerRotationTargets();
        }
    }

    private void updateRotationDeviations() {
        double headToBody = ((Float)this.field_6011.method_12789(DATA_BODY_DEVIATION)).floatValue();
        double pitchDelta = ((Float)this.field_6011.method_12789(DATA_PITCH_DEVIATION)).floatValue();
        double bodyYawDelta = ((Float)this.field_6011.method_12789(DATA_YAW_VELOCITY)).floatValue();
        this.bodyRotDeviation.setTo(headToBody);
        this.bodyRotDeviation.update(0.25f);
        this.xRotDeviation.setTo(pitchDelta);
        this.xRotDeviation.update(0.25f);
        this.yawVelocity.setTo(bodyYawDelta);
        this.yawVelocity.update(0.25f);
    }

    private void updateServerRotationTargets() {
        float bodyYawDelta = (float)((double)class_3532.method_15393((float)(this.field_6283 - this.field_6220)) * 2.0);
        this.field_6011.method_12778(DATA_YAW_VELOCITY, (Object)Float.valueOf(bodyYawDelta));
        if (this.method_5782()) {
            this.field_6011.method_12778(DATA_BODY_DEVIATION, (Object)Float.valueOf(0.0f));
            this.field_6011.method_12778(DATA_PITCH_DEVIATION, (Object)Float.valueOf(0.0f));
            return;
        }
        float headToBody = (float)((double)class_3532.method_15393((float)(this.field_6241 - this.field_6283)) * 0.25);
        float pitchDelta = (this.method_36455() - this.field_6004) * 0.5f;
        this.field_6011.method_12778(DATA_BODY_DEVIATION, (Object)Float.valueOf(headToBody));
        this.field_6011.method_12778(DATA_PITCH_DEVIATION, (Object)Float.valueOf(pitchDelta));
    }

    public int getCommand() {
        return (Integer)this.field_6011.method_12789(DATA_COMMAND);
    }

    public void setCommand(int command) {
        this.field_6011.method_12778(DATA_COMMAND, (Object)command);
        if (this.method_6181()) {
            this.method_24346(command == 1);
        }
    }

    public boolean canOwnerCommand(class_1657 player) {
        return player != null && player.method_18276();
    }

    public boolean canOwnerMount(class_1657 player) {
        return !this.method_6109();
    }

    public boolean isAlly(class_1297 entity) {
        class_6025 ownable;
        class_1309 owner;
        class_1321 tamable;
        class_1657 player;
        if (entity == null) {
            return false;
        }
        if (entity instanceof class_1657) {
            player = (class_1657)entity;
            if (this.method_6181() && this.method_6171((class_1309)player)) {
                return true;
            }
        }
        if (entity instanceof DragonEntity) {
            DragonEntity otherDragon = (DragonEntity)entity;
            if (this.method_6181() && otherDragon.method_6181()) {
                class_1309 owner2 = this.method_35057();
                if (owner2 instanceof class_1657) {
                    class_1657 ownerPlayer = (class_1657)owner2;
                    if (otherDragon.method_6171((class_1309)ownerPlayer)) {
                        return true;
                    }
                    class_1309 otherOwner = otherDragon.method_35057();
                    if (otherOwner instanceof class_1657) {
                        class_1657 otherPlayer = (class_1657)otherOwner;
                        return this.allyManager.isAlly(otherPlayer);
                    }
                }
                return false;
            }
        }
        if (entity instanceof class_1657) {
            player = (class_1657)entity;
            return this.allyManager.isAlly(player);
        }
        if (entity instanceof class_1321 && (tamable = (class_1321)entity).method_6181() && (owner = tamable.method_35057()) instanceof class_1657) {
            class_1657 playerOwner = (class_1657)owner;
            return this.method_6181() && this.method_6171((class_1309)playerOwner) || this.allyManager.isAlly(playerOwner);
        }
        if (entity instanceof class_6025 && (owner = (ownable = (class_6025)entity).method_35057()) instanceof class_1657) {
            class_1657 playerOwner = (class_1657)owner;
            return this.method_6181() && this.method_6171((class_1309)playerOwner) || this.allyManager.isAlly(playerOwner);
        }
        return false;
    }

    public boolean canTarget(class_1297 entity) {
        class_6025 ownable;
        class_1657 playerOwner;
        class_1309 owner;
        class_1321 tamable;
        if (entity == null) {
            return false;
        }
        if (this.isAlly(entity)) {
            return false;
        }
        if (entity instanceof class_1321 && (tamable = (class_1321)entity).method_6181() && (owner = tamable.method_35057()) instanceof class_1657) {
            playerOwner = (class_1657)owner;
            if (this.method_6181() && this.method_6171((class_1309)playerOwner)) {
                return false;
            }
        }
        if (entity instanceof class_6025 && (owner = (ownable = (class_6025)entity).method_35057()) instanceof class_1657) {
            playerOwner = (class_1657)owner;
            if (this.method_6181() && this.method_6171((class_1309)playerOwner)) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    public class_1269 method_5992(@NotNull class_1657 player, @NotNull class_1268 hand) {
        if (this.method_6181() && this.method_6171((class_1309)player) && this.canOwnerCommand(player) && hand == class_1268.field_5808 && player.method_5998(hand).method_7960()) {
            int next = (this.getCommand() + 1) % 3;
            this.setCommand(next);
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    public void method_5652(@NotNull class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("Command", this.getCommand());
        tag.method_10567("Gender", this.getGender().getId());
        tag.method_10556("IsFemale", this.isFemale());
        this.allyManager.saveToNBT(tag);
    }

    public void method_5749(@NotNull class_2487 tag) {
        if (tag.method_10545("IsRespawning")) {
            this.isRespawning = tag.method_10577("IsRespawning");
        }
        super.method_5749(tag);
        if (tag.method_10545("Command")) {
            this.setCommand(tag.method_10550("Command"));
        }
        if (tag.method_10573("Gender", 1)) {
            this.setGender(DragonGender.fromId(tag.method_10571("Gender")));
        } else if (tag.method_10545("IsFemale")) {
            this.setFemale(tag.method_10577("IsFemale"));
        } else {
            this.genderInitialized = false;
            this.ensureGenderInitialized();
        }
        this.allyManager.loadFromNBT(tag);
    }

    public void method_6091(@NotNull class_243 travelVector) {
        if (this.method_24345() && !this.method_5782() && !this.method_5765()) {
            this.method_18799(class_243.field_1353);
            super.method_6091(class_243.field_1353);
            return;
        }
        super.method_6091(travelVector);
    }

    public void method_5614(int age) {
        boolean wasBaby = this.method_6109();
        super.method_5614(age);
        boolean isNowBaby = this.method_6109();
        if (wasBaby != isNowBaby && !this.method_37908().field_9236 && !this.isRespawning && this.method_5628() != -1 && this.skipRespawnTicks == 0) {
            this.isRespawning = true;
            class_1937 world = this.method_37908();
            double posX = this.method_23317();
            double posY = this.method_23318();
            double posZ = this.method_23321();
            float yaw = this.method_36454();
            float pitch = this.method_36455();
            UUID oldUUID = this.method_5667();
            boolean wasTamed = this.method_6181();
            class_2487 nbt = new class_2487();
            this.method_5647(nbt);
            nbt.method_10556("IsRespawning", true);
            nbt.method_10569("Age", age);
            DragonEntity newEntity = (DragonEntity)this.method_5864().method_5883(world);
            if (newEntity != null) {
                newEntity.method_5651(nbt);
                newEntity.method_5814(posX, posY, posZ);
                newEntity.method_36456(yaw);
                newEntity.method_36457(pitch);
                if (wasTamed) {
                    newEntity.method_5826(oldUUID);
                }
                newEntity.isRespawning = false;
                world.method_8649((class_1297)newEntity);
                this.method_31472();
                world.method_8421((class_1297)newEntity, (byte)7);
            }
        }
    }

    public void method_24650(class_3218 level, class_1429 otherParent) {
        class_1296 baby = this.method_5613(level, (class_1296)otherParent);
        if (baby != null) {
            class_2338 safePos = this.findSafeBabySpawnPos((class_1936)level, this.method_24515());
            baby.method_7217(true);
            baby.method_5808(this.method_23317(), safePos != null ? (double)safePos.method_10264() : this.method_23318(), this.method_23321(), 0.0f, 0.0f);
            level.method_30771((class_1297)baby);
        }
    }

    @Nullable
    protected class_2338 findSafeBabySpawnPos(class_1936 level, class_2338 start) {
        if (level == null || start == null) {
            return null;
        }
        class_2338.class_2339 cursor = start.method_25503();
        int minY = level.method_31607();
        while (cursor.method_10264() >= minY) {
            class_2338 above;
            class_2680 aboveState;
            class_2680 state = level.method_8320((class_2338)cursor);
            if (this.isStableBabyLandingSurface((class_1922)level, (class_2338)cursor, state) && (aboveState = level.method_8320(above = cursor.method_10084())).method_26220((class_1922)level, above).method_1110() && aboveState.method_26227().method_15769()) {
                return above;
            }
            cursor.method_10098(class_2350.field_11033);
        }
        return null;
    }

    private boolean isStableBabyLandingSurface(class_1922 level, class_2338 pos, class_2680 state) {
        if (state.method_26215() || !state.method_26227().method_15769()) {
            return false;
        }
        return state.method_26216(level, pos) || state.method_26206(level, pos, class_2350.field_11036);
    }

    public abstract class_243 getHeadPosition();

    public abstract class_243 getMouthPosition();

    public static final class VocalEntryBuilder {
        private final Map<String, VocalEntry> entries = new HashMap<String, VocalEntry>();

        public VocalEntryBuilder add(String key, String controller, String animation, Supplier<class_3414> sound, float volume, float basePitch, float variance, boolean allowWhenSitting, boolean allowDuringSleep, boolean preventOverlap) {
            this.entries.put(key, new VocalEntry(controller, animation, sound, volume, basePitch, variance, allowWhenSitting, allowDuringSleep, preventOverlap));
            return this;
        }

        public VocalEntryBuilder add(String key, String controller, String animation, Supplier<class_3414> sound) {
            return this.add(key, controller, animation, sound, 1.0f, 1.0f, 0.0f, false, false, false);
        }

        public Map<String, VocalEntry> build() {
            return Map.copyOf(this.entries);
        }
    }

    public record VocalEntry(String controllerId, String animationId, Supplier<class_3414> soundSupplier, float volume, float basePitch, float pitchVariance, boolean allowWhenSitting, boolean allowDuringSleep, boolean preventOverlap) {
    }
}

