/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.base;

import com.leon.saintsdragons.common.network.DragonAnimTickets;
import com.leon.saintsdragons.common.network.DragonRiderAction;
import com.leon.saintsdragons.common.network.MessageDragonRideInput;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.base.RideableDragonData;
import com.leon.saintsdragons.server.entity.interfaces.RideableDragon;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1432;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RideableDragonBase
extends DragonEntity
implements RideableDragon,
class_1432 {
    private static final class_2940<Integer> DATA_MELEE_MODE = class_2945.method_12791(RideableDragonBase.class, (class_2941)class_2943.field_13327);

    protected RideableDragonBase(class_1299<? extends class_1321> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_MELEE_MODE, (Object)0);
        this.defineRideableDragonData();
    }

    protected abstract void defineRideableDragonData();

    public boolean canBeControlledBy(class_1657 player) {
        if (player == null) {
            return false;
        }
        if (this.method_6181()) {
            return this.method_6171((class_1309)player);
        }
        return player.method_7337() || player.method_7325();
    }

    public void handleRiderNetworkInput(class_3222 player, MessageDragonRideInput msg) {
        boolean locked = this.isRiderInputLocked((class_1657)player);
        this.applyRiderVerticalInput((class_1657)player, msg.goingUp(), msg.goingDown(), locked);
        this.applyRiderMovementInput((class_1657)player, msg.forward(), msg.strafe(), msg.yaw(), locked);
        this.handleRiderAction(player, msg.action(), msg.abilityName(), locked);
    }

    protected boolean isRiderInputLocked(class_1657 player) {
        return false;
    }

    protected void applyRiderVerticalInput(class_1657 player, boolean goingUp, boolean goingDown, boolean locked) {
        if (locked) {
            this.setGoingUp(false);
            this.setGoingDown(false);
            return;
        }
        this.setGoingUp(goingUp);
        this.setGoingDown(goingDown);
    }

    protected float applyInputDeadzone(float value) {
        return Math.abs(value) > 0.02f ? value : 0.0f;
    }

    protected void applyRiderMovementInput(class_1657 player, float forward, float strafe, float yaw, boolean locked) {
        float clampedForward = locked ? 0.0f : this.applyInputDeadzone(forward);
        float clampedStrafe = locked ? 0.0f : this.applyInputDeadzone(strafe);
        this.setLastRiderForward(clampedForward);
        this.setLastRiderStrafe(clampedStrafe);
    }

    protected void handleRiderAction(class_3222 player, DragonRiderAction action, String abilityName, boolean locked) {
        if (action == null) {
            return;
        }
        switch (action) {
            case TAKEOFF_REQUEST: {
                if (locked) break;
                this.onRiderTakeoffRequest((class_1657)player);
                break;
            }
            case ACCELERATE: {
                if (locked) break;
                this.onRiderAccelerationStart((class_1657)player);
                break;
            }
            case STOP_ACCELERATE: {
                this.onRiderAccelerationStop((class_1657)player);
                break;
            }
            case ABILITY_USE: {
                if (locked) break;
                this.onRiderAbilityUse((class_1657)player, abilityName);
                break;
            }
            case ABILITY_STOP: {
                if (locked) break;
                this.onRiderAbilityStop((class_1657)player, abilityName);
                break;
            }
            case TOGGLE_MELEE: {
                if (locked) break;
                this.onRiderToggleMelee((class_1657)player);
                break;
            }
        }
    }

    protected void onRiderToggleMelee(class_1657 player) {
        if (!this.hasSecondaryMelee()) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                serverPlayer.method_7353((class_2561)class_2561.method_43471((String)"saintsdragons.message.no_secondary_melee"), true);
            }
            return;
        }
        this.toggleMeleeMode();
    }

    public boolean hasSecondaryMelee() {
        return true;
    }

    protected void onRiderTakeoffRequest(class_1657 player) {
    }

    protected void onRiderAccelerationStart(class_1657 player) {
        this.setAccelerating(true);
    }

    protected void onRiderAccelerationStop(class_1657 player) {
        this.setAccelerating(false);
    }

    protected void onRiderAbilityUse(class_1657 player, String abilityName) {
    }

    protected void onRiderAbilityStop(class_1657 player, String abilityName) {
    }

    protected float getRiderLockYawBlend() {
        return 0.18f;
    }

    protected float getRiderLockPitchBlend() {
        return 0.18f;
    }

    protected float getRiderLockPitchMin() {
        return -45.0f;
    }

    protected float getRiderLockPitchMax() {
        return 45.0f;
    }

    @Nullable
    public RiderAbilityBinding getPrimaryRiderAbility() {
        return null;
    }

    @Nullable
    public RiderAbilityBinding getSecondaryRiderAbility() {
        return null;
    }

    @Nullable
    public RiderAbilityBinding getTertiaryRiderAbility() {
        return null;
    }

    @Nullable
    public RiderAbilityBinding getAttackRiderAbility() {
        return null;
    }

    public int getMeleeMode() {
        return (Integer)this.field_6011.method_12789(DATA_MELEE_MODE);
    }

    public void setMeleeMode(int mode) {
        this.field_6011.method_12778(DATA_MELEE_MODE, (Object)class_3532.method_15340((int)mode, (int)0, (int)1));
    }

    public void toggleMeleeMode() {
        this.setMeleeMode(this.getMeleeMode() == 0 ? 1 : 0);
    }

    @Override
    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("MeleeMode", this.getMeleeMode());
    }

    @Override
    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        if (tag.method_10545("MeleeMode")) {
            this.setMeleeMode(tag.method_10550("MeleeMode"));
        }
    }

    public byte buildClientControlState(boolean ascendDown, boolean descendDown, boolean attackDown, boolean primaryDown, boolean secondaryDown, boolean sneakDown) {
        return -1;
    }

    protected abstract class_2940<Float> getRiderForwardAccessor();

    protected abstract class_2940<Float> getRiderStrafeAccessor();

    protected abstract class_2940<Integer> getGroundMoveStateAccessor();

    protected abstract class_2940<Integer> getFlightModeAccessor();

    protected abstract class_2940<Boolean> getGoingUpAccessor();

    protected abstract class_2940<Boolean> getGoingDownAccessor();

    protected abstract class_2940<Boolean> getAcceleratingAccessor();

    @Override
    public void setLastRiderForward(float forward) {
        this.field_6011.method_12778(this.getRiderForwardAccessor(), (Object)Float.valueOf(forward));
    }

    @Override
    public void setLastRiderStrafe(float strafe) {
        this.field_6011.method_12778(this.getRiderStrafeAccessor(), (Object)Float.valueOf(strafe));
    }

    @Override
    public int getGroundMoveState() {
        return (Integer)this.field_6011.method_12789(this.getGroundMoveStateAccessor());
    }

    @Override
    public int getSyncedFlightMode() {
        return (Integer)this.field_6011.method_12789(this.getFlightModeAccessor());
    }

    @Override
    public int getEffectiveGroundState() {
        Integer state = (Integer)this.getAnimData(DragonAnimTickets.GROUND_STATE);
        if (state != null) {
            return state;
        }
        return (Integer)this.field_6011.method_12789(this.getGroundMoveStateAccessor());
    }

    @Override
    public boolean isGoingUp() {
        return (Boolean)this.field_6011.method_12789(this.getGoingUpAccessor());
    }

    @Override
    public void setGoingUp(boolean goingUp) {
        this.field_6011.method_12778(this.getGoingUpAccessor(), (Object)goingUp);
    }

    @Override
    public boolean isGoingDown() {
        return (Boolean)this.field_6011.method_12789(this.getGoingDownAccessor());
    }

    @Override
    public void setGoingDown(boolean goingDown) {
        this.field_6011.method_12778(this.getGoingDownAccessor(), (Object)goingDown);
    }

    @Override
    public boolean isAccelerating() {
        return (Boolean)this.field_6011.method_12789(this.getAcceleratingAccessor());
    }

    @Override
    public void setAccelerating(boolean accelerating) {
        this.field_6011.method_12778(this.getAcceleratingAccessor(), (Object)accelerating);
    }

    protected void copyRiderLook(class_1657 player) {
        if (player == null) {
            return;
        }
        float currentYaw = this.method_36454();
        float targetYaw = player.method_36454();
        float yawDelta = class_3532.method_15393((float)(targetYaw - currentYaw));
        float yawBlend = this.getRiderLockYawBlend();
        float blendedYaw = currentYaw + yawDelta * yawBlend;
        this.method_36456(blendedYaw);
        this.field_6220 = this.field_6283;
        this.field_6283 = blendedYaw;
        this.field_6259 = this.field_6241;
        this.method_5847(blendedYaw);
        float targetPitch = class_3532.method_15363((float)player.method_36455(), (float)this.getRiderLockPitchMin(), (float)this.getRiderLockPitchMax());
        float blendedPitch = class_3532.method_16439((float)this.getRiderLockPitchBlend(), (float)this.method_36455(), (float)targetPitch);
        this.field_6004 = this.method_36455();
        this.method_36457(blendedPitch);
    }

    @Override
    public void syncAnimState(int groundState, int flightMode) {
        if (this.method_37908().field_9236) {
            return;
        }
        this.setAnimData(DragonAnimTickets.GROUND_STATE, groundState);
        this.setAnimData(DragonAnimTickets.FLIGHT_MODE, flightMode);
    }

    @Override
    public void initializeAnimationState() {
        if (!this.method_37908().field_9236) {
            int initialGroundState = 0;
            int initialFlightMode = -1;
            if (!(this.method_6581() || this.isTakeoff() || this.isLanding() || this.isHovering())) {
                double velSqr = this.method_18798().method_37268();
                initialGroundState = RideableDragonData.getGroundStateFromVelocity(velSqr);
            } else if (this.method_6581()) {
                initialFlightMode = this.getFlightMode();
            }
            this.field_6011.method_12778(this.getGroundMoveStateAccessor(), (Object)initialGroundState);
            this.field_6011.method_12778(this.getFlightModeAccessor(), (Object)initialFlightMode);
        }
    }

    @Override
    public void resetAnimationState() {
        if (!this.method_37908().field_9236) {
            int currentGroundState = 0;
            if (!(this.method_6581() || this.isTakeoff() || this.isLanding() || this.isHovering())) {
                double velSqr = this.method_18798().method_37268();
                currentGroundState = RideableDragonData.getGroundStateFromVelocity(velSqr);
            }
            int currentFlightMode = this.getFlightMode();
            this.field_6011.method_12778(this.getGroundMoveStateAccessor(), (Object)currentGroundState);
            this.field_6011.method_12778(this.getFlightModeAccessor(), (Object)currentFlightMode);
            this.syncAnimState(currentGroundState, currentFlightMode);
        }
    }

    @Override
    @NotNull
    public class_243 method_49482(@NotNull class_1657 player, @NotNull class_243 deltaIn) {
        class_243 input = super.method_49482(player, deltaIn);
        if (!this.method_37908().field_9236 && !this.method_6581()) {
            float fwd = (float)class_3532.method_15350((double)input.field_1350, (double)-1.0, (double)1.0);
            float str = (float)class_3532.method_15350((double)input.field_1352, (double)-1.0, (double)1.0);
            this.setLastRiderForward(RideableDragonData.applyInputThreshold(fwd));
            this.setLastRiderStrafe(RideableDragonData.applyInputThreshold(str));
        }
        return input;
    }

    @Override
    public void method_5793(@NotNull class_1297 passenger) {
        super.method_5793(passenger);
        if (!this.method_37908().field_9236) {
            this.setAccelerating(false);
            this.setRunning(false);
            this.setLastRiderForward(0.0f);
            this.setLastRiderStrafe(0.0f);
            this.field_6011.method_12778(this.getGroundMoveStateAccessor(), (Object)0);
            this.syncAnimState(0, this.getSyncedFlightMode());
        }
    }

    @Override
    public void tickAnimationStates() {
        boolean flightModeChanged;
        int moveState = 0;
        if (!(this.method_6581() || this.isTakeoff() || this.isLanding() || this.isHovering())) {
            if (this.method_5642() != null) {
                float str;
                float fwd = ((Float)this.field_6011.method_12789(this.getRiderForwardAccessor())).floatValue();
                if (RideableDragonData.isSignificantRiderInput(fwd, str = ((Float)this.field_6011.method_12789(this.getRiderStrafeAccessor())).floatValue())) {
                    moveState = this.isAccelerating() ? 2 : 1;
                } else {
                    double speedSqr = this.method_18798().method_37268();
                    moveState = RideableDragonData.getRiddenGroundStateFromVelocity(speedSqr);
                }
            } else {
                double velSqr = this.method_18798().method_37268();
                moveState = RideableDragonData.getGroundStateFromVelocity(velSqr);
            }
        }
        int flightMode = this.getFlightMode();
        boolean groundStateChanged = (Integer)this.field_6011.method_12789(this.getGroundMoveStateAccessor()) != moveState;
        boolean bl = flightModeChanged = (Integer)this.field_6011.method_12789(this.getFlightModeAccessor()) != flightMode;
        if (groundStateChanged) {
            this.field_6011.method_12778(this.getGroundMoveStateAccessor(), (Object)moveState);
        }
        if (flightModeChanged) {
            this.field_6011.method_12778(this.getFlightModeAccessor(), (Object)flightMode);
        }
        if (groundStateChanged || flightModeChanged) {
            this.syncAnimState(moveState, flightMode);
        }
        if (((Float)this.field_6011.method_12789(this.getRiderForwardAccessor())).floatValue() != 0.0f || ((Float)this.field_6011.method_12789(this.getRiderStrafeAccessor())).floatValue() != 0.0f) {
            float nf = RideableDragonData.decayRiderInput(((Float)this.field_6011.method_12789(this.getRiderForwardAccessor())).floatValue());
            float ns = RideableDragonData.decayRiderInput(((Float)this.field_6011.method_12789(this.getRiderStrafeAccessor())).floatValue());
            this.field_6011.method_12778(this.getRiderForwardAccessor(), (Object)Float.valueOf(nf));
            this.field_6011.method_12778(this.getRiderStrafeAccessor(), (Object)Float.valueOf(ns));
        }
        if (this.isRunning() && this.method_18798().method_37268() < 0.01) {
            this.setRunning(false);
        }
    }

    protected abstract int getFlightMode();

    @Override
    public final boolean method_6581() {
        return this.isDragonFlying();
    }

    protected abstract boolean isDragonFlying();

    public abstract boolean isTakeoff();

    public abstract boolean isLanding();

    public abstract boolean isHovering();

    @Override
    public abstract boolean isRunning();

    public abstract void setRunning(boolean var1);

    public void forceSitProgress(float value) {
        float clamped;
        this.sitProgress = clamped = class_3532.method_15363((float)value, (float)0.0f, (float)this.maxSitTicks());
        this.prevSitProgress = clamped;
        this.field_6011.method_12778(DATA_SIT_PROGRESS, (Object)Float.valueOf(clamped));
    }

    protected void saveRideableData(class_2487 tag) {
        tag.method_10556("Flying", this.method_6581());
        tag.method_10556("Takeoff", this.isTakeoff());
        tag.method_10556("Hovering", this.isHovering());
        tag.method_10556("Landing", this.isLanding());
        tag.method_10556("Running", this.isRunning());
        tag.method_10556("Accelerating", ((Boolean)this.field_6011.method_12789(this.getAcceleratingAccessor())).booleanValue());
        tag.method_10556("GoingUp", this.isGoingUp());
        tag.method_10556("GoingDown", this.isGoingDown());
        tag.method_10569("GroundMoveState", ((Integer)this.field_6011.method_12789(this.getGroundMoveStateAccessor())).intValue());
        tag.method_10569("FlightMode", ((Integer)this.field_6011.method_12789(this.getFlightModeAccessor())).intValue());
        tag.method_10548("RiderForward", ((Float)this.field_6011.method_12789(this.getRiderForwardAccessor())).floatValue());
        tag.method_10548("RiderStrafe", ((Float)this.field_6011.method_12789(this.getRiderStrafeAccessor())).floatValue());
        tag.method_10556("IsSitting", this.method_24345());
        tag.method_10548("SitProgress", this.sitProgress);
    }

    protected void loadRideableData(class_2487 tag) {
        boolean savedFlying = tag.method_10577("Flying");
        boolean savedTakeoff = tag.method_10577("Takeoff");
        boolean savedHovering = tag.method_10577("Hovering");
        boolean savedLanding = tag.method_10577("Landing");
        this.applyLoadedFlightState(savedFlying, savedTakeoff, savedHovering, savedLanding);
        this.setRunning(tag.method_10577("Running"));
        this.setAccelerating(tag.method_10577("Accelerating"));
        this.setGoingUp(savedFlying && tag.method_10577("GoingUp"));
        this.setGoingDown(savedFlying && tag.method_10577("GoingDown"));
        int groundState = tag.method_10545("GroundMoveState") ? tag.method_10550("GroundMoveState") : 0;
        this.field_6011.method_12778(this.getGroundMoveStateAccessor(), (Object)class_3532.method_15340((int)groundState, (int)0, (int)2));
        int flightMode = tag.method_10545("FlightMode") ? tag.method_10550("FlightMode") : -1;
        this.field_6011.method_12778(this.getFlightModeAccessor(), (Object)(savedFlying ? class_3532.method_15340((int)flightMode, (int)-1, (int)3) : -1));
        float riderForward = tag.method_10545("RiderForward") ? tag.method_10583("RiderForward") : 0.0f;
        float riderStrafe = tag.method_10545("RiderStrafe") ? tag.method_10583("RiderStrafe") : 0.0f;
        this.field_6011.method_12778(this.getRiderForwardAccessor(), (Object)Float.valueOf(riderForward));
        this.field_6011.method_12778(this.getRiderStrafeAccessor(), (Object)Float.valueOf(riderStrafe));
        boolean savedSitting = tag.method_10577("IsSitting");
        this.method_24346(savedSitting);
        float savedSitProgress = tag.method_10545("SitProgress") ? tag.method_10583("SitProgress") : (savedSitting ? this.maxSitTicks() : 0.0f);
        this.prevSitProgress = this.sitProgress = class_3532.method_15363((float)savedSitProgress, (float)0.0f, (float)this.maxSitTicks());
        this.field_6011.method_12778(DATA_SIT_PROGRESS, (Object)Float.valueOf(this.sitProgress));
        if (!this.method_37908().field_9236) {
            this.syncAnimState((Integer)this.field_6011.method_12789(this.getGroundMoveStateAccessor()), (Integer)this.field_6011.method_12789(this.getFlightModeAccessor()));
        }
    }

    protected void applyLoadedFlightState(boolean flying, boolean takeoff, boolean hovering, boolean landing) {
    }

    public record RiderAbilityBinding(String abilityId, Activation activation) {

        public static enum Activation {
            PRESS,
            HOLD;

        }
    }
}

