/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.conductivity;

import com.leon.saintsdragons.server.entity.conductivity.ElectricalConductivityProfile;
import com.leon.saintsdragons.server.entity.conductivity.ElectricalConductivityState;
import com.leon.saintsdragons.server.entity.interfaces.ElectricalConductivityCapable;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;

public final class ElectricalConductivityHelper {
    private ElectricalConductivityHelper() {
    }

    public static ElectricalConductivityState evaluate(ElectricalConductivityCapable subject) {
        class_1309 entity = subject.asConductiveEntity();
        class_1937 level = entity.method_37908();
        class_2338 pos = entity.method_24515();
        boolean submerged = entity.method_5816();
        boolean wet = entity.method_5637() || level.method_8520(pos) || level.method_8546() && level.method_8311(pos);
        ElectricalConductivityProfile profile = subject.getConductivityProfile();
        float damage = profile.baseDamageMultiplier();
        double range = profile.baseRangeMultiplier();
        if (submerged) {
            damage += profile.submergedDamageBonus();
            range += profile.submergedRangeBonus();
        } else if (wet) {
            damage += profile.wetDamageBonus();
            range += profile.wetRangeBonus();
        }
        if (damage < 0.0f) {
            damage = 0.0f;
        }
        if (range < 0.0) {
            range = 0.0;
        }
        return new ElectricalConductivityState(submerged, wet, damage, range);
    }
}

