/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.controller.cindervane;

import com.leon.saintsdragons.server.entity.dragons.cindervane.Cindervane;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record CindervaneRiderController(Cindervane dragon) {
    private static final double SEAT_BASE_FACTOR = 0.05;
    private static final double SEAT_LIFT = 0.7;
    private static final double SEAT_0_FORWARD = 8.0;
    private static final double SEAT_0_SIDE = 0.0;
    private static final double SEAT_1_FORWARD = 4.0;
    private static final double SEAT_1_SIDE = 0.0;
    private static final double CRUISE_SPEED_MULT = 4.5;
    private static final double SPRINT_SPEED_MULT = 6.5;
    private static final double ACCELERATION = 0.12;
    private static final double DRAG_WITH_INPUT = 0.06;
    private static final double DRAG_NO_INPUT = 0.45;
    private static final double STRAFE_POWER = 0.4;
    private static final double ASCEND_THRUST = 0.06;
    private static final double DESCEND_THRUST = 0.85;
    private static final double TERMINAL_VELOCITY = 1.2;
    private static final double VERTICAL_DRAG = 0.95;

    @Nullable
    public class_1657 getRidingPlayer() {
        class_1309 class_13092 = this.dragon.method_5642();
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            return player;
        }
        return null;
    }

    public class_243 getRiddenInput(class_1657 player, class_243 deltaIn) {
        float f;
        float f2 = f = player.field_6250 < 0.0f ? 0.5f : 1.0f;
        if (this.dragon.method_6581()) {
            return new class_243((double)(player.field_6212 * 0.3f), 0.0, (double)(player.field_6250 * 0.8f * f));
        }
        return new class_243((double)(player.field_6212 * 0.4f), 0.0, (double)(player.field_6250 * 0.7f * f));
    }

    public void tickRidden(class_1657 player, class_243 travelVector) {
        player.field_6017 = 0.0f;
        this.dragon.field_6017 = 0.0f;
        this.dragon.method_5980(null);
        boolean flying = this.dragon.method_6581();
        float yawDiff = Math.abs(player.method_36454() - this.dragon.method_36454());
        if (player.field_6250 != 0.0f || player.field_6212 != 0.0f || yawDiff > 5.0f) {
            float currentYaw = this.dragon.method_36454();
            float targetYaw = player.method_36454();
            float rawDiff = class_3532.method_15393((float)(targetYaw - currentYaw));
            float blend = flying ? 0.3f : 0.25f;
            float newYaw = currentYaw + rawDiff * blend;
            this.dragon.method_36456(newYaw);
            this.dragon.field_6283 = newYaw;
            this.dragon.field_6241 = newYaw;
            if (flying) {
                float targetPitch = class_3532.method_15363((float)(player.method_36455() * 0.4f), (float)-35.0f, (float)30.0f);
                this.dragon.method_36457(targetPitch);
            } else {
                this.dragon.method_36457(0.0f);
            }
            this.dragon.method_18799(this.dragon.method_18798());
        }
        if (this.dragon.method_24828()) {
            player.field_6017 = 0.0f;
            this.dragon.field_6017 = 0.0f;
        }
    }

    public float getRiddenSpeed(class_1657 rider) {
        if (this.dragon.method_6581()) {
            return (float)this.dragon.method_26825(class_5134.field_23720);
        }
        float baseSpeed = (float)this.dragon.method_26825(class_5134.field_23719);
        if (this.dragon.isAccelerating()) {
            return baseSpeed * 0.6f;
        }
        return baseSpeed * 0.5f;
    }

    public void handleRiderMovement(class_1657 player, class_243 motion) {
        if (this.dragon.method_5942().method_6345() != null) {
            this.dragon.method_5942().method_6340();
        }
        if (this.dragon.method_6581()) {
            class_243 newHorizontalVel;
            boolean hasInput;
            double baseSpeed = this.dragon.method_26825(class_5134.field_23720);
            boolean sprinting = this.dragon.isAccelerating();
            double targetSpeed = (sprinting ? 6.5 : 4.5) * baseSpeed;
            double forwardInput = motion.field_1350;
            double strafeInput = motion.field_1352;
            class_243 currentVel = this.dragon.method_18798();
            class_243 horizontalVel = new class_243(currentVel.field_1352, 0.0, currentVel.field_1350);
            float yawRad = (float)Math.toRadians(this.dragon.method_36454());
            double forwardX = -Math.sin(yawRad);
            double forwardZ = Math.cos(yawRad);
            double strafeX = Math.cos(yawRad);
            double strafeZ = Math.sin(yawRad);
            double targetDirX = forwardX * forwardInput + strafeX * strafeInput * 0.4;
            double targetDirZ = forwardZ * forwardInput + strafeZ * strafeInput * 0.4;
            double dirLength = Math.hypot(targetDirX, targetDirZ);
            boolean bl = hasInput = Math.abs(forwardInput) > 0.01 || Math.abs(strafeInput) > 0.01;
            if (hasInput && dirLength > 0.01) {
                class_243 targetVelocity = new class_243((targetDirX /= dirLength) * targetSpeed, 0.0, (targetDirZ /= dirLength) * targetSpeed);
                newHorizontalVel = new class_243(class_3532.method_16436((double)0.12, (double)horizontalVel.field_1352, (double)targetVelocity.field_1352), 0.0, class_3532.method_16436((double)0.12, (double)horizontalVel.field_1350, (double)targetVelocity.field_1350));
                newHorizontalVel = newHorizontalVel.method_1021(0.94);
            } else {
                newHorizontalVel = horizontalVel.method_1021(0.55);
                if (newHorizontalVel.method_1033() < 0.01) {
                    newHorizontalVel = class_243.field_1353;
                }
            }
            double finalSpeed = newHorizontalVel.method_1033();
            if (finalSpeed > targetSpeed) {
                newHorizontalVel = newHorizontalVel.method_1021(targetSpeed / finalSpeed);
            }
            double newVerticalVel = currentVel.field_1351;
            newVerticalVel = this.dragon.isGoingUp() ? (newVerticalVel += 0.06) : (this.dragon.isGoingDown() ? (newVerticalVel -= 0.85) : (newVerticalVel *= 0.95));
            newVerticalVel = class_3532.method_15350((double)newVerticalVel, (double)-1.2, (double)1.2);
            class_243 finalVelocity = new class_243(newHorizontalVel.field_1352, newVerticalVel, newHorizontalVel.field_1350);
            this.dragon.method_5784(class_1313.field_6308, finalVelocity);
            this.dragon.method_18799(finalVelocity);
            this.dragon.method_29242(true);
            player.field_6017 = 0.0f;
            this.dragon.field_6017 = 0.0f;
        }
    }

    public double getPassengersRidingOffset() {
        return (double)this.dragon.method_17682() * 0.05;
    }

    public void positionRider(@NotNull class_1297 passenger, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_1297.class_4738 moveFunction) {
        if (!this.dragon.method_5626(passenger)) {
            return;
        }
        List passengers = this.dragon.method_5685();
        int seatIndex = passengers.indexOf(passenger);
        if (seatIndex == -1) {
            return;
        }
        String locatorName = seatIndex == 0 ? "passengerSeat0" : "passengerSeat1";
        class_243 passengerLoc = this.dragon.getClientLocatorPosition(locatorName);
        if (passengerLoc != null) {
            class_243 dragonOldPos = new class_243(this.dragon.field_6014, this.dragon.field_6036, this.dragon.field_5969);
            float oldYaw = this.dragon.field_5982;
            class_243 worldOffset = passengerLoc.method_1020(dragonOldPos);
            double oldYawRad = Math.toRadians(-oldYaw);
            double cosOld = Math.cos(oldYawRad);
            double sinOld = Math.sin(oldYawRad);
            double localX = worldOffset.field_1352 * cosOld - worldOffset.field_1350 * sinOld;
            double localY = worldOffset.field_1351;
            double localZ = worldOffset.field_1352 * sinOld + worldOffset.field_1350 * cosOld;
            float currentYaw = this.dragon.method_36454();
            double currentYawRad = Math.toRadians(-currentYaw);
            double cosCurrent = Math.cos(currentYawRad);
            double sinCurrent = Math.sin(currentYawRad);
            double currentWorldX = localX * cosCurrent + localZ * sinCurrent;
            double currentWorldZ = -localX * sinCurrent + localZ * cosCurrent;
            class_243 dragonCurrentPos = this.dragon.method_19538();
            class_243 passengerCurrentPos = dragonCurrentPos.method_1031(currentWorldX, localY, currentWorldZ);
            moveFunction.accept(passenger, passengerCurrentPos.field_1352, passengerCurrentPos.field_1351, passengerCurrentPos.field_1350);
        } else {
            double side;
            double forward;
            double offsetY = this.getPassengersRidingOffset() + 0.7;
            if (seatIndex == 0) {
                forward = 8.0;
                side = 0.0;
            } else {
                forward = 4.0;
                side = 0.0;
            }
            double rad = Math.toRadians(this.dragon.field_6283);
            double dx = -Math.sin(rad) * forward + Math.cos(rad) * side;
            double dz = Math.cos(rad) * forward + Math.sin(rad) * side;
            moveFunction.accept(passenger, this.dragon.method_23317() + dx, this.dragon.method_23318() + offsetY, this.dragon.method_23321() + dz);
        }
    }

    @NotNull
    public class_243 getDismountLocationForPassenger(@NotNull class_1309 passenger) {
        passenger.field_6017 = 0.0f;
        class_1937 level = this.dragon.method_37908();
        class_243 base = this.dragon.method_19538();
        double[] radii = new double[]{2.5, 3.5, 1.8};
        int[] angles = new int[]{0, 30, -30, 60, -60, 90, -90, 150, -150, 180};
        for (double r : radii) {
            for (int a : angles) {
                double rad = Math.toRadians(this.dragon.method_36454() + (float)a);
                double cx = base.field_1352 + Math.cos(rad) * r;
                double cz = base.field_1350 + Math.sin(rad) * r;
                int startY = (int)Math.floor(base.field_1351 + 1.0);
                for (int dy = 0; dy <= 6; ++dy) {
                    int y = startY - dy;
                    class_2338 pos = new class_2338((int)Math.floor(cx), y, (int)Math.floor(cz));
                    class_2338 below = pos.method_10074();
                    class_2680 bsBelow = level.method_8320(below);
                    class_2680 bsAt = level.method_8320(pos);
                    boolean solidBelow = !bsBelow.method_26215() && !bsBelow.method_26220((class_1922)level, below).method_1110();
                    boolean spaceFree = bsAt.method_26220((class_1922)level, pos).method_1110();
                    boolean fluidOk = bsAt.method_26227().method_15769();
                    if (!solidBelow || !spaceFree || !fluidOk) continue;
                    return new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.05, (double)pos.method_10260() + 0.5);
                }
            }
        }
        class_243 direction = this.dragon.method_5828(1.0f);
        return base.method_1019(direction.method_1021(2.0));
    }

    @Nullable
    public class_1309 getControllingPassenger() {
        List passengers = this.dragon.method_5685();
        if (passengers.isEmpty()) {
            return null;
        }
        class_1297 firstPassenger = (class_1297)passengers.get(0);
        if (firstPassenger instanceof class_1657) {
            class_1657 player = (class_1657)firstPassenger;
            if (this.dragon.method_6181() && this.dragon.method_6171((class_1309)player)) {
                return player;
            }
        }
        return null;
    }

    public void requestRiderTakeoff() {
        if (!this.dragon.method_6181() || this.getRidingPlayer() == null || this.dragon.method_6581()) {
            return;
        }
        if (!this.dragon.canTakeoff()) {
            return;
        }
        this.dragon.method_5942().method_6340();
        this.dragon.setFlying(true);
        this.dragon.setTakeoff(true);
        this.dragon.setHovering(false);
        this.dragon.setLanding(false);
        this.dragon.setRiderTakeoffTicks(25);
        class_243 current = this.dragon.method_18798();
        double upward = Math.max(current.field_1351, 0.25);
        this.dragon.method_18800(current.field_1352, upward, current.field_1350);
    }
}

