/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.controller.nulljaw;

import com.leon.saintsdragons.server.entity.dragons.nulljaw.Nulljaw;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1941;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_5134;
import net.minecraft.class_5275;
import org.jetbrains.annotations.Nullable;

public record NulljawRiderController(Nulljaw drake) {
    private static final double SEAT_BASE_FACTOR = 0.45;
    private static final double SEAT_LIFT = 0.75;
    private static final double SEAT_FORWARD = 3.0;
    private static final double SEAT_SIDE = 0.0;
    private static final double GROUND_SPEED_MULT = 0.5;
    private static final double WATER_SPEED_MULT = 1.2;

    @Nullable
    public class_1657 getRidingPlayer() {
        class_1297 class_12972 = this.drake.method_31483();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            return player;
        }
        return null;
    }

    public class_243 getRiddenInput(class_1657 player, class_243 deltaIn) {
        float f;
        float f2 = f = player.field_6250 < 0.0f ? 0.5f : 1.0f;
        if (this.drake.method_5799()) {
            return new class_243((double)(player.field_6212 * 0.6f), 0.0, (double)(player.field_6250 * 1.0f * f));
        }
        return new class_243((double)(player.field_6212 * 0.5f), 0.0, (double)(player.field_6250 * 0.9f * f));
    }

    public void tickRidden(class_1657 player, class_243 travelVector) {
        player.field_6017 = 0.0f;
        this.drake.field_6017 = 0.0f;
        this.drake.method_5980(null);
        float yawDiff = Math.abs(player.method_36454() - this.drake.method_36454());
        if (player.field_6250 != 0.0f || player.field_6212 != 0.0f || yawDiff > 5.0f) {
            float currentYaw = this.drake.method_36454();
            float targetYaw = player.method_36454();
            float rawDiff = class_3532.method_15393((float)(targetYaw - currentYaw));
            float blend = 0.28f;
            float newYaw = currentYaw + rawDiff * blend;
            this.drake.method_36456(newYaw);
            this.drake.method_36457(0.0f);
            this.drake.method_18799(this.drake.method_18798());
            this.drake.field_6283 = newYaw;
            this.drake.field_6241 = newYaw;
        }
    }

    public void handleRiderMovement(class_1657 player, class_243 motion) {
        throw new UnsupportedOperationException("handleRiderMovement should not be called for ground-based dragons");
    }

    public float getRiddenSpeed(class_1657 player) {
        float baseSpeed = (float)this.drake.method_26825(class_5134.field_23719);
        if (this.drake.method_5799()) {
            float swimSpeed = (float)this.drake.getSwimSpeed();
            return this.drake.isAccelerating() ? swimSpeed * 1.2f : swimSpeed;
        }
        return this.drake.isAccelerating() ? baseSpeed * 1.0f : baseSpeed * 0.5f;
    }

    public double getPassengersRidingOffset() {
        return (double)this.drake.method_17682() * 0.45 + 0.75;
    }

    public void positionRider(class_1297 passenger, class_1297.class_4738 moveFunction) {
        if (passenger == null) {
            return;
        }
        class_243 passengerLoc = this.drake.getClientLocatorPosition("passengerLocator");
        if (passengerLoc != null) {
            class_243 drakeOldPos = new class_243(this.drake.field_6014, this.drake.field_6036, this.drake.field_5969);
            float oldYaw = this.drake.field_5982;
            class_243 worldOffset = passengerLoc.method_1020(drakeOldPos);
            double oldYawRad = Math.toRadians(-oldYaw);
            double cosOld = Math.cos(oldYawRad);
            double sinOld = Math.sin(oldYawRad);
            double localX = worldOffset.field_1352 * cosOld - worldOffset.field_1350 * sinOld;
            double localY = worldOffset.field_1351;
            double localZ = worldOffset.field_1352 * sinOld + worldOffset.field_1350 * cosOld;
            float currentYaw = this.drake.method_36454();
            double currentYawRad = Math.toRadians(-currentYaw);
            double cosCurrent = Math.cos(currentYawRad);
            double sinCurrent = Math.sin(currentYawRad);
            double currentWorldX = localX * cosCurrent + localZ * sinCurrent;
            double currentWorldZ = -localX * sinCurrent + localZ * cosCurrent;
            class_243 drakeCurrentPos = this.drake.method_19538();
            class_243 passengerCurrentPos = drakeCurrentPos.method_1031(currentWorldX, localY, currentWorldZ);
            moveFunction.accept(passenger, passengerCurrentPos.field_1352, passengerCurrentPos.field_1351, passengerCurrentPos.field_1350);
        } else {
            double seatY = this.getPassengersRidingOffset();
            class_243 forward = class_243.method_1030((float)0.0f, (float)this.drake.method_36454());
            class_243 right = new class_243(forward.field_1350, 0.0, -forward.field_1352);
            class_243 offset = forward.method_1021(3.0).method_1019(right.method_1021(0.0)).method_1031(0.0, seatY, 0.0);
            moveFunction.accept(passenger, this.drake.method_23317() + offset.field_1352, this.drake.method_23318() + offset.field_1351, this.drake.method_23321() + offset.field_1350);
        }
    }

    public class_243 getDismountLocationForPassenger(class_1309 passenger) {
        class_243 vec3 = NulljawRiderController.getCollisionHorizontalEscapeVector(this.drake.method_17681(), passenger.method_17681(), this.drake.method_36454() + (passenger.method_6068() == class_1306.field_6183 ? 90.0f : -90.0f));
        class_243 rightSide = this.getDismountLocationInDirection(vec3, passenger);
        if (rightSide != null) {
            return rightSide;
        }
        class_243 vec32 = NulljawRiderController.getCollisionHorizontalEscapeVector(this.drake.method_17681(), passenger.method_17681(), this.drake.method_36454() + (passenger.method_6068() == class_1306.field_6182 ? 90.0f : -90.0f));
        class_243 leftSide = this.getDismountLocationInDirection(vec32, passenger);
        return leftSide != null ? leftSide : this.drake.method_19538();
    }

    private static class_243 getCollisionHorizontalEscapeVector(double entityWidth, double passengerWidth, float yaw) {
        double d0 = (entityWidth + passengerWidth + (double)1.0E-5f) / 2.0;
        float f = -class_3532.method_15374((float)(yaw * ((float)Math.PI / 180)));
        float f1 = class_3532.method_15362((float)(yaw * ((float)Math.PI / 180)));
        float f2 = Math.max(Math.abs(f), Math.abs(f1));
        return new class_243((double)f * d0 / (double)f2, 0.0, (double)f1 * d0 / (double)f2);
    }

    @Nullable
    private class_243 getDismountLocationInDirection(class_243 offset, class_1309 passenger) {
        double targetX = this.drake.method_23317() + offset.field_1352;
        double minY = this.drake.method_5829().field_1322;
        double targetZ = this.drake.method_23321() + offset.field_1350;
        class_2338.class_2339 pos = new class_2338.class_2339();
        block0: for (class_4050 pose : passenger.method_24831()) {
            pos.method_10102(targetX, minY, targetZ);
            double maxY = this.drake.method_5829().field_1325 + 0.75;
            do {
                double floorHeight = this.drake.method_37908().method_30347((class_2338)pos);
                if ((double)pos.method_10264() + floorHeight > maxY) continue block0;
                if (class_5275.method_27932((double)floorHeight)) {
                    class_238 aabb = passenger.method_24833(pose);
                    class_243 dismountPos = new class_243(targetX, (double)pos.method_10264() + floorHeight, targetZ);
                    if (class_5275.method_27933((class_1941)this.drake.method_37908(), (class_1309)passenger, (class_238)aabb.method_997(dismountPos))) {
                        passenger.method_18380(pose);
                        return dismountPos;
                    }
                }
                pos.method_10098(class_2350.field_11036);
            } while ((double)pos.method_10264() < maxY);
        }
        return null;
    }

    @Nullable
    public class_1657 getControllingPassenger() {
        return this.getRidingPlayer();
    }
}

