/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.controller.raevyx;

import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class RaevyxFlightController {
    private final Raevyx wyvern;
    private class_2338 plannedLandingPos = null;
    private static final double TAKEOFF_UPWARD_FORCE = 0.11;
    private static final double LANDING_DOWNWARD_FORCE = 0.4;
    private static final double FALLING_RESISTANCE = 0.6;
    private static final int TAKEOFF_TIME_THRESHOLD = 30;
    private static final int LANDING_TIME_THRESHOLD = 40;

    public RaevyxFlightController(Raevyx wyvern) {
        this.wyvern = wyvern;
    }

    public void handleFlightLogic() {
        if (this.wyvern.method_6581()) {
            this.handleFlyingTick();
        } else {
            this.handleGroundedTick();
        }
        if (this.wyvern.isLanding()) {
            this.handleSimpleLanding();
        }
    }

    public void switchToGroundNavigation() {
        this.wyvern.switchToGroundNavigation();
    }

    public void planSmartLanding() {
        if (this.wyvern.method_37908().field_9236) {
            return;
        }
        class_1309 owner = this.wyvern.method_35057();
        class_2338 center = owner != null && owner.method_37908() == this.wyvern.method_37908() && (double)this.wyvern.method_5739((class_1297)owner) < 40.0 ? owner.method_24515() : this.wyvern.method_24515();
        this.plannedLandingPos = this.findSafeLandingSpot(center);
        if (this.plannedLandingPos != null) {
            this.wyvern.method_5942().method_6337((double)this.plannedLandingPos.method_10263() + 0.5, (double)this.plannedLandingPos.method_10264() + 0.5, (double)this.plannedLandingPos.method_10260() + 0.5, 1.2);
            this.wyvern.setHovering(true);
        }
    }

    private class_2338 findSafeLandingSpot(class_2338 center) {
        class_1937 level = this.wyvern.method_37908();
        for (int r = 2; r <= 10; r += 2) {
            for (int step = 0; step < 16; ++step) {
                double ang = Math.PI * 2 * ((double)step / 16.0);
                int x = center.method_10263() + (int)Math.round(Math.cos(ang) * (double)r);
                int z = center.method_10260() + (int)Math.round(Math.sin(ang) * (double)r);
                int startY = center.method_10264() + 6;
                int minY = center.method_10264() - 8;
                for (int y = startY; y >= minY; --y) {
                    class_2338 pos = new class_2338(x, y, z);
                    class_2338 below = pos.method_10074();
                    class_2680 bsBelow = level.method_8320(below);
                    class_2680 bsAt = level.method_8320(pos);
                    boolean solidBelow = !bsBelow.method_26215() && !bsBelow.method_26220((class_1922)level, below).method_1110() && bsBelow.method_26227().method_15769();
                    boolean freeAt = bsAt.method_26220((class_1922)level, pos).method_1110();
                    boolean fluidOk = bsAt.method_26227().method_15769();
                    if (!solidBelow || !freeAt || !fluidOk || !this.isFlatEnough(pos)) continue;
                    return pos;
                }
            }
        }
        return null;
    }

    private boolean isFlatEnough(class_2338 pos) {
        class_1937 level = this.wyvern.method_37908();
        int y = pos.method_10264();
        int[] dx = new int[]{1, -1, 0, 0};
        int[] dz = new int[]{0, 0, 1, -1};
        for (int i = 0; i < 4; ++i) {
            class_2338 p = pos.method_10069(dx[i], 0, dz[i]);
            int ny = this.surfaceYAt(p);
            if (Math.abs(ny - y) > 1) {
                return false;
            }
            class_2338 below = new class_2338(p.method_10263(), ny - 1, p.method_10260());
            class_2680 st = level.method_8320(below);
            if (st.method_26227().method_15769()) continue;
            return false;
        }
        return true;
    }

    private int surfaceYAt(class_2338 pos) {
        class_1937 level = this.wyvern.method_37908();
        int y = pos.method_10264();
        for (int dy = 0; dy <= 6; ++dy) {
            class_2338 p = new class_2338(pos.method_10263(), y - dy, pos.method_10260());
            class_2338 below = p.method_10074();
            class_2680 bsBelow = level.method_8320(below);
            class_2680 bsAt = level.method_8320(p);
            if (bsBelow.method_26215() || bsBelow.method_26220((class_1922)level, below).method_1110() || !bsAt.method_26220((class_1922)level, p).method_1110()) continue;
            return p.method_10264();
        }
        return y;
    }

    public void initiateAggressiveLanding() {
        if (!this.wyvern.method_6581()) {
            return;
        }
        this.wyvern.setLanding(true);
        this.wyvern.setFlying(false);
        this.wyvern.setTakeoff(false);
        this.wyvern.setHovering(false);
        this.wyvern.setRunning(true);
        this.wyvern.method_5942().method_6340();
        this.wyvern.setHovering(true);
        this.wyvern.landingTimer = 0;
    }

    public void handleFlightTravel(class_243 motion) {
        if (this.wyvern.isTakeoff() || this.wyvern.isHovering()) {
            this.handleHoveringTravel(motion);
        } else {
            this.handleGlidingTravel(motion);
        }
    }

    private void handleFlyingTick() {
        ++this.wyvern.timeFlying;
        if (this.wyvern.method_18798().field_1351 < 0.0 && this.wyvern.method_5805()) {
            this.wyvern.method_18799(this.wyvern.method_18798().method_18805(1.0, 0.6, 1.0));
        }
        if (this.wyvern.method_24345() || this.wyvern.method_5765()) {
            this.wyvern.setTakeoff(false);
            this.wyvern.setHovering(false);
            this.wyvern.setFlying(false);
            return;
        }
        if (!this.wyvern.method_37908().field_9236) {
            this.handleServerFlightLogic();
            this.handleFlightPitchControl();
        }
        this.applyHoverStabilizer();
    }

    private void handleServerFlightLogic() {
        class_1309 target;
        this.wyvern.setTakeoff(this.shouldTakeoff() && this.wyvern.method_6581());
        if (this.wyvern.isTakeoff() && this.wyvern.method_6581() && this.wyvern.method_5805()) {
            if (this.wyvern.timeFlying < 30) {
                this.wyvern.method_18799(this.wyvern.method_18798().method_1031(0.0, 0.11, 0.0));
            }
            if (this.wyvern.landingFlag) {
                this.wyvern.method_18799(this.wyvern.method_18798().method_1031(0.0, -0.4, 0.0));
            }
        }
        if (!this.wyvern.isTakeoff() && this.wyvern.method_6581() && this.wyvern.timeFlying > 40 && this.wyvern.method_24828() && ((target = this.wyvern.method_5968()) == null || !target.method_5805() || this.wyvern.method_5782())) {
            this.wyvern.setFlying(false);
        }
        if (this.wyvern.isLanding() && this.plannedLandingPos != null) {
            if (this.wyvern.field_6012 % 5 == 0 && this.wyvern.method_5942().method_6357()) {
                this.wyvern.method_5942().method_6337((double)this.plannedLandingPos.method_10263() + 0.5, (double)this.plannedLandingPos.method_10264() + 0.5, (double)this.plannedLandingPos.method_10260() + 0.5, 1.1);
            }
            if (this.wyvern.method_24828()) {
                this.plannedLandingPos = null;
            }
        }
    }

    private void applyHoverStabilizer() {
        boolean hoveringLike;
        if (!this.wyvern.method_6581()) {
            return;
        }
        if (this.wyvern.method_5642() != null) {
            return;
        }
        boolean bl = hoveringLike = this.wyvern.isHovering() || this.wyvern.isTakeoff() || this.wyvern.isBeaming();
        if (!hoveringLike) {
            return;
        }
        class_243 v = this.wyvern.method_18798();
        double h = Math.sqrt(v.field_1352 * v.field_1352 + v.field_1350 * v.field_1350);
        if (h < 0.03) {
            this.wyvern.method_18800(0.0, v.field_1351 * 0.98, 0.0);
        } else {
            this.wyvern.method_18800(v.field_1352 * 0.85, v.field_1351 * 0.98, v.field_1350 * 0.85);
        }
    }

    private void handleGroundedTick() {
        this.wyvern.timeFlying = 0;
    }

    public boolean shouldTakeoff() {
        if (this.wyvern.method_5642() != null) {
            return this.wyvern.getRiderTakeoffTicks() > 0;
        }
        class_1309 target = this.wyvern.method_5968();
        if (target != null && target.method_5805()) {
            double d = this.wyvern.method_5739((class_1297)target);
            boolean targetFarAway = d > 20.0;
            boolean targetAbove = target.method_23318() - this.wyvern.method_23318() > 5.0;
            boolean cantReachOnGround = d > 10.0 && !this.wyvern.method_5985().method_6369((class_1297)target);
            return this.wyvern.landingFlag || targetFarAway || targetAbove || cantReachOnGround;
        }
        return this.wyvern.landingFlag || this.wyvern.timeFlying < 30;
    }

    private void handleFlightPitchControl() {
        if (this.wyvern.method_5642() != null) {
            return;
        }
        if (!this.wyvern.method_6581() || this.wyvern.isLanding() || this.wyvern.isHovering()) {
            return;
        }
        class_243 velocity = this.wyvern.method_18798();
        double horizontalSpeed = Math.sqrt(velocity.field_1352 * velocity.field_1352 + velocity.field_1350 * velocity.field_1350);
        if (horizontalSpeed > 0.05) {
            float desiredPitch = (float)(Math.atan2(-velocity.field_1351, horizontalSpeed) * 57.2957763671875);
            desiredPitch = class_3532.method_15363((float)desiredPitch, (float)-25.0f, (float)35.0f);
            this.wyvern.method_36457(class_3532.method_15388((float)this.wyvern.method_36455(), (float)desiredPitch, (float)3.0f));
        }
    }

    private void handleSimpleLanding() {
        if (!this.wyvern.method_37908().field_9236) {
            ++this.wyvern.landingTimer;
            int landingTime = 60;
            if (this.wyvern.landingTimer > landingTime || this.wyvern.method_24828()) {
                this.wyvern.setLanding(false);
                this.wyvern.setFlying(false);
                this.wyvern.setTakeoff(false);
                this.wyvern.setHovering(false);
                this.wyvern.markLandedNow();
                this.switchToGroundNavigation();
            }
        }
    }

    private void handleGlidingTravel(class_243 motion) {
        class_243 vec3 = this.wyvern.method_18798();
        if (vec3.field_1351 > -0.5) {
            this.wyvern.field_6017 = 1.0f;
        }
        class_243 moveDirection = this.wyvern.method_5720().method_1029();
        float pitchRad = this.wyvern.method_36455() * ((float)Math.PI / 180);
        vec3 = this.applyGlidingPhysics(vec3, moveDirection, pitchRad);
        float horizontalFriction = 0.99f;
        float verticalFriction = 0.98f;
        this.wyvern.method_18799(vec3.method_18805((double)horizontalFriction, (double)verticalFriction, (double)horizontalFriction));
        this.wyvern.method_5784(class_1313.field_6308, this.wyvern.method_18798());
    }

    private class_243 applyGlidingPhysics(class_243 currentVel, class_243 moveDirection, float pitchRad) {
        double horizontalSpeed = Math.sqrt(moveDirection.field_1352 * moveDirection.field_1352 + moveDirection.field_1350 * moveDirection.field_1350);
        if (horizontalSpeed < 0.001) {
            return currentVel;
        }
        double currentHorizontalSpeed = Math.sqrt(currentVel.method_37268());
        double lookDirectionLength = moveDirection.method_1033();
        float pitchFactor = class_3532.method_15362((float)pitchRad);
        pitchFactor = (float)((double)pitchFactor * (double)pitchFactor * Math.min(1.0, lookDirectionLength / 0.4));
        double gravity = this.getGravity();
        class_243 result = currentVel.method_1031(0.0, gravity * (-1.0 + (double)pitchFactor * 0.75), 0.0);
        if (result.field_1351 < 0.0 && horizontalSpeed > 0.0) {
            double liftFactor = this.getLiftFactor(result, pitchFactor);
            result = result.method_1031(moveDirection.field_1352 * liftFactor / horizontalSpeed, liftFactor, moveDirection.field_1350 * liftFactor / horizontalSpeed);
        }
        if (pitchRad < 0.0f && horizontalSpeed > 0.0) {
            double diveFactor = currentHorizontalSpeed * (double)(-class_3532.method_15374((float)pitchRad)) * 0.04;
            result = result.method_1031(-moveDirection.field_1352 * diveFactor / horizontalSpeed, diveFactor * 3.2, -moveDirection.field_1350 * diveFactor / horizontalSpeed);
        }
        if (horizontalSpeed > 0.0) {
            double alignmentFactor = 0.1;
            result = result.method_1031((moveDirection.field_1352 / horizontalSpeed * currentHorizontalSpeed - result.field_1352) * alignmentFactor, 0.0, (moveDirection.field_1350 / horizontalSpeed * currentHorizontalSpeed - result.field_1350) * alignmentFactor);
        }
        return result;
    }

    private double getLiftFactor(class_243 result, double pitchFactor) {
        double baseLiftFactor = result.field_1351 * -0.1 * pitchFactor;
        double liftMultiplier = 1.0;
        if (this.wyvern.getFlappingFraction() > 0.3f) {
            liftMultiplier += (double)this.wyvern.getFlappingFraction() * 0.6;
        }
        if (this.wyvern.getGlidingFraction() > 0.5f) {
            liftMultiplier += (double)this.wyvern.getGlidingFraction() * 0.4;
        }
        return baseLiftFactor * liftMultiplier;
    }

    private double getGravity() {
        double gravity = 0.08;
        if (this.wyvern.getFlappingFraction() > 0.2f) {
            gravity *= 1.0 - (double)this.wyvern.getFlappingFraction() * 0.5;
        } else if (this.wyvern.getHoveringFraction() > 0.4f) {
            gravity *= 1.0 - (double)this.wyvern.getHoveringFraction() * 0.3;
        }
        if (this.wyvern.getGlidingFraction() > 0.5f) {
            gravity *= 1.0 - (double)this.wyvern.getGlidingFraction() * 0.2;
        }
        return gravity;
    }

    private void handleHoveringTravel(class_243 motion) {
        double dz;
        double dy;
        double dx;
        double distanceToDest;
        class_2338 ground = new class_2338((int)this.wyvern.method_23317(), (int)(this.wyvern.method_5829().field_1322 - 1.0), (int)this.wyvern.method_23321());
        float friction = 0.91f;
        if (this.wyvern.method_24828()) {
            class_2680 blockState = this.wyvern.method_37908().method_8320(ground);
            friction = blockState.method_26204().method_9499() * 0.91f;
        }
        float frictionFactor = 0.16277137f / (friction * friction * friction);
        friction = 0.91f;
        if (this.wyvern.method_24828()) {
            class_2680 blockState = this.wyvern.method_37908().method_8320(ground);
            friction = blockState.method_26204().method_9499() * 0.91f;
        }
        this.wyvern.method_5724(this.wyvern.method_24828() ? 0.1f * frictionFactor : 0.02f, motion);
        this.wyvern.method_5784(class_1313.field_6308, this.wyvern.method_18798());
        this.wyvern.method_18799(this.wyvern.method_18798().method_1021((double)friction));
        class_2338 destination = this.wyvern.method_5942().method_6355();
        if (destination != null && (distanceToDest = Math.sqrt((dx = (double)destination.method_10263() - this.wyvern.method_23317()) * dx + (dy = (double)destination.method_10264() - this.wyvern.method_23318()) * dy + (dz = (double)destination.method_10260() - this.wyvern.method_23321()) * dz)) < 0.1) {
            this.wyvern.method_18800(0.0, 0.0, 0.0);
        }
    }
}

