/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.controller.raevyx;

import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import com.leon.saintsdragons.server.entity.dragons.raevyx.handlers.RaevyxConstantsHandler;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3532;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class RaevyxPhysicsController {
    private final Raevyx wyvern;
    private static final int TAKEOFF_ANIM_MAX_TICKS = 24;
    private static final int TAKEOFF_ANIM_EARLY_TICKS = 16;
    private final Envelope01 glideEnv = new Envelope01(0.25f, 0.25f);
    private final Envelope01 flapEnv = new Envelope01(0.25f, 0.18f);
    private final Envelope01 hoverEnv = new Envelope01(0.4f, 0.15f);
    public float glidingFraction = 0.0f;
    public float prevGlidingFraction = 0.0f;
    public float flappingFraction = 0.0f;
    public float prevFlappingFraction = 0.0f;
    public float hoveringFraction = 0.0f;
    public float prevHoveringFraction = 0.0f;
    private RawAnimation currentFlightAnimation = RaevyxConstantsHandler.FLY_GLIDE;
    private static final float MASS = 1.3f;
    private static final float LIFT_K = 11.0f;
    private static final float CLIMB_COST = 6.0f;
    private static final float RESPONSE = 1.5f;

    public RaevyxPhysicsController(Raevyx wyvern) {
        this.wyvern = wyvern;
    }

    public void tick() {
        this.prevGlidingFraction = this.glidingFraction;
        this.prevFlappingFraction = this.flappingFraction;
        this.prevHoveringFraction = this.hoveringFraction;
        this.updatePhysicsEnvelopes();
    }

    public PlayState handleMovementAnimation(AnimationState<Raevyx> state) {
        state.getController().transitionLength(6);
        if (this.wyvern.isDying() || this.wyvern.method_6113() || this.wyvern.isSleepingEntering() || this.wyvern.isSleepingExiting()) {
            return PlayState.STOP;
        }
        float maxSit = this.wyvern.maxSitTicks();
        float sitProgress = this.wyvern.getSitProgress();
        if (sitProgress >= maxSit) {
            state.setAndContinue(RaevyxConstantsHandler.SIT);
            return PlayState.CONTINUE;
        }
        if (sitProgress > 0.0f) {
            return PlayState.STOP;
        }
        if (this.wyvern.method_6109()) {
            if (this.wyvern.isActuallyRunning()) {
                state.getController().transitionLength(3);
                state.setAndContinue(RaevyxConstantsHandler.GROUND_RUN);
            } else if (this.wyvern.isWalking()) {
                state.getController().transitionLength(3);
                state.setAndContinue(RaevyxConstantsHandler.GROUND_WALK);
            } else {
                state.getController().transitionLength(4);
                state.setAndContinue(RaevyxConstantsHandler.GROUND_IDLE);
            }
            return PlayState.CONTINUE;
        }
        if (this.wyvern.isDodging()) {
            state.setAndContinue(RaevyxConstantsHandler.DODGE);
        } else if (this.wyvern.isLanding()) {
            state.setAndContinue(RaevyxConstantsHandler.LANDING);
        } else if (this.wyvern.method_6581()) {
            boolean manualRiderControl;
            int syncedMode = this.wyvern.getSyncedFlightMode();
            class_243 vNow = this.wyvern.method_18798();
            if (syncedMode == 3) {
                state.getController().transitionLength(4);
                state.setAndContinue(RaevyxConstantsHandler.TAKEOFF);
                return PlayState.CONTINUE;
            }
            if (this.wyvern.isRiderLandingBlendActive()) {
                state.getController().transitionLength(4);
                this.currentFlightAnimation = RaevyxConstantsHandler.LANDING;
                state.setAndContinue(RaevyxConstantsHandler.LANDING);
                return PlayState.CONTINUE;
            }
            boolean bl = manualRiderControl = this.wyvern.method_6181() && this.wyvern.method_5782();
            if (manualRiderControl) {
                boolean isStationary;
                class_243 vel = this.wyvern.method_18798();
                boolean isMovingHorizontally = vel.method_37268() > 0.01;
                boolean isMovingVertically = Math.abs(vel.field_1351) > 0.02;
                boolean bl2 = isStationary = !isMovingHorizontally && !isMovingVertically;
                if (this.wyvern.isGoingDown() && !this.wyvern.isRiderLandingBlendActive()) {
                    RawAnimation descend = RaevyxConstantsHandler.GLIDE_DOWN;
                    if (this.currentFlightAnimation != descend) {
                        state.getController().transitionLength(6);
                        this.currentFlightAnimation = descend;
                    }
                    state.setAndContinue(descend);
                    return PlayState.CONTINUE;
                }
                if (isStationary) {
                    RawAnimation hover = RaevyxConstantsHandler.FLAP;
                    if (this.currentFlightAnimation != hover) {
                        state.getController().transitionLength(6);
                        this.currentFlightAnimation = hover;
                    }
                    state.setAndContinue(hover);
                    return PlayState.CONTINUE;
                }
                if (this.wyvern.isAccelerating() && isMovingHorizontally) {
                    RawAnimation sprint = RaevyxConstantsHandler.SPRINT_FLAP;
                    if (this.currentFlightAnimation != sprint) {
                        state.getController().transitionLength(3);
                        this.currentFlightAnimation = sprint;
                    }
                    state.setAndContinue(sprint);
                    return PlayState.CONTINUE;
                }
                if (this.wyvern.isGoingUp()) {
                    RawAnimation upward = RaevyxConstantsHandler.FLAP;
                    if (this.currentFlightAnimation != upward) {
                        state.getController().transitionLength(4);
                        this.currentFlightAnimation = upward;
                    }
                    state.setAndContinue(upward);
                    return PlayState.CONTINUE;
                }
            }
            if (syncedMode == 2) {
                state.getController().transitionLength(6);
                state.setAndContinue(RaevyxConstantsHandler.FLAP);
                return PlayState.CONTINUE;
            }
            if (syncedMode == 1) {
                state.getController().transitionLength(4);
                state.setAndContinue(RaevyxConstantsHandler.FLAP);
                return PlayState.CONTINUE;
            }
            if (syncedMode == 0) {
                state.getController().transitionLength(12);
                state.setAndContinue(this.resolveGlideAnimation(vNow));
                return PlayState.CONTINUE;
            }
            if (this.shouldPlayTakeoff()) {
                state.getController().transitionLength(4);
                state.setAndContinue(RaevyxConstantsHandler.TAKEOFF);
            } else {
                boolean ascendingNow;
                boolean shouldFlapBase;
                boolean descendingNow;
                float hoverWeight = this.hoveringFraction;
                float flapWeight = this.flappingFraction;
                boolean bl3 = descendingNow = vNow.field_1351 < -0.03;
                descendingNow = this.wyvern.method_5782() ? (descendingNow |= this.wyvern.isGoingDown()) : (descendingNow |= this.wyvern.getPitchDirection() > 0);
                boolean bl4 = this.currentFlightAnimation == RaevyxConstantsHandler.FLAP ? flapWeight > 0.55f || hoverWeight > 0.65f : (shouldFlapBase = flapWeight > 0.22f || hoverWeight > 0.28f);
                if (hoverWeight > 0.45f) {
                    state.getController().transitionLength(6);
                    this.currentFlightAnimation = RaevyxConstantsHandler.FLAP;
                    state.setAndContinue(RaevyxConstantsHandler.FLAP);
                    return PlayState.CONTINUE;
                }
                boolean bl5 = ascendingNow = this.wyvern.isGoingUp() || vNow.field_1351 > 0.02;
                if (ascendingNow) {
                    if (this.currentFlightAnimation != RaevyxConstantsHandler.FLAP) {
                        state.getController().transitionLength(4);
                        this.currentFlightAnimation = RaevyxConstantsHandler.FLAP;
                    }
                    state.setAndContinue(RaevyxConstantsHandler.FLAP);
                } else if (shouldFlapBase) {
                    if (this.currentFlightAnimation != RaevyxConstantsHandler.FLAP) {
                        state.getController().transitionLength(4);
                        this.currentFlightAnimation = RaevyxConstantsHandler.FLAP;
                    }
                    state.setAndContinue(RaevyxConstantsHandler.FLAP);
                } else {
                    RawAnimation glideAnimation = this.resolveGlideAnimation(vNow);
                    if (this.currentFlightAnimation != glideAnimation) {
                        state.getController().transitionLength(8);
                        this.currentFlightAnimation = glideAnimation;
                    }
                    state.setAndContinue(glideAnimation);
                }
            }
        } else if (this.wyvern.isActuallyRunning()) {
            state.getController().transitionLength(3);
            state.setAndContinue(RaevyxConstantsHandler.GROUND_RUN);
        } else if (this.wyvern.isWalking()) {
            state.getController().transitionLength(3);
            state.setAndContinue(RaevyxConstantsHandler.GROUND_WALK);
        } else {
            state.getController().transitionLength(4);
            state.setAndContinue(RaevyxConstantsHandler.GROUND_IDLE);
        }
        return PlayState.CONTINUE;
    }

    private boolean shouldPlayTakeoff() {
        if (this.wyvern.timeFlying < 16) {
            return true;
        }
        boolean airborne = !this.wyvern.method_24828();
        boolean ascending = this.wyvern.method_18798().field_1351 > 0.08;
        return this.wyvern.timeFlying < 24 && (airborne || ascending);
    }

    private void updatePhysicsEnvelopes() {
        class_243 v = this.wyvern.method_18798();
        float vH = (float)Math.hypot(v.field_1352, v.field_1350);
        float vY = (float)v.field_1351;
        float glideLift = 11.0f * vH * vH;
        float climbNeed = vY > 0.0f ? vY * 6.0f : 0.0f;
        float need = 1.3f + climbNeed - glideLift;
        float flapTarget = need <= 0.0f ? 0.0f : need / (need + 1.5f);
        flapTarget = class_3532.method_15363((float)flapTarget, (float)0.0f, (float)1.0f);
        float hoverTarget = this.wyvern.isHovering() || this.wyvern.isLanding() || this.wyvern.isBeaming() || vH < 0.02f && Math.abs(vY) < 0.02f ? 1.0f : 0.0f;
        float glideTarget = class_3532.method_15363((float)(1.0f - flapTarget), (float)0.15f, (float)1.0f);
        if (this.wyvern.method_6581()) {
            if (this.wyvern.method_5642() != null && this.wyvern.isGoingUp()) {
                flapTarget = Math.max(flapTarget, 0.6f);
            } else if (vY > 0.06f) {
                float ascentBias = class_3532.method_15363((float)((vY - 0.02f) * 3.0f), (float)0.2f, (float)0.8f);
                flapTarget = Math.max(flapTarget, ascentBias);
            }
            glideTarget = class_3532.method_15363((float)(1.0f - flapTarget), (float)0.15f, (float)1.0f);
        }
        this.flapEnv.tickToward(flapTarget);
        this.hoverEnv.tickToward(hoverTarget);
        this.glideEnv.tickToward(glideTarget);
        this.glidingFraction = this.glideEnv.raw();
        this.flappingFraction = this.flapEnv.raw();
        this.hoveringFraction = this.hoverEnv.raw();
    }

    private RawAnimation resolveGlideAnimation(class_243 velocity) {
        boolean hasForwardSpeed;
        if (!this.wyvern.method_6181()) {
            return RaevyxConstantsHandler.FLY_GLIDE;
        }
        class_243 motion = velocity == null ? class_243.field_1353 : velocity;
        double verticalSpeed = motion.field_1351;
        double horizontalSpeedSqr = motion.method_37268();
        boolean riderDescending = this.wyvern.method_5782() && this.wyvern.isGoingDown();
        boolean pitchingDown = !this.wyvern.method_5782() && this.wyvern.getPitchDirection() > 0;
        boolean fallingFast = verticalSpeed < -0.06;
        boolean moderateDescent = verticalSpeed < -0.025;
        boolean sustainedGlide = this.glidingFraction > 0.18f || this.flapEnv.raw() < 0.35f;
        boolean bl = hasForwardSpeed = horizontalSpeedSqr > 9.0E-4;
        if ((pitchingDown || riderDescending || fallingFast || moderateDescent) && sustainedGlide && hasForwardSpeed) {
            return RaevyxConstantsHandler.GLIDE_DOWN;
        }
        return RaevyxConstantsHandler.FLY_GLIDE;
    }

    public void writeToNBT(class_2487 tag) {
        tag.method_10548("GlideVal", this.glideEnv.raw());
        tag.method_10548("FlapVal", this.flapEnv.raw());
        tag.method_10548("HoverVal", this.hoverEnv.raw());
    }

    public void readFromNBT(class_2487 tag) {
        if (tag.method_10545("GlideVal")) {
            this.glideEnv.setRaw(tag.method_10583("GlideVal"));
            this.flapEnv.setRaw(tag.method_10583("FlapVal"));
            this.hoverEnv.setRaw(tag.method_10583("HoverVal"));
        }
        this.glidingFraction = this.glideEnv.raw();
        this.flappingFraction = this.flapEnv.raw();
        this.hoveringFraction = this.hoverEnv.raw();
        this.prevGlidingFraction = this.glidingFraction;
        this.prevFlappingFraction = this.flappingFraction;
        this.prevHoveringFraction = this.hoveringFraction;
    }

    public static class Envelope01 {
        private float val = 0.0f;
        private float prev = 0.0f;
        private final float upRate;
        private final float downRate;

        public Envelope01(float upRate, float downRate) {
            this.upRate = upRate;
            this.downRate = downRate;
        }

        public void tickToward(float target) {
            this.prev = this.val;
            float rate = target > this.val ? this.upRate : this.downRate;
            this.val += (target - this.val) * rate;
            if (this.val < 0.0f) {
                this.val = 0.0f;
            } else if (this.val > 1.0f) {
                this.val = 1.0f;
            }
        }

        public float raw() {
            return this.val;
        }

        public float get(float pt) {
            return class_3532.method_16439((float)pt, (float)this.prev, (float)this.val);
        }

        public void setRaw(float v) {
            this.prev = this.val = class_3532.method_15363((float)v, (float)0.0f, (float)1.0f);
        }
    }
}

