/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.controller.raevyx;

import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record RaevyxRiderController(Raevyx wyvern) {
    private static final double SEAT_BASE_FACTOR = 0.5;
    private static final double CRUISE_SPEED_MULT = 3.75;
    private static final double SPRINT_SPEED_MULT = 7.85;
    private static final double ACCELERATION = 0.15;
    private static final double DRAG_WITH_INPUT = 0.08;
    private static final double DRAG_NO_INPUT = 0.5;
    private static final double STRAFE_POWER = 0.5;
    private static final double ASCEND_THRUST = 0.08;
    private static final double DESCEND_THRUST = 1.0;
    private static final double TERMINAL_VELOCITY = 1.5;
    private static final double VERTICAL_DRAG = 0.92;

    @Nullable
    public class_1657 getRidingPlayer() {
        class_1309 class_13092 = this.wyvern.method_5642();
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            return player;
        }
        return null;
    }

    public class_243 getRiddenInput(class_1657 player, class_243 deltaIn) {
        float f;
        float f2 = f = player.field_6250 < 0.0f ? 0.5f : 1.0f;
        if (this.wyvern.method_6581()) {
            return new class_243((double)(player.field_6212 * 0.4f), 0.0, (double)(player.field_6250 * 1.0f * f));
        }
        return new class_243((double)(player.field_6212 * 0.5f), 0.0, (double)(player.field_6250 * 0.9f * f));
    }

    public void tickRidden(class_1657 player, class_243 travelVector) {
        player.field_6017 = 0.0f;
        this.wyvern.field_6017 = 0.0f;
        this.wyvern.method_5980(null);
        boolean flying = this.wyvern.method_6581();
        float yawDiff = Math.abs(player.method_36454() - this.wyvern.method_36454());
        if (player.field_6250 != 0.0f || player.field_6212 != 0.0f || yawDiff > 5.0f) {
            float currentYaw = this.wyvern.method_36454();
            float targetYaw = player.method_36454();
            float rawDiff = class_3532.method_15393((float)(targetYaw - currentYaw));
            float blend = flying ? 0.35f : 0.28f;
            float newYaw = currentYaw + rawDiff * blend;
            this.wyvern.method_36456(newYaw);
            this.wyvern.field_6283 = newYaw;
            this.wyvern.field_6241 = newYaw;
            if (flying) {
                float targetPitch = class_3532.method_15363((float)(player.method_36455() * 0.55f), (float)-35.0f, (float)30.0f);
                this.wyvern.method_36457(targetPitch);
            } else {
                this.wyvern.method_36457(0.0f);
            }
            this.wyvern.method_18799(this.wyvern.method_18798());
        }
        if (this.wyvern.method_24828()) {
            player.field_6017 = 0.0f;
            this.wyvern.field_6017 = 0.0f;
        }
    }

    public float getRiddenSpeed(class_1657 rider) {
        boolean isMoving;
        if (this.wyvern.method_6581()) {
            return (float)this.wyvern.method_26825(class_5134.field_23720);
        }
        float baseSpeed = (float)this.wyvern.method_26825(class_5134.field_23719);
        boolean bl = isMoving = this.wyvern.method_18798().method_37268() > 1.0E-4;
        if (this.wyvern.isAccelerating() && isMoving) {
            this.wyvern.setRunning(true);
            return baseSpeed * 0.7f;
        }
        this.wyvern.setRunning(false);
        return baseSpeed * 0.5f;
    }

    public void handleRiderMovement(class_1657 player, class_243 motion) {
        if (this.wyvern.method_5942().method_6345() != null) {
            this.wyvern.method_5942().method_6340();
        }
        if (this.wyvern.method_6581()) {
            class_243 newHorizontalVel;
            double baseSpeed = this.wyvern.method_26825(class_5134.field_23720);
            boolean sprinting = this.wyvern.isAccelerating();
            double targetSpeed = (sprinting ? 7.85 : 3.75) * baseSpeed;
            class_243 currentVelocity = this.wyvern.method_18798();
            class_243 horizontalVel = new class_243(currentVelocity.field_1352, 0.0, currentVelocity.field_1350);
            double currentSpeed = horizontalVel.method_1033();
            double forwardInput = motion.field_1350;
            double strafeInput = motion.field_1352;
            boolean hasInput = Math.abs(forwardInput) > 0.01 || Math.abs(strafeInput) > 0.01;
            float yawRad = (float)Math.toRadians(this.wyvern.method_36454());
            double forwardX = -Math.sin(yawRad);
            double forwardZ = Math.cos(yawRad);
            double rightX = Math.cos(yawRad);
            double rightZ = Math.sin(yawRad);
            double targetDirX = forwardX * forwardInput + rightX * (strafeInput * 0.5);
            double targetDirZ = forwardZ * forwardInput + rightZ * (strafeInput * 0.5);
            double dirLength = Math.hypot(targetDirX, targetDirZ);
            if (hasInput && dirLength > 0.01) {
                class_243 targetVelocity = new class_243((targetDirX /= dirLength) * targetSpeed, 0.0, (targetDirZ /= dirLength) * targetSpeed);
                newHorizontalVel = new class_243(class_3532.method_16436((double)0.15, (double)horizontalVel.field_1352, (double)targetVelocity.field_1352), 0.0, class_3532.method_16436((double)0.15, (double)horizontalVel.field_1350, (double)targetVelocity.field_1350));
                newHorizontalVel = newHorizontalVel.method_1021(0.92);
            } else {
                newHorizontalVel = horizontalVel.method_1021(0.5);
                if (newHorizontalVel.method_1033() < 0.01) {
                    newHorizontalVel = class_243.field_1353;
                }
            }
            double verticalVel = currentVelocity.field_1351;
            verticalVel = this.wyvern.isGoingUp() ? (verticalVel += 0.08) : (this.wyvern.isGoingDown() ? (verticalVel -= 1.0) : (verticalVel *= 0.92));
            verticalVel = class_3532.method_15350((double)verticalVel, (double)-1.5, (double)1.5);
            class_243 finalVelocity = new class_243(newHorizontalVel.field_1352, verticalVel, newHorizontalVel.field_1350);
            this.wyvern.method_5784(class_1313.field_6308, finalVelocity);
            this.wyvern.method_18799(finalVelocity);
            this.wyvern.method_29242(true);
            player.field_6017 = 0.0f;
            this.wyvern.field_6017 = 0.0f;
        }
    }

    public double getPassengersRidingOffset() {
        return (double)this.wyvern.method_17682() * 0.5;
    }

    public void positionRider(@NotNull class_1297 passenger, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_1297.class_4738 moveFunction) {
        if (!this.wyvern.method_5626(passenger)) {
            return;
        }
        class_243 passengerLoc = this.wyvern.getClientLocatorPosition("passengerLocator");
        if (passengerLoc != null) {
            class_243 dragonOldPos = new class_243(this.wyvern.field_6014, this.wyvern.field_6036, this.wyvern.field_5969);
            float oldYaw = this.wyvern.field_5982;
            class_243 worldOffset = passengerLoc.method_1020(dragonOldPos);
            double oldYawRad = Math.toRadians(-oldYaw);
            double cosOld = Math.cos(oldYawRad);
            double sinOld = Math.sin(oldYawRad);
            double localX = worldOffset.field_1352 * cosOld - worldOffset.field_1350 * sinOld;
            double localY = worldOffset.field_1351;
            double localZ = worldOffset.field_1352 * sinOld + worldOffset.field_1350 * cosOld;
            float currentYaw = this.wyvern.method_36454();
            double currentYawRad = Math.toRadians(-currentYaw);
            double cosCurrent = Math.cos(currentYawRad);
            double sinCurrent = Math.sin(currentYawRad);
            double currentWorldX = localX * cosCurrent + localZ * sinCurrent;
            double currentWorldZ = -localX * sinCurrent + localZ * cosCurrent;
            class_243 dragonCurrentPos = this.wyvern.method_19538();
            class_243 passengerCurrentPos = dragonCurrentPos.method_1031(currentWorldX, localY, currentWorldZ);
            moveFunction.accept(passenger, passengerCurrentPos.field_1352, passengerCurrentPos.field_1351, passengerCurrentPos.field_1350);
        } else {
            double x = this.wyvern.method_23317();
            double y = this.wyvern.method_23318() + this.getPassengersRidingOffset() + passenger.method_5678();
            double z = this.wyvern.method_23321();
            moveFunction.accept(passenger, x, y, z);
        }
    }

    @NotNull
    public class_243 getDismountLocationForPassenger(@NotNull class_1309 passenger) {
        passenger.field_6017 = 0.0f;
        class_1937 level = this.wyvern.method_37908();
        class_243 base = this.wyvern.method_19538();
        double[] radii = new double[]{2.5, 3.5, 1.8};
        int[] angles = new int[]{0, 30, -30, 60, -60, 90, -90, 150, -150, 180};
        for (double r : radii) {
            for (int a : angles) {
                double rad = Math.toRadians(this.wyvern.method_36454() + (float)a);
                double cx = base.field_1352 + Math.cos(rad) * r;
                double cz = base.field_1350 + Math.sin(rad) * r;
                int startY = (int)Math.floor(base.field_1351 + 1.0);
                for (int dy = 0; dy <= 6; ++dy) {
                    int y = startY - dy;
                    class_2338 pos = new class_2338((int)Math.floor(cx), y, (int)Math.floor(cz));
                    class_2338 below = pos.method_10074();
                    class_2680 bsBelow = level.method_8320(below);
                    class_2680 bsAt = level.method_8320(pos);
                    boolean solidBelow = !bsBelow.method_26215() && !bsBelow.method_26220((class_1922)level, below).method_1110();
                    boolean spaceFree = bsAt.method_26220((class_1922)level, pos).method_1110();
                    boolean fluidOk = bsAt.method_26227().method_15769();
                    if (!solidBelow || !spaceFree || !fluidOk) continue;
                    return new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.05, (double)pos.method_10260() + 0.5);
                }
            }
        }
        class_243 direction = this.wyvern.method_5828(1.0f);
        return base.method_1019(direction.method_1021(2.0));
    }

    @Nullable
    public class_1309 getControllingPassenger() {
        class_1297 entity = this.wyvern.method_31483();
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (this.wyvern.method_6181() && this.wyvern.method_6171((class_1309)player)) {
                return player;
            }
        }
        return null;
    }

    public void requestRiderTakeoff() {
        if (!this.wyvern.method_6181() || this.getRidingPlayer() == null || this.wyvern.method_6581()) {
            return;
        }
        if (this.wyvern.isTakeoffLocked()) {
            return;
        }
        long now = this.wyvern.method_37908().method_8510();
        long lastLand = this.wyvern.getLastLandingGameTime();
        if (lastLand != Long.MIN_VALUE && now - lastLand < 20L) {
            return;
        }
        this.wyvern.timeFlying = 0;
        this.wyvern.landingFlag = false;
        this.wyvern.landingTimer = 0;
        this.wyvern.setFlying(true);
        this.wyvern.setTakeoff(true);
        this.wyvern.setHovering(false);
        this.wyvern.setLanding(false);
        this.wyvern.setRiderTakeoffTicks(30);
        if (this.wyvern.method_37908().field_9236) {
            float urgency = this.wyvern.method_5968() != null ? 1.3f : 1.0f;
            this.wyvern.method_37908().method_8486(this.wyvern.method_23317(), this.wyvern.method_23318(), this.wyvern.method_23321(), class_3417.field_14550, class_3419.field_15254, urgency * 1.2f, 0.85f, false);
        }
    }
}

