/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.dragons.cindervane;

import com.leon.saintsdragons.common.network.DragonRiderAction;
import com.leon.saintsdragons.common.registry.AbilityRegistry;
import com.leon.saintsdragons.common.registry.ModEntities;
import com.leon.saintsdragons.common.registry.ModSounds;
import com.leon.saintsdragons.common.registry.cindervane.CindervaneAbilities;
import com.leon.saintsdragons.server.ai.goals.base.DragonOwnerHurtByTargetGoal;
import com.leon.saintsdragons.server.ai.goals.base.DragonOwnerHurtTargetGoal;
import com.leon.saintsdragons.server.ai.goals.cindervane.CindervaneCombatGoal;
import com.leon.saintsdragons.server.ai.goals.cindervane.CindervaneFlightGoal;
import com.leon.saintsdragons.server.ai.goals.cindervane.CindervaneFollowOwnerGoal;
import com.leon.saintsdragons.server.ai.goals.cindervane.CindervaneGroundWanderGoal;
import com.leon.saintsdragons.server.ai.goals.cindervane.CindervaneRestGoal;
import com.leon.saintsdragons.server.ai.goals.cindervane.CindervaneSleepGoal;
import com.leon.saintsdragons.server.ai.navigation.DragonFlightMoveHelper;
import com.leon.saintsdragons.server.ai.navigation.DragonPathNavigateGround;
import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.base.RideableDragonBase;
import com.leon.saintsdragons.server.entity.base.RideableDragonData;
import com.leon.saintsdragons.server.entity.controller.cindervane.CindervanePhysicsController;
import com.leon.saintsdragons.server.entity.controller.cindervane.CindervaneRiderController;
import com.leon.saintsdragons.server.entity.dragons.cindervane.handlers.CindervaneAnimationHandler;
import com.leon.saintsdragons.server.entity.dragons.cindervane.handlers.CindervaneInteractionHandler;
import com.leon.saintsdragons.server.entity.dragons.cindervane.handlers.CindervaneSoundProfile;
import com.leon.saintsdragons.server.entity.handler.DragonSoundHandler;
import com.leon.saintsdragons.server.entity.interfaces.DragonFlightCapable;
import com.leon.saintsdragons.server.entity.interfaces.DragonSleepCapable;
import com.leon.saintsdragons.server.entity.interfaces.DragonSoundProfile;
import com.leon.saintsdragons.server.entity.interfaces.ShakesScreen;
import com.leon.saintsdragons.server.entity.interfaces.SoundHandledDragon;
import com.leon.saintsdragons.server.entity.sleep.DragonRestManager;
import com.leon.saintsdragons.server.entity.sleep.DragonRestState;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1335;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1386;
import net.minecraft.class_1399;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5362;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import net.minecraft.class_8111;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.keyframe.event.SoundKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Cindervane
extends RideableDragonBase
implements DragonFlightCapable,
SoundHandledDragon,
ShakesScreen,
DragonSleepCapable {
    private static final int LANDING_SETTLE_TICKS = 4;
    private static final double FIRE_BODY_CRASH_MIN_DROP = 7.0;
    private static final float FIRE_BODY_EXPLOSION_RADIUS = 15.0f;
    private static final double FIRE_BODY_IMPRINT_RADIUS = 9.0;
    private static final double FIRE_BODY_IMPRINT_DEPTH_FACTOR = 0.6;
    private static final float FIRE_BODY_EXPLOSION_DAMAGE = 200.0f;
    private static final int MIN_AMBIENT_DELAY = 180;
    private static final int MAX_AMBIENT_DELAY = 420;
    private int ambientSoundTimer;
    private int nextAmbientSoundDelay;
    private static final Map<String, DragonEntity.VocalEntry> VOCAL_ENTRIES = new DragonEntity.VocalEntryBuilder().add("grumble1", "actions", "animation.cindervane.grumble1", ModSounds.CINDERVANE_GRUMBLE_1, 1.1f, 0.98f, 0.06f, false, false, false).add("grumble2", "actions", "animation.cindervane.grumble2", ModSounds.CINDERVANE_GRUMBLE_2, 1.2f, 0.96f, 0.08f, false, false, false).add("grumble3", "actions", "animation.cindervane.grumble3", ModSounds.CINDERVANE_GRUMBLE_3, 1.0f, 1.0f, 0.05f, false, false, false).add("roar", "actions", "animation.cindervane.roar", ModSounds.CINDERVANE_ROAR, 1.5f, 0.95f, 0.1f, false, false, false).add("roar_ground", "actions", "animation.cindervane.roar_ground", ModSounds.CINDERVANE_ROAR, 1.5f, 0.9f, 0.05f, false, false, false).add("roar_air", "actions", "animation.cindervane.roar_air", ModSounds.CINDERVANE_ROAR, 1.5f, 1.05f, 0.05f, false, false, false).add("cindervane_hurt", "hurt", "animation.cindervane.hurt", ModSounds.CINDERVANE_HURT, 1.2f, 0.95f, 0.1f, false, false, false).add("cindervane_die", "action", "animation.cindervane.die", ModSounds.CINDERVANE_DIE, 1.5f, 1.0f, 0.0f, false, false, false).build();
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final CindervaneAnimationHandler animationHandler = new CindervaneAnimationHandler(this);
    private final CindervanePhysicsController physicsController = new CindervanePhysicsController(this);
    private final DragonSoundHandler soundHandler = new DragonSoundHandler(this);
    private final CindervaneInteractionHandler interactionHandler = new CindervaneInteractionHandler(this);
    private final CindervaneRiderController riderController;
    private final DragonRestManager restManager = new DragonRestManager((class_1309)this);
    private final DragonPathNavigateGround groundNav;
    private final class_1407 airNav;
    private boolean usingAirNav;
    private int targetCooldown;
    private int airTicks;
    public int groundTicks;
    public int timeFlying = 0;
    private int landingTicks;
    private int riderTakeoffTicks;
    private boolean wasVehicleLastTick;
    private boolean fireBodyCrashArmed;
    private double fireBodyCrashMaxHeight;
    private float bankSmoothedYaw = 0.0f;
    private int bankHoldTicks = 0;
    private int bankDir = 0;
    private float bankAngle = 0.0f;
    private float prevBankAngle = 0.0f;
    private float pitchSmoothedPitch = 0.0f;
    private int pitchHoldTicks = 0;
    private int pitchDir = 0;
    private float prevScreenShakeAmount = 0.0f;
    private float screenShakeAmount = 0.0f;
    private static final double MODEL_SCALE = 1.0;
    private static final double RIDER_GLIDE_ALTITUDE_THRESHOLD = 40.0;
    private static final double RIDER_GLIDE_ALTITUDE_EXIT = 30.0;
    private boolean inHighAltitudeGlide = false;
    private static final double RIDER_LANDING_BLEND_ALTITUDE = 8.0;
    private static final int RIDER_LANDING_BLEND_DURATION = 3;
    private int riderLandingBlendTicks = 0;
    private int sitTransitionTicks = 0;
    private boolean isSittingDown = false;
    private boolean isStandingUp = false;
    private int sleepTransitionTicks = 0;
    private int sleepAmbientCooldownTicks = 0;
    private int sleepReentryCooldownTicks = 0;
    private int sleepCancelTicks = 0;
    private boolean sleepLocked = false;
    private int sleepCommandSnapshot = -1;
    private final Map<String, class_243> clientLocatorCache = new ConcurrentHashMap<String, class_243>();
    private static final class_2940<Boolean> DATA_FIRE_BREATHING = class_2945.method_12791(Cindervane.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DATA_FLYING = class_2945.method_12791(Cindervane.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DATA_TAKEOFF = class_2945.method_12791(Cindervane.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DATA_HOVERING = class_2945.method_12791(Cindervane.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DATA_LANDING = class_2945.method_12791(Cindervane.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DATA_RUNNING = class_2945.method_12791(Cindervane.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> DATA_GROUND_MOVE_STATE = class_2945.method_12791(Cindervane.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> DATA_FLIGHT_MODE = class_2945.method_12791(Cindervane.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> DATA_RIDER_FORWARD = class_2945.method_12791(Cindervane.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> DATA_RIDER_STRAFE = class_2945.method_12791(Cindervane.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Boolean> DATA_GOING_UP = class_2945.method_12791(Cindervane.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DATA_GOING_DOWN = class_2945.method_12791(Cindervane.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DATA_ACCELERATING = class_2945.method_12791(Cindervane.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Float> DATA_SCREEN_SHAKE_AMOUNT = class_2945.method_12791(Cindervane.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Boolean> DATA_RIDER_LANDING_BLEND = class_2945.method_12791(Cindervane.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DATA_SLEEPING = class_2945.method_12791(Cindervane.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DATA_SLEEPING_ENTERING = class_2945.method_12791(Cindervane.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DATA_SLEEPING_EXITING = class_2945.method_12791(Cindervane.class, (class_2941)class_2943.field_13323);
    private static final double WATER_EFFECT_MAX_HEIGHT = 10.0;
    private static final double WATER_EFFECT_INTENSITY = 1.5;

    public Cindervane(class_1299<? extends Cindervane> type, class_1937 level) {
        super(type, level);
        this.method_49477(1.1f);
        this.groundNav = new DragonPathNavigateGround((class_1308)this, level);
        this.airNav = new class_1407((class_1308)this, level){

            public boolean method_6333(@Nonnull class_2338 pos) {
                class_2680 below = this.field_6677.method_8320(pos.method_10074());
                return !below.method_26215();
            }
        };
        this.airNav.method_6332(false);
        this.airNav.method_6354(false);
        this.airNav.method_6331(false);
        this.field_6189 = this.groundNav;
        this.field_6207 = new class_1335((class_1308)this);
        this.usingAirNav = false;
        this.riderController = new CindervaneRiderController(this);
        this.method_5941(class_7.field_6, -1.0f);
        this.method_5941(class_7.field_9, -1.0f);
        class_5819 rng = this.method_6051();
        this.ambientSoundTimer = rng.method_43048(80);
        this.nextAmbientSoundDelay = 180 + rng.method_43048(Math.max(1, 241));
    }

    @Override
    @NotNull
    public class_1315 method_5943(@NotNull class_5425 level, @NotNull class_1266 difficulty, @NotNull class_3730 spawnType, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        class_1315 data = super.method_5943(level, difficulty, spawnType, spawnData, dataTag);
        if (!this.method_6181()) {
            this.method_6174(null);
            this.setCommand(2);
            this.method_24346(false);
        }
        return data;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1321.method_26828().method_26868(class_5134.field_23716, 80.0).method_26868(class_5134.field_23719, 0.45).method_26868(class_5134.field_23717, 48.0).method_26868(class_5134.field_23720, 0.6).method_26868(class_5134.field_23724, 4.0);
    }

    public static boolean canSpawnHere(class_1299<? extends Cindervane> type, class_1936 level, class_3730 spawnType, class_2338 pos, class_5819 random) {
        if (!class_1429.method_20663(type, (class_1936)level, (class_3730)spawnType, (class_2338)pos, (class_5819)random)) {
            return false;
        }
        if (!level.method_8316(pos).method_15769()) {
            return false;
        }
        if (!level.method_8316(pos.method_10074()).method_15769()) {
            return false;
        }
        return level.method_8320(pos.method_10074()).method_26206((class_1922)level, pos.method_10074(), class_2350.field_11036);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_FIRE_BREATHING, (Object)false);
        this.field_6011.method_12784(DATA_SCREEN_SHAKE_AMOUNT, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(DATA_RIDER_LANDING_BLEND, (Object)false);
        this.field_6011.method_12784(DATA_SLEEPING, (Object)false);
        this.field_6011.method_12784(DATA_SLEEPING_ENTERING, (Object)false);
        this.field_6011.method_12784(DATA_SLEEPING_EXITING, (Object)false);
    }

    @Override
    protected void defineRideableDragonData() {
        this.field_6011.method_12784(DATA_FLYING, (Object)false);
        this.field_6011.method_12784(DATA_TAKEOFF, (Object)false);
        this.field_6011.method_12784(DATA_HOVERING, (Object)false);
        this.field_6011.method_12784(DATA_LANDING, (Object)false);
        this.field_6011.method_12784(DATA_RUNNING, (Object)false);
        this.field_6011.method_12784(DATA_GROUND_MOVE_STATE, (Object)0);
        this.field_6011.method_12784(DATA_FLIGHT_MODE, (Object)-1);
        this.field_6011.method_12784(DATA_RIDER_FORWARD, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(DATA_RIDER_STRAFE, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(DATA_GOING_UP, (Object)false);
        this.field_6011.method_12784(DATA_GOING_DOWN, (Object)false);
        this.field_6011.method_12784(DATA_ACCELERATING, (Object)false);
    }

    @Override
    protected class_2940<Float> getRiderForwardAccessor() {
        return DATA_RIDER_FORWARD;
    }

    @Override
    protected class_2940<Float> getRiderStrafeAccessor() {
        return DATA_RIDER_STRAFE;
    }

    @Override
    protected class_2940<Integer> getGroundMoveStateAccessor() {
        return DATA_GROUND_MOVE_STATE;
    }

    @Override
    protected class_2940<Integer> getFlightModeAccessor() {
        return DATA_FLIGHT_MODE;
    }

    @Override
    protected class_2940<Boolean> getGoingUpAccessor() {
        return DATA_GOING_UP;
    }

    @Override
    protected class_2940<Boolean> getGoingDownAccessor() {
        return DATA_GOING_DOWN;
    }

    @Override
    protected class_2940<Boolean> getAcceleratingAccessor() {
        return DATA_ACCELERATING;
    }

    @Override
    protected void applyLoadedFlightState(boolean flying, boolean takeoff, boolean hovering, boolean landing) {
        this.setFlying(flying);
        this.setTakeoff(takeoff);
        this.setHovering(hovering);
        this.setLanding(landing);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new CindervaneSleepGoal(this));
        this.field_6201.method_6277(2, (class_1352)new CindervaneRestGoal(this));
        this.field_6201.method_6277(3, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(4, (class_1352)new CindervaneFlightGoal(this));
        this.field_6201.method_6277(5, (class_1352)new CindervaneCombatGoal(this));
        this.field_6201.method_6277(6, (class_1352)new CindervaneFollowOwnerGoal(this));
        this.field_6201.method_6277(7, (class_1352)new CindervaneGroundWanderGoal(this, 0.6, 160));
        this.field_6185.method_6277(1, (class_1352)new DragonOwnerHurtByTargetGoal(this));
        this.field_6185.method_6277(2, (class_1352)new DragonOwnerHurtTargetGoal(this));
        this.field_6185.method_6277(3, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6201.method_6277(12, (class_1352)new class_1376((class_1308)this){

            public boolean method_6264() {
                return !Cindervane.this.method_5782() && super.method_6264();
            }
        });
        this.field_6201.method_6277(12, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f){

            public boolean method_6264() {
                return !Cindervane.this.method_5782() && super.method_6264();
            }
        });
    }

    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().field_9236) {
            boolean onGroundNow;
            if (!this.method_24345() && ((Float)this.field_6011.method_12789(DATA_SIT_PROGRESS)).floatValue() != 0.0f) {
                this.field_6011.method_12778(DATA_SIT_PROGRESS, (Object)Float.valueOf(0.0f));
            }
            boolean bl = onGroundNow = this.method_24828() && !this.method_5799();
            if (this.method_6581()) {
                ++this.airTicks;
                this.groundTicks = 0;
                this.field_6017 = 0.0f;
                if (this.isTakeoff() && !onGroundNow && this.airTicks > 5) {
                    this.setTakeoff(false);
                }
                if (onGroundNow && !this.isTakeoff()) {
                    if (!this.isLanding()) {
                        this.setLanding(true);
                    }
                    this.setFlying(false);
                } else if (this.isLanding() && !onGroundNow) {
                    this.setLanding(false);
                }
            } else {
                ++this.groundTicks;
                this.airTicks = 0;
            }
            if (this.isLanding()) {
                if (onGroundNow) {
                    ++this.landingTicks;
                    if (this.landingTicks >= 4) {
                        this.markLandedNow();
                    }
                } else {
                    this.landingTicks = 0;
                }
            } else {
                this.landingTicks = 0;
            }
            this.tickAnimationStates();
        }
        this.method_5875(this.method_6581() || this.isHovering());
        if (!this.method_6581() && this.usingAirNav) {
            this.switchToGroundNavigation();
        }
    }

    @Override
    public void method_5773() {
        super.method_5773();
        this.physicsController.tick();
        this.tickSittingState();
        this.tickBankingLogic();
        this.tickPitchingLogic();
        this.tickRiderTakeoff();
        this.tickMountedState();
        this.tickScreenShake();
        this.updateSittingProgress();
        this.tickSleepTransition();
        this.tickSleepCooldowns();
        this.tickWaterSlicing();
        if (!this.method_37908().field_9236) {
            if (this.method_5782() && ((Float)this.field_6011.method_12789(DATA_SIT_PROGRESS)).floatValue() != 0.0f) {
                this.field_6011.method_12778(DATA_SIT_PROGRESS, (Object)Float.valueOf(0.0f));
            }
            if (this.targetCooldown > 0) {
                --this.targetCooldown;
            }
            this.handleFireBodyCrash();
            this.timeFlying = this.method_6581() ? ++this.timeFlying : 0;
            this.handleAmbientSounds();
            if (this.method_6113() || this.isSleepingEntering() || this.isSleepingExiting()) {
                if (this.method_5968() != null || this.method_6510()) {
                    this.wakeUpImmediately();
                    this.suppressSleep(200);
                } else if (this.method_5816() || this.method_5771()) {
                    this.wakeUpImmediately();
                    this.suppressSleep(200);
                }
            }
        }
        if (!this.method_37908().field_9236 && this.field_6012 == 1) {
            this.initializeAnimationState();
        }
        this.tickClientSideUpdates();
    }

    private void tickSittingState() {
        if (!this.method_37908().field_9236 && this.method_5782() && this.method_24345()) {
            this.method_24346(false);
        }
    }

    private void tickMountedState() {
        boolean mounted = this.method_5782();
        if (mounted && !this.wasVehicleLastTick) {
            this.sitProgress = 0.0f;
            this.prevSitProgress = 0.0f;
            this.field_6011.method_12778(DATA_SIT_PROGRESS, (Object)Float.valueOf(0.0f));
            this.clearStatesWhenMounted();
            if (this.method_24345()) {
                this.method_24346(false);
                if (this.getCommand() == 1) {
                    this.setCommand(0);
                }
            }
            if (this.method_6113() || this.isSleepingEntering() || this.isSleepingExiting()) {
                this.wakeUpImmediately();
                this.suppressSleep(300);
            }
        }
        if (!mounted && this.wasVehicleLastTick) {
            this.setBreathingFire(false);
            this.combatManager.forceEndActiveAbility();
            this.sitProgress = 0.0f;
            this.prevSitProgress = 0.0f;
            this.field_6011.method_12778(DATA_SIT_PROGRESS, (Object)Float.valueOf(0.0f));
            this.field_6011.method_12778(DATA_GROUND_MOVE_STATE, (Object)0);
            this.field_6011.method_12778(DATA_FLIGHT_MODE, (Object)-1);
            this.field_6011.method_12778(DATA_RIDER_FORWARD, (Object)Float.valueOf(0.0f));
            this.field_6011.method_12778(DATA_RIDER_STRAFE, (Object)Float.valueOf(0.0f));
            this.syncAnimState(0, -1);
        }
        this.wasVehicleLastTick = mounted;
    }

    private void updateSittingProgress() {
        if (this.method_37908().field_9236) {
            return;
        }
        if (this.sitTransitionTicks > 0) {
            --this.sitTransitionTicks;
            if (this.sitTransitionTicks == 0) {
                this.isSittingDown = false;
                this.isStandingUp = false;
            }
        }
        if (this.method_24345()) {
            if ((this.sitProgress == 0.0f || this.isStandingUp) && !this.isSittingDown) {
                this.animationHandler.triggerSitDownAnimation();
                this.isSittingDown = true;
                this.isStandingUp = false;
                this.sitTransitionTicks = 45;
            }
            if (this.sitProgress < this.maxSitTicks()) {
                this.sitProgress += 1.0f;
                this.field_6011.method_12778(DATA_SIT_PROGRESS, (Object)Float.valueOf(this.sitProgress));
            }
        } else if (this.method_5782()) {
            if (this.sitProgress != 0.0f) {
                this.sitProgress = 0.0f;
                this.prevSitProgress = 0.0f;
                this.field_6011.method_12778(DATA_SIT_PROGRESS, (Object)Float.valueOf(0.0f));
            }
        } else if (this.sitProgress > 0.0f) {
            if ((this.sitProgress >= this.maxSitTicks() - 1.0f || this.isSittingDown) && !this.isStandingUp) {
                this.animationHandler.triggerSitUpAnimation();
                this.isStandingUp = true;
                this.isSittingDown = false;
                this.sitTransitionTicks = 46;
            }
            this.sitProgress -= 1.0f;
            if (this.sitProgress < 0.0f) {
                this.sitProgress = 0.0f;
            }
            this.field_6011.method_12778(DATA_SIT_PROGRESS, (Object)Float.valueOf(this.sitProgress));
        }
    }

    private void tickClientSideUpdates() {
        if (this.method_37908().field_9236) {
            this.prevSitProgress = this.sitProgress;
            this.sitProgress = ((Float)this.field_6011.method_12789(DATA_SIT_PROGRESS)).floatValue();
        }
    }

    private void handleAmbientSounds() {
        if (this.nextAmbientSoundDelay <= 0) {
            this.resetAmbientSoundTimer();
        }
        if (this.method_6109() || this.isDying() || this.method_6113() || this.isSleepTransitioning() || this.isInSitTransition() || this.sleepAmbientCooldownTicks > 0) {
            this.ambientSoundTimer = 0;
            return;
        }
        if (this.getActiveAbility() != null || this.isBreathingFire() || this.method_5968() != null) {
            this.ambientSoundTimer = 0;
            return;
        }
        if (this.method_5782() || this.isTakeoff() || this.isLanding() || this.isHovering()) {
            return;
        }
        ++this.ambientSoundTimer;
        if (this.ambientSoundTimer < this.nextAmbientSoundDelay) {
            return;
        }
        String vocal = this.selectAmbientGrumble();
        if (vocal != null) {
            this.getSoundHandler().playVocal(vocal);
        }
        this.resetAmbientSoundTimer();
    }

    private String selectAmbientGrumble() {
        class_5819 random = this.method_6051();
        float roll = random.method_43057();
        if (roll < 0.45f) {
            return "grumble1";
        }
        if (roll < 0.8f) {
            return "grumble2";
        }
        return "grumble3";
    }

    private void resetAmbientSoundTimer() {
        this.ambientSoundTimer = 0;
        class_5819 random = this.method_6051();
        int range = Math.max(1, 241);
        this.nextAmbientSoundDelay = 180 + random.method_43048(range);
    }

    private void clearStatesWhenMounted() {
        if (this.method_37908().field_9236 || !this.method_5782()) {
            return;
        }
        this.setRunning(false);
        this.setGoingUp(false);
        this.setGoingDown(false);
        this.setHovering(false);
        this.setLanding(false);
        this.setTakeoff(false);
        this.setAccelerating(false);
        this.riderTakeoffTicks = 0;
        if (!this.method_6581()) {
            this.airTicks = 0;
        }
        if (this.method_5942().method_6345() != null) {
            this.method_5942().method_6340();
        }
        if (!this.method_6581() && this.usingAirNav) {
            this.switchToGroundNavigation();
        }
        this.field_6011.method_12778(DATA_GROUND_MOVE_STATE, (Object)0);
        this.field_6011.method_12778(DATA_FLIGHT_MODE, (Object)-1);
        this.field_6011.method_12778(DATA_RIDER_FORWARD, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12778(DATA_RIDER_STRAFE, (Object)Float.valueOf(0.0f));
        this.syncAnimState(0, -1);
        this.method_5980(null);
        this.method_24346(false);
        this.method_5875(this.method_6581() || this.isHovering());
    }

    private void tickRiderTakeoff() {
        if (!this.method_37908().field_9236 && this.riderTakeoffTicks > 0) {
            double boost;
            --this.riderTakeoffTicks;
            class_243 velocity = this.method_18798();
            double d = boost = this.method_6581() ? 0.08 : 0.12;
            if (velocity.field_1351 < boost) {
                this.method_18800(velocity.field_1352, boost, velocity.field_1350);
            }
            this.field_6007 = true;
        }
    }

    private void tickBankingLogic() {
        boolean shouldBank;
        this.prevBankAngle = this.bankAngle;
        boolean bl = shouldBank = this.method_6581() && !this.isLanding() && !this.isHovering() && !this.method_24345();
        if (!shouldBank) {
            if (this.bankDir != 0 || this.bankAngle != 0.0f || this.bankSmoothedYaw != 0.0f) {
                this.bankDir = 0;
                this.bankSmoothedYaw = 0.0f;
                this.bankHoldTicks = 0;
                this.bankAngle = 0.0f;
                this.prevBankAngle = 0.0f;
            }
            return;
        }
        float yawChange = class_3532.method_15393((float)(this.method_36454() - this.field_5982));
        this.bankSmoothedYaw = this.bankSmoothedYaw * 0.75f + yawChange * 0.25f;
        float targetAngle = class_3532.method_15363((float)(this.bankSmoothedYaw * 6.0f), (float)-90.0f, (float)90.0f);
        this.bankAngle = class_3532.method_16439((float)0.3f, (float)this.bankAngle, (float)targetAngle);
        if (Math.abs(this.bankAngle) < 0.01f) {
            this.bankAngle = 0.0f;
        }
        float enter = 10.0f;
        float exit = 4.0f;
        int desiredDir = this.bankDir;
        if (this.bankAngle > enter) {
            desiredDir = 1;
        } else if (this.bankAngle < -enter) {
            desiredDir = -1;
        } else if (Math.abs(this.bankAngle) < exit) {
            desiredDir = 0;
        }
        if (desiredDir != this.bankDir) {
            int holdTime;
            int n = holdTime = desiredDir == 0 ? 1 : 2;
            if (this.bankHoldTicks >= holdTime) {
                this.bankDir = desiredDir;
                this.bankHoldTicks = 0;
            } else {
                ++this.bankHoldTicks;
            }
        } else {
            this.bankHoldTicks = Math.min(this.bankHoldTicks + 1, 10);
        }
    }

    private void tickRiderLandingBlendTimer() {
        if (!this.method_5782() || !this.method_6581() || this.method_24828()) {
            this.riderLandingBlendTicks = 0;
            if (!this.method_37908().field_9236) {
                this.field_6011.method_12778(DATA_RIDER_LANDING_BLEND, (Object)false);
            }
            return;
        }
        if (this.riderLandingBlendTicks > 0) {
            --this.riderLandingBlendTicks;
            if (this.riderLandingBlendTicks == 0 && !this.method_37908().field_9236) {
                this.field_6011.method_12778(DATA_RIDER_LANDING_BLEND, (Object)false);
            }
        }
    }

    private void triggerRiderLandingBlend() {
        this.riderLandingBlendTicks = 3;
        if (!this.method_37908().field_9236) {
            this.field_6011.method_12778(DATA_RIDER_LANDING_BLEND, (Object)true);
        }
    }

    public boolean isRiderLandingBlendActive() {
        return (Boolean)this.field_6011.method_12789(DATA_RIDER_LANDING_BLEND);
    }

    private double getAltitudeAboveTerrain() {
        class_2338 pos = this.method_24515();
        if (!this.method_37908().method_22340(pos)) {
            return Double.POSITIVE_INFINITY;
        }
        int groundY = this.method_37908().method_8624(class_2902.class_2903.field_13203, pos.method_10263(), pos.method_10260());
        int dragonY = (int)Math.floor(this.method_23318());
        int scanTopY = dragonY + 3;
        int scanBottomY = Math.min(groundY - 1, dragonY - 15);
        for (int y = scanTopY; y >= scanBottomY; --y) {
            class_2338 checkPos = new class_2338(pos.method_10263(), y, pos.method_10260());
            class_2680 checkState = this.method_37908().method_8320(checkPos);
            if (checkState.method_26227().method_15769()) continue;
            return Double.POSITIVE_INFINITY;
        }
        return this.method_23318() - (double)groundY;
    }

    private void tickPitchingLogic() {
        this.tickRiderLandingBlendTimer();
        if (!this.method_6581() || this.isLanding() || this.isHovering() || this.method_24345()) {
            if (this.pitchDir != 0) {
                this.pitchDir = 0;
                this.pitchSmoothedPitch = 0.0f;
                this.pitchHoldTicks = 0;
            }
            return;
        }
        int desiredDir = this.pitchDir;
        if (this.method_5782() && this.method_5642() instanceof class_1657) {
            double altitude;
            desiredDir = this.isGoingUp() ? -1 : (this.isGoingDown() ? 1 : 0);
            if (this.isGoingDown() && (altitude = this.getAltitudeAboveTerrain()) != Double.POSITIVE_INFINITY && altitude >= -0.25 && altitude <= 8.0) {
                desiredDir = 0;
                this.triggerRiderLandingBlend();
            }
        } else {
            float pitchChange = this.method_36455() - this.field_6004;
            this.pitchSmoothedPitch = this.pitchSmoothedPitch * 0.9f + pitchChange * 0.1f;
            float enter = 4.0f;
            float exit = 6.0f;
            if (this.pitchSmoothedPitch > enter) {
                desiredDir = 1;
            } else if (this.pitchSmoothedPitch < -enter) {
                desiredDir = -1;
            } else if (Math.abs(this.pitchSmoothedPitch) < exit) {
                desiredDir = 0;
            }
        }
        if (desiredDir != this.pitchDir) {
            int holdTime;
            int n = holdTime = desiredDir == 0 ? 4 : 6;
            if (this.pitchHoldTicks >= holdTime) {
                this.pitchDir = desiredDir;
                this.pitchHoldTicks = 0;
            } else {
                ++this.pitchHoldTicks;
            }
        } else {
            this.pitchHoldTicks = Math.min(this.pitchHoldTicks + 1, 15);
        }
    }

    private void tickScreenShake() {
        this.prevScreenShakeAmount = this.screenShakeAmount;
        if (this.screenShakeAmount > 0.0f) {
            this.screenShakeAmount = Math.max(0.0f, this.screenShakeAmount - 0.12f);
            this.field_6011.method_12778(DATA_SCREEN_SHAKE_AMOUNT, (Object)Float.valueOf(this.screenShakeAmount));
        }
    }

    private void tickWaterSlicing() {
        if (this.method_37908().field_9236) {
            return;
        }
        if (!this.method_6581()) {
            return;
        }
        class_243 pos = this.method_19538();
        class_238 box = this.method_5829();
        int checkDown = 0;
        while ((double)checkDown < 10.0) {
            class_2338 checkPos = new class_2338((int)Math.floor(pos.field_1352), (int)Math.floor(pos.field_1351) - checkDown, (int)Math.floor(pos.field_1350));
            class_2680 state = this.method_37908().method_8320(checkPos);
            if (!state.method_26227().method_15769()) {
                double waterY = (double)checkPos.method_10264() + 1.0;
                double boxWidth = box.method_17939();
                double boxLength = box.method_17941();
                int particleCount = (int)Math.ceil((boxWidth + boxLength) / 2.0 * 1.5 * 8.0);
                particleCount = Math.min(particleCount, 50);
                for (int i = 0; i < particleCount; ++i) {
                    double offsetX = (this.field_5974.method_43058() - 0.5) * boxWidth;
                    double offsetZ = (this.field_5974.method_43058() - 0.5) * boxLength;
                    double particleX = pos.field_1352 + offsetX;
                    double particleZ = pos.field_1350 + offsetZ;
                    ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11202, particleX, waterY, particleZ, 1, offsetX * 0.2, 0.1, offsetZ * 0.2, 0.1);
                    if (!(this.field_5974.method_43057() < 0.3f)) continue;
                    ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11241, particleX, waterY, particleZ, 1, 0.0, 0.0, 0.0, 0.0);
                }
                break;
            }
            ++checkDown;
        }
    }

    public int getBankDirection() {
        return this.bankDir;
    }

    public float getBankAngleDegrees() {
        return this.bankAngle;
    }

    public float getBankAngleDegrees(float partialTick) {
        return class_3532.method_16439((float)partialTick, (float)this.prevBankAngle, (float)this.bankAngle);
    }

    public float getSmoothBankDirection() {
        return class_3532.method_15363((float)(this.bankAngle / 45.0f), (float)-1.0f, (float)1.0f);
    }

    public int getPitchDirection() {
        return this.pitchDir;
    }

    public int getAirTicks() {
        return this.airTicks;
    }

    public int getTimeFlying() {
        return this.timeFlying;
    }

    @Override
    public boolean isGoingUp() {
        return (Boolean)this.field_6011.method_12789(DATA_GOING_UP);
    }

    @Override
    public boolean isRunning() {
        return (Boolean)this.field_6011.method_12789(DATA_RUNNING);
    }

    @Override
    public void setRunning(boolean running) {
        this.field_6011.method_12778(DATA_RUNNING, (Object)running);
    }

    @Override
    public boolean isWalking() {
        if (this.method_37908().field_9236) {
            int s = this.getEffectiveGroundState();
            return s == 1;
        }
        int s = (Integer)this.field_6011.method_12789(DATA_GROUND_MOVE_STATE);
        return s == 1;
    }

    public void setGroundMoveStateFromAI(int state) {
        if (!this.method_37908().field_9236) {
            int s = class_3532.method_15340((int)state, (int)0, (int)2);
            if ((Integer)this.field_6011.method_12789(DATA_GROUND_MOVE_STATE) != s) {
                this.field_6011.method_12778(DATA_GROUND_MOVE_STATE, (Object)s);
                this.syncAnimState(s, this.getSyncedFlightMode());
            }
        }
    }

    @Override
    public void initializeAnimationState() {
        super.initializeAnimationState();
        if (!this.method_37908().field_9236) {
            this.groundTicks = 0;
            this.airTicks = 0;
            this.landingTicks = 0;
        }
    }

    @Override
    public int getFlightMode() {
        return this.physicsController.computeFlightModeForSync();
    }

    @Override
    protected void applyRiderVerticalInput(class_1657 player, boolean goingUp, boolean goingDown, boolean locked) {
        if (this.method_6581()) {
            this.setGoingUp(goingUp);
            this.setGoingDown(goingDown);
        } else {
            this.setGoingUp(false);
            this.setGoingDown(false);
        }
    }

    @Override
    protected void applyRiderMovementInput(class_1657 player, float forward, float strafe, float yaw, boolean locked) {
        float fwd = this.applyInputDeadzone(forward);
        float str = this.applyInputDeadzone(strafe);
        this.setLastRiderForward(fwd);
        this.setLastRiderStrafe(str);
        if (!this.method_6581()) {
            int moveState = 0;
            float magnitude = Math.abs(fwd) + Math.abs(str);
            if (magnitude > 0.05f) {
                moveState = this.isAccelerating() ? 2 : 1;
            }
            this.setGroundMoveStateFromAI(moveState);
            this.setRunning(moveState == 2);
        }
    }

    @Override
    protected void handleRiderAction(class_3222 player, DragonRiderAction action, String abilityName, boolean locked) {
        if (action == null) {
            return;
        }
        switch (action) {
            case TAKEOFF_REQUEST: {
                this.requestRiderTakeoff();
                break;
            }
            case ACCELERATE: {
                this.setAccelerating(true);
                break;
            }
            case STOP_ACCELERATE: {
                this.setAccelerating(false);
                break;
            }
            case ABILITY_USE: {
                if (abilityName == null || abilityName.isEmpty()) break;
                this.useRidingAbility(abilityName);
                break;
            }
            case ABILITY_STOP: {
                if (abilityName == null || abilityName.isEmpty()) break;
                this.forceEndActiveAbility();
                break;
            }
        }
    }

    @Override
    public RideableDragonBase.RiderAbilityBinding getTertiaryRiderAbility() {
        return new RideableDragonBase.RiderAbilityBinding("cindervane_fire_body", RideableDragonBase.RiderAbilityBinding.Activation.HOLD);
    }

    @Override
    public RideableDragonBase.RiderAbilityBinding getPrimaryRiderAbility() {
        return new RideableDragonBase.RiderAbilityBinding("cindervane_roar", RideableDragonBase.RiderAbilityBinding.Activation.PRESS);
    }

    @Override
    public RideableDragonBase.RiderAbilityBinding getSecondaryRiderAbility() {
        return new RideableDragonBase.RiderAbilityBinding("cindervane_fire_breath_volley", RideableDragonBase.RiderAbilityBinding.Activation.PRESS);
    }

    @Override
    public RideableDragonBase.RiderAbilityBinding getAttackRiderAbility() {
        return new RideableDragonBase.RiderAbilityBinding("cindervane_bite", RideableDragonBase.RiderAbilityBinding.Activation.PRESS);
    }

    protected int getMaxPassengers() {
        return 2;
    }

    protected boolean method_5818(@NotNull class_1297 passenger) {
        return this.method_5685().size() < this.getMaxPassengers();
    }

    public void requestRiderTakeoff() {
        this.riderController.requestRiderTakeoff();
    }

    public double method_5621() {
        return this.riderController.getPassengersRidingOffset();
    }

    protected void method_5865(@Nonnull class_1297 passenger, @Nonnull class_1297.class_4738 moveFunction) {
        this.riderController.positionRider(passenger, moveFunction);
    }

    @NotNull
    public class_243 method_24829(@Nonnull class_1309 passenger) {
        return this.riderController.getDismountLocationForPassenger(passenger);
    }

    @Nullable
    public class_1309 method_5642() {
        return this.riderController.getControllingPassenger();
    }

    protected float method_49485(@Nonnull class_1657 rider) {
        return this.riderController.getRiddenSpeed(rider);
    }

    protected void method_49481(@Nonnull class_1657 player, @Nonnull class_243 travelVector) {
        super.method_49481(player, travelVector);
        this.riderController.tickRidden(player, travelVector);
        if (this.areRiderControlsLocked() && this.combatManager.getActiveAbility() == null && !this.combatManager.hasActiveOverlay()) {
            this.copyRiderLook(player);
        }
    }

    @Override
    @NotNull
    public class_243 method_49482(@Nonnull class_1657 player, @Nonnull class_243 deltaIn) {
        class_243 input = this.riderController.getRiddenInput(player, deltaIn);
        if (!this.method_37908().field_9236 && !this.method_6581()) {
            float fwd = (float)class_3532.method_15350((double)input.field_1350, (double)-1.0, (double)1.0);
            float str = (float)class_3532.method_15350((double)input.field_1352, (double)-1.0, (double)1.0);
            this.field_6011.method_12778(DATA_RIDER_FORWARD, (Object)Float.valueOf(RideableDragonData.applyInputThreshold(fwd)));
            this.field_6011.method_12778(DATA_RIDER_STRAFE, (Object)Float.valueOf(RideableDragonData.applyInputThreshold(str)));
        }
        return input;
    }

    public void method_24346(boolean sitting) {
        super.method_24346(sitting);
        if (sitting) {
            if (this.method_6581()) {
                this.setLanding(true);
            }
            this.setRunning(false);
            this.method_5942().method_6340();
            if (!this.method_37908().field_9236) {
                this.field_6011.method_12778(DATA_SIT_PROGRESS, (Object)Float.valueOf(this.sitProgress));
            }
        }
    }

    @Override
    public void method_6091(@NotNull class_243 motion) {
        class_1309 class_13092;
        if (this.method_5782() && (class_13092 = this.method_5642()) instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            if (this.method_5942().method_6345() != null) {
                this.method_5942().method_6340();
            }
            if (this.method_6581()) {
                this.riderController.handleRiderMovement(player, motion);
            } else {
                super.method_6091(motion);
            }
        } else {
            super.method_6091(motion);
        }
    }

    public void switchToAirNavigation() {
        if (!this.usingAirNav) {
            this.field_6189 = this.airNav;
            this.field_6207 = new DragonFlightMoveHelper(this, this.getGliderFlightParameters());
            this.usingAirNav = true;
        }
    }

    private DragonFlightMoveHelper.FlightParameters getGliderFlightParameters() {
        return new DragonFlightMoveHelper.FlightParameters(3.0f, 5.0f, 0.3f, 2.0f, 0.08f, 0.15, 0.1);
    }

    private void handleFireBodyCrash() {
        boolean fireActive = this.isBreathingFire();
        boolean airborne = !this.method_24828();
        class_1309 rider = this.method_5642();
        if (fireActive && rider != null) {
            rider.method_6092(new class_1293(class_1294.field_5918, 10, 0, true, false, false));
        }
        if (fireActive && airborne) {
            if (!this.fireBodyCrashArmed) {
                this.fireBodyCrashMaxHeight = this.method_23318();
            } else if (this.method_23318() > this.fireBodyCrashMaxHeight) {
                this.fireBodyCrashMaxHeight = this.method_23318();
            }
            this.fireBodyCrashArmed = true;
        }
        if (this.fireBodyCrashArmed && !airborne && fireActive) {
            double dropDistance = this.fireBodyCrashMaxHeight - this.method_23318();
            if (dropDistance >= 7.0) {
                this.triggerFireBodyCrash();
            }
            this.fireBodyCrashArmed = false;
            this.fireBodyCrashMaxHeight = 0.0;
        }
        if (!fireActive && !airborne) {
            this.fireBodyCrashArmed = false;
            this.fireBodyCrashMaxHeight = 0.0;
        }
    }

    private void triggerFireBodyCrash() {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 server = (class_3218)class_19372;
        double x = this.method_23317();
        double y = this.method_23318();
        double z = this.method_23321();
        ArrayList<class_1297> immune = new ArrayList<class_1297>(this.method_5685());
        for (class_1297 passenger : immune) {
            if (!(passenger instanceof class_1309)) continue;
            class_1309 livingPassenger = (class_1309)passenger;
            livingPassenger.method_6092(new class_1293(class_1294.field_5907, 20, 4, true, false, false));
        }
        class_5362 calculator = new class_5362(){

            @NotNull
            public Optional<Float> method_29555(@NotNull class_1927 explosion, @NotNull class_1922 level, @NotNull class_2338 pos, @NotNull class_2680 state, @NotNull class_3610 fluid) {
                if (Cindervane.this.isFireBodyImmuneBlock(state)) {
                    return Optional.of(Float.valueOf(Float.MAX_VALUE));
                }
                return Optional.of(Float.valueOf(0.0f));
            }

            public boolean method_29554(@NotNull class_1927 explosion, @NotNull class_1922 level, @NotNull class_2338 pos, @NotNull class_2680 state, float exposure) {
                return !Cindervane.this.isFireBodyImmuneBlock(state);
            }
        };
        class_1927 explosion = new class_1927((class_1937)server, (class_1297)this, server.method_48963().method_48819((class_1297)this, (class_1297)this), calculator, x, y + 0.2, z, 15.0f, true, class_1927.class_4179.field_18687);
        List<class_1309> allies = this.grantAlliesExplosionImmunity(server, x, y, z);
        for (class_1309 ally : allies) {
            ally.method_5684(true);
        }
        explosion.method_8348();
        explosion.method_8350(true);
        for (class_1309 ally : allies) {
            ally.method_5684(false);
        }
        this.applyFireBodyBlastDamage(server, x, y, z, immune);
        this.carveFireBodyImprint(server, class_2338.method_49637((double)x, (double)y, (double)z));
        server.method_14199((class_2394)class_2398.field_11240, x, y + 0.8, z, 150, 2.0, 1.0, 2.0, 0.2);
        server.method_14199((class_2394)class_2398.field_27783, x, y + 0.5, z, 120, 1.8, 0.8, 1.8, 0.15);
        server.method_14199((class_2394)class_2398.field_11239, x, y + 0.5, z, 40, 1.3, 0.6, 1.3, 0.12);
        server.method_14199((class_2394)class_2398.field_11237, x, y + 0.5, z, 80, 2.2, 0.7, 2.2, 0.05);
        class_2338.class_2339 flamePos = new class_2338.class_2339();
        int baseY = this.method_31478();
        for (int dx = -3; dx <= 3; ++dx) {
            for (int dz = -3; dz <= 3; ++dz) {
                class_2680 belowState;
                if (this.method_6051().method_43057() > 0.45f) continue;
                flamePos.method_10102(x + (double)dx, (double)baseY, z + (double)dz);
                if (!server.method_8477((class_2338)flamePos) || !server.method_8320((class_2338)flamePos).method_26215() || (belowState = server.method_8320(flamePos.method_10074())).method_26215() || !class_2246.field_10036.method_9564().method_26184((class_4538)server, (class_2338)flamePos)) continue;
                server.method_8652((class_2338)flamePos, class_2246.field_10036.method_9564(), 11);
            }
        }
        this.forceEndActiveAbility();
    }

    private boolean isFireBodyImmuneBlock(class_2680 state) {
        return state.method_27852(class_2246.field_9987) || state.method_27852(class_2246.field_10540);
    }

    private List<class_1309> grantAlliesExplosionImmunity(class_3218 server, double x, double y, double z) {
        double radius = 19.0;
        class_238 area = new class_238(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius);
        List allies = server.method_8390(class_1309.class, area, entity -> entity.method_5805() && entity != this && this.isAlly((class_1297)entity));
        if (allies.isEmpty()) {
            return allies;
        }
        for (class_1309 ally : allies) {
            ally.method_6092(new class_1293(class_1294.field_5907, 40, 4, true, false, false));
            ally.method_6092(new class_1293(class_1294.field_5918, 200, 0, true, false, false));
            ally.method_20803(0);
        }
        return allies;
    }

    private void applyFireBodyBlastDamage(class_3218 server, double x, double y, double z, List<class_1297> immune) {
        double radius = 17.5;
        class_238 area = new class_238(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius);
        HashSet<Integer> immuneIds = new HashSet<Integer>();
        for (class_1297 entity : immune) {
            immuneIds.add(entity.method_5628());
        }
        immuneIds.add(this.method_5628());
        List targets = server.method_8390(class_1309.class, area, living -> living.method_5805() && !immuneIds.contains(living.method_5628()) && !this.isAlly((class_1297)living));
        if (targets.isEmpty()) {
            return;
        }
        for (class_1309 target : targets) {
            if (!target.method_5643(server.method_48963().method_48819((class_1297)this, (class_1297)this), 200.0f)) continue;
            target.method_5639(8);
        }
    }

    private void carveFireBodyImprint(class_3218 server, class_2338 center) {
        int radius = class_3532.method_15384((double)9.0);
        double radiusSq = 81.0;
        class_2338.class_2339 cursor = new class_2338.class_2339();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                double horizontalSq = dx * dx + dz * dz;
                if (horizontalSq > radiusSq) continue;
                double normalized = Math.sqrt(horizontalSq) / 9.0;
                double depth = (1.0 - normalized * normalized) * 5.3999999999999995;
                int maxDepth = class_3532.method_15357((double)depth);
                for (int dy = 0; dy <= maxDepth; ++dy) {
                    class_2680 state;
                    cursor.method_10103(center.method_10263() + dx, center.method_10264() - dy, center.method_10260() + dz);
                    if (!server.method_8477((class_2338)cursor) || (state = server.method_8320((class_2338)cursor)).method_26215() || this.isFireBodyImmuneBlock(state)) continue;
                    server.method_8651((class_2338)cursor, true, (class_1297)this);
                }
            }
        }
    }

    public void switchToGroundNavigation() {
        if (this.usingAirNav) {
            this.field_6189 = this.groundNav;
            this.field_6207 = new class_1335((class_1308)this);
            this.usingAirNav = false;
        }
    }

    public boolean isBreathingFire() {
        return (Boolean)this.field_6011.method_12789(DATA_FIRE_BREATHING);
    }

    public void setBreathingFire(boolean breathing) {
        this.field_6011.method_12778(DATA_FIRE_BREATHING, (Object)breathing);
    }

    @NotNull
    protected class_1408 method_5965(@Nonnull class_1937 level) {
        return new DragonPathNavigateGround((class_1308)this, level);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController movement = new AnimationController((GeoAnimatable)this, "movement", 5, this.animationHandler::handleMovementAnimation);
        movement.setSoundKeyframeHandler(this::onAnimationSound);
        controllers.add(new AnimationController[]{movement});
        AnimationController banking = new AnimationController((GeoAnimatable)this, "banking", 10, this.animationHandler::bankingPredicate);
        controllers.add(new AnimationController[]{banking});
        AnimationController pitching = new AnimationController((GeoAnimatable)this, "pitching", 10, this.animationHandler::pitchingPredicate);
        controllers.add(new AnimationController[]{pitching});
        AnimationController actions = new AnimationController((GeoAnimatable)this, "actions", 5, this.animationHandler::actionPredicate);
        this.animationHandler.setupActionController((AnimationController<Cindervane>)actions);
        actions.setSoundKeyframeHandler(this::onAnimationSound);
        controllers.add(new AnimationController[]{actions});
        AnimationController HurtController = new AnimationController((GeoAnimatable)this, "hurt", 3, state -> PlayState.STOP);
        HurtController.triggerableAnim("cindervane_hurt", RawAnimation.begin().thenPlay("animation.cindervane.hurt"));
        HurtController.setSoundKeyframeHandler(this::onAnimationSound);
        controllers.add(new AnimationController[]{HurtController});
    }

    private void onAnimationSound(SoundKeyframeEvent<Cindervane> event) {
        this.soundHandler.handleAnimationSound(this, event.getKeyframeData(), event.getController());
    }

    @Override
    public DragonSoundHandler getSoundHandler() {
        return this.soundHandler;
    }

    public DragonRestManager getRestManager() {
        return this.restManager;
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public Map<String, DragonEntity.VocalEntry> getVocalEntries() {
        return VOCAL_ENTRIES;
    }

    @Override
    public DragonSoundProfile getSoundProfile() {
        return CindervaneSoundProfile.INSTANCE;
    }

    @Override
    public DragonAbilityType<?, ?> getPrimaryAttackAbility() {
        return CindervaneAbilities.BITE;
    }

    @Override
    public boolean hasSecondaryMelee() {
        return false;
    }

    @Override
    public DragonAbilityType<?, ?> getRoaringAbility() {
        return CindervaneAbilities.ROAR;
    }

    @Override
    protected DragonAbilityType<?, ?> getHurtAbilityType() {
        return CindervaneAbilities.HURT;
    }

    @Override
    public int getDeathAnimationDurationTicks() {
        return 95;
    }

    @Override
    public boolean method_5643(@Nonnull class_1282 source, float amount) {
        if (this.isDying()) {
            if (source.method_49708(class_8111.field_44869)) {
                return super.method_5643(source, amount);
            }
            return false;
        }
        if (this.method_6113() || this.isSleepingEntering() || this.isSleepingExiting()) {
            this.wakeUpImmediately();
            this.suppressSleep(200);
        }
        if (this.handleLethalDamage(source, amount, CindervaneAbilities.DIE)) {
            return true;
        }
        return super.method_5643(source, amount);
    }

    protected void method_6108() {
        ++this.field_6213;
        if (this.field_6213 >= 20) {
            this.method_5650(class_1297.class_5529.field_26998);
            this.method_23883();
        }
    }

    @Override
    public <T extends DragonEntity> DragonAbility<T> getActiveAbility() {
        return this.combatManager.getActiveAbility();
    }

    public boolean isAbilityActive(DragonAbilityType<?, ?> abilityType) {
        return this.combatManager.isAbilityActive(abilityType);
    }

    public void forceEndAbility(DragonAbilityType<?, ?> abilityType) {
        this.combatManager.forceEndAbility(abilityType);
    }

    public void useRidingAbility(String abilityName) {
        class_1657 player;
        if (abilityName == null || abilityName.isEmpty()) {
            return;
        }
        class_1309 rider = this.method_5642();
        if (!(rider instanceof class_1309)) {
            return;
        }
        if (this.method_6181() && rider instanceof class_1657 && !this.method_6171((class_1309)(player = (class_1657)rider))) {
            return;
        }
        DragonAbilityType<?, ?> type = AbilityRegistry.get(abilityName);
        if (type == CindervaneAbilities.BITE || type == CindervaneAbilities.FIRE_BODY || type == CindervaneAbilities.ROAR || type == CindervaneAbilities.FIRE_BREATH_VOLLEY) {
            this.combatManager.tryUseAbility(type);
        }
    }

    public void forceEndActiveAbility() {
        this.combatManager.forceEndActiveAbility();
        this.fireBodyCrashArmed = false;
        this.setBreathingFire(false);
    }

    public boolean method_6121(@NotNull class_1297 target) {
        if (!this.method_5782() && !this.method_24345()) {
            this.combatManager.tryUseAbility(CindervaneAbilities.BITE);
        }
        return true;
    }

    @Override
    public class_243 getHeadPosition() {
        return this.method_33571();
    }

    @Override
    public class_243 getMouthPosition() {
        return this.computeMouthOrigin(1.0f);
    }

    public class_243 computeMouthOrigin(float partialTicks) {
        double x = class_3532.method_16436((double)partialTicks, (double)this.field_6014, (double)this.method_23317());
        double y = class_3532.method_16436((double)partialTicks, (double)this.field_6036, (double)this.method_23318());
        double z = class_3532.method_16436((double)partialTicks, (double)this.field_5969, (double)this.method_23321());
        float yawDeg = class_3532.method_16439((float)partialTicks, (float)this.field_6259, (float)this.field_6241);
        float pitchDeg = class_3532.method_16439((float)partialTicks, (float)this.field_6004, (float)this.method_36455());
        double yaw = Math.toRadians(yawDeg);
        double pitch = Math.toRadians(pitchDeg);
        double R = -0.025;
        double U = 0.325;
        double F = 0.78125;
        double cp = Math.cos(pitch);
        double sp = Math.sin(pitch);
        double up = U * cp - F * sp;
        double fwd = U * sp + F * cp;
        double cy = Math.cos(yaw);
        double sy = Math.sin(yaw);
        double offX = R * cy - fwd * sy;
        double offZ = R * sy + fwd * cy;
        return new class_243(x + offX, y + up, z + offZ);
    }

    public boolean method_6481(@Nonnull class_1799 stack) {
        return stack.method_31574(class_1802.field_8429) || stack.method_31574(class_1802.field_8209) || stack.method_31574(class_1802.field_8846) || stack.method_31574(class_1802.field_8726);
    }

    @Override
    @NotNull
    public class_1269 method_5992(@NotNull class_1657 player, @NotNull class_1268 hand) {
        class_1269 handlerResult = this.interactionHandler.handleInteraction(player, hand);
        if (handlerResult != class_1269.field_5811) {
            return handlerResult;
        }
        return super.method_5992(player, hand);
    }

    @Nullable
    public class_1296 method_5613(@Nonnull class_3218 level, @Nonnull class_1296 partner) {
        Cindervane baby = (Cindervane)ModEntities.CINDERVANE.get().method_5883((class_1937)level);
        if (baby != null) {
            class_2338 safePos = this.findSafeBabySpawnPos((class_1936)level, this.method_24515());
            double spawnY = safePos != null ? (double)safePos.method_10264() : this.method_23318();
            baby.method_5808(this.method_23317(), spawnY, this.method_23321(), this.method_36454(), 0.0f);
        }
        return baby;
    }

    @Override
    public void method_5652(@NotNull class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("TimeFlying", this.timeFlying);
        this.saveRideableData(tag);
        this.restManager.save(tag);
    }

    @Override
    public void method_5749(@NotNull class_2487 tag) {
        super.method_5749(tag);
        this.loadRideableData(tag);
        boolean savedFlying = tag.method_10577("Flying");
        this.timeFlying = tag.method_10550("TimeFlying");
        if (!savedFlying) {
            this.landingTicks = 0;
            this.airTicks = 0;
        } else {
            this.airTicks = Math.max(this.airTicks, 1);
        }
        this.groundTicks = 0;
        this.method_5875(this.method_6581() || this.isHovering());
        this.restManager.load(tag);
        DragonRestState restState = this.restManager.getCurrentState();
        switch (restState) {
            case SLEEPING: {
                this.method_24346(true);
                this.animationHandler.triggerSleepAnimation();
                break;
            }
            case SITTING_DOWN: 
            case SITTING: 
            case SITTING_AFTER: {
                this.method_24346(true);
                break;
            }
            case FALLING_ASLEEP: {
                this.method_24346(true);
                this.startSleepEnter();
                break;
            }
            case WAKING_UP: {
                this.method_24346(true);
                this.startSleepExit();
                break;
            }
            case STANDING_UP: {
                this.method_24346(false);
            }
        }
        if (!this.method_37908().field_9236) {
            this.field_6012 = 0;
        }
    }

    public void prepareForMounting() {
        if (this.method_37908().field_9236) {
            return;
        }
        this.method_24346(false);
        if (this.getCommand() == 1) {
            this.setCommand(0);
        }
        this.sitProgress = 0.0f;
        this.prevSitProgress = 0.0f;
        this.field_6011.method_12778(DATA_SIT_PROGRESS, (Object)Float.valueOf(0.0f));
        this.method_5980(null);
        if (this.method_5942().method_6345() != null) {
            this.method_5942().method_6340();
        }
        this.clearStatesWhenMounted();
    }

    @Override
    protected boolean isDragonFlying() {
        return (Boolean)this.field_6011.method_12789(DATA_FLYING);
    }

    @Override
    public void setFlying(boolean flying) {
        if (flying == this.method_6581()) {
            return;
        }
        this.field_6011.method_12778(DATA_FLYING, (Object)flying);
        if (flying) {
            this.switchToAirNavigation();
            this.setLanding(false);
            this.setTakeoff(true);
            this.method_5942().method_6340();
        } else {
            this.switchToGroundNavigation();
            this.setHovering(false);
            this.setTakeoff(false);
        }
    }

    @Override
    public boolean isTakeoff() {
        return (Boolean)this.field_6011.method_12789(DATA_TAKEOFF);
    }

    @Override
    public void setTakeoff(boolean takeoff) {
        this.field_6011.method_12778(DATA_TAKEOFF, (Object)takeoff);
    }

    @Override
    public boolean isHovering() {
        return (Boolean)this.field_6011.method_12789(DATA_HOVERING);
    }

    @Override
    public void setHovering(boolean hovering) {
        this.field_6011.method_12778(DATA_HOVERING, (Object)hovering);
    }

    @Override
    public boolean isLanding() {
        return (Boolean)this.field_6011.method_12789(DATA_LANDING);
    }

    @Override
    public void setLanding(boolean landing) {
        this.field_6011.method_12778(DATA_LANDING, (Object)landing);
        this.landingTicks = 0;
        if (landing) {
            this.setHovering(false);
            this.setTakeoff(false);
        }
    }

    @Override
    public float getFlightSpeed() {
        return 0.5f;
    }

    @Override
    public double getPreferredFlightAltitude() {
        double base = 24.0 + this.method_6051().method_43058() * 10.0;
        return class_3532.method_15350((double)base, (double)20.0, (double)45.0);
    }

    @Override
    public boolean canTakeoff() {
        return !this.method_6109() && !this.method_24345() && this.method_5805() && (this.method_24828() || this.method_5799());
    }

    @Override
    public void markLandedNow() {
        this.setLanding(false);
        this.setTakeoff(false);
        this.riderTakeoffTicks = 0;
    }

    public void setRiderTakeoffTicks(int ticks) {
        this.riderTakeoffTicks = Math.max(0, ticks);
    }

    public boolean method_5747(float fallDistance, float fallMultiplier, @NotNull class_1282 source) {
        if (this.method_6581() || this.isTakeoff() || this.isLanding()) {
            return false;
        }
        return super.method_5747(fallDistance, fallMultiplier, source);
    }

    public boolean method_5776() {
        return this.method_6581() && this.method_18798().field_1351 > -0.1;
    }

    public boolean canBeBound() {
        return !this.method_6581() && !this.isDying() && !this.isAccelerating();
    }

    @Override
    public DragonAbilityType<?, ?> getChannelingAbility() {
        return CindervaneAbilities.FIRE_BREATH_VOLLEY;
    }

    public void method_5711(byte eventId) {
        if (eventId == 6) {
            if (this.method_37908().field_9236) {
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.field_5974.method_43059() * 0.02;
                    double d1 = this.field_5974.method_43059() * 0.02;
                    double d2 = this.field_5974.method_43059() * 0.02;
                    this.method_37908().method_8406((class_2394)class_2398.field_11251, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d0, d1, d2);
                }
            }
        } else if (eventId == 7) {
            if (this.method_37908().field_9236) {
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.field_5974.method_43059() * 0.02;
                    double d1 = this.field_5974.method_43059() * 0.02;
                    double d2 = this.field_5974.method_43059() * 0.02;
                    this.method_37908().method_8406((class_2394)class_2398.field_11201, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d0, d1, d2);
                }
            }
        } else {
            super.method_5711(eventId);
        }
    }

    public void setClientLocatorPosition(String name, class_243 pos) {
        if (name == null || pos == null) {
            return;
        }
        this.clientLocatorCache.put(name, pos);
    }

    @Override
    public class_243 getClientLocatorPosition(String name) {
        if (name == null) {
            return null;
        }
        return this.clientLocatorCache.get(name);
    }

    @Override
    public float getScreenShakeAmount(float partialTicks) {
        float current = ((Float)this.field_6011.method_12789(DATA_SCREEN_SHAKE_AMOUNT)).floatValue();
        return this.prevScreenShakeAmount + (current - this.prevScreenShakeAmount) * partialTicks;
    }

    @Override
    public double getShakeDistance() {
        return 18.0;
    }

    @Override
    public boolean canFeelShake(class_1297 player) {
        return true;
    }

    public void triggerScreenShake(float intensity) {
        this.screenShakeAmount = Math.max(this.screenShakeAmount, intensity);
        this.field_6011.method_12778(DATA_SCREEN_SHAKE_AMOUNT, (Object)Float.valueOf(this.screenShakeAmount));
    }

    public boolean isInSitTransition() {
        return this.isSittingDown || this.isStandingUp;
    }

    public boolean isSittingDownAnimation() {
        return this.isSittingDown;
    }

    public boolean isStandingUpAnimation() {
        return this.isStandingUp;
    }

    private void tickSleepTransition() {
        if (this.isSleepingEntering() && !this.method_37908().field_9236) {
            if (this.getSitProgress() >= this.maxSitTicks()) {
                if (this.sleepTransitionTicks > 60) {
                    this.animationHandler.triggerFallAsleepAnimation();
                    this.sleepTransitionTicks = 60;
                }
            } else {
                this.sleepTransitionTicks = 61;
                return;
            }
        }
        if (this.sleepTransitionTicks > 0) {
            --this.sleepTransitionTicks;
            if (this.sleepTransitionTicks == 0) {
                if (this.isSleepingEntering()) {
                    this.setSleeping(true);
                    this.setSleepingEntering(false);
                    this.animationHandler.triggerSleepAnimation();
                } else if (this.isSleepingExiting()) {
                    this.setSleepingExiting(false);
                    this.sleepAmbientCooldownTicks = 10;
                }
            }
        }
    }

    private void tickSleepCooldowns() {
        if (this.sleepAmbientCooldownTicks > 0) {
            --this.sleepAmbientCooldownTicks;
        }
        if (this.sleepReentryCooldownTicks > 0) {
            --this.sleepReentryCooldownTicks;
        }
        if (this.sleepCancelTicks > 0) {
            --this.sleepCancelTicks;
        }
    }

    @Override
    public boolean method_6113() {
        return (Boolean)this.field_6011.method_12789(DATA_SLEEPING);
    }

    public void setSleeping(boolean sleeping) {
        this.field_6011.method_12778(DATA_SLEEPING, (Object)sleeping);
    }

    @Override
    public boolean isSleepTransitioning() {
        return this.isSleepingEntering() || this.isSleepingExiting();
    }

    public boolean isSleepingEntering() {
        return (Boolean)this.field_6011.method_12789(DATA_SLEEPING_ENTERING);
    }

    public void setSleepingEntering(boolean entering) {
        this.field_6011.method_12778(DATA_SLEEPING_ENTERING, (Object)entering);
    }

    public boolean isSleepingExiting() {
        return (Boolean)this.field_6011.method_12789(DATA_SLEEPING_EXITING);
    }

    public void setSleepingExiting(boolean exiting) {
        this.field_6011.method_12778(DATA_SLEEPING_EXITING, (Object)exiting);
    }

    public boolean isSleepLocked() {
        return this.sleepLocked || this.method_6113() || this.isSleepingEntering() || this.isSleepingExiting();
    }

    private void enterSleepLock() {
        int snapshot = this.getCommand();
        if (!this.sleepLocked) {
            this.sleepLocked = true;
            this.sleepCommandSnapshot = snapshot;
            if (this.getCommand() != 1) {
                this.setCommand(1);
                this.method_24346(true);
            }
        }
    }

    private void releaseSleepLock() {
        if (this.sleepLocked) {
            int desired = this.sleepCommandSnapshot;
            this.sleepCommandSnapshot = -1;
            this.sleepLocked = false;
            if (desired >= 0 && desired != this.getCommand()) {
                this.setCommand(desired);
                this.method_24346(desired == 1);
            }
        }
    }

    @Override
    public void startSleepEnter() {
        if (this.method_6113() || this.isSleepingEntering() || this.isSleepingExiting()) {
            return;
        }
        this.setSleepingEntering(true);
        this.sleepTransitionTicks = 61;
        if (!this.method_37908().field_9236) {
            this.enterSleepLock();
        }
    }

    @Override
    public void startSleepExit() {
        if (!this.method_6113() && !this.isSleepingEntering() || this.isSleepingExiting()) {
            return;
        }
        this.field_6011.method_12778(DATA_SLEEPING, (Object)false);
        this.setSleepingEntering(false);
        this.setSleepingExiting(true);
        this.sleepTransitionTicks = 42;
        this.animationHandler.triggerWakeUpAnimation();
        if (!this.method_37908().field_9236) {
            this.suppressSleep(20);
            this.releaseSleepLock();
        }
    }

    public void wakeUpImmediately() {
        this.field_6011.method_12778(DATA_SLEEPING, (Object)false);
        this.setSleepingEntering(false);
        this.setSleepingExiting(false);
        this.sleepTransitionTicks = 0;
        this.sleepCancelTicks = 2;
        if (!this.method_37908().field_9236) {
            this.suppressSleep(20);
            this.releaseSleepLock();
        }
    }

    public void suppressSleep(int ticks) {
        this.sleepReentryCooldownTicks = Math.max(this.sleepReentryCooldownTicks, ticks);
    }

    @Override
    public boolean isSleepSuppressed() {
        return this.sleepReentryCooldownTicks > 0;
    }

    @Override
    public DragonSleepCapable.SleepPreferences getSleepPreferences() {
        return new DragonSleepCapable.SleepPreferences(true, false, true, true, true);
    }

    @Override
    public boolean canSleepNow() {
        return !this.isBreathingFire() && !this.method_5782() && this.getActiveAbility() == null;
    }
}

