/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.dragons.cindervane.handlers;

import com.leon.saintsdragons.common.SaintsDragonsCommon;
import com.leon.saintsdragons.server.entity.dragons.cindervane.Cindervane;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class CindervaneInteractionHandler {
    private final Cindervane dragon;

    public CindervaneInteractionHandler(Cindervane dragon) {
        this.dragon = dragon;
    }

    public class_1269 handleInteraction(class_1657 player, class_1268 hand) {
        class_1799 heldItem = player.method_5998(hand);
        if (!this.dragon.method_6181()) {
            return this.handleUntamedInteraction(player, hand, heldItem);
        }
        return this.handleTamedInteraction(player, hand, heldItem);
    }

    private class_1269 handleUntamedInteraction(class_1657 player, class_1268 hand, class_1799 heldItem) {
        if (!this.dragon.method_6481(heldItem)) {
            return class_1269.field_5811;
        }
        if (!this.dragon.method_37908().field_9236) {
            if (!player.method_31549().field_7477) {
                heldItem.method_7934(1);
            }
            this.dragon.triggerAnim("actions", "eat");
            if (this.dragon.method_6051().method_43048(5) == 0) {
                this.dragon.method_6170(player);
                this.dragon.method_5942().method_6340();
                this.dragon.method_24346(true);
                this.dragon.setCommand(1);
                this.dragon.method_5980(null);
                this.dragon.method_37908().method_8421((class_1297)this.dragon, (byte)7);
                this.triggerTamingAdvancement(player);
            } else {
                this.dragon.method_37908().method_8421((class_1297)this.dragon, (byte)6);
            }
            return class_1269.method_29236((boolean)false);
        }
        return class_1269.field_5812;
    }

    private class_1269 handleTamedInteraction(class_1657 player, class_1268 hand, class_1799 heldItem) {
        boolean isOwner = this.dragon.method_6171((class_1309)player);
        if (isOwner) {
            if (this.dragon.method_6481(heldItem) && this.dragon.method_6032() < this.dragon.method_6063()) {
                return this.handleFeeding(player, heldItem);
            }
            if (this.dragon.canOwnerCommand(player) && heldItem.method_7960() && hand == class_1268.field_5808) {
                return this.handleCommandCycling(player);
            }
        }
        if (hand == class_1268.field_5808 && heldItem.method_7960() && !player.method_18276()) {
            return this.handleMounting(player, isOwner);
        }
        return class_1269.field_5811;
    }

    private class_1269 handleMounting(class_1657 player, boolean isOwner) {
        List passengers = this.dragon.method_5685();
        if (isOwner) {
            if (passengers.isEmpty() && this.dragon.canOwnerMount(player)) {
                if (!this.dragon.method_37908().field_9236) {
                    this.dragon.prepareForMounting();
                    player.method_5804((class_1297)this.dragon);
                }
                return class_1269.method_29236((boolean)this.dragon.method_37908().field_9236);
            }
            if (!passengers.isEmpty() && passengers.get(0) != player) {
                if (!this.dragon.method_37908().field_9236) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"entity.saintsdragons.cindervane.mount_occupied"), true);
                }
                return class_1269.field_5814;
            }
        } else {
            class_1657 firstPlayer;
            if (passengers.isEmpty()) {
                if (!this.dragon.method_37908().field_9236) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"entity.saintsdragons.cindervane.passenger_needs_owner"), true);
                }
                return class_1269.field_5814;
            }
            if (passengers.size() >= 2) {
                if (!this.dragon.method_37908().field_9236) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"entity.saintsdragons.cindervane.seats_full"), true);
                }
                return class_1269.field_5814;
            }
            Object e = passengers.get(0);
            if (e instanceof class_1657 && this.dragon.method_6171((class_1309)(firstPlayer = (class_1657)e))) {
                if (!this.dragon.method_37908().field_9236) {
                    player.method_5804((class_1297)this.dragon);
                }
                return class_1269.method_29236((boolean)this.dragon.method_37908().field_9236);
            }
            if (!this.dragon.method_37908().field_9236) {
                player.method_7353((class_2561)class_2561.method_43471((String)"entity.saintsdragons.cindervane.passenger_needs_owner"), true);
            }
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    private class_1269 handleFeeding(class_1657 player, class_1799 food) {
        if (!this.dragon.method_37908().field_9236) {
            if (!player.method_31549().field_7477) {
                food.method_7934(1);
            }
            this.dragon.triggerAnim("actions", "eat");
            float healAmount = 5.0f;
            float newHealth = Math.min(this.dragon.method_6032() + healAmount, this.dragon.method_6063());
            boolean fullyHealed = newHealth >= this.dragon.method_6063();
            this.dragon.method_6025(healAmount);
            this.dragon.method_37908().method_8421((class_1297)this.dragon, (byte)7);
            if (fullyHealed) {
                player.method_7353((class_2561)class_2561.method_43469((String)"entity.saintsdragons.cindervane.fed", (Object[])new Object[]{this.dragon.method_5477()}), true);
            } else {
                player.method_7353((class_2561)class_2561.method_43469((String)"entity.saintsdragons.cindervane.fed_partial", (Object[])new Object[]{this.dragon.method_5477()}), true);
            }
            return class_1269.field_21466;
        }
        return class_1269.method_29236((boolean)true);
    }

    private class_1269 handleCommandCycling(class_1657 player) {
        int currentCommand = this.dragon.getCommand();
        int nextCommand = (currentCommand + 1) % 3;
        this.dragon.setCommand(nextCommand);
        this.applyCommandState(nextCommand);
        if (!this.dragon.method_37908().field_9236) {
            player.method_7353((class_2561)class_2561.method_43469((String)("entity.saintsdragons.all.command_" + nextCommand), (Object[])new Object[]{this.dragon.method_5477()}), true);
        }
        return class_1269.field_5812;
    }

    private void applyCommandState(int command) {
        switch (command) {
            case 0: {
                this.dragon.method_24346(false);
                break;
            }
            case 1: {
                this.dragon.method_24346(true);
                break;
            }
            case 2: {
                this.dragon.method_24346(false);
            }
        }
    }

    private void triggerTamingAdvancement(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            class_161 advancement = serverPlayer.field_13995.method_3851().method_12896(SaintsDragonsCommon.rl("tame_cindervane"));
            if (advancement != null) {
                serverPlayer.method_14236().method_12878(advancement, "tame_cindervane");
            }
        }
    }
}

