/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.dragons.nulljaw;

import com.leon.saintsdragons.common.network.DragonRiderAction;
import com.leon.saintsdragons.common.registry.AbilityRegistry;
import com.leon.saintsdragons.common.registry.ModSounds;
import com.leon.saintsdragons.common.registry.nulljaw.NulljawAbilities;
import com.leon.saintsdragons.server.ai.goals.base.DragonOwnerHurtByTargetGoal;
import com.leon.saintsdragons.server.ai.goals.base.DragonOwnerHurtTargetGoal;
import com.leon.saintsdragons.server.ai.goals.nulljaw.NulljawCombatGoal;
import com.leon.saintsdragons.server.ai.goals.nulljaw.NulljawFindWaterGoal;
import com.leon.saintsdragons.server.ai.goals.nulljaw.NulljawFollowOwnerGoal;
import com.leon.saintsdragons.server.ai.goals.nulljaw.NulljawGroundWanderGoal;
import com.leon.saintsdragons.server.ai.goals.nulljaw.NulljawLeaveWaterGoal;
import com.leon.saintsdragons.server.ai.goals.nulljaw.NulljawRandomSwimGoal;
import com.leon.saintsdragons.server.ai.goals.nulljaw.NulljawRestGoal;
import com.leon.saintsdragons.server.ai.goals.nulljaw.NulljawSleepGoal;
import com.leon.saintsdragons.server.ai.navigation.DragonAmphibiousNavigation;
import com.leon.saintsdragons.server.ai.navigation.DragonPathNavigateGround;
import com.leon.saintsdragons.server.ai.navigation.DragonSwimMoveControl;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.base.RideableDragonBase;
import com.leon.saintsdragons.server.entity.base.RideableDragonData;
import com.leon.saintsdragons.server.entity.controller.nulljaw.NulljawRiderController;
import com.leon.saintsdragons.server.entity.dragons.nulljaw.handlers.NulljawAnimationHandler;
import com.leon.saintsdragons.server.entity.dragons.nulljaw.handlers.NulljawInteractionHandler;
import com.leon.saintsdragons.server.entity.dragons.nulljaw.handlers.NulljawSoundProfile;
import com.leon.saintsdragons.server.entity.handler.DragonSoundHandler;
import com.leon.saintsdragons.server.entity.interfaces.AquaticDragon;
import com.leon.saintsdragons.server.entity.interfaces.DragonSleepCapable;
import com.leon.saintsdragons.server.entity.interfaces.DragonSoundProfile;
import com.leon.saintsdragons.server.entity.interfaces.ShakesScreen;
import com.leon.saintsdragons.server.entity.interfaces.SoundHandledDragon;
import com.leon.saintsdragons.server.entity.sleep.DragonRestManager;
import com.leon.saintsdragons.server.entity.sleep.DragonRestState;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1333;
import net.minecraft.class_1335;
import net.minecraft.class_1342;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1399;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.keyframe.event.SoundKeyframeEvent;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Nulljaw
extends RideableDragonBase
implements AquaticDragon,
ShakesScreen,
SoundHandledDragon,
DragonSleepCapable {
    private static final Map<String, DragonEntity.VocalEntry> VOCAL_ENTRIES;
    private int ambientSoundTimer;
    private int nextAmbientSoundDelay;
    private static final int MIN_AMBIENT_DELAY = 200;
    private static final int MAX_AMBIENT_DELAY = 600;
    private static final class_2940<Integer> DATA_GROUND_MOVE_STATE;
    private static final class_2940<Float> DATA_RIDER_FORWARD;
    private static final class_2940<Float> DATA_RIDER_STRAFE;
    private static final class_2940<Boolean> DATA_ACCELERATING;
    private static final class_2940<Boolean> DATA_SWIMMING;
    private static final class_2940<Integer> DATA_SWIM_TURN;
    private static final class_2940<Integer> DATA_SWIM_PITCH;
    private static final class_2940<Boolean> DATA_PHASE_TWO;
    private static final class_2940<Boolean> DATA_RIDER_LOCKED;
    private static final class_2940<Float> DATA_SCREEN_SHAKE_AMOUNT;
    private static final class_2940<Integer> DATA_FLIGHT_MODE;
    private static final class_2940<Boolean> DATA_GOING_UP;
    private static final class_2940<Boolean> DATA_GOING_DOWN;
    private static final class_2940<Boolean> DATA_SLEEPING;
    private static final class_2940<Boolean> DATA_SLEEPING_ENTERING;
    private static final class_2940<Boolean> DATA_SLEEPING_EXITING;
    private final AnimatableInstanceCache animCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final DragonSoundHandler soundHandler = new DragonSoundHandler(this);
    private final NulljawAnimationHandler animationHandler = new NulljawAnimationHandler(this);
    private final NulljawInteractionHandler interactionHandler = new NulljawInteractionHandler(this);
    private final DragonRestManager restManager = new DragonRestManager((class_1309)this);
    private final NulljawRiderController riderController;
    private final class_1408 groundNavigation;
    private final DragonAmphibiousNavigation waterNavigation;
    private final class_1335 landMoveControl;
    private final DragonSwimMoveControl swimMoveControl;
    private final RiftDrakeLookController landLookControl;
    private int riderControlLockTicks = 0;
    private NulljawRandomSwimGoal waterSwimGoal;
    private NulljawGroundWanderGoal groundWanderGoal;
    private boolean swimming;
    private int swimTicks;
    private int ticksInWater;
    private int ticksOutOfWater;
    private float swimTurnSmoothedYaw;
    private int swimTurnState;
    private int swimPitchStateTicks;
    private float swimRollAngle = 0.0f;
    private float prevSwimRollAngle = 0.0f;
    private boolean useLeftClawNext = true;
    private static final float SHAKE_DECAY_PER_TICK = 0.02f;
    private float prevScreenShakeAmount = 0.0f;
    private float screenShakeAmount = 0.0f;
    private boolean isSittingDown = false;
    private boolean isStandingUp = false;
    private int sitTransitionTicks = 0;
    private int sleepTransitionTicks = 0;
    private int sleepAmbientCooldownTicks = 0;
    private int sleepReentryCooldownTicks = 0;
    private int sleepCancelTicks = 0;
    private boolean sleepLocked = false;
    private int sleepCommandSnapshot = -1;
    private boolean wasVehicleLastTick = false;
    private final Map<String, class_243> clientLocatorCache = new ConcurrentHashMap<String, class_243>();

    public Nulljaw(class_1299<? extends Nulljaw> type, class_1937 level) {
        super(type, level);
        this.method_5941(class_7.field_18, 0.0f);
        this.method_5941(class_7.field_4, 0.0f);
        this.method_49477(1.4f);
        this.groundNavigation = new DragonPathNavigateGround((class_1308)this, level);
        this.waterNavigation = new DragonAmphibiousNavigation((class_1308)this, level);
        this.landMoveControl = new RiftDrakeMoveControl(this);
        this.swimMoveControl = new DragonSwimMoveControl((class_1308)this, 6.0f, 0.08, 0.12);
        this.landLookControl = new RiftDrakeLookController(this);
        this.field_6189 = this.groundNavigation;
        this.field_6207 = this.landMoveControl;
        this.field_6206 = this.landLookControl;
        this.riderController = new NulljawRiderController(this);
        this.setRideable();
        class_5819 rng = this.method_6051();
        this.ambientSoundTimer = rng.method_43048(80);
        this.nextAmbientSoundDelay = 200 + rng.method_43048(400);
    }

    private void tickRiderControlLock() {
        if (this.riderControlLockTicks > 0) {
            --this.riderControlLockTicks;
            if (this.riderControlLockTicks <= 0) {
                this.field_6011.method_12778(DATA_RIDER_LOCKED, (Object)false);
            }
        }
    }

    @Override
    protected float getRiderLockYawBlend() {
        return this.isPhaseTwoActive() ? 0.25f : 0.18f;
    }

    @Override
    protected float getRiderLockPitchBlend() {
        return this.isPhaseTwoActive() ? 0.25f : 0.18f;
    }

    @Override
    public boolean areRiderControlsLocked() {
        return this.method_37908().field_9236 ? (Boolean)this.field_6011.method_12789(DATA_RIDER_LOCKED) : this.riderControlLockTicks > 0;
    }

    public void lockRiderControls(int ticks) {
        this.riderControlLockTicks = Math.max(this.riderControlLockTicks, Math.max(0, ticks));
        this.field_6011.method_12778(DATA_RIDER_LOCKED, (Object)true);
        this.setAccelerating(false);
        this.setLastRiderForward(0.0f);
        this.setLastRiderStrafe(0.0f);
        this.setGroundMoveStateFromRider(0);
        this.setGoingUp(false);
        this.setGoingDown(false);
        this.method_18799(class_243.field_1353);
        if (!this.method_37908().field_9236) {
            this.method_5942().method_6340();
            this.method_5980(null);
        }
    }

    @Override
    public void lockAbilities(int ticks) {
        this.combatManager.lockGlobalCooldown(ticks);
    }

    @Override
    protected boolean isRiderInputLocked(class_1657 player) {
        return this.areRiderControlsLocked();
    }

    @Override
    protected void applyRiderVerticalInput(class_1657 player, boolean goingUp, boolean goingDown, boolean locked) {
        if (locked) {
            this.setGoingUp(false);
            this.setGoingDown(false);
            return;
        }
        boolean inWater = this.method_5681() || this.method_5816();
        this.setGoingUp(inWater && goingUp);
        this.setGoingDown(inWater && goingDown);
    }

    @Override
    protected void applyRiderMovementInput(class_1657 player, float forward, float strafe, float yaw, boolean locked) {
        float fwd = locked ? 0.0f : this.applyInputDeadzone(forward);
        float str = locked ? 0.0f : this.applyInputDeadzone(strafe);
        this.setLastRiderForward(fwd);
        this.setLastRiderStrafe(str);
        int moveState = 0;
        float magnitude = Math.abs(fwd) + Math.abs(str);
        if (magnitude > 0.05f) {
            moveState = this.isAccelerating() ? 2 : 1;
        }
        this.setGroundMoveStateFromRider(moveState);
    }

    @Override
    protected void handleRiderAction(class_3222 player, DragonRiderAction action, String abilityName, boolean locked) {
        if (locked || action == null) {
            return;
        }
        switch (action) {
            case TAKEOFF_REQUEST: {
                this.handleJumpRequest();
                break;
            }
            case ACCELERATE: {
                this.setAccelerating(true);
                break;
            }
            case STOP_ACCELERATE: {
                this.setAccelerating(false);
                break;
            }
            case ABILITY_USE: {
                if (abilityName == null || abilityName.isEmpty()) break;
                this.useRidingAbility(abilityName);
                break;
            }
            case ABILITY_STOP: {
                if (abilityName == null || abilityName.isEmpty()) break;
                this.forceEndActiveAbility();
                break;
            }
            case TOGGLE_MELEE: {
                if (locked) break;
                this.toggleMeleeMode();
                break;
            }
        }
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1321.method_26827().method_26868(class_5134.field_23716, 250.0).method_26868(class_5134.field_23719, 0.28).method_26868(class_5134.field_23717, 40.0).method_26868(class_5134.field_23718, 0.5).method_26868(class_5134.field_23724, 8.0).method_26868(class_5134.field_23721, 10.0);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_SWIMMING, (Object)false);
        this.field_6011.method_12784(DATA_SWIM_TURN, (Object)0);
        this.field_6011.method_12784(DATA_SWIM_PITCH, (Object)0);
        this.field_6011.method_12784(DATA_PHASE_TWO, (Object)false);
        this.field_6011.method_12784(DATA_RIDER_LOCKED, (Object)false);
        this.field_6011.method_12784(DATA_SCREEN_SHAKE_AMOUNT, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(DATA_SLEEPING, (Object)false);
        this.field_6011.method_12784(DATA_SLEEPING_ENTERING, (Object)false);
        this.field_6011.method_12784(DATA_SLEEPING_EXITING, (Object)false);
    }

    @Override
    protected void defineRideableDragonData() {
        this.field_6011.method_12784(DATA_GROUND_MOVE_STATE, (Object)0);
        this.field_6011.method_12784(DATA_RIDER_FORWARD, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(DATA_RIDER_STRAFE, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(DATA_ACCELERATING, (Object)false);
        this.field_6011.method_12784(DATA_FLIGHT_MODE, (Object)-1);
        this.field_6011.method_12784(DATA_GOING_UP, (Object)false);
        this.field_6011.method_12784(DATA_GOING_DOWN, (Object)false);
    }

    @Override
    protected class_2940<Float> getRiderForwardAccessor() {
        return DATA_RIDER_FORWARD;
    }

    @Override
    protected class_2940<Float> getRiderStrafeAccessor() {
        return DATA_RIDER_STRAFE;
    }

    @Override
    protected class_2940<Integer> getGroundMoveStateAccessor() {
        return DATA_GROUND_MOVE_STATE;
    }

    @Override
    protected class_2940<Integer> getFlightModeAccessor() {
        return DATA_FLIGHT_MODE;
    }

    @Override
    protected class_2940<Boolean> getGoingUpAccessor() {
        return DATA_GOING_UP;
    }

    @Override
    protected class_2940<Boolean> getGoingDownAccessor() {
        return DATA_GOING_DOWN;
    }

    @Override
    protected class_2940<Boolean> getAcceleratingAccessor() {
        return DATA_ACCELERATING;
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1342((class_1314)this));
        this.field_6201.method_6277(1, (class_1352)new NulljawSleepGoal(this));
        this.field_6201.method_6277(2, (class_1352)new NulljawRestGoal(this));
        this.field_6201.method_6277(3, (class_1352)new NulljawCombatGoal(this));
        this.field_6201.method_6277(6, (class_1352)new NulljawLeaveWaterGoal(this));
        this.field_6201.method_6277(7, (class_1352)new NulljawFindWaterGoal(this));
        this.field_6201.method_6277(8, (class_1352)new NulljawFollowOwnerGoal(this));
        this.waterSwimGoal = new NulljawRandomSwimGoal(this, 1.2, 30);
        this.field_6201.method_6277(9, (class_1352)this.waterSwimGoal);
        this.groundWanderGoal = new NulljawGroundWanderGoal(this, 1.0, 100);
        this.field_6201.method_6277(10, (class_1352)this.groundWanderGoal);
        this.field_6201.method_6277(11, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(11, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6185.method_6277(1, (class_1352)new DragonOwnerHurtByTargetGoal(this));
        this.field_6185.method_6277(2, (class_1352)new DragonOwnerHurtTargetGoal(this));
        this.field_6185.method_6277(3, (class_1352)new class_1399((class_1314)this, new Class[0]));
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController movementController = new AnimationController((GeoAnimatable)this, "movement", 5, this.animationHandler::movementPredicate);
        AnimationController swimController = new AnimationController((GeoAnimatable)this, "swim_direction", 4, this.animationHandler::swimDirectionPredicate);
        AnimationController actions = new AnimationController((GeoAnimatable)this, "action", 10, this.animationHandler::actionPredicate);
        this.animationHandler.configureMovementBlend((AnimationController<Nulljaw>)movementController);
        this.animationHandler.configureSwimBlend((AnimationController<Nulljaw>)swimController);
        movementController.setSoundKeyframeHandler(this::onAnimationSound);
        swimController.setSoundKeyframeHandler(this::onAnimationSound);
        actions.setSoundKeyframeHandler(this::onAnimationSound);
        this.animationHandler.setupActionController((AnimationController<Nulljaw>)actions);
        controllers.add(new AnimationController[]{movementController});
        controllers.add(new AnimationController[]{swimController});
        controllers.add(new AnimationController[]{actions});
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animCache;
    }

    @Override
    public DragonSoundHandler getSoundHandler() {
        return this.soundHandler;
    }

    @Override
    public DragonSoundProfile getSoundProfile() {
        return NulljawSoundProfile.INSTANCE;
    }

    @Override
    public Map<String, DragonEntity.VocalEntry> getVocalEntries() {
        return VOCAL_ENTRIES;
    }

    @Override
    protected void method_5712(@NotNull class_2338 pos, @NotNull class_2680 state) {
    }

    private void playCustomAmbientSound() {
        class_5819 random = this.method_6051();
        if (this.isDying() || this.method_5968() != null || this.getActiveAbility() != null) {
            return;
        }
        String vocalKey = null;
        float moodRoll = random.method_43057();
        vocalKey = moodRoll < 0.4f ? "grumble1" : (moodRoll < 0.7f ? "grumble2" : "grumble3");
        if (vocalKey != null) {
            this.getSoundHandler().playVocal(vocalKey);
        }
    }

    private void handleAmbientSounds() {
        if (this.method_6109() || this.isDying() || this.method_24345() || this.method_6113() || this.isSleepTransitioning() || this.isInSitTransition() || this.sleepAmbientCooldownTicks > 0) {
            return;
        }
        ++this.ambientSoundTimer;
        if (this.ambientSoundTimer >= this.nextAmbientSoundDelay) {
            this.playCustomAmbientSound();
            this.resetAmbientSoundTimer();
        }
    }

    private void resetAmbientSoundTimer() {
        class_5819 random = this.method_6051();
        this.ambientSoundTimer = 0;
        this.nextAmbientSoundDelay = 200 + random.method_43048(400);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        this.soundHandler.tick();
        this.tickSittingState();
        this.tickMountedState();
        this.tickScreenShake();
        this.updateSittingProgress();
        this.tickSleepTransition();
        this.tickSleepCooldowns();
        if (!this.method_37908().field_9236) {
            this.handleAmbientSounds();
            this.tickRiderControlLock();
            boolean inWater = this.method_5799();
            if (inWater) {
                this.method_5855(this.method_5748());
                this.swimTicks = Math.min(this.swimTicks + 1, 200);
                this.ticksInWater = Math.min(this.ticksInWater + 1, 1200);
                this.ticksOutOfWater = 0;
            } else {
                this.swimTicks = Math.max(this.swimTicks - 1, 0);
                this.ticksOutOfWater = Math.min(this.ticksOutOfWater + 1, 1200);
                this.ticksInWater = 0;
            }
            if (inWater && !this.swimming) {
                this.enterSwimState();
            } else if (!inWater && this.swimming) {
                this.exitSwimState();
            }
            if (this.method_5642() != null && this.field_6206 != this.landLookControl) {
                this.field_6206 = this.landLookControl;
            }
            if ((this.method_6113() || this.isSleepingEntering() || this.isSleepingExiting()) && (this.method_5968() != null || this.method_6510() || this.method_5816())) {
                this.wakeUpImmediately();
                this.suppressSleep(200);
            }
            this.tickAnimationStates();
            this.updateSwimOrientationState();
        }
        this.tickClientSideUpdates();
    }

    @Override
    public void method_6091(@NotNull class_243 motion) {
        class_1309 class_13092;
        if (this.method_5782() && (class_13092 = this.method_5642()) instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            if (this.areRiderControlsLocked()) {
                this.method_18799(class_243.field_1353);
                return;
            }
            if (this.method_5942().method_6345() != null) {
                this.method_5942().method_6340();
            }
            if (this.method_5816()) {
                this.handleRiddenSwimming(motion);
            } else {
                this.setGoingUp(false);
                this.setGoingDown(false);
                super.method_6091(motion);
            }
        } else {
            super.method_6091(motion);
        }
    }

    @NotNull
    public class_1408 method_5942() {
        return this.swimming ? this.waterNavigation : this.groundNavigation;
    }

    @Override
    public class_1408 getAquaticNavigation() {
        return this.waterNavigation;
    }

    @Override
    public double getSwimSpeed() {
        double baseSpeed = 1.45;
        if (this.method_5782()) {
            baseSpeed += 0.2;
        }
        return baseSpeed;
    }

    @Override
    public void onEnterWater() {
        this.method_18799(this.method_18798());
        this.tickAnimationStates();
    }

    @Override
    public void onExitWater() {
        this.method_18799(this.method_18798().method_18805(1.0, 0.6, 1.0));
        this.tickAnimationStates();
    }

    @Override
    @NotNull
    public class_1269 method_5992(@NotNull class_1657 player, @NotNull class_1268 hand) {
        class_1269 handlerResult = this.interactionHandler.handleInteraction(player, hand);
        if (handlerResult != class_1269.field_5811) {
            return handlerResult;
        }
        return super.method_5992(player, hand);
    }

    public class_1269 superMobInteract(class_1657 player, class_1268 hand) {
        return super.method_5992(player, hand);
    }

    public boolean method_6481(@Nonnull class_1799 stack) {
        return stack.method_31574(class_1802.field_8429) || stack.method_31574(class_1802.field_8209) || stack.method_31574(class_1802.field_8846);
    }

    @Override
    public void setLastRiderForward(float forward) {
        this.field_6011.method_12778(DATA_RIDER_FORWARD, (Object)Float.valueOf(forward));
    }

    @Override
    public void setLastRiderStrafe(float strafe) {
        this.field_6011.method_12778(DATA_RIDER_STRAFE, (Object)Float.valueOf(strafe));
    }

    public float getLastRiderForward() {
        return ((Float)this.field_6011.method_12789(DATA_RIDER_FORWARD)).floatValue();
    }

    public float getLastRiderStrafe() {
        return ((Float)this.field_6011.method_12789(DATA_RIDER_STRAFE)).floatValue();
    }

    @Override
    public boolean isAccelerating() {
        return (Boolean)this.field_6011.method_12789(DATA_ACCELERATING);
    }

    @Override
    public void setAccelerating(boolean accelerating) {
        this.field_6011.method_12778(DATA_ACCELERATING, (Object)accelerating);
    }

    public void setGroundMoveStateFromRider(int state) {
        int s = class_3532.method_15340((int)state, (int)0, (int)2);
        if ((Integer)this.field_6011.method_12789(DATA_GROUND_MOVE_STATE) != s) {
            this.field_6011.method_12778(DATA_GROUND_MOVE_STATE, (Object)s);
        }
        this.syncAnimState(s, this.getSyncedFlightMode());
    }

    public void setGroundMoveStateFromAI(int state) {
        if (!this.method_37908().field_9236) {
            int s = class_3532.method_15340((int)state, (int)0, (int)2);
            if ((Integer)this.field_6011.method_12789(DATA_GROUND_MOVE_STATE) != s) {
                this.field_6011.method_12778(DATA_GROUND_MOVE_STATE, (Object)s);
                this.syncAnimState(s, this.getSyncedFlightMode());
            }
        }
    }

    @Override
    public boolean isRunning() {
        return false;
    }

    @Override
    public void setRunning(boolean running) {
    }

    @Override
    public boolean isDragonFlying() {
        return false;
    }

    @Override
    public boolean isHovering() {
        return false;
    }

    @Override
    public boolean isTakeoff() {
        return false;
    }

    @Override
    public boolean isLanding() {
        return false;
    }

    @Override
    public int getFlightMode() {
        return -1;
    }

    public void handleJumpRequest() {
        if (this.areRiderControlsLocked()) {
            return;
        }
        if (this.method_5799()) {
            class_243 jump = new class_243(0.0, 0.6, 0.0);
            this.method_18799(this.method_18798().method_1019(jump));
            this.field_6007 = true;
        } else if (this.method_24828()) {
            class_243 movement = this.method_18798();
            this.method_18800(movement.field_1352, 0.42, movement.field_1350);
            this.field_6007 = true;
        }
    }

    @Override
    @NotNull
    public class_243 method_49482(@NotNull class_1657 player, @NotNull class_243 deltaIn) {
        if (this.areRiderControlsLocked()) {
            return class_243.field_1353;
        }
        class_243 input = this.riderController.getRiddenInput(player, deltaIn);
        if (!this.method_37908().field_9236) {
            float fwd = (float)class_3532.method_15350((double)input.field_1350, (double)-1.0, (double)1.0);
            float str = (float)class_3532.method_15350((double)input.field_1352, (double)-1.0, (double)1.0);
            this.setLastRiderForward(RideableDragonData.applyInputThreshold(fwd));
            this.setLastRiderStrafe(RideableDragonData.applyInputThreshold(str));
        }
        return input;
    }

    protected float method_49485(@Nonnull @NotNull class_1657 rider) {
        if (this.areRiderControlsLocked()) {
            return 0.0f;
        }
        return this.riderController.getRiddenSpeed(rider);
    }

    protected void method_49481(@NotNull class_1657 player, @NotNull class_243 travelVector) {
        super.method_49481(player, travelVector);
        if (this.areRiderControlsLocked()) {
            player.field_6017 = 0.0f;
            this.field_6017 = 0.0f;
            this.method_5980(null);
            this.copyRiderLook(player);
            this.setAccelerating(false);
            this.setGoingUp(false);
            this.setGoingDown(false);
            this.method_18799(class_243.field_1353);
            return;
        }
        this.riderController.tickRidden(player, travelVector);
    }

    @Override
    public void method_5793(@NotNull class_1297 passenger) {
        super.method_5793(passenger);
        if (!this.method_37908().field_9236) {
            this.setAccelerating(false);
            this.setLastRiderForward(0.0f);
            this.setLastRiderStrafe(0.0f);
            this.setGroundMoveStateFromRider(0);
        }
    }

    public void method_6043() {
        super.method_6043();
        this.setGroundMoveStateFromRider(1);
    }

    public void initializeRiderState() {
        if (!this.method_37908().field_9236) {
            this.field_6011.method_12778(DATA_GROUND_MOVE_STATE, (Object)0);
            this.field_6011.method_12778(DATA_RIDER_FORWARD, (Object)Float.valueOf(0.0f));
            this.field_6011.method_12778(DATA_RIDER_STRAFE, (Object)Float.valueOf(0.0f));
            this.setAccelerating(false);
        }
    }

    @Override
    public class_243 getHeadPosition() {
        return this.method_33571();
    }

    @Override
    public class_243 getMouthPosition() {
        return this.method_19538().method_1031(0.0, (double)this.method_17682() * 0.8, 0.0);
    }

    public void useRidingAbility(String abilityName) {
        class_1657 player;
        if (abilityName == null || abilityName.isEmpty()) {
            return;
        }
        if (this.areRiderControlsLocked()) {
            return;
        }
        class_1309 rider = this.method_5642();
        if (!(rider instanceof class_1309)) {
            return;
        }
        if (this.method_6181() && rider instanceof class_1657 && !this.method_6171((class_1309)(player = (class_1657)rider))) {
            return;
        }
        DragonAbilityType<?, ?> type = AbilityRegistry.get(abilityName);
        if (type != null) {
            this.combatManager.tryUseAbility(type);
        } else {
            System.out.println("[Nulljaw Debug] Ability '" + abilityName + "' not found in registry!");
        }
    }

    public void forceEndActiveAbility() {
        this.combatManager.forceEndActiveAbility();
    }

    public double method_5621() {
        return this.riderController.getPassengersRidingOffset();
    }

    protected void method_5865(@Nonnull @NotNull class_1297 passenger, @Nonnull @NotNull class_1297.class_4738 moveFunction) {
        this.riderController.positionRider(passenger, moveFunction);
    }

    @Nullable
    public class_1309 method_5642() {
        return this.riderController.getControllingPassenger();
    }

    @NotNull
    public class_243 method_24829(@NotNull class_1309 passenger) {
        return this.riderController.getDismountLocationForPassenger(passenger);
    }

    public class_1296 method_5613(@Nonnull class_3218 level, @Nonnull class_1296 other) {
        return null;
    }

    @Override
    public DragonAbilityType<?, ?> getPrimaryAttackAbility() {
        boolean useHornGore;
        boolean bl = useHornGore = this.getMeleeMode() == 1;
        if (this.isPhaseTwoActive()) {
            return useHornGore ? NulljawAbilities.NULLJAW_HORN_GORE : NulljawAbilities.NULLJAW_BITE2;
        }
        return useHornGore ? NulljawAbilities.NULLJAW_HORN_GORE : NulljawAbilities.NULLJAW_BITE;
    }

    public boolean isAbilityActive(DragonAbilityType<?, ?> abilityType) {
        return this.combatManager.isAbilityActive(abilityType);
    }

    public void forceEndAbility(DragonAbilityType<?, ?> abilityType) {
        this.combatManager.forceEndAbility(abilityType);
    }

    public static boolean canSpawnHere(class_1299<? extends Nulljaw> type, class_1936 level, class_3730 spawnType, class_2338 pos, class_5819 random) {
        boolean fluidHere;
        if (!class_1429.method_20663(type, (class_1936)level, (class_3730)spawnType, (class_2338)pos, (class_5819)random)) {
            return false;
        }
        boolean bl = fluidHere = !level.method_8316(pos).method_15769();
        if (!fluidHere) {
            class_2338 below = pos.method_10074();
            boolean solidGround = level.method_8320(below).method_26206((class_1922)level, below, class_2350.field_11036);
            boolean feetFree = level.method_8320(pos).method_26220((class_1922)level, pos).method_1110();
            boolean headFree = level.method_8320(pos.method_10084()).method_26220((class_1922)level, pos.method_10084()).method_1110();
            return solidGround && feetFree && headFree;
        }
        class_3610 feet = level.method_8316(pos);
        class_3610 head = level.method_8316(pos.method_10084());
        boolean feetWater = !feet.method_15769() && feet.method_15771();
        boolean headWater = !head.method_15769();
        return feetWater && headWater;
    }

    private void enterSwimState() {
        this.swimming = true;
        this.field_6189 = this.waterNavigation;
        this.field_6207 = this.swimMoveControl;
        this.field_6011.method_12778(DATA_SWIMMING, (Object)true);
        if (this.waterSwimGoal != null) {
            this.waterSwimGoal.forceTrigger();
        }
    }

    private void exitSwimState() {
        this.swimming = false;
        this.field_6189 = this.groundNavigation;
        this.field_6207 = this.landMoveControl;
        this.field_6206 = this.landLookControl;
        this.waterNavigation.method_6340();
        class_243 delta = this.method_18798();
        this.method_18799(new class_243(delta.field_1352, 0.0, delta.field_1350));
        if (this.groundWanderGoal != null) {
            this.groundWanderGoal.forceTrigger();
        }
        this.field_6011.method_12778(DATA_SWIMMING, (Object)false);
        this.field_6011.method_12778(DATA_SWIM_TURN, (Object)0);
        this.field_6011.method_12778(DATA_SWIM_PITCH, (Object)0);
        this.swimTurnSmoothedYaw = 0.0f;
        this.swimTurnState = 0;
        this.swimPitchStateTicks = 0;
        this.swimRollAngle = 0.0f;
        this.prevSwimRollAngle = 0.0f;
    }

    private void updateSwimOrientationState() {
        class_1657 player;
        class_1309 class_13092;
        boolean riderControlled;
        if (this.method_37908().field_9236) {
            return;
        }
        int desiredTurn = (Integer)this.field_6011.method_12789(DATA_SWIM_TURN);
        int desiredPitchState = (Integer)this.field_6011.method_12789(DATA_SWIM_PITCH);
        boolean bl = riderControlled = this.method_6181() && this.method_5782() && (class_13092 = this.method_5642()) instanceof class_1657 && this.method_6171((class_1309)(player = (class_1657)class_13092)) && this.method_5816();
        if (riderControlled) {
            float yawDelta = class_3532.method_15393((float)(this.method_36454() - this.field_5982));
            this.swimTurnSmoothedYaw = this.swimTurnSmoothedYaw * 0.6f + yawDelta * 0.4f;
            float enter = 0.35f;
            float exit = 0.12f;
            int targetState = this.swimTurnState;
            if (this.swimTurnSmoothedYaw > enter) {
                targetState = -1;
            } else if (this.swimTurnSmoothedYaw < -enter) {
                targetState = 1;
            } else if (Math.abs(this.swimTurnSmoothedYaw) < exit) {
                targetState = 0;
            }
            desiredTurn = this.swimTurnState = targetState;
            if (this.isGoingUp()) {
                desiredPitchState = -1;
                this.swimPitchStateTicks = 6;
            } else if (this.isGoingDown()) {
                desiredPitchState = 1;
                this.swimPitchStateTicks = 6;
            } else if (desiredPitchState != 0) {
                if (this.swimPitchStateTicks > 0) {
                    --this.swimPitchStateTicks;
                } else {
                    desiredPitchState = 0;
                }
            }
        } else {
            this.swimTurnSmoothedYaw *= 0.5f;
            if (Math.abs(this.swimTurnSmoothedYaw) < 0.05f) {
                this.swimTurnState = 0;
            }
            desiredTurn = this.swimTurnState;
            if (desiredPitchState != 0) {
                if (++this.swimPitchStateTicks > 4) {
                    desiredPitchState = 0;
                    this.swimPitchStateTicks = 0;
                }
            } else {
                this.swimPitchStateTicks = 0;
            }
        }
        if ((Integer)this.field_6011.method_12789(DATA_SWIM_TURN) != desiredTurn) {
            this.field_6011.method_12778(DATA_SWIM_TURN, (Object)desiredTurn);
        }
        if ((Integer)this.field_6011.method_12789(DATA_SWIM_PITCH) != desiredPitchState) {
            this.field_6011.method_12778(DATA_SWIM_PITCH, (Object)desiredPitchState);
        }
        this.prevSwimRollAngle = this.swimRollAngle;
        if (!this.method_5681() || this.areRiderControlsLocked()) {
            this.swimRollAngle = 0.0f;
            this.prevSwimRollAngle = 0.0f;
            return;
        }
        float targetAngle = class_3532.method_15363((float)(this.swimTurnSmoothedYaw * 40.0f), (float)-60.0f, (float)60.0f);
        this.swimRollAngle = class_3532.method_16439((float)0.25f, (float)this.swimRollAngle, (float)targetAngle);
        if (Math.abs(this.swimRollAngle) < 0.01f) {
            this.swimRollAngle = 0.0f;
        }
    }

    public boolean method_5681() {
        if (this.method_37908().field_9236) {
            return (Boolean)this.field_6011.method_12789(DATA_SWIMMING);
        }
        return this.swimming;
    }

    public int getSwimTurnDirection() {
        return class_3532.method_15340((int)((Integer)this.field_6011.method_12789(DATA_SWIM_TURN)), (int)-1, (int)1);
    }

    public boolean isSwimmingDown() {
        return this.method_5681() && (Integer)this.field_6011.method_12789(DATA_SWIM_PITCH) > 0;
    }

    public boolean isSwimmingUp() {
        return this.method_5681() && (Integer)this.field_6011.method_12789(DATA_SWIM_PITCH) < 0;
    }

    public boolean isSwimmingMoving() {
        if (!this.method_5681()) {
            return false;
        }
        if (this.method_5942().method_23966() && this.method_5942().method_6345() != null) {
            return true;
        }
        if (this.method_5782()) {
            float fwd = Math.abs(((Float)this.field_6011.method_12789(DATA_RIDER_FORWARD)).floatValue());
            float str = Math.abs(((Float)this.field_6011.method_12789(DATA_RIDER_STRAFE)).floatValue());
            if (fwd > 0.03f || str > 0.03f) {
                return true;
            }
        }
        return this.method_18798().method_37268() > 0.0025;
    }

    public float getSwimRollAngleDegrees() {
        return this.swimRollAngle;
    }

    public float getSwimRollAngleDegrees(float partialTick) {
        return class_3532.method_16439((float)partialTick, (float)this.prevSwimRollAngle, (float)this.swimRollAngle);
    }

    public boolean isPhaseTwoActive() {
        return (Boolean)this.field_6011.method_12789(DATA_PHASE_TWO);
    }

    public void setPhaseTwoActive(boolean active, boolean syncAnim) {
        this.field_6011.method_12778(DATA_PHASE_TWO, (Object)active);
        if (syncAnim) {
            this.syncAnimState((Integer)this.field_6011.method_12789(DATA_GROUND_MOVE_STATE), this.getSyncedFlightMode());
        }
    }

    public boolean shouldUseLeftClaw() {
        return this.useLeftClawNext;
    }

    public void toggleClawSide() {
        this.useLeftClawNext = !this.useLeftClawNext;
    }

    @Override
    public RideableDragonBase.RiderAbilityBinding getAttackRiderAbility() {
        if (this.getMeleeMode() == 1) {
            return new RideableDragonBase.RiderAbilityBinding("nulljaw_horn_gore", RideableDragonBase.RiderAbilityBinding.Activation.PRESS);
        }
        try {
            if (this.isPhaseTwoActive()) {
                return new RideableDragonBase.RiderAbilityBinding("nulljaw_bite2", RideableDragonBase.RiderAbilityBinding.Activation.PRESS);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new RideableDragonBase.RiderAbilityBinding("nulljaw_bite", RideableDragonBase.RiderAbilityBinding.Activation.PRESS);
    }

    @Override
    public RideableDragonBase.RiderAbilityBinding getPrimaryRiderAbility() {
        return new RideableDragonBase.RiderAbilityBinding("nulljaw_roar", RideableDragonBase.RiderAbilityBinding.Activation.PRESS);
    }

    @Override
    public RideableDragonBase.RiderAbilityBinding getSecondaryRiderAbility() {
        return new RideableDragonBase.RiderAbilityBinding("nulljaw_phase_shift", RideableDragonBase.RiderAbilityBinding.Activation.PRESS);
    }

    @Override
    public RideableDragonBase.RiderAbilityBinding getTertiaryRiderAbility() {
        if (this.isPhaseTwoActive()) {
            return new RideableDragonBase.RiderAbilityBinding("nulljaw_claw", RideableDragonBase.RiderAbilityBinding.Activation.PRESS);
        }
        return null;
    }

    @Override
    public DragonAbilityType<?, ?> getChannelingAbility() {
        return NulljawAbilities.NULLJAW_PHASE_SHIFT;
    }

    public void onAnimationSound(SoundKeyframeEvent<Nulljaw> event) {
        this.getSoundHandler().handleAnimationSound(this, event.getKeyframeData(), event.getController());
    }

    private void handleRiddenSwimming(class_243 input) {
        class_243 velocity = this.method_18798();
        double swimSpeed = this.getSwimSpeed();
        if (this.isAccelerating()) {
            swimSpeed *= 1.6;
        }
        class_243 desired = this.getVec3(input, swimSpeed, velocity);
        class_243 blended = velocity.method_1019(desired.method_1020(velocity).method_1021(0.28));
        double dragFactor = this.method_5787() ? 0.92 : 0.94;
        blended = blended.method_18805(dragFactor, 0.96, dragFactor);
        if (!this.isGoingUp() && !this.isGoingDown() && this.method_5642() != null) {
            blended = blended.method_18805(1.0, 0.0, 1.0);
        } else if (!this.isGoingUp() && !this.isGoingDown() && this.method_5968() == null) {
            blended = blended.method_1031(0.0, -0.01, 0.0);
        }
        this.method_18799(blended);
        this.method_5784(class_1313.field_6308, this.method_18798());
    }

    @NotNull
    private class_243 getVec3(class_243 wishDir, double swimSpeed, class_243 velocity) {
        double strafe = wishDir.field_1352;
        double forward = wishDir.field_1350;
        float yawRad = this.method_36454() * ((float)Math.PI / 180);
        double sin = Math.sin(yawRad);
        double cos = Math.cos(yawRad);
        double worldX = strafe * cos - forward * sin;
        double worldZ = forward * cos + strafe * sin;
        double dx = worldX * 0.85 * swimSpeed;
        double dz = worldZ * 0.85 * swimSpeed;
        double dy = velocity.field_1351;
        dy = this.isGoingUp() ? Math.min(swimSpeed, dy + 0.12 * swimSpeed) : (this.isGoingDown() ? Math.max(-swimSpeed, dy - 0.12 * swimSpeed) : (dy *= 0.9));
        class_243 desired = new class_243(dx, dy, dz);
        return desired;
    }

    @Override
    public boolean isDying() {
        return this.method_6032() < this.method_6063() * 0.1f;
    }

    @Override
    public boolean isGoingUp() {
        return (Boolean)this.field_6011.method_12789(DATA_GOING_UP);
    }

    @Override
    public void setGoingUp(boolean goingUp) {
        this.field_6011.method_12778(DATA_GOING_UP, (Object)goingUp);
    }

    @Override
    public boolean isGoingDown() {
        return (Boolean)this.field_6011.method_12789(DATA_GOING_DOWN);
    }

    @Override
    public void setGoingDown(boolean goingDown) {
        this.field_6011.method_12778(DATA_GOING_DOWN, (Object)goingDown);
    }

    private void tickSittingState() {
        if (!this.method_37908().field_9236 && this.method_5782() && this.method_24345()) {
            this.method_24346(false);
        }
    }

    private void tickMountedState() {
        boolean mounted = this.method_5782();
        if (mounted && !this.wasVehicleLastTick) {
            this.sitProgress = 0.0f;
            this.prevSitProgress = 0.0f;
            this.field_6011.method_12778(DATA_SIT_PROGRESS, (Object)Float.valueOf(0.0f));
            this.isSittingDown = false;
            this.isStandingUp = false;
            this.sitTransitionTicks = 0;
            if (this.method_24345()) {
                this.method_24346(false);
                if (this.getCommand() == 1) {
                    this.setCommand(0);
                }
            }
            if (this.method_6113() || this.isSleepingEntering() || this.isSleepingExiting()) {
                this.wakeUpImmediately();
                this.suppressSleep(300);
            }
        }
        if (!mounted && this.wasVehicleLastTick) {
            this.sitProgress = 0.0f;
            this.prevSitProgress = 0.0f;
            this.field_6011.method_12778(DATA_SIT_PROGRESS, (Object)Float.valueOf(0.0f));
            this.isSittingDown = false;
            this.isStandingUp = false;
            this.sitTransitionTicks = 0;
        }
        this.wasVehicleLastTick = mounted;
    }

    private void updateSittingProgress() {
        if (this.method_37908().field_9236) {
            return;
        }
        if (this.sitTransitionTicks > 0) {
            --this.sitTransitionTicks;
            if (this.sitTransitionTicks == 0) {
                this.isSittingDown = false;
                this.isStandingUp = false;
            }
        }
        if (this.method_24345()) {
            if ((this.sitProgress == 0.0f || this.isStandingUp) && !this.isSittingDown) {
                this.animationHandler.triggerSitDownAnimation();
                this.isSittingDown = true;
                this.isStandingUp = false;
                this.sitTransitionTicks = this.getSitDownAnimationTicks();
            }
            if (this.sitProgress < this.maxSitTicks()) {
                this.sitProgress += 1.0f;
                this.field_6011.method_12778(DATA_SIT_PROGRESS, (Object)Float.valueOf(this.sitProgress));
            }
        } else if (this.method_5782()) {
            if (this.sitProgress != 0.0f) {
                this.sitProgress = 0.0f;
                this.prevSitProgress = 0.0f;
                this.field_6011.method_12778(DATA_SIT_PROGRESS, (Object)Float.valueOf(0.0f));
                this.isSittingDown = false;
                this.isStandingUp = false;
                this.sitTransitionTicks = 0;
            }
        } else if (this.sitProgress > 0.0f) {
            if ((this.sitProgress >= this.maxSitTicks() || this.isSittingDown) && !this.isStandingUp) {
                this.animationHandler.triggerSitUpAnimation();
                this.isStandingUp = true;
                this.isSittingDown = false;
                this.sitTransitionTicks = this.getSitUpAnimationTicks();
            }
            float decrementRate = this.maxSitTicks() / (float)this.getSitUpAnimationTicks();
            this.sitProgress -= decrementRate;
            if (this.sitProgress < 0.0f) {
                this.sitProgress = 0.0f;
            }
            this.field_6011.method_12778(DATA_SIT_PROGRESS, (Object)Float.valueOf(this.sitProgress));
        }
    }

    private void tickClientSideUpdates() {
        if (this.method_37908().field_9236) {
            this.prevSitProgress = this.sitProgress;
            this.sitProgress = ((Float)this.field_6011.method_12789(DATA_SIT_PROGRESS)).floatValue();
        }
    }

    private void tickSleepTransition() {
        if (this.isSleepingEntering() && !this.method_37908().field_9236 && this.getSitProgress() >= this.maxSitTicks() && this.sleepTransitionTicks == this.getFallAsleepAnimationTicks()) {
            this.animationHandler.triggerFallAsleepAnimation();
        }
        if (this.sleepTransitionTicks > 0) {
            --this.sleepTransitionTicks;
            if (this.sleepTransitionTicks == 3 && this.isSleepingEntering() && !this.method_37908().field_9236) {
                this.animationHandler.triggerSleepAnimation();
            }
            if (this.sleepTransitionTicks == 0) {
                if (this.isSleepingEntering()) {
                    this.setSleeping(true);
                    this.setSleepingEntering(false);
                } else if (this.isSleepingExiting()) {
                    this.setSleepingExiting(false);
                    this.sleepAmbientCooldownTicks = Math.max(this.sleepAmbientCooldownTicks, 10);
                }
            }
        }
    }

    private void tickSleepCooldowns() {
        if (this.sleepAmbientCooldownTicks > 0) {
            --this.sleepAmbientCooldownTicks;
        }
        if (this.sleepReentryCooldownTicks > 0) {
            --this.sleepReentryCooldownTicks;
        }
        if (this.sleepCancelTicks > 0) {
            --this.sleepCancelTicks;
        }
    }

    public boolean isInSitTransition() {
        return this.isSittingDown || this.isStandingUp;
    }

    public boolean isSittingDownAnimation() {
        return this.isSittingDown;
    }

    public boolean isStandingUpAnimation() {
        return this.isStandingUp;
    }

    @Override
    public float maxSitTicks() {
        return 33.0f;
    }

    public int getSitDownAnimationTicks() {
        return 33;
    }

    public int getSitUpAnimationTicks() {
        return 40;
    }

    public int getFallAsleepAnimationTicks() {
        return 50;
    }

    public int getWakeUpAnimationTicks() {
        return 40;
    }

    public DragonRestManager getRestManager() {
        return this.restManager;
    }

    @Override
    public boolean method_6113() {
        return (Boolean)this.field_6011.method_12789(DATA_SLEEPING);
    }

    public void setSleeping(boolean sleeping) {
        this.field_6011.method_12778(DATA_SLEEPING, (Object)sleeping);
    }

    @Override
    public boolean isSleepTransitioning() {
        return this.isSleepingEntering() || this.isSleepingExiting();
    }

    public boolean isSleepingEntering() {
        return (Boolean)this.field_6011.method_12789(DATA_SLEEPING_ENTERING);
    }

    public void setSleepingEntering(boolean entering) {
        this.field_6011.method_12778(DATA_SLEEPING_ENTERING, (Object)entering);
    }

    public boolean isSleepingExiting() {
        return (Boolean)this.field_6011.method_12789(DATA_SLEEPING_EXITING);
    }

    public void setSleepingExiting(boolean exiting) {
        this.field_6011.method_12778(DATA_SLEEPING_EXITING, (Object)exiting);
    }

    public boolean isSleepLocked() {
        return this.sleepLocked || this.method_6113() || this.isSleepingEntering() || this.isSleepingExiting();
    }

    private void enterSleepLock() {
        if (this.method_37908().field_9236) {
            return;
        }
        if (!this.sleepLocked) {
            this.sleepLocked = true;
            this.sleepCommandSnapshot = this.getCommand();
        }
        this.method_24346(true);
        this.method_5942().method_6340();
        this.method_5980(null);
        this.method_18799(class_243.field_1353);
        if (this.getCommand() != 1) {
            this.setCommand(1);
        }
    }

    private void releaseSleepLock() {
        if (this.method_37908().field_9236) {
            return;
        }
        if (this.sleepLocked) {
            int desired = this.sleepCommandSnapshot;
            this.sleepCommandSnapshot = -1;
            this.sleepLocked = false;
            if (desired >= 0 && desired != this.getCommand()) {
                this.setCommand(desired);
                this.method_24346(desired == 1);
            }
        }
    }

    @Override
    public void startSleepEnter() {
        if (this.method_6113() || this.isSleepingEntering() || this.isSleepingExiting()) {
            return;
        }
        this.setSleepingEntering(true);
        this.sleepTransitionTicks = this.getFallAsleepAnimationTicks();
        if (!this.method_37908().field_9236) {
            this.enterSleepLock();
        }
    }

    @Override
    public void startSleepExit() {
        if (!this.method_6113() && !this.isSleepingEntering() || this.isSleepingExiting()) {
            return;
        }
        this.field_6011.method_12778(DATA_SLEEPING, (Object)false);
        this.setSleepingEntering(false);
        this.setSleepingExiting(true);
        this.sleepTransitionTicks = this.getWakeUpAnimationTicks();
        this.animationHandler.triggerWakeUpAnimation();
        if (!this.method_37908().field_9236) {
            this.suppressSleep(40);
            this.releaseSleepLock();
        }
    }

    public void wakeUpImmediately() {
        this.sleepAmbientCooldownTicks = Math.max(this.sleepAmbientCooldownTicks, 10);
        this.field_6011.method_12778(DATA_SLEEPING, (Object)false);
        this.setSleepingEntering(false);
        this.setSleepingExiting(false);
        this.sleepTransitionTicks = 0;
        this.sleepCancelTicks = 2;
        if (!this.method_37908().field_9236) {
            this.suppressSleep(40);
            this.releaseSleepLock();
        }
    }

    public void suppressSleep(int ticks) {
        this.sleepReentryCooldownTicks = Math.max(this.sleepReentryCooldownTicks, ticks);
    }

    @Override
    public boolean isSleepSuppressed() {
        return this.sleepReentryCooldownTicks > 0;
    }

    @Override
    public DragonSleepCapable.SleepPreferences getSleepPreferences() {
        return new DragonSleepCapable.SleepPreferences(true, false, false, true, true);
    }

    @Override
    public boolean canSleepNow() {
        return !this.method_5782() && !this.method_5816() && this.getActiveAbility() == null && !this.isPhaseTwoActive();
    }

    private void tickScreenShake() {
        if (this.method_37908().field_9236) {
            this.prevScreenShakeAmount = this.screenShakeAmount;
            this.screenShakeAmount = ((Float)this.field_6011.method_12789(DATA_SCREEN_SHAKE_AMOUNT)).floatValue();
            return;
        }
        this.prevScreenShakeAmount = this.screenShakeAmount;
        if (this.screenShakeAmount > 0.0f) {
            float newAmount;
            this.screenShakeAmount = newAmount = Math.max(0.0f, this.screenShakeAmount - 0.02f);
            this.field_6011.method_12778(DATA_SCREEN_SHAKE_AMOUNT, (Object)Float.valueOf(newAmount));
        } else if (((Float)this.field_6011.method_12789(DATA_SCREEN_SHAKE_AMOUNT)).floatValue() != 0.0f) {
            this.field_6011.method_12778(DATA_SCREEN_SHAKE_AMOUNT, (Object)Float.valueOf(0.0f));
        }
    }

    @Override
    public void method_5652(@NotNull class_2487 tag) {
        super.method_5652(tag);
        this.saveRideableData(tag);
        tag.method_10556("PhaseTwo", this.isPhaseTwoActive());
        tag.method_10556("Sleeping", this.method_6113());
        tag.method_10556("SleepingEntering", this.isSleepingEntering());
        tag.method_10556("SleepingExiting", this.isSleepingExiting());
        tag.method_10556("SleepLocked", this.sleepLocked);
        tag.method_10569("SleepTransitionTicks", this.sleepTransitionTicks);
        tag.method_10569("SleepAmbientCooldown", this.sleepAmbientCooldownTicks);
        tag.method_10569("SleepReentryCooldown", this.sleepReentryCooldownTicks);
        this.restManager.save(tag);
        tag.method_10569("SleepCancelTicks", this.sleepCancelTicks);
        tag.method_10569("SleepCommandSnapshot", this.sleepCommandSnapshot);
    }

    @Override
    public void method_5749(@NotNull class_2487 tag) {
        super.method_5749(tag);
        this.loadRideableData(tag);
        this.setSleeping(tag.method_10577("Sleeping"));
        this.setSleepingEntering(tag.method_10577("SleepingEntering"));
        this.setSleepingExiting(tag.method_10577("SleepingExiting"));
        this.sleepLocked = tag.method_10577("SleepLocked");
        this.sleepTransitionTicks = tag.method_10550("SleepTransitionTicks");
        this.sleepAmbientCooldownTicks = tag.method_10550("SleepAmbientCooldown");
        this.sleepReentryCooldownTicks = tag.method_10550("SleepReentryCooldown");
        this.restManager.load(tag);
        if (!this.method_37908().field_9236) {
            DragonRestState restState = this.restManager.getCurrentState();
            switch (restState) {
                case SITTING_DOWN: 
                case SITTING: 
                case SITTING_AFTER: {
                    this.method_24346(true);
                    break;
                }
                case FALLING_ASLEEP: {
                    this.method_24346(true);
                    break;
                }
                case SLEEPING: {
                    this.method_24346(true);
                    this.animationHandler.triggerSleepAnimation();
                    break;
                }
                case WAKING_UP: {
                    this.method_24346(true);
                }
            }
        }
        this.sleepCancelTicks = tag.method_10550("SleepCancelTicks");
        int n = this.sleepCommandSnapshot = tag.method_10545("SleepCommandSnapshot") ? tag.method_10550("SleepCommandSnapshot") : -1;
        if (this.sleepLocked) {
            this.method_24346(true);
        }
        if (tag.method_10545("PhaseTwo")) {
            this.setPhaseTwoActive(tag.method_10577("PhaseTwo"), false);
        }
    }

    public void method_5711(byte eventId) {
        if (eventId == 6) {
            if (this.method_37908().field_9236) {
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.field_5974.method_43059() * 0.02;
                    double d1 = this.field_5974.method_43059() * 0.02;
                    double d2 = this.field_5974.method_43059() * 0.02;
                    this.method_37908().method_8406((class_2394)class_2398.field_11251, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d0, d1, d2);
                }
            }
        } else if (eventId == 7) {
            if (this.method_37908().field_9236) {
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.field_5974.method_43059() * 0.02;
                    double d1 = this.field_5974.method_43059() * 0.02;
                    double d2 = this.field_5974.method_43059() * 0.02;
                    this.method_37908().method_8406((class_2394)class_2398.field_11201, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d0, d1, d2);
                }
            }
        } else {
            super.method_5711(eventId);
        }
    }

    public void setClientLocatorPosition(String name, class_243 pos) {
        if (name == null || pos == null) {
            return;
        }
        this.clientLocatorCache.put(name, pos);
    }

    @Override
    public class_243 getClientLocatorPosition(String name) {
        if (name == null) {
            return null;
        }
        return this.clientLocatorCache.get(name);
    }

    @Override
    public float getScreenShakeAmount(float partialTicks) {
        float currentAmount = ((Float)this.field_6011.method_12789(DATA_SCREEN_SHAKE_AMOUNT)).floatValue();
        return this.prevScreenShakeAmount + (currentAmount - this.prevScreenShakeAmount) * partialTicks;
    }

    @Override
    public double getShakeDistance() {
        return 18.0;
    }

    @Override
    public boolean canFeelShake(class_1297 player) {
        return true;
    }

    public void triggerScreenShake(float intensity) {
        float clamped = Math.max(0.0f, intensity);
        if (clamped <= 0.0f) {
            return;
        }
        if (this.method_37908().field_9236) {
            return;
        }
        this.screenShakeAmount = Math.max(this.screenShakeAmount, clamped);
        this.field_6011.method_12778(DATA_SCREEN_SHAKE_AMOUNT, (Object)Float.valueOf(this.screenShakeAmount));
    }

    public boolean canBeBound() {
        return !this.isDying() && !this.isAccelerating() && !this.areRiderControlsLocked() && !this.isAbilityActive(NulljawAbilities.NULLJAW_PHASE_SHIFT);
    }

    @Override
    public boolean shouldEnterWater() {
        if (this.method_24345() || this.method_5782()) {
            return false;
        }
        if (this.method_5809()) {
            return true;
        }
        if (this.method_6032() < this.method_6063() * 0.5f && this.method_5968() != null) {
            return true;
        }
        return this.ticksOutOfWater > 1000 && this.method_6051().method_43057() < 0.08f;
    }

    @Override
    public boolean shouldLeaveWater() {
        class_1309 owner;
        if (this.method_24345()) {
            return false;
        }
        if (this.method_6181() && this.method_35057() != null && !(owner = this.method_35057()).method_5799() && this.method_5858((class_1297)owner) > 100.0) {
            return true;
        }
        return this.ticksInWater > 1200 && this.method_6051().method_43057() < 0.08f;
    }

    static {
        try {
            Class.forName("com.leon.saintsdragons.common.registry.nulljaw.NulljawAbilities");
            System.out.println("[Nulljaw] Abilities loaded successfully in static initializer!");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to load Nulljaw abilities!", e);
        }
        VOCAL_ENTRIES = new DragonEntity.VocalEntryBuilder().add("grumble1", "action", "animation.nulljaw.grumble1", ModSounds.NULLJAW_GRUMBLE_1, 0.8f, 0.95f, 0.1f, false, false, true).add("grumble2", "action", "animation.nulljaw.grumble2", ModSounds.NULLJAW_GRUMBLE_2, 0.8f, 0.95f, 0.1f, false, false, true).add("grumble3", "action", "animation.nulljaw.grumble3", ModSounds.NULLJAW_GRUMBLE_3, 0.8f, 0.95f, 0.1f, false, false, true).build();
        DATA_GROUND_MOVE_STATE = class_2945.method_12791(Nulljaw.class, (class_2941)class_2943.field_13327);
        DATA_RIDER_FORWARD = class_2945.method_12791(Nulljaw.class, (class_2941)class_2943.field_13320);
        DATA_RIDER_STRAFE = class_2945.method_12791(Nulljaw.class, (class_2941)class_2943.field_13320);
        DATA_ACCELERATING = class_2945.method_12791(Nulljaw.class, (class_2941)class_2943.field_13323);
        DATA_SWIMMING = class_2945.method_12791(Nulljaw.class, (class_2941)class_2943.field_13323);
        DATA_SWIM_TURN = class_2945.method_12791(Nulljaw.class, (class_2941)class_2943.field_13327);
        DATA_SWIM_PITCH = class_2945.method_12791(Nulljaw.class, (class_2941)class_2943.field_13327);
        DATA_PHASE_TWO = class_2945.method_12791(Nulljaw.class, (class_2941)class_2943.field_13323);
        DATA_RIDER_LOCKED = class_2945.method_12791(Nulljaw.class, (class_2941)class_2943.field_13323);
        DATA_SCREEN_SHAKE_AMOUNT = class_2945.method_12791(Nulljaw.class, (class_2941)class_2943.field_13320);
        DATA_FLIGHT_MODE = class_2945.method_12791(Nulljaw.class, (class_2941)class_2943.field_13327);
        DATA_GOING_UP = class_2945.method_12791(Nulljaw.class, (class_2941)class_2943.field_13323);
        DATA_GOING_DOWN = class_2945.method_12791(Nulljaw.class, (class_2941)class_2943.field_13323);
        DATA_SLEEPING = class_2945.method_12791(Nulljaw.class, (class_2941)class_2943.field_13323);
        DATA_SLEEPING_ENTERING = class_2945.method_12791(Nulljaw.class, (class_2941)class_2943.field_13323);
        DATA_SLEEPING_EXITING = class_2945.method_12791(Nulljaw.class, (class_2941)class_2943.field_13323);
    }

    private static class RiftDrakeMoveControl
    extends class_1335 {
        public RiftDrakeMoveControl(Nulljaw drake) {
            super((class_1308)drake);
        }

        public void method_6240() {
            super.method_6240();
        }
    }

    public static class RiftDrakeLookController
    extends class_1333 {
        private final Nulljaw dragon;

        public RiftDrakeLookController(Nulljaw dragon) {
            super((class_1308)dragon);
            this.dragon = dragon;
        }

        public void method_6231() {
            if (!this.dragon.method_5805()) {
                return;
            }
            class_1309 rider = this.dragon.method_5642();
            if (this.dragon.method_5782() && rider != null) {
                if (this.dragon.method_5787()) {
                    boolean allowRiderPitch;
                    float bodyYaw = rider.method_36454();
                    this.dragon.method_36456(bodyYaw);
                    this.dragon.method_5847(bodyYaw);
                    this.dragon.field_6259 = bodyYaw;
                    this.dragon.field_6283 = bodyYaw;
                    this.dragon.field_6220 = bodyYaw;
                    boolean bl = allowRiderPitch = !this.dragon.isPhaseTwoActive() || !this.dragon.areRiderControlsLocked();
                    if (allowRiderPitch) {
                        float pitch = class_3532.method_15363((float)rider.method_36455(), (float)-45.0f, (float)45.0f);
                        this.dragon.method_36457(pitch);
                        this.dragon.field_6004 = pitch;
                    } else {
                        float eased = class_3532.method_15388((float)this.dragon.method_36455(), (float)0.0f, (float)6.0f);
                        this.dragon.method_36457(eased);
                        this.dragon.field_6004 = eased;
                    }
                } else {
                    float serverPitch;
                    this.dragon.field_6004 = serverPitch = this.dragon.method_36455();
                }
                return;
            }
            super.method_6231();
        }
    }
}

