/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.dragons.nulljaw.handlers;

import com.leon.saintsdragons.server.entity.dragons.nulljaw.Nulljaw;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public record NulljawAnimationHandler(Nulljaw drake) {
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.nulljaw.idle");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.nulljaw.walk");
    private static final RawAnimation RUN = RawAnimation.begin().thenLoop("animation.nulljaw.run");
    private static final RawAnimation IDLE2 = RawAnimation.begin().thenLoop("animation.nulljaw.idle2");
    private static final RawAnimation WALK2 = RawAnimation.begin().thenLoop("animation.nulljaw.walk2");
    private static final RawAnimation RUN2 = RawAnimation.begin().thenLoop("animation.nulljaw.run2");
    private static final RawAnimation SWIM_IDLE = RawAnimation.begin().thenLoop("animation.nulljaw.swim_idle");
    private static final RawAnimation SWIM_CRUISE = RawAnimation.begin().thenLoop("animation.nulljaw.swim_move");
    private static final RawAnimation SWIM_UP = RawAnimation.begin().thenLoop("animation.nulljaw.swimming_up");
    private static final RawAnimation SWIM_DOWN = RawAnimation.begin().thenLoop("animation.nulljaw.swimming_down");
    private static final RawAnimation SWIM_LEFT = RawAnimation.begin().thenLoop("animation.nulljaw.swimming_left");
    private static final RawAnimation SWIM_RIGHT = RawAnimation.begin().thenLoop("animation.nulljaw.swimming_right");
    private static final RawAnimation SWIM_NEUTRAL = RawAnimation.begin().thenLoop("animation.nulljaw.swimming_off");
    private static final RawAnimation SIT = RawAnimation.begin().thenLoop("animation.nulljaw.sit");
    private static final RawAnimation SIT_DOWN = RawAnimation.begin().thenPlay("animation.nulljaw.down");
    private static final RawAnimation SIT_UP = RawAnimation.begin().thenPlay("animation.nulljaw.up");
    private static final RawAnimation FALL_ASLEEP = RawAnimation.begin().thenPlay("animation.nulljaw.fall_asleep");
    private static final RawAnimation SLEEP_LOOP = RawAnimation.begin().thenLoop("animation.nulljaw.sleep");
    private static final RawAnimation WAKE_UP = RawAnimation.begin().thenPlay("animation.nulljaw.wake_up");
    private static final int MOVEMENT_TRANSITION_TICKS = 6;
    private static final int SWIM_TRANSITION_TICKS = 7;

    public void triggerSitDownAnimation() {
        this.drake.triggerAnim("action", "sit_down");
    }

    public void triggerSitUpAnimation() {
        this.drake.triggerAnim("action", "sit_up");
    }

    public void triggerFallAsleepAnimation() {
        this.drake.triggerAnim("action", "fall_asleep");
    }

    public void triggerSleepAnimation() {
        this.drake.triggerAnim("action", "sleep");
    }

    public void triggerWakeUpAnimation() {
        this.drake.triggerAnim("action", "wake_up");
    }

    public void setupActionController(AnimationController<Nulljaw> actionController) {
        actionController.triggerableAnim("phase1", RawAnimation.begin().thenPlay("animation.nulljaw.phase1"));
        actionController.triggerableAnim("phase2", RawAnimation.begin().thenPlay("animation.nulljaw.phase2"));
        actionController.triggerableAnim("bite", RawAnimation.begin().thenPlay("animation.nulljaw.bite"));
        actionController.triggerableAnim("bite2", RawAnimation.begin().thenPlay("animation.nulljaw.bite2"));
        actionController.triggerableAnim("claw_left", RawAnimation.begin().thenPlay("animation.nulljaw.claw_left"));
        actionController.triggerableAnim("claw_right", RawAnimation.begin().thenPlay("animation.nulljaw.claw_right"));
        actionController.triggerableAnim("horn_gore", RawAnimation.begin().thenPlay("animation.nulljaw.horn_gore"));
        actionController.triggerableAnim("roar", RawAnimation.begin().thenPlay("animation.nulljaw.roar"));
        actionController.triggerableAnim("roar2", RawAnimation.begin().thenPlay("animation.nulljaw.roar2"));
        actionController.triggerableAnim("eat", RawAnimation.begin().thenPlay("animation.nulljaw.eat"));
        actionController.triggerableAnim("sit_down", SIT_DOWN);
        actionController.triggerableAnim("sit_up", SIT_UP);
        actionController.triggerableAnim("fall_asleep", FALL_ASLEEP);
        actionController.triggerableAnim("sleep", SLEEP_LOOP);
        actionController.triggerableAnim("wake_up", WAKE_UP);
        actionController.triggerableAnim("grumble1", RawAnimation.begin().thenPlay("animation.nulljaw.grumble1"));
        actionController.triggerableAnim("grumble2", RawAnimation.begin().thenPlay("animation.nulljaw.grumble2"));
        actionController.triggerableAnim("grumble3", RawAnimation.begin().thenPlay("animation.nulljaw.grumble3"));
    }

    public PlayState movementPredicate(AnimationState<Nulljaw> state) {
        boolean isSwimming = this.drake.method_5681();
        boolean isInWater = this.drake.method_5799();
        boolean isNavigating = this.drake.method_5942().method_23966() && this.drake.method_5942().method_6345() != null;
        double horizontalSpeedSq = this.drake.method_18798().method_37268();
        double totalSpeedSq = this.drake.method_18798().method_1027();
        boolean isMovingLand = state.isMoving() || horizontalSpeedSq > 0.008;
        AnimationController controller = state.getController();
        controller.setAnimationSpeed(1.0);
        if (isSwimming || isInWater) {
            boolean isSwimmingMoving;
            controller.transitionLength(7);
            if (this.drake.method_5782() && this.drake.method_5642() != null) {
                float riderFwd = Math.abs(this.drake.getLastRiderForward());
                float riderStr = Math.abs(this.drake.getLastRiderStrafe());
                boolean riderMoving = riderFwd > 0.05f || riderStr > 0.05f;
                isSwimmingMoving = riderMoving || totalSpeedSq > 0.004;
            } else {
                isSwimmingMoving = this.drake.isSwimmingMoving() || isNavigating || totalSpeedSq > 0.002 || Math.abs(this.drake.field_6250) > 0.01f || Math.abs(this.drake.field_6227) > 0.01f;
            }
            RawAnimation swimAnim = isSwimmingMoving ? SWIM_CRUISE : SWIM_IDLE;
            state.setAnimation(swimAnim);
        } else if (this.drake.getSitProgress() > 0.5f) {
            controller.transitionLength(4);
            state.setAnimation(SIT);
        } else {
            class_1657 player;
            class_1309 class_13092;
            int groundState = this.drake.getEffectiveGroundState();
            boolean phaseTwo = this.drake.isPhaseTwoActive();
            boolean abilityActive = this.drake.getActiveAbility() != null;
            boolean riderControlled = this.drake.method_5782() && (class_13092 = this.drake.method_5642()) instanceof class_1657 && this.drake.method_6171((class_1309)(player = (class_1657)class_13092));
            boolean isAggressive = this.drake.method_6510() && isMovingLand;
            int baseTransition = 6;
            if (riderControlled) {
                baseTransition = Math.max(3, baseTransition - 2);
            }
            if (abilityActive) {
                baseTransition = Math.max(2, baseTransition - 1);
            }
            if (groundState == 2 || isAggressive) {
                controller.transitionLength(baseTransition);
                state.setAnimation(phaseTwo ? RUN2 : RUN);
            } else if (groundState == 1 || isMovingLand) {
                controller.transitionLength(Math.max(3, baseTransition + 1));
                state.setAnimation(phaseTwo ? WALK2 : WALK);
            } else {
                controller.transitionLength(Math.max(3, baseTransition + (abilityActive ? 2 : 0)));
                state.setAnimation(phaseTwo ? IDLE2 : IDLE);
            }
        }
        return PlayState.CONTINUE;
    }

    public PlayState swimDirectionPredicate(AnimationState<Nulljaw> state) {
        AnimationController controller = state.getController();
        controller.transitionLength(7);
        if (!this.drake.method_5681()) {
            state.setAndContinue(SWIM_NEUTRAL);
            return PlayState.CONTINUE;
        }
        if (this.drake.isSwimmingUp()) {
            state.setAndContinue(SWIM_UP);
            return PlayState.CONTINUE;
        }
        if (this.drake.isSwimmingDown()) {
            state.setAndContinue(SWIM_DOWN);
            return PlayState.CONTINUE;
        }
        int yawDir = this.drake.getSwimTurnDirection();
        if (yawDir < 0) {
            state.setAndContinue(SWIM_LEFT);
        } else if (yawDir > 0) {
            state.setAndContinue(SWIM_RIGHT);
        } else {
            state.setAndContinue(SWIM_NEUTRAL);
        }
        return PlayState.CONTINUE;
    }

    public PlayState actionPredicate(AnimationState<Nulljaw> state) {
        state.getController().transitionLength(5);
        return PlayState.STOP;
    }

    public void configureMovementBlend(AnimationController<Nulljaw> controller) {
        controller.transitionLength(6);
    }

    public void configureSwimBlend(AnimationController<Nulljaw> controller) {
        controller.transitionLength(7);
    }
}

