/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.dragons.raevyx;

import com.leon.saintsdragons.common.network.DragonRiderAction;
import com.leon.saintsdragons.common.particle.raevyx.RaevyxLightningStormData;
import com.leon.saintsdragons.common.registry.AbilityRegistry;
import com.leon.saintsdragons.common.registry.ModEntities;
import com.leon.saintsdragons.common.registry.ModSounds;
import com.leon.saintsdragons.common.registry.raevyx.RaevyxAbilities;
import com.leon.saintsdragons.server.ai.goals.base.DragonOwnerHurtByTargetGoal;
import com.leon.saintsdragons.server.ai.goals.base.DragonOwnerHurtTargetGoal;
import com.leon.saintsdragons.server.ai.goals.raevyx.RaevyxBreedGoal;
import com.leon.saintsdragons.server.ai.goals.raevyx.RaevyxCombatGoal;
import com.leon.saintsdragons.server.ai.goals.raevyx.RaevyxDodgeGoal;
import com.leon.saintsdragons.server.ai.goals.raevyx.RaevyxFlightGoal;
import com.leon.saintsdragons.server.ai.goals.raevyx.RaevyxFollowOwnerGoal;
import com.leon.saintsdragons.server.ai.goals.raevyx.RaevyxGroundWanderGoal;
import com.leon.saintsdragons.server.ai.goals.raevyx.RaevyxProtectBabiesGoal;
import com.leon.saintsdragons.server.ai.goals.raevyx.RaevyxRestGoal;
import com.leon.saintsdragons.server.ai.goals.raevyx.RaevyxSleepGoal;
import com.leon.saintsdragons.server.ai.goals.raevyx.RaevyxTemptGoal;
import com.leon.saintsdragons.server.ai.goals.raevyx.baby.RaevyxFollowParentGoal;
import com.leon.saintsdragons.server.ai.navigation.DragonFlightMoveHelper;
import com.leon.saintsdragons.server.ai.navigation.DragonPathNavigateGround;
import com.leon.saintsdragons.server.entity.ability.DieAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.base.DragonGender;
import com.leon.saintsdragons.server.entity.base.RideableDragonBase;
import com.leon.saintsdragons.server.entity.conductivity.ElectricalConductivityProfile;
import com.leon.saintsdragons.server.entity.conductivity.ElectricalConductivityState;
import com.leon.saintsdragons.server.entity.controller.raevyx.RaevyxFlightController;
import com.leon.saintsdragons.server.entity.controller.raevyx.RaevyxPhysicsController;
import com.leon.saintsdragons.server.entity.controller.raevyx.RaevyxRiderController;
import com.leon.saintsdragons.server.entity.dragons.raevyx.handlers.RaevyxAnimationHandler;
import com.leon.saintsdragons.server.entity.dragons.raevyx.handlers.RaevyxInteractionHandler;
import com.leon.saintsdragons.server.entity.dragons.raevyx.handlers.RaevyxSoundProfile;
import com.leon.saintsdragons.server.entity.handler.DragonSoundHandler;
import com.leon.saintsdragons.server.entity.interfaces.DragonFlightCapable;
import com.leon.saintsdragons.server.entity.interfaces.DragonSleepCapable;
import com.leon.saintsdragons.server.entity.interfaces.DragonSoundProfile;
import com.leon.saintsdragons.server.entity.interfaces.ElectricalConductivityCapable;
import com.leon.saintsdragons.server.entity.interfaces.ShakesScreen;
import com.leon.saintsdragons.server.entity.interfaces.SoundHandledDragon;
import com.leon.saintsdragons.server.entity.sleep.DragonRestManager;
import com.leon.saintsdragons.server.entity.sleep.DragonRestState;
import com.leon.saintsdragons.util.DragonMathUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1335;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1386;
import net.minecraft.class_1399;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1429;
import net.minecraft.class_1432;
import net.minecraft.class_1538;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import net.minecraft.class_8111;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.keyframe.event.SoundKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;

public class Raevyx
extends RideableDragonBase
implements class_1432,
class_1603,
DragonFlightCapable,
DragonSleepCapable,
ShakesScreen,
SoundHandledDragon,
ElectricalConductivityCapable {
    public static final class_2940<Boolean> DATA_FLYING = class_2945.method_12791(Raevyx.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> DATA_TAKEOFF = class_2945.method_12791(Raevyx.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> DATA_HOVERING = class_2945.method_12791(Raevyx.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> DATA_LANDING = class_2945.method_12791(Raevyx.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> DATA_RUNNING = class_2945.method_12791(Raevyx.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Integer> DATA_GROUND_MOVE_STATE = class_2945.method_12791(Raevyx.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Integer> DATA_FLIGHT_MODE = class_2945.method_12791(Raevyx.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Float> DATA_RIDER_FORWARD = class_2945.method_12791(Raevyx.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Float> DATA_RIDER_STRAFE = class_2945.method_12791(Raevyx.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Float> DATA_SCREEN_SHAKE_AMOUNT = class_2945.method_12791(Raevyx.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Boolean> DATA_BEAMING = class_2945.method_12791(Raevyx.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> DATA_RIDER_LANDING_BLEND = class_2945.method_12791(Raevyx.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> DATA_RIDER_LOCKED = class_2945.method_12791(Raevyx.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> DATA_BEAM_END_SET = class_2945.method_12791(Raevyx.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Float> DATA_BEAM_END_X = class_2945.method_12791(Raevyx.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Float> DATA_BEAM_END_Y = class_2945.method_12791(Raevyx.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Float> DATA_BEAM_END_Z = class_2945.method_12791(Raevyx.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Boolean> DATA_BEAM_START_SET = class_2945.method_12791(Raevyx.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Float> DATA_BEAM_START_X = class_2945.method_12791(Raevyx.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Float> DATA_BEAM_START_Y = class_2945.method_12791(Raevyx.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Float> DATA_BEAM_START_Z = class_2945.method_12791(Raevyx.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Boolean> DATA_GOING_UP = class_2945.method_12791(Raevyx.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> DATA_GOING_DOWN = class_2945.method_12791(Raevyx.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> DATA_ACCELERATING = class_2945.method_12791(Raevyx.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> DATA_SLEEPING = class_2945.method_12791(Raevyx.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> DATA_SLEEPING_ENTERING = class_2945.method_12791(Raevyx.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> DATA_SLEEPING_EXITING = class_2945.method_12791(Raevyx.class, (class_2941)class_2943.field_13323);
    public static final float MAX_BEAM_YAW_DEG = 40.0f;
    public static final float MAX_BEAM_PITCH_DEG = 50.0f;
    private double cachedOwnerDistance = Double.MAX_VALUE;
    private int ownerDistanceCacheTime = -1;
    private List<class_1676> cachedNearbyProjectiles = new CopyOnWriteArrayList<class_1676>();
    private int nearbyProjectilesCacheTime = -1;
    private int projectileCacheIntervalTicks = 3;
    private int emptyProjectileScans = 0;
    private double cachedHorizontalSpeed = 0.0;
    private int horizontalSpeedCacheTime = -1;
    private static final double RIDER_GLIDE_ALTITUDE_THRESHOLD = 40.0;
    private static final double RIDER_GLIDE_ALTITUDE_EXIT = 30.0;
    private static final double RIDER_LANDING_BLEND_ALTITUDE = 8.5;
    private static final int RIDER_LANDING_BLEND_DURATION = 5;
    private boolean inHighAltitudeGlide = false;
    private static final Map<String, DragonEntity.VocalEntry> VOCAL_ENTRIES = new DragonEntity.VocalEntryBuilder().add("grumble1", "action", "animation.raevyx.grumble1", ModSounds.RAEVYX_GRUMBLE_1, 0.8f, 0.95f, 0.1f, false, false, false).add("grumble2", "action", "animation.raevyx.grumble2", ModSounds.RAEVYX_GRUMBLE_2, 0.8f, 0.95f, 0.1f, false, false, false).add("grumble3", "action", "animation.raevyx.grumble3", ModSounds.RAEVYX_GRUMBLE_3, 0.8f, 0.95f, 0.1f, false, false, false).add("purr", "action", "animation.raevyx.purr", ModSounds.RAEVYX_PURR, 0.8f, 1.05f, 0.05f, true, false, true).add("snort", "action", "animation.raevyx.snort", ModSounds.RAEVYX_SNORT, 0.9f, 0.9f, 0.2f, false, false, false).add("chuff", "action", "animation.raevyx.chuff", ModSounds.RAEVYX_CHUFF, 0.9f, 0.9f, 0.2f, false, false, false).add("content", "action", "animation.raevyx.content", ModSounds.RAEVYX_CONTENT, 0.8f, 1.0f, 0.1f, true, false, true).add("excited", "action", "", ModSounds.RAEVYX_EXCITED, 1.0f, 1.0f, 0.3f, false, false, false).add("growl_warning", "action", "", ModSounds.RAEVYX_GROWL_WARNING, 1.2f, 0.8f, 0.4f, false, false, false).add("roar", "action", "animation.raevyx.roar", ModSounds.RAEVYX_ROAR, 1.4f, 0.9f, 0.15f, false, false, false).add("roar_ground", "action", "animation.raevyx.roar_ground", ModSounds.RAEVYX_ROAR, 1.4f, 0.9f, 0.15f, false, false, false).add("roar_air", "action", "animation.raevyx.roar_air", ModSounds.RAEVYX_ROAR, 1.4f, 0.9f, 0.15f, false, false, false).add("raevyx_hurt", "hurt", "animation.raevyx.hurt", ModSounds.RAEVYX_HURT, 1.2f, 0.95f, 0.1f, true, true, true).add("raevyx_die", "action", "animation.raevyx.die", ModSounds.RAEVYX_DIE, 1.5f, 0.95f, 0.1f, false, true, true).add("baby_raevyx_hurt", "hurt", "animation.raevyx.hurt", ModSounds.BABY_RAEVYX_HURT, 1.4f, 1.05f, 0.15f, true, true, true).add("baby_raevyx_die", "action", "animation.raevyx.die", ModSounds.BABY_RAEVYX_DIE, 1.3f, 1.0f, 0.1f, false, true, true).build();
    private boolean manualSitCommand = false;
    private boolean commandChangeManual = false;
    private int riderLandingBlendTicks = 0;
    private int ambientSoundTimer;
    private int nextAmbientSoundDelay;
    private float prevScreenShakeAmount = 0.0f;
    private float screenShakeAmount = 0.0f;
    public int timeFlying = 0;
    public boolean landingFlag = false;
    public int landingTimer = 0;
    int runningTicks = 0;
    private float bankSmoothedYaw = 0.0f;
    private int bankHoldTicks = 0;
    private int bankDir = 0;
    private float bankAngle = 0.0f;
    private float prevBankAngle = 0.0f;
    private float pitchSmoothedPitch = 0.0f;
    private int pitchHoldTicks = 0;
    private int pitchDir = 0;
    boolean dodging = false;
    int dodgeTicksLeft = 0;
    class_243 dodgeVec = class_243.field_1353;
    private boolean allowGroundBeamDuringStorm = false;
    private int sitTransitionTicks = 0;
    private boolean isSittingDown = false;
    private boolean isStandingUp = false;
    private int sleepTransitionTicks = 0;
    private int sleepAmbientCooldownTicks = 0;
    private int sleepReentryCooldownTicks = 0;
    private int sleepCancelTicks = 0;
    private boolean sleepLocked = false;
    private int sleepCommandSnapshot = -1;
    private int postLoadAirStabilizeTicks = 0;
    private int followFailsafeCooldown = 0;
    private int postStandUnlockTicks = 0;
    private int riderTakeoffTicks = 0;
    private long lastLandingGameTime = Long.MIN_VALUE;
    public final class_1409 groundNav;
    public final class_1407 airNav;
    public boolean usingAirNav = false;
    public final RaevyxFlightController flightController;
    private final RaevyxInteractionHandler lightningInteractionHandler;
    private final RaevyxAnimationHandler animationHandler;
    private final RaevyxRiderController riderController;
    private final DragonSoundHandler soundHandler;
    private final DragonRestManager restManager;
    private final Map<String, class_243> clientLocatorCache = new ConcurrentHashMap<String, class_243>();
    private final RaevyxPhysicsController animationController = new RaevyxPhysicsController(this);
    private int hurtSoundCooldown = 0;
    private class_243 prevClientBeamEnd = null;
    private class_243 clientBeamEnd = null;
    private class_243 beamLookLerp = null;
    private class_243 beamAimDir = null;
    private float beamYawOffsetRad = 0.0f;
    private float beamPitchOffsetRad = 0.0f;
    private static final double WATER_EFFECT_MAX_HEIGHT = 8.0;
    private static final double WATER_EFFECT_INTENSITY = 1.2;
    private boolean wasVehicleLastTick = false;
    private boolean shouldSpawnBabies = false;
    private int babiesToSpawn = 0;
    private int superchargeTicks = 0;
    private int tempInvulnTicks = 0;
    private int superchargeVfxCooldown = 0;
    private int riderControlLockTicks = 0;
    private int takeoffLockTicks = 0;
    private final Map<Integer, Long> recentAggroIds = new ConcurrentHashMap<Integer, Long>();
    private int aggroGrowlCooldown = 0;
    private static final ElectricalConductivityProfile CONDUCTIVITY_PROFILE = new ElectricalConductivityProfile(1.0f, 0.5f, 0.0f, 1.0, 0.3, 0.0);

    @Override
    public void setCommand(int command) {
        int previous = super.getCommand();
        super.setCommand(command);
        this.manualSitCommand = command == 1 ? this.commandChangeManual || this.manualSitCommand : false;
        this.commandChangeManual = false;
    }

    public void setCommandManual(int command) {
        this.commandChangeManual = true;
        this.setCommand(command);
    }

    public void setCommandAuto(int command) {
        this.commandChangeManual = false;
        this.setCommand(command);
    }

    private boolean getBooleanData(class_2940<Boolean> accessor) {
        return (Boolean)this.field_6011.method_12789(accessor);
    }

    private void setBooleanData(class_2940<Boolean> accessor, boolean value) {
        this.field_6011.method_12778(accessor, (Object)value);
    }

    private int getIntegerData(class_2940<Integer> accessor) {
        return (Integer)this.field_6011.method_12789(accessor);
    }

    private void setIntegerData(class_2940<Integer> accessor, int value) {
        this.field_6011.method_12778(accessor, (Object)value);
    }

    private float getFloatData(class_2940<Float> accessor) {
        return ((Float)this.field_6011.method_12789(accessor)).floatValue();
    }

    private void setFloatData(class_2940<Float> accessor, float value) {
        this.field_6011.method_12778(accessor, (Object)Float.valueOf(value));
    }

    public long getLastLandingGameTime() {
        return this.lastLandingGameTime;
    }

    @Override
    public void markLandedNow() {
        if (!this.method_37908().field_9236) {
            this.lastLandingGameTime = this.method_37908().method_8510();
        }
    }

    public boolean method_6172() {
        return super.method_6172() && !this.method_5782() && !this.method_5765() && !this.method_6581();
    }

    public float getGlidingFraction() {
        return this.animationController.glidingFraction;
    }

    public float getFlappingFraction() {
        return this.animationController.flappingFraction;
    }

    public float getHoveringFraction() {
        return this.animationController.hoveringFraction;
    }

    public Raevyx(class_1299<? extends class_1321> type, class_1937 level) {
        super(type, level);
        this.method_49477(1.25f);
        this.groundNav = new DragonPathNavigateGround((class_1308)this, level);
        this.airNav = new class_1407((class_1308)this, level){

            public boolean method_6333(@Nonnull class_2338 pos) {
                return !this.field_6677.method_8320(pos.method_10074()).method_26215();
            }
        };
        this.airNav.method_6332(false);
        this.airNav.method_6354(false);
        this.airNav.method_6331(false);
        this.field_6189 = this.groundNav;
        this.field_6207 = new class_1335((class_1308)this);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_4, -1.0f);
        this.method_5941(class_7.field_10, -1.0f);
        this.flightController = new RaevyxFlightController(this);
        this.lightningInteractionHandler = new RaevyxInteractionHandler(this);
        this.animationHandler = new RaevyxAnimationHandler(this);
        this.riderController = new RaevyxRiderController(this);
        this.soundHandler = new DragonSoundHandler(this);
        this.restManager = new DragonRestManager((class_1309)this);
        class_5819 rng = this.method_6051();
        this.ambientSoundTimer = rng.method_43048(80);
        this.nextAmbientSoundDelay = 200 + rng.method_43048(400);
    }

    @Override
    protected float getBodyTurnSpeed() {
        return 0.6f;
    }

    @Override
    public DragonSoundHandler getSoundHandler() {
        return this.soundHandler;
    }

    public DragonRestManager getRestManager() {
        return this.restManager;
    }

    public void setClientLocatorPosition(String name, class_243 pos) {
        if (name == null || pos == null) {
            return;
        }
        this.clientLocatorCache.put(name, pos);
    }

    @Override
    public class_243 getClientLocatorPosition(String name) {
        if (name == null) {
            return null;
        }
        return this.clientLocatorCache.get(name);
    }

    @Override
    public boolean isStayOrSitMuted() {
        return this.method_24345() || this.method_6172();
    }

    @Override
    protected void method_5712(@Nonnull class_2338 pos, @Nonnull class_2680 state) {
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1321.method_26828().method_26868(class_5134.field_23716, 180.0).method_26868(class_5134.field_23719, 0.25).method_26868(class_5134.field_23717, 80.0).method_26868(class_5134.field_23720, 1.0).method_26868(class_5134.field_23718, 1.0).method_26868(class_5134.field_23724, 8.0);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_SCREEN_SHAKE_AMOUNT, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(DATA_BEAMING, (Object)false);
        this.field_6011.method_12784(DATA_RIDER_LANDING_BLEND, (Object)false);
        this.field_6011.method_12784(DATA_RIDER_LOCKED, (Object)false);
        this.field_6011.method_12784(DATA_SLEEPING_ENTERING, (Object)false);
        this.field_6011.method_12784(DATA_SLEEPING_EXITING, (Object)false);
        this.field_6011.method_12784(DATA_BEAM_END_SET, (Object)false);
        this.field_6011.method_12784(DATA_BEAM_END_X, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(DATA_BEAM_END_Y, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(DATA_BEAM_END_Z, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(DATA_BEAM_START_SET, (Object)false);
        this.field_6011.method_12784(DATA_BEAM_START_X, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(DATA_BEAM_START_Y, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(DATA_BEAM_START_Z, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(DATA_SLEEPING, (Object)false);
    }

    @Override
    protected void defineRideableDragonData() {
        this.field_6011.method_12784(DATA_FLYING, (Object)false);
        this.field_6011.method_12784(DATA_TAKEOFF, (Object)false);
        this.field_6011.method_12784(DATA_HOVERING, (Object)false);
        this.field_6011.method_12784(DATA_LANDING, (Object)false);
        this.field_6011.method_12784(DATA_RUNNING, (Object)false);
        this.field_6011.method_12784(DATA_GROUND_MOVE_STATE, (Object)0);
        this.field_6011.method_12784(DATA_FLIGHT_MODE, (Object)-1);
        this.field_6011.method_12784(DATA_RIDER_FORWARD, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(DATA_RIDER_STRAFE, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(DATA_GOING_UP, (Object)false);
        this.field_6011.method_12784(DATA_GOING_DOWN, (Object)false);
        this.field_6011.method_12784(DATA_ACCELERATING, (Object)false);
    }

    @Override
    protected class_2940<Float> getRiderForwardAccessor() {
        return DATA_RIDER_FORWARD;
    }

    @Override
    protected class_2940<Float> getRiderStrafeAccessor() {
        return DATA_RIDER_STRAFE;
    }

    @Override
    protected class_2940<Integer> getGroundMoveStateAccessor() {
        return DATA_GROUND_MOVE_STATE;
    }

    @Override
    protected class_2940<Integer> getFlightModeAccessor() {
        return DATA_FLIGHT_MODE;
    }

    @Override
    protected class_2940<Boolean> getGoingUpAccessor() {
        return DATA_GOING_UP;
    }

    @Override
    protected class_2940<Boolean> getGoingDownAccessor() {
        return DATA_GOING_DOWN;
    }

    @Override
    protected class_2940<Boolean> getAcceleratingAccessor() {
        return DATA_ACCELERATING;
    }

    @Override
    protected void applyLoadedFlightState(boolean flying, boolean takeoff, boolean hovering, boolean landing) {
        this.setFlying(flying);
        this.setTakeoff(takeoff);
        this.setHovering(hovering);
        this.setLanding(landing);
    }

    @Override
    public <T extends DragonEntity> DragonAbility<T> getActiveAbility() {
        return this.combatManager.getActiveAbility();
    }

    public boolean isAbilityActive(DragonAbilityType<?, ?> abilityType) {
        return this.combatManager.isAbilityActive(abilityType);
    }

    @Override
    public boolean canUseAbility() {
        return !this.method_6109() && this.combatManager.canUseAbility();
    }

    public void useRidingAbility(String abilityName) {
        class_1657 p;
        if (this.method_6109()) {
            return;
        }
        if (abilityName == null || abilityName.isEmpty()) {
            return;
        }
        class_1309 cp = this.method_5642();
        if (!(cp instanceof class_1309)) {
            return;
        }
        if (this.areRiderControlsLocked()) {
            return;
        }
        if (this.method_6181() && cp instanceof class_1657 && !this.method_6171((class_1309)(p = (class_1657)cp))) {
            return;
        }
        DragonAbilityType<?, ?> type = AbilityRegistry.get(abilityName);
        if (type != null) {
            this.combatManager.tryUseAbility(type);
        }
    }

    @Override
    public <T extends DragonEntity> void tryActivateAbility(DragonAbilityType<T, ?> abilityType) {
        if (this.method_6109()) {
            return;
        }
        super.tryActivateAbility(abilityType);
    }

    @Override
    protected boolean isRiderInputLocked(class_1657 player) {
        return this.areRiderControlsLocked();
    }

    @Override
    protected void applyRiderVerticalInput(class_1657 player, boolean goingUp, boolean goingDown, boolean locked) {
        if (this.method_6581()) {
            this.setGoingUp(goingUp);
            this.setGoingDown(goingDown);
        } else {
            this.setGoingUp(false);
            this.setGoingDown(false);
        }
    }

    @Override
    protected void applyRiderMovementInput(class_1657 player, float forward, float strafe, float yaw, boolean locked) {
        float fwd = this.applyInputDeadzone(forward);
        float str = this.applyInputDeadzone(strafe);
        this.setLastRiderForward(fwd);
        this.setLastRiderStrafe(str);
        if (!this.method_6581()) {
            int moveState = 0;
            float magnitude = Math.abs(fwd) + Math.abs(str);
            if (magnitude > 0.05f) {
                int n = moveState = this.isAccelerating() ? 2 : 1;
            }
            if ((Integer)this.method_5841().method_12789(DATA_GROUND_MOVE_STATE) != moveState) {
                this.method_5841().method_12778(DATA_GROUND_MOVE_STATE, (Object)moveState);
                this.syncAnimState(moveState, this.getSyncedFlightMode());
            }
        }
    }

    @Override
    protected void handleRiderAction(class_3222 player, DragonRiderAction action, String abilityName, boolean locked) {
        if (action == null) {
            return;
        }
        switch (action) {
            case TAKEOFF_REQUEST: {
                if (locked) break;
                this.requestRiderTakeoff();
                break;
            }
            case ACCELERATE: {
                if (locked) break;
                this.setAccelerating(true);
                break;
            }
            case STOP_ACCELERATE: {
                this.setAccelerating(false);
                break;
            }
            case ABILITY_USE: {
                if (abilityName == null || abilityName.isEmpty()) break;
                this.useRidingAbility(abilityName);
                break;
            }
            case ABILITY_STOP: {
                DragonAbility active;
                if (abilityName == null || abilityName.isEmpty() || (active = this.getActiveAbility()) == null) break;
                this.forceEndActiveAbility();
                break;
            }
            case TOGGLE_MELEE: {
                if (locked) break;
                this.toggleMeleeMode();
                break;
            }
        }
    }

    public void requestRiderTakeoff() {
        this.riderController.requestRiderTakeoff();
    }

    @Override
    public class_243 getHeadPosition() {
        return this.method_33571();
    }

    @Override
    public class_243 getMouthPosition() {
        class_243 mouthLoc = this.getClientLocatorPosition("mouth_origin");
        if (mouthLoc != null) {
            return mouthLoc;
        }
        return this.computeHeadMouthOrigin(1.0f);
    }

    public class_243 computeHeadMouthOrigin(float partialTicks) {
        double x = class_3532.method_16436((double)partialTicks, (double)this.field_6014, (double)this.method_23317());
        double y = class_3532.method_16436((double)partialTicks, (double)this.field_6036, (double)this.method_23318());
        double z = class_3532.method_16436((double)partialTicks, (double)this.field_5969, (double)this.method_23321());
        float yawDeg = class_3532.method_16439((float)partialTicks, (float)this.field_6259, (float)this.field_6241);
        float pitchDeg = class_3532.method_16439((float)partialTicks, (float)this.field_6004, (float)this.method_36455());
        double yaw = Math.toRadians(yawDeg);
        double pitch = Math.toRadians(pitchDeg);
        double R = -0.03125;
        double U = 0.4125;
        double F = 0.915625;
        double cp = Math.cos(pitch);
        double sp = Math.sin(pitch);
        double up = U * cp - F * sp;
        double fwd = U * sp + F * cp;
        double cy = Math.cos(yaw);
        double sy = Math.sin(yaw);
        double offX = R * cy - fwd * sy;
        double offZ = R * sy + fwd * cy;
        return new class_243(x + offX, y + up, z + offZ);
    }

    public void forceEndActiveAbility() {
        this.combatManager.forceEndActiveAbility();
    }

    public boolean isBeaming() {
        return this.getBooleanData(DATA_BEAMING);
    }

    public void setBeaming(boolean beaming) {
        boolean wasBeaming = this.getBooleanData(DATA_BEAMING);
        this.setBooleanData(DATA_BEAMING, beaming);
        if (!beaming || !wasBeaming) {
            this.resetBeamAim();
        }
    }

    public void setBeamEndPosition(@Nullable class_243 pos) {
        if (pos == null) {
            this.field_6011.method_12778(DATA_BEAM_END_SET, (Object)false);
        } else {
            this.field_6011.method_12778(DATA_BEAM_END_SET, (Object)true);
            this.field_6011.method_12778(DATA_BEAM_END_X, (Object)Float.valueOf((float)pos.field_1352));
            this.field_6011.method_12778(DATA_BEAM_END_Y, (Object)Float.valueOf((float)pos.field_1351));
            this.field_6011.method_12778(DATA_BEAM_END_Z, (Object)Float.valueOf((float)pos.field_1350));
        }
    }

    public class_243 getBeamEndPosition() {
        if (!this.getBooleanData(DATA_BEAM_END_SET)) {
            return null;
        }
        return new class_243((double)this.getFloatData(DATA_BEAM_END_X), (double)this.getFloatData(DATA_BEAM_END_Y), (double)this.getFloatData(DATA_BEAM_END_Z));
    }

    public class_243 getClientBeamEndPosition(float partialTicks) {
        if (this.clientBeamEnd != null && this.prevClientBeamEnd != null) {
            class_243 d = this.clientBeamEnd.method_1020(this.prevClientBeamEnd);
            return this.prevClientBeamEnd.method_1019(d.method_1021((double)partialTicks));
        }
        class_243 serverPos = this.getBeamEndPosition();
        return this.clientBeamEnd != null ? this.clientBeamEnd : (serverPos != null ? serverPos : class_243.field_1353);
    }

    public void setBeamStartPosition(@Nullable class_243 pos) {
        if (pos == null) {
            this.field_6011.method_12778(DATA_BEAM_START_SET, (Object)false);
        } else {
            this.field_6011.method_12778(DATA_BEAM_START_SET, (Object)true);
            this.field_6011.method_12778(DATA_BEAM_START_X, (Object)Float.valueOf((float)pos.field_1352));
            this.field_6011.method_12778(DATA_BEAM_START_Y, (Object)Float.valueOf((float)pos.field_1351));
            this.field_6011.method_12778(DATA_BEAM_START_Z, (Object)Float.valueOf((float)pos.field_1350));
        }
    }

    public class_243 getBeamStartPosition() {
        if (!this.getBooleanData(DATA_BEAM_START_SET)) {
            return null;
        }
        return new class_243((double)this.getFloatData(DATA_BEAM_START_X), (double)this.getFloatData(DATA_BEAM_START_Y), (double)this.getFloatData(DATA_BEAM_START_Z));
    }

    public void switchToAirNavigation() {
        if (!this.usingAirNav) {
            this.field_6189 = this.airNav;
            this.field_6207 = new DragonFlightMoveHelper(this);
            this.usingAirNav = true;
        }
    }

    public void switchToGroundNavigation() {
        if (this.usingAirNav) {
            this.field_6189 = this.groundNav;
            this.field_6207 = new class_1335((class_1308)this);
            this.usingAirNav = false;
        }
    }

    @NotNull
    protected class_1408 method_5965(@Nonnull class_1937 level) {
        return new DragonPathNavigateGround((class_1308)this, level);
    }

    @Override
    public void setFlying(boolean flying) {
        if (flying && this.method_6109()) {
            flying = false;
        }
        if (!flying && this.method_5782() && !this.method_24345() && !this.method_24828()) {
            return;
        }
        boolean wasFlying = this.method_6581();
        this.field_6011.method_12778(DATA_FLYING, (Object)flying);
        if (wasFlying != flying) {
            this.setAccelerating(false);
        }
        if (wasFlying != flying) {
            if (flying) {
                this.switchToAirNavigation();
                this.setRunning(false);
            } else {
                this.switchToGroundNavigation();
            }
        }
    }

    @Override
    public void setTakeoff(boolean takeoff) {
        if (takeoff && this.method_6109()) {
            takeoff = false;
        }
        this.field_6011.method_12778(DATA_TAKEOFF, (Object)takeoff);
    }

    @Override
    public void setHovering(boolean hovering) {
        if (hovering && this.method_6109()) {
            hovering = false;
        }
        this.field_6011.method_12778(DATA_HOVERING, (Object)hovering);
    }

    @Override
    public boolean isWalking() {
        int s;
        if (this.method_6581()) {
            return false;
        }
        int n = s = this.method_37908().field_9236 ? this.getEffectiveGroundState() : ((Integer)this.field_6011.method_12789(DATA_GROUND_MOVE_STATE)).intValue();
        if (s == 1) {
            return true;
        }
        if (s == 2) {
            return false;
        }
        if (this.method_37908().field_9236 && super.getEffectiveGroundState() < 0) {
            double speed = this.method_18798().method_37268();
            return speed > 0.004 && speed <= 0.1;
        }
        return false;
    }

    @Override
    public boolean isActuallyRunning() {
        int s;
        if (this.method_6581()) {
            return false;
        }
        int n = s = this.method_37908().field_9236 ? this.getEffectiveGroundState() : ((Integer)this.field_6011.method_12789(DATA_GROUND_MOVE_STATE)).intValue();
        if (s == 2) {
            return true;
        }
        if (s == 1) {
            return false;
        }
        return this.getBooleanData(DATA_RUNNING);
    }

    @Override
    public void setLanding(boolean landing) {
        if (landing && this.method_5782()) {
            return;
        }
        this.field_6011.method_12778(DATA_LANDING, (Object)landing);
        if (landing) {
            this.landingTimer = 0;
            this.method_5942().method_6340();
            this.setTakeoff(true);
            this.landingFlag = true;
            if (!this.method_37908().field_9236) {
                this.flightController.planSmartLanding();
            }
        } else {
            this.landingFlag = false;
        }
    }

    @Override
    public int getSyncedFlightMode() {
        return this.getIntegerData(DATA_FLIGHT_MODE);
    }

    @Override
    public int getGroundMoveState() {
        return this.getIntegerData(DATA_GROUND_MOVE_STATE);
    }

    @Override
    protected int getFlightMode() {
        if (!this.method_6581()) {
            this.inHighAltitudeGlide = false;
            return -1;
        }
        if (this.isTakeoff()) {
            return 3;
        }
        if (this.isHovering()) {
            return 2;
        }
        if (this.isLanding()) {
            return 2;
        }
        if (this.method_6181() && this.method_5782()) {
            class_1657 player;
            class_1309 rider = this.method_5642();
            if (rider instanceof class_1657 && this.method_6171((class_1309)(player = (class_1657)rider))) {
                int groundY = this.method_37908().method_8624(class_2902.class_2903.field_13203, class_3532.method_15357((double)this.method_23317()), class_3532.method_15357((double)this.method_23321()));
                double altitudeAboveTerrain = this.method_23318() - (double)groundY;
                if (this.inHighAltitudeGlide) {
                    if (altitudeAboveTerrain > 30.0) {
                        return 0;
                    }
                    this.inHighAltitudeGlide = false;
                    return 1;
                }
                if (altitudeAboveTerrain > 40.0) {
                    this.inHighAltitudeGlide = true;
                    return 0;
                }
                return 1;
            }
        } else {
            this.inHighAltitudeGlide = false;
        }
        double horizontalSpeedSqr = this.method_18798().method_37268();
        double yDelta = this.method_23318() - this.field_6036;
        if (Math.abs(yDelta) < 0.06 && horizontalSpeedSqr > 0.01) {
            return 0;
        }
        return 1;
    }

    @Override
    protected boolean isDragonFlying() {
        return this.getBooleanData(DATA_FLYING);
    }

    @Override
    public boolean isTakeoff() {
        return this.getBooleanData(DATA_TAKEOFF);
    }

    @Override
    public boolean isLanding() {
        return this.getBooleanData(DATA_LANDING);
    }

    @Override
    public boolean isHovering() {
        return this.getBooleanData(DATA_HOVERING);
    }

    @Override
    public boolean isRunning() {
        return this.getBooleanData(DATA_RUNNING);
    }

    @Override
    public void setRunning(boolean running) {
        this.setBooleanData(DATA_RUNNING, running);
        if (running) {
            this.runningTicks = 0;
            Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6192(0.45);
        } else {
            Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6192(0.25);
        }
    }

    @Override
    public void tickAnimationStates() {
    }

    @Override
    public int getEffectiveGroundState() {
        return super.getEffectiveGroundState();
    }

    public double getYDelta() {
        return this.method_23318() - this.field_6036;
    }

    public void setGroundMoveStateFromAI(int state) {
        if (!this.method_37908().field_9236) {
            int s = Math.max(0, Math.min(2, state));
            if ((Integer)this.field_6011.method_12789(DATA_GROUND_MOVE_STATE) != s) {
                this.field_6011.method_12778(DATA_GROUND_MOVE_STATE, (Object)s);
                this.syncAnimState(s, this.getSyncedFlightMode());
            }
        }
    }

    @Override
    @Nullable
    public class_1657 getRidingPlayer() {
        class_1309 class_13092 = this.method_5642();
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            return player;
        }
        return null;
    }

    @Override
    public boolean canOwnerCommand(class_1657 ownerPlayer) {
        return ownerPlayer.method_18276();
    }

    @Override
    public RideableDragonBase.RiderAbilityBinding getTertiaryRiderAbility() {
        return new RideableDragonBase.RiderAbilityBinding(RaevyxAbilities.RAEVYX_LIGHTNING_BEAM.getName(), RideableDragonBase.RiderAbilityBinding.Activation.HOLD);
    }

    @Override
    public RideableDragonBase.RiderAbilityBinding getPrimaryRiderAbility() {
        return new RideableDragonBase.RiderAbilityBinding(RaevyxAbilities.RAEVYX_ROAR.getName(), RideableDragonBase.RiderAbilityBinding.Activation.PRESS);
    }

    @Override
    public RideableDragonBase.RiderAbilityBinding getSecondaryRiderAbility() {
        return new RideableDragonBase.RiderAbilityBinding(RaevyxAbilities.RAEVYX_SUMMON_STORM.getName(), RideableDragonBase.RiderAbilityBinding.Activation.PRESS);
    }

    @Override
    public RideableDragonBase.RiderAbilityBinding getAttackRiderAbility() {
        if (this.getMeleeMode() == 0) {
            return new RideableDragonBase.RiderAbilityBinding(RaevyxAbilities.RAEVYX_BITE.getName(), RideableDragonBase.RiderAbilityBinding.Activation.PRESS);
        }
        return new RideableDragonBase.RiderAbilityBinding(RaevyxAbilities.RAEVYX_HORN_GORE.getName(), RideableDragonBase.RiderAbilityBinding.Activation.PRESS);
    }

    public double method_5621() {
        return this.riderController.getPassengersRidingOffset();
    }

    protected void method_5865(@Nonnull class_1297 passenger, @Nonnull class_1297.class_4738 moveFunction) {
        this.riderController.positionRider(passenger, moveFunction);
    }

    @NotNull
    public class_243 method_24829(@Nonnull class_1309 passenger) {
        return this.riderController.getDismountLocationForPassenger(passenger);
    }

    public boolean isDodging() {
        return this.dodging;
    }

    public void beginDodge(class_243 vec, int ticks) {
        this.dodging = true;
        this.dodgeVec = vec;
        this.dodgeTicksLeft = Math.max(1, ticks);
        this.method_5942().method_6340();
        this.field_6007 = true;
    }

    @Override
    public void method_5773() {
        this.animationController.tick();
        super.method_5773();
        this.tickScreenShake();
        this.tickSittingState();
        this.tickSound();
        this.tickPostLoadStabilization();
        this.tickRiderTakeoff();
        this.tickControllers();
        this.tickHurtSoundCooldown();
        this.tickWaterDisturbance();
        if (!this.method_37908().field_9236) {
            this.spawnBabiesIfNeeded();
            if (this.method_6581() && this.method_5642() != null && !this.isLanding() && !this.isBeaming() && !this.isTakeoff() && this.isHovering()) {
                this.setHovering(false);
            }
            this.tickRiderControlLock();
            this.tickRiderControlLockMovement();
            this.handleAmbientSounds();
        }
        if (!this.method_37908().field_9236) {
            this.tickSuperchargeTimer();
            this.tickTempInvulnTimer();
            this.tickSuperchargeVfx();
            this.tickSleepTransition();
            this.tickSleepCooldowns();
            this.tickMountingState();
            this.tickFollowFailsafe();
            if (this.postStandUnlockTicks > 0) {
                --this.postStandUnlockTicks;
            }
        }
        this.tickBankingLogic();
        this.tickPitchingLogic();
        if (!this.method_37908().field_9236 && (this.method_6113() || this.isSleepingEntering() || this.isSleepingExiting())) {
            if (this.method_5782()) {
                this.wakeUpImmediately();
                this.clearAllStatesWhenMounted();
            } else if (this.method_5968() != null || this.method_6510()) {
                this.wakeUpImmediately();
                this.suppressSleep(200);
            } else if (this.method_5816() || this.method_5771()) {
                this.wakeUpImmediately();
                this.suppressSleep(200);
            }
            super.tickAnimationStates();
        }
        if (!(this.method_37908().field_9236 || this.method_6113() || this.isSleepingEntering() || this.isSleepingExiting())) {
            super.tickAnimationStates();
        }
        if (!this.method_37908().field_9236 && this.isDodging()) {
            this.handleDodgeMovement();
            return;
        }
        this.tickRunningTime();
        this.tickBeamLook();
        if (!this.method_37908().field_9236 && this.method_6109()) {
            if (this.method_5968() != null) {
                super.method_5980(null);
            }
            if (this.getActiveAbility() != null) {
                this.combatManager.forceEndActiveAbility();
            }
            this.method_19540(false);
        }
        this.tickClientSideUpdates();
    }

    private void tickScreenShake() {
        this.prevScreenShakeAmount = this.screenShakeAmount;
        if (this.screenShakeAmount > 0.0f) {
            this.screenShakeAmount = Math.max(0.0f, this.screenShakeAmount - 0.34f);
            this.field_6011.method_12778(DATA_SCREEN_SHAKE_AMOUNT, (Object)Float.valueOf(this.screenShakeAmount));
        }
    }

    private void tickWaterDisturbance() {
        if (this.method_37908().field_9236) {
            return;
        }
        if (!this.method_6581()) {
            return;
        }
        class_243 pos = this.method_19538();
        class_238 box = this.method_5829();
        int checkDown = 0;
        while ((double)checkDown < 8.0) {
            class_2338 checkPos = new class_2338((int)Math.floor(pos.field_1352), (int)Math.floor(pos.field_1351) - checkDown, (int)Math.floor(pos.field_1350));
            class_2680 state = this.method_37908().method_8320(checkPos);
            if (!state.method_26227().method_15769()) {
                double waterY = (double)checkPos.method_10264() + 1.0;
                double boxWidth = box.method_17939();
                double boxLength = box.method_17941();
                int particleCount = (int)Math.ceil((boxWidth + boxLength) / 2.0 * 1.2 * 8.0);
                particleCount = Math.min(particleCount, 50);
                for (int i = 0; i < particleCount; ++i) {
                    double offsetX = (this.field_5974.method_43058() - 0.5) * boxWidth;
                    double offsetZ = (this.field_5974.method_43058() - 0.5) * boxLength;
                    double particleX = pos.field_1352 + offsetX;
                    double particleZ = pos.field_1350 + offsetZ;
                    ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11202, particleX, waterY, particleZ, 1, offsetX * 0.2, 0.1, offsetZ * 0.2, 0.1);
                    if (!(this.field_5974.method_43057() < 0.25f)) continue;
                    ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11241, particleX, waterY, particleZ, 1, 0.0, 0.0, 0.0, 0.0);
                }
                break;
            }
            ++checkDown;
        }
    }

    private void tickHurtSoundCooldown() {
        if (this.hurtSoundCooldown > 0) {
            --this.hurtSoundCooldown;
        }
    }

    private void tickSound() {
        this.getSoundHandler().tick();
    }

    private void tickSittingState() {
        if (!this.method_37908().field_9236 && this.method_5782() && this.method_24345()) {
            this.method_24346(false);
        }
    }

    private void tickMountingState() {
        if (!this.method_37908().field_9236 && this.method_5782() && !this.wasVehicleLastTick) {
            this.clearAllStatesWhenMounted();
        }
        this.wasVehicleLastTick = this.method_5782();
    }

    private void clearAllStatesWhenMounted() {
        if (!this.method_37908().field_9236 && this.method_5782()) {
            this.wakeUpImmediately();
            if (this.method_24345()) {
                this.method_24346(false);
                if (this.getCommand() == 1) {
                    this.setCommandAuto(0);
                }
            }
            if (this.method_5942().method_6345() != null) {
                this.method_5942().method_6340();
            }
            this.suppressSleep(300);
        }
    }

    private void tickRunningTime() {
        this.runningTicks = this.isRunning() ? ++this.runningTicks : Math.max(0, this.runningTicks - 2);
    }

    private void tickBeamLook() {
        if (!this.isBeaming()) {
            this.resetBeamAim();
            return;
        }
        class_243 start = this.getBeamStartPosition();
        if (start == null) {
            start = this.computeHeadMouthOrigin(1.0f);
        }
        if (start == null) {
            this.resetBeamAim();
            return;
        }
        class_243 aimDir = this.refreshBeamAimDirection(start, true);
        if (aimDir == null) {
            aimDir = this.beamAimDir = class_243.method_1030((float)this.method_36455(), (float)this.field_6241).method_1029();
            this.updateBeamOffsets(aimDir);
        }
        class_243 desiredLook = start.method_1019(aimDir.method_1021(6.0));
        double alpha = 0.35;
        this.beamLookLerp = this.beamLookLerp == null ? desiredLook : this.beamLookLerp.method_1019(desiredLook.method_1020(this.beamLookLerp).method_1021(alpha));
        float yawSpeed = Math.max(90.0f, (float)this.method_20240());
        float pitchRange = this.method_5978();
        this.method_5988().method_6230(this.beamLookLerp.field_1352, this.beamLookLerp.field_1351, this.beamLookLerp.field_1350, yawSpeed, pitchRange);
    }

    public class_243 getBeamAimDirection() {
        return this.beamAimDir;
    }

    public float getBeamYawOffsetRad() {
        return this.beamYawOffsetRad;
    }

    public float getBeamPitchOffsetRad() {
        return this.beamPitchOffsetRad;
    }

    public class_243 refreshBeamAimDirection(class_243 start, boolean smooth) {
        class_243 desiredDir = this.computeRawBeamAimDirection(start);
        if (desiredDir == null) {
            this.updateBeamOffsets(null);
            return null;
        }
        class_243 clamped = this.clampBeamDirection(desiredDir);
        if (clamped == null) {
            this.updateBeamOffsets(null);
            return null;
        }
        if (this.beamAimDir == null) {
            this.beamAimDir = clamped;
        } else if (smooth) {
            double blend = 0.35;
            this.beamAimDir = this.beamAimDir.method_1019(clamped.method_1020(this.beamAimDir).method_1021(blend));
            double len = this.beamAimDir.method_1033();
            this.beamAimDir = len > 1.0E-6 ? this.beamAimDir.method_1021(1.0 / len) : clamped;
        } else {
            this.beamAimDir = clamped;
        }
        this.updateBeamOffsets(this.beamAimDir);
        return this.beamAimDir;
    }

    private class_243 computeRawBeamAimDirection(class_243 start) {
        class_243 aimPoint;
        class_243 towardTarget;
        class_1309 rider;
        class_243 riderLook;
        class_1309 cp = this.method_5642();
        if (cp instanceof class_1309 && (riderLook = (rider = cp).method_5720()).method_1027() > 1.0E-6) {
            return riderLook.method_1029();
        }
        class_1309 target = this.method_5968();
        if (target != null && target.method_5805() && (towardTarget = (aimPoint = target.method_33571().method_1031(0.0, -0.25, 0.0)).method_1020(start)).method_1027() > 1.0E-6) {
            return towardTarget.method_1029();
        }
        class_243 fallbackDir = class_243.method_1030((float)this.method_36455(), (float)this.field_6241);
        return fallbackDir.method_1027() > 1.0E-6 ? fallbackDir.method_1029() : class_243.field_1353;
    }

    private class_243 clampBeamDirection(class_243 desiredDir) {
        float finalYaw;
        if (desiredDir == null || desiredDir.method_1027() < 1.0E-6) {
            this.updateBeamOffsets(null);
            return null;
        }
        class_243 dir = desiredDir.method_1029();
        float desiredYawDeg = (float)(Math.atan2(-dir.field_1352, dir.field_1350) * 57.29577951308232);
        float desiredPitchDeg = (float)(-Math.atan2(dir.field_1351, Math.sqrt(dir.field_1352 * dir.field_1352 + dir.field_1350 * dir.field_1350)) * 57.29577951308232);
        float headYaw = this.field_6241;
        float headPitch = this.method_36455();
        float yawErrDeg = class_3532.method_15381((float)headYaw, (float)desiredYawDeg);
        float pitchErrDeg = desiredPitchDeg - headPitch;
        float clampedYawErr = class_3532.method_15363((float)yawErrDeg, (float)-40.0f, (float)40.0f);
        float clampedPitchErr = class_3532.method_15363((float)pitchErrDeg, (float)-50.0f, (float)50.0f);
        float finalPitch = headPitch + clampedPitchErr;
        class_243 finalDir = class_243.method_1030((float)finalPitch, (float)(finalYaw = headYaw + clampedYawErr));
        return finalDir.method_1027() > 1.0E-6 ? finalDir.method_1029() : null;
    }

    private void resetBeamAim() {
        this.beamLookLerp = null;
        this.beamAimDir = null;
        this.beamYawOffsetRad = 0.0f;
        this.beamPitchOffsetRad = 0.0f;
    }

    private void updateBeamOffsets(@Nullable class_243 direction) {
        if (direction == null || direction.method_1027() < 1.0E-6) {
            this.beamYawOffsetRad = 0.0f;
            this.beamPitchOffsetRad = 0.0f;
            return;
        }
        class_243 dir = direction.method_1029();
        float finalYawDeg = (float)(Math.atan2(-dir.field_1352, dir.field_1350) * 57.29577951308232);
        float finalPitchDeg = (float)(-Math.atan2(dir.field_1351, Math.sqrt(dir.field_1352 * dir.field_1352 + dir.field_1350 * dir.field_1350)) * 57.29577951308232);
        float headYaw = this.field_6241;
        float headPitch = this.method_36455();
        float yawOffsetDeg = class_3532.method_15381((float)headYaw, (float)finalYawDeg);
        float pitchOffsetDeg = finalPitchDeg - headPitch;
        this.beamYawOffsetRad = yawOffsetDeg * ((float)Math.PI / 180);
        this.beamPitchOffsetRad = pitchOffsetDeg * ((float)Math.PI / 180);
    }

    private void tickClientSideUpdates() {
        if (this.method_37908().field_9236) {
            this.prevSitProgress = this.sitProgress;
            this.sitProgress = ((Float)this.field_6011.method_12789(DATA_SIT_PROGRESS)).floatValue();
            this.prevClientBeamEnd = this.clientBeamEnd;
            this.clientBeamEnd = this.getBeamEndPosition();
        }
    }

    private void tickRiderTakeoff() {
        if (!this.method_37908().field_9236 && this.riderTakeoffTicks > 0 && !this.isDying()) {
            --this.riderTakeoffTicks;
        }
    }

    private void tickPostLoadStabilization() {
        if (!this.method_37908().field_9236 && this.postLoadAirStabilizeTicks > 0) {
            if (!this.method_6581()) {
                this.setFlying(true);
            }
            if (!this.isTakeoff()) {
                this.setTakeoff(true);
            }
            this.setLanding(false);
            this.setHovering(true);
            this.switchToAirNavigation();
            this.timeFlying = Math.min(this.timeFlying, 5);
            this.landingFlag = false;
            this.landingTimer = 0;
            class_243 v = this.method_18798();
            if (v.field_1351 < 0.05) {
                this.method_18800(v.field_1352 * 0.95, Math.max(0.05, v.field_1351 + 0.02), v.field_1350 * 0.95);
            }
            --this.postLoadAirStabilizeTicks;
            if (this.postLoadAirStabilizeTicks == 0 && !this.method_6181() && !this.method_5782()) {
                this.setFlying(false);
                this.setTakeoff(false);
                this.setHovering(false);
                this.setLanding(true);
                this.switchToGroundNavigation();
                this.method_18799(this.method_18798().method_18805(0.5, -0.3, 0.5));
            }
        }
    }

    private void tickControllers() {
        if (!this.isDying()) {
            this.flightController.handleFlightLogic();
        }
        this.updateSittingProgress();
    }

    private void updateSittingProgress() {
        if (this.method_37908().field_9236) {
            return;
        }
        if (this.sitTransitionTicks > 0) {
            --this.sitTransitionTicks;
            if (this.sitTransitionTicks == 0) {
                this.isSittingDown = false;
                this.isStandingUp = false;
            }
        }
        if (this.method_24345()) {
            if ((this.sitProgress == 0.0f || this.isStandingUp) && !this.isSittingDown) {
                this.animationHandler.triggerSitDownAnimation();
                this.isSittingDown = true;
                this.isStandingUp = false;
                this.sitTransitionTicks = this.getSitDownAnimationTicks();
            }
            if (this.sitProgress < this.maxSitTicks()) {
                this.sitProgress += 1.0f;
                this.field_6011.method_12778(DATA_SIT_PROGRESS, (Object)Float.valueOf(this.sitProgress));
            }
        } else {
            if (!this.method_37908().field_9236 && super.method_6172()) {
                this.method_6179(false);
            }
            if (this.method_5782()) {
                if (this.sitProgress != 0.0f) {
                    this.sitProgress = 0.0f;
                    this.prevSitProgress = 0.0f;
                    this.field_6011.method_12778(DATA_SIT_PROGRESS, (Object)Float.valueOf(0.0f));
                    this.isSittingDown = false;
                    this.isStandingUp = false;
                    this.sitTransitionTicks = 0;
                }
            } else if (this.sitProgress > 0.0f) {
                if ((this.sitProgress == this.maxSitTicks() || this.isSittingDown) && !this.isStandingUp) {
                    this.animationHandler.triggerSitUpAnimation();
                    this.isStandingUp = true;
                    this.isSittingDown = false;
                    this.sitTransitionTicks = this.getSitUpAnimationTicks();
                }
                float decrementRate = this.maxSitTicks() / (float)this.getSitUpAnimationTicks();
                this.sitProgress -= decrementRate;
                if (this.sitProgress < 0.0f) {
                    this.sitProgress = 0.0f;
                }
                this.field_6011.method_12778(DATA_SIT_PROGRESS, (Object)Float.valueOf(this.sitProgress));
            }
        }
    }

    private void tickRiderControlLockMovement() {
        if (!this.areRiderControlsLocked()) {
            return;
        }
        if (this.method_5642() == null) {
            this.riderControlLockTicks = 0;
            return;
        }
        this.method_5942().method_6340();
        this.method_5980(null);
        this.method_18800(0.0, 0.0, 0.0);
    }

    private void tickFollowFailsafe() {
        double speed;
        class_1309 owner;
        if (this.followFailsafeCooldown > 0) {
            --this.followFailsafeCooldown;
            return;
        }
        this.followFailsafeCooldown = 20;
        if (this.isSleepLocked() || this.method_24345() || this.method_5765() || this.method_5782() || this.isDying()) {
            return;
        }
        if (this.getCommand() == 1 && !this.method_24345()) {
            this.setCommandAuto(0);
        }
        if ((owner = this.method_35057()) == null || !owner.method_5805()) {
            return;
        }
        if (owner.method_37908() != this.method_37908()) {
            return;
        }
        if (this.method_5968() != null && this.method_5968().method_5805()) {
            return;
        }
        if (this.method_6581()) {
            return;
        }
        double distSq = this.method_5858((class_1297)owner);
        if (distSq < 324.0) {
            if (!this.method_5942().method_23966() && this.getCommand() == 0 && !this.method_24345()) {
                this.method_5942().method_6335((class_1297)owner, 0.8);
            }
            return;
        }
        boolean moveGoalActive = this.field_6201.method_19048().anyMatch(wrapped -> {
            class_1352 goal = wrapped.method_19058();
            return goal instanceof RaevyxFollowOwnerGoal || goal instanceof RaevyxCombatGoal;
        });
        if (moveGoalActive) {
            return;
        }
        this.switchToGroundNavigation();
        boolean shouldRun = distSq > 625.0;
        this.setRunning(shouldRun);
        this.setGroundMoveStateFromAI(shouldRun ? 2 : 1);
        double d = speed = shouldRun ? 1.35 : 0.9;
        if (!this.method_5942().method_6335((class_1297)owner, speed)) {
            this.method_5942().method_6340();
            this.attemptOwnerTeleport(owner);
        }
    }

    private void attemptOwnerTeleport(class_1309 owner) {
        class_2338 ownerPos = owner.method_24515();
        for (int i = 0; i < 8; ++i) {
            int dz;
            int dx = this.field_5974.method_43048(7) - 3;
            class_2338 candidate = ownerPos.method_10069(dx, 0, dz = this.field_5974.method_43048(7) - 3);
            if (!this.isTeleportFriendlyBlock(candidate)) continue;
            this.method_5859((double)candidate.method_10263() + 0.5, candidate.method_10264(), (double)candidate.method_10260() + 0.5);
            this.method_5942().method_6340();
            return;
        }
    }

    private boolean isTeleportFriendlyBlock(class_2338 pos) {
        class_2338 below = pos.method_10074();
        class_2680 floor = this.method_37908().method_8320(below);
        class_2680 body = this.method_37908().method_8320(pos);
        class_2680 above = this.method_37908().method_8320(pos.method_10084());
        return floor.method_26216((class_1922)this.method_37908(), below) && body.method_26215() && above.method_26215();
    }

    private void tickSuperchargeTimer() {
        if (this.superchargeTicks > 0) {
            --this.superchargeTicks;
            if (this.superchargeTicks == 0) {
                Objects.requireNonNull(this.method_5996(class_5134.field_23716)).method_6192(180.0);
                if (this.method_6032() > this.method_6063()) {
                    this.method_6033(this.method_6063());
                }
                this.allowGroundBeamDuringStorm = false;
            }
        }
    }

    private void tickTempInvulnTimer() {
        if (this.tempInvulnTicks > 0) {
            --this.tempInvulnTicks;
            if (this.tempInvulnTicks == 0 && !this.isDying()) {
                this.method_5684(false);
            }
        }
    }

    private void tickSuperchargeVfx() {
        if ((this.isSupercharged() || this.method_37908().method_8546()) && this.superchargeVfxCooldown-- <= 0) {
            this.spawnSuperchargeVfx();
            this.superchargeVfxCooldown = 6 + this.field_5974.method_43048(6);
        }
    }

    private void tickSleepTransition() {
        if (this.isSleepingEntering() && !this.method_37908().field_9236 && this.getSitProgress() >= this.maxSitTicks() && this.sleepTransitionTicks == this.getFallAsleepAnimationTicks()) {
            this.animationHandler.triggerFallAsleepAnimation();
        }
        if (this.sleepTransitionTicks > 0) {
            --this.sleepTransitionTicks;
            if (this.sleepTransitionTicks == 0) {
                if (this.isSleepingEntering()) {
                    this.setSleeping(true);
                    this.setSleepingEntering(false);
                    this.animationHandler.triggerSleepAnimation();
                } else if (this.isSleepingExiting()) {
                    this.setSleepingExiting(false);
                    this.sleepAmbientCooldownTicks = 10;
                }
            }
        }
    }

    private void tickSleepCooldowns() {
        if (this.sleepAmbientCooldownTicks > 0) {
            --this.sleepAmbientCooldownTicks;
        }
        if (this.sleepReentryCooldownTicks > 0) {
            --this.sleepReentryCooldownTicks;
        }
        if (this.sleepCancelTicks > 0) {
            --this.sleepCancelTicks;
        }
    }

    private void tickBankingLogic() {
        this.prevBankAngle = this.bankAngle;
        if (this.areRiderControlsLocked() || !this.method_6581() || this.method_24345()) {
            if (this.bankDir != 0 || this.bankAngle != 0.0f || this.bankSmoothedYaw != 0.0f) {
                this.bankDir = 0;
                this.bankSmoothedYaw = 0.0f;
                this.bankHoldTicks = 0;
                this.bankAngle = 0.0f;
                this.prevBankAngle = 0.0f;
            }
            return;
        }
        float yawChange = class_3532.method_15393((float)(this.method_36454() - this.field_5982));
        this.bankSmoothedYaw = this.bankSmoothedYaw * 0.65f + yawChange * 0.35f;
        float targetAngle = class_3532.method_15363((float)(this.bankSmoothedYaw * 6.5f), (float)-90.0f, (float)90.0f);
        this.bankAngle = class_3532.method_16439((float)0.4f, (float)this.bankAngle, (float)targetAngle);
        if (Math.abs(this.bankAngle) < 0.01f) {
            this.bankAngle = 0.0f;
        }
        float enter = 10.0f;
        float exit = 4.0f;
        int desiredDir = this.bankDir;
        if (this.bankAngle > enter) {
            desiredDir = 1;
        } else if (this.bankAngle < -enter) {
            desiredDir = -1;
        } else if (Math.abs(this.bankAngle) < exit) {
            desiredDir = 0;
        }
        if (desiredDir != this.bankDir) {
            int holdTime;
            int n = holdTime = desiredDir == 0 ? 1 : 2;
            if (this.bankHoldTicks >= holdTime) {
                this.bankDir = desiredDir;
                this.bankHoldTicks = 0;
            } else {
                ++this.bankHoldTicks;
            }
        } else {
            this.bankHoldTicks = Math.min(this.bankHoldTicks + 1, 10);
        }
    }

    private void tickRiderLandingBlendTimer() {
        if (!this.method_5782() || !this.method_6581() || this.method_24828()) {
            this.riderLandingBlendTicks = 0;
            if (!this.method_37908().field_9236) {
                this.field_6011.method_12778(DATA_RIDER_LANDING_BLEND, (Object)false);
            }
            return;
        }
        if (this.riderLandingBlendTicks > 0) {
            --this.riderLandingBlendTicks;
            if (this.riderLandingBlendTicks == 0 && !this.method_37908().field_9236) {
                this.field_6011.method_12778(DATA_RIDER_LANDING_BLEND, (Object)false);
            }
        }
    }

    private void triggerRiderLandingBlend() {
        this.riderLandingBlendTicks = 5;
        if (!this.method_37908().field_9236) {
            this.field_6011.method_12778(DATA_RIDER_LANDING_BLEND, (Object)true);
        }
    }

    public boolean isRiderLandingBlendActive() {
        return (Boolean)this.field_6011.method_12789(DATA_RIDER_LANDING_BLEND);
    }

    private double getAltitudeAboveTerrain() {
        class_2338 pos = this.method_24515();
        if (!this.method_37908().method_22340(pos)) {
            return Double.POSITIVE_INFINITY;
        }
        int surfaceY = this.method_37908().method_8624(class_2902.class_2903.field_13197, pos.method_10263(), pos.method_10260());
        int groundY = this.method_37908().method_8624(class_2902.class_2903.field_13203, pos.method_10263(), pos.method_10260());
        int dragonY = (int)Math.floor(this.method_23318());
        int scanTopY = dragonY + 3;
        int scanBottomY = Math.min(groundY - 1, dragonY - 15);
        for (int y = scanTopY; y >= scanBottomY; --y) {
            class_2338 checkPos = new class_2338(pos.method_10263(), y, pos.method_10260());
            class_2680 checkState = this.method_37908().method_8320(checkPos);
            if (checkState.method_26227().method_15769()) continue;
            return Double.POSITIVE_INFINITY;
        }
        return this.method_23318() - (double)groundY;
    }

    private void tickPitchingLogic() {
        this.tickRiderLandingBlendTimer();
        if (this.areRiderControlsLocked() || !this.method_6581() || this.method_24345()) {
            if (this.pitchDir != 0) {
                this.pitchDir = 0;
                this.pitchSmoothedPitch = 0.0f;
                this.pitchHoldTicks = 0;
            }
            return;
        }
        int desiredDir = this.pitchDir;
        if (this.method_5782() && this.method_5642() instanceof class_1657) {
            double altitude;
            desiredDir = this.isGoingUp() ? -1 : (this.isGoingDown() ? 1 : 0);
            if (this.isGoingDown() && (altitude = this.getAltitudeAboveTerrain()) != Double.POSITIVE_INFINITY && altitude >= -0.25 && altitude <= 8.5) {
                desiredDir = 0;
                this.triggerRiderLandingBlend();
            }
        } else {
            float pitchChange = this.method_36455() - this.field_6004;
            this.pitchSmoothedPitch = this.pitchSmoothedPitch * 0.85f + pitchChange * 0.15f;
            float enter = 3.0f;
            float exit = 3.0f;
            if (this.pitchSmoothedPitch > enter) {
                desiredDir = 1;
            } else if (this.pitchSmoothedPitch < -enter) {
                desiredDir = -1;
            } else if (Math.abs(this.pitchSmoothedPitch) < exit) {
                desiredDir = 0;
            }
        }
        if (desiredDir != this.pitchDir) {
            int holdTime;
            int n = holdTime = desiredDir == 0 ? 1 : 2;
            if (this.pitchHoldTicks >= holdTime) {
                this.pitchDir = desiredDir;
                this.pitchHoldTicks = 0;
            } else {
                ++this.pitchHoldTicks;
            }
        } else {
            this.pitchHoldTicks = Math.min(this.pitchHoldTicks + 1, 20);
        }
    }

    protected void method_6013(@Nonnull class_1282 source) {
    }

    @Override
    protected DragonAbilityType<?, ?> getHurtAbilityType() {
        return this.method_6109() ? RaevyxAbilities.BABY_HURT : RaevyxAbilities.HURT;
    }

    @Override
    protected void onSuccessfulDamage(class_1282 source, float amount) {
        if (this.isDying()) {
            return;
        }
        if (this.hurtSoundCooldown > 0) {
            return;
        }
        super.onSuccessfulDamage(source, amount);
        this.hurtSoundCooldown = this.method_5782() ? 15 : 8;
    }

    private void playCustomAmbientSound() {
        if (this.method_6109()) {
            return;
        }
        class_5819 random = this.method_6051();
        if (this.isDying() || this.method_6510() || this.isBeaming() || this.getActiveAbility() != null) {
            return;
        }
        String vocalKey = null;
        if (this.method_24345()) {
            vocalKey = random.method_43057() < 0.6f ? "content" : "purr";
        } else if (this.method_6581()) {
            if (random.method_43057() < 0.3f) {
                vocalKey = "chuff";
            }
        } else {
            float grumbleChance;
            vocalKey = !(this.method_6581() || this.isTakeoff() || this.isLanding() || this.isHovering() || !this.isWalking() && !this.isRunning()) ? (this.isRunning() ? "snort" : "chuff") : ((grumbleChance = random.method_43057()) < 0.4f ? "grumble1" : (grumbleChance < 0.7f ? "grumble2" : (grumbleChance < 0.9f ? "grumble3" : "purr")));
        }
        if (vocalKey != null) {
            this.getSoundHandler().playVocal(vocalKey);
        }
    }

    private void handleAmbientSounds() {
        if (this.method_6109() || this.isDying() || this.method_6113() || this.isSleepTransitioning() || this.isInSitTransition() || this.sleepAmbientCooldownTicks > 0) {
            return;
        }
        ++this.ambientSoundTimer;
        if (this.ambientSoundTimer >= this.nextAmbientSoundDelay) {
            this.playCustomAmbientSound();
            this.resetAmbientSoundTimer();
        }
    }

    private void suppressAmbientSounds(int ticks) {
        this.sleepAmbientCooldownTicks = Math.max(this.sleepAmbientCooldownTicks, ticks);
        this.ambientSoundTimer = 0;
        this.nextAmbientSoundDelay = Math.max(this.nextAmbientSoundDelay, ticks);
    }

    private void resetAmbientSoundTimer() {
        class_5819 random = this.method_6051();
        this.ambientSoundTimer = 0;
        this.nextAmbientSoundDelay = 200 + random.method_43048(400);
    }

    public void playExcitedSound() {
        this.getSoundHandler().playVocal("excited");
    }

    public void playAnnoyedSound() {
        this.getSoundHandler().playVocal("annoyed");
    }

    private void handleDodgeMovement() {
        class_243 current = this.method_18798();
        class_243 boosted = current.method_1019(this.dodgeVec.method_1021(0.25));
        this.method_18799(boosted.method_18805(0.92, 0.95, 0.92));
        this.field_6007 = true;
        if (--this.dodgeTicksLeft <= 0) {
            this.dodging = false;
            this.dodgeVec = class_243.field_1353;
        }
    }

    @Override
    public void method_6091(@NotNull class_243 motion) {
        class_1309 class_13092;
        boolean sittingLocked;
        boolean bl = sittingLocked = (this.method_24345() || this.method_6172()) && this.postStandUnlockTicks <= 0;
        if (sittingLocked || this.isDodging() || this.isDying() || this.method_6113() || this.isSleepTransitioning()) {
            if (this.method_5942().method_6345() != null) {
                this.method_5942().method_6340();
            }
            motion = class_243.field_1353;
            super.method_6091(motion);
            return;
        }
        if (this.dodging) {
            super.method_6091(motion);
            return;
        }
        if (this.method_5782() && (class_13092 = this.method_5642()) instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            if (this.method_5942().method_6345() != null) {
                this.method_5942().method_6340();
            }
            if (this.method_6581()) {
                this.riderController.handleRiderMovement(player, motion);
            } else {
                super.method_6091(motion);
            }
        } else if (this.method_6581()) {
            this.flightController.handleFlightTravel(motion);
        } else {
            super.method_6091(motion);
        }
    }

    public void method_7105(@Nonnull class_1309 target, float distanceFactor) {
    }

    public boolean isFlightControllerStuck() {
        class_1335 class_13352 = this.field_6207;
        if (class_13352 instanceof DragonFlightMoveHelper) {
            DragonFlightMoveHelper flightHelper = (DragonFlightMoveHelper)class_13352;
            return flightHelper.hasGivenUp();
        }
        return false;
    }

    public static boolean canSpawnHere(class_1299<Raevyx> type, class_1936 level, class_3730 reason, class_2338 pos, class_5819 random) {
        class_2338 below = pos.method_10074();
        if (!level.method_8316(pos).method_15769()) {
            return false;
        }
        if (!level.method_8316(below).method_15769()) {
            return false;
        }
        boolean solidGround = level.method_8320(below).method_26206((class_1922)level, below, class_2350.field_11036);
        boolean feetFree = level.method_8320(pos).method_26220((class_1922)level, pos).method_1110();
        boolean headFree = level.method_8320(pos.method_10084()).method_26220((class_1922)level, pos.method_10084()).method_1110();
        return solidGround && feetFree && headFree;
    }

    @Override
    @Nullable
    public class_1315 method_5943(@Nonnull class_5425 level, @Nonnull class_1266 difficulty, @Nonnull class_3730 spawnReason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        spawnData = super.method_5943(level, difficulty, spawnReason, (class_1315)spawnData, dataTag);
        if (spawnReason == class_3730.field_16472 && (spawnData == null || !(spawnData instanceof RaevyxFamilyData)) && this.field_5974.method_43057() < 0.6f) {
            spawnData = new RaevyxFamilyData(false);
            this.shouldSpawnBabies = true;
            this.babiesToSpawn = 2 + this.field_5974.method_43048(2);
        }
        return spawnData;
    }

    private void spawnBabiesIfNeeded() {
        if (!this.shouldSpawnBabies || this.babiesToSpawn <= 0) {
            return;
        }
        this.shouldSpawnBabies = false;
        for (int i = 0; i < this.babiesToSpawn; ++i) {
            Raevyx baby = (Raevyx)ModEntities.RAEVYX.get().method_5883(this.method_37908());
            if (baby == null) continue;
            baby.method_7217(true);
            baby.method_5614(-24000);
            baby.setGender(this.field_5974.method_43056() ? DragonGender.FEMALE : DragonGender.MALE);
            double angle = Math.PI * 2 * (double)i / (double)this.babiesToSpawn;
            double distance = 1.0 + this.field_5974.method_43058() * 0.5;
            double offsetX = Math.cos(angle) * distance;
            double offsetZ = Math.sin(angle) * distance;
            baby.method_5808(this.method_23317() + offsetX, this.method_23318(), this.method_23321() + offsetZ, this.field_5974.method_43057() * 360.0f, 0.0f);
            this.method_37908().method_8649((class_1297)baby);
        }
        this.babiesToSpawn = 0;
    }

    public int method_5978() {
        return this.isBeaming() ? 50 : 180;
    }

    public int method_5986() {
        return this.isBeaming() ? 40 : 180;
    }

    public int method_20240() {
        return this.isBeaming() ? 90 : 180;
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new RaevyxDodgeGoal(this));
        this.field_6201.method_6277(5, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(6, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(7, (class_1352)new RaevyxFollowParentGoal(this, 1.15));
        this.field_6201.method_6277(7, (class_1352)new RaevyxBreedGoal(this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new RaevyxCombatGoal(this));
        this.field_6201.method_6277(0, (class_1352)new RaevyxSleepGoal(this));
        this.field_6201.method_6277(1, (class_1352)new RaevyxRestGoal(this));
        this.field_6201.method_6277(8, (class_1352)new RaevyxFollowOwnerGoal(this));
        this.field_6201.method_6277(9, (class_1352)new RaevyxGroundWanderGoal(this, 1.0, 60));
        this.field_6201.method_6277(10, (class_1352)new RaevyxTemptGoal(this, 1.2, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8209, class_1802.field_8429, class_1802.field_8323}), false));
        this.field_6201.method_6277(11, (class_1352)new RaevyxFlightGoal(this));
        this.field_6201.method_6277(12, (class_1352)new class_1376((class_1308)this){

            public boolean method_6264() {
                return !Raevyx.this.method_5782() && super.method_6264();
            }
        });
        this.field_6201.method_6277(12, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f){

            public boolean method_6264() {
                return !Raevyx.this.method_5782() && super.method_6264();
            }
        });
        this.field_6185.method_6277(1, (class_1352)new DragonOwnerHurtByTargetGoal(this));
        this.field_6185.method_6277(2, (class_1352)new DragonOwnerHurtTargetGoal(this));
        this.field_6185.method_6277(3, (class_1352)new RaevyxProtectBabiesGoal(this));
        this.field_6185.method_6277(4, (class_1352)new class_1399((class_1314)this, new Class[0]));
    }

    @Override
    public boolean method_5643(@Nonnull class_1282 damageSource, float amount) {
        DragonAbilityType<Raevyx, DieAbility<Raevyx>> dieAbility;
        if (this.isDying()) {
            if (damageSource.method_49708(class_8111.field_44869)) {
                return super.method_5643(damageSource, amount);
            }
            return false;
        }
        if (damageSource.method_49708(class_8111.field_42336)) {
            return false;
        }
        if (this.method_6113() || this.isSleepingEntering() || this.isSleepingExiting()) {
            this.wakeUpImmediately();
            this.suppressSleep(200);
        }
        if (damageSource.method_49708(class_8111.field_42345)) {
            return false;
        }
        DragonAbilityType<Raevyx, DieAbility<Raevyx>> dragonAbilityType = dieAbility = this.method_6109() ? RaevyxAbilities.BABY_DIE : RaevyxAbilities.DIE;
        if (this.handleLethalDamage(damageSource, amount, dieAbility)) {
            return true;
        }
        boolean wasFlying = this.method_6581();
        boolean wasRidden = this.method_5782();
        boolean result = super.method_5643(damageSource, amount);
        if (result && wasRidden && wasFlying && this.method_5782()) {
            this.setFlying(true);
            this.setLanding(false);
            this.switchToAirNavigation();
        }
        return result;
    }

    public int method_5748() {
        return 3600;
    }

    public int method_6064(int currentAir) {
        int refillPerTick = 50;
        return Math.min(this.method_5748(), currentAir + refillPerTick);
    }

    public void method_5800(@Nonnull class_3218 level, @Nonnull class_1538 lightning) {
        if (this.method_5809()) {
            this.method_5646();
        }
    }

    public int getBankDirection() {
        return this.bankDir;
    }

    public float getBankAngleDegrees() {
        return this.bankAngle;
    }

    public float getBankAngleDegrees(float partialTick) {
        return class_3532.method_16439((float)partialTick, (float)this.prevBankAngle, (float)this.bankAngle);
    }

    public int getPitchDirection() {
        return this.pitchDir;
    }

    public boolean isSummoning() {
        return false;
    }

    public void startSupercharge(int ticks) {
        boolean wasNotSupercharged = !this.isSupercharged();
        this.superchargeTicks = Math.max(this.superchargeTicks, Math.max(0, ticks));
        if (wasNotSupercharged && this.isSupercharged()) {
            Objects.requireNonNull(this.method_5996(class_5134.field_23716)).method_6192(360.0);
            this.method_6033(this.method_6063());
            this.allowGroundBeamDuringStorm = true;
        }
    }

    public boolean isSupercharged() {
        return this.superchargeTicks > 0;
    }

    public float getDamageMultiplier() {
        return this.isSupercharged() ? 2.0f : 1.0f;
    }

    public void startTemporaryInvuln(int ticks) {
        this.tempInvulnTicks = Math.max(this.tempInvulnTicks, Math.max(0, ticks));
        this.method_5684(true);
    }

    private void spawnSuperchargeVfx() {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 server = (class_3218)class_19372;
        class_243 center = this.method_19538().method_1031(0.0, (double)this.method_17682() * 0.6, 0.0);
        double radius = Math.max(this.method_5829().method_17939(), this.method_5829().method_17941()) * 0.55;
        int bursts = 2 + this.field_5974.method_43048(3);
        for (int i = 0; i < bursts; ++i) {
            class_243 dir = Raevyx.randomUnit(this.field_5974);
            double length = 0.4 + this.field_5974.method_43058() * 0.7;
            class_243 offset = Raevyx.randomUnit(this.field_5974).method_1021(radius * 0.35);
            class_243 from = center.method_1019(offset);
            class_243 to = from.method_1019(dir.method_1021(length));
            float size = 0.5f + this.field_5974.method_43057() * 0.25f;
            this.emitMicroArc(server, from, to, size);
        }
        server.method_14199((class_2394)class_2398.field_29644, center.field_1352, center.field_1351, center.field_1350, 3, radius * 0.15, radius * 0.15, radius * 0.15, 0.0);
    }

    private void emitMicroArc(class_3218 server, class_243 from, class_243 to, float size) {
        class_243 delta = to.method_1020(from);
        int steps = 2 + this.field_5974.method_43048(3);
        class_243 step = delta.method_1021(1.0 / (double)steps);
        class_243 pos = from;
        class_243 dir = step.method_1027() > 1.0E-6 ? step.method_1029() : Raevyx.randomUnit(this.field_5974);
        boolean female = this.isFemale();
        for (int i = 0; i <= steps; ++i) {
            if (this.field_5974.method_43057() < 0.7f) {
                server.method_14199((class_2394)new RaevyxLightningStormData(size, female), pos.field_1352, pos.field_1351, pos.field_1350, 1, dir.field_1352, dir.field_1351, dir.field_1350, 0.0);
            }
            pos = pos.method_1019(step);
        }
    }

    private static class_243 randomUnit(class_5819 rnd) {
        double u = rnd.method_43058();
        double v = rnd.method_43058();
        double theta = Math.PI * 2 * u;
        double z = 2.0 * v - 1.0;
        double r = Math.sqrt(1.0 - z * z);
        return new class_243(r * Math.cos(theta), z, r * Math.sin(theta));
    }

    public boolean isInSitTransition() {
        return this.isSittingDown || this.isStandingUp;
    }

    public boolean isSittingDownAnimation() {
        return this.isSittingDown;
    }

    public boolean isStandingUpAnimation() {
        return this.isStandingUp;
    }

    private int getSitDownAnimationTicks() {
        return 30;
    }

    private int getSitUpAnimationTicks() {
        return 20;
    }

    private int getFallAsleepAnimationTicks() {
        return 50;
    }

    private int getWakeUpAnimationTicks() {
        return 53;
    }

    @Override
    public float maxSitTicks() {
        return 30.0f;
    }

    @Override
    public boolean method_6113() {
        return this.getBooleanData(DATA_SLEEPING);
    }

    public void setSleeping(boolean sleeping) {
        this.setBooleanData(DATA_SLEEPING, sleeping);
    }

    @Override
    public boolean isSleepTransitioning() {
        return this.isSleepingEntering() || this.isSleepingExiting();
    }

    public boolean isSleepingEntering() {
        return this.getBooleanData(DATA_SLEEPING_ENTERING);
    }

    public void setSleepingEntering(boolean entering) {
        this.setBooleanData(DATA_SLEEPING_ENTERING, entering);
    }

    public boolean isSleepingExiting() {
        return this.getBooleanData(DATA_SLEEPING_EXITING);
    }

    public void setSleepingExiting(boolean exiting) {
        this.setBooleanData(DATA_SLEEPING_EXITING, exiting);
    }

    public boolean isSleepLocked() {
        return this.sleepLocked || this.method_6113() || this.isSleepingEntering() || this.isSleepingExiting();
    }

    private void enterSleepLock() {
        int snapshot = this.getCommand();
        if (!this.sleepLocked) {
            this.sleepLocked = true;
            this.sleepCommandSnapshot = snapshot;
        }
        if (snapshot == 1) {
            this.setCommandManual(1);
        } else {
            this.setCommandAuto(1);
        }
        this.method_24346(true);
        this.method_5942().method_6340();
        this.method_5980(null);
        this.setRunning(false);
        this.setGroundMoveStateFromAI(0);
        this.method_18799(class_243.field_1353);
        this.setFlying(false);
        this.setLanding(false);
        this.setTakeoff(false);
        this.setHovering(false);
    }

    private void releaseSleepLock() {
        if (this.sleepLocked) {
            int desired = this.sleepCommandSnapshot;
            this.sleepCommandSnapshot = -1;
            this.sleepLocked = false;
            if (desired == 1) {
                this.setCommandManual(1);
                this.method_24346(true);
            } else {
                this.setCommandAuto(desired);
                this.method_24346(false);
            }
        }
        this.method_5942().method_6340();
        this.setRunning(false);
        this.setGroundMoveStateFromAI(0);
    }

    @Override
    public void startSleepEnter() {
        if (this.method_6113() || this.isSleepingEntering() || this.isSleepingExiting()) {
            return;
        }
        this.setSleepingEntering(true);
        this.sleepTransitionTicks = this.getFallAsleepAnimationTicks();
        this.animationHandler.triggerSitDownAnimation();
        if (!this.method_37908().field_9236) {
            this.enterSleepLock();
        }
    }

    @Override
    public void startSleepExit() {
        if (!this.method_6113() && !this.isSleepingEntering() || this.isSleepingExiting()) {
            return;
        }
        this.field_6011.method_12778(DATA_SLEEPING, (Object)false);
        this.setSleepingEntering(false);
        this.setSleepingExiting(true);
        this.sleepTransitionTicks = this.getWakeUpAnimationTicks();
        this.animationHandler.triggerWakeUpAnimation();
        if (!this.method_37908().field_9236) {
            this.suppressSleep(20);
            this.releaseSleepLock();
        }
    }

    public void wakeUpImmediately() {
        this.field_6011.method_12778(DATA_SLEEPING, (Object)false);
        this.setSleepingEntering(false);
        this.setSleepingExiting(false);
        this.sleepTransitionTicks = 0;
        this.sleepCancelTicks = 2;
        if (!this.method_37908().field_9236) {
            this.suppressSleep(20);
            this.releaseSleepLock();
        }
    }

    public void suppressSleep(int ticks) {
        this.sleepReentryCooldownTicks = Math.max(this.sleepReentryCooldownTicks, ticks);
    }

    @Override
    public boolean isSleepSuppressed() {
        return this.sleepReentryCooldownTicks > 0;
    }

    @Override
    @NotNull
    public class_1269 method_5992(@NotNull class_1657 player, @NotNull class_1268 hand) {
        class_1269 result = this.lightningInteractionHandler.handleInteraction(player, hand);
        if (result == class_1269.field_5811) {
            return super.method_5992(player, hand);
        }
        return result;
    }

    public void method_24346(boolean sitting) {
        super.method_24346(sitting);
        if (sitting) {
            if (this.method_6581()) {
                this.setLanding(true);
            }
            this.setRunning(false);
            this.method_5942().method_6340();
        } else {
            if (!this.method_37908().field_9236) {
                this.switchToGroundNavigation();
                if (this.method_6581()) {
                    this.setFlying(false);
                }
                this.setTakeoff(false);
                this.setLanding(false);
                this.setHovering(false);
                this.usingAirNav = false;
                this.postStandUnlockTicks = Math.max(this.postStandUnlockTicks, 20);
            }
            if (this.getCommand() == 1) {
                this.setCommandAuto(0);
            }
            if (!this.method_37908().field_9236) {
                this.followFailsafeCooldown = 0;
                this.method_5942().method_6340();
                this.tickFollowFailsafe();
            }
        }
    }

    public void method_5711(byte eventId) {
        if (eventId == 6) {
            if (this.method_37908().field_9236) {
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.field_5974.method_43059() * 0.02;
                    double d1 = this.field_5974.method_43059() * 0.02;
                    double d2 = this.field_5974.method_43059() * 0.02;
                    this.method_37908().method_8406((class_2394)class_2398.field_11251, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d0, d1, d2);
                }
            }
        } else if (eventId == 7) {
            if (this.method_37908().field_9236) {
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.field_5974.method_43059() * 0.02;
                    double d1 = this.field_5974.method_43059() * 0.02;
                    double d2 = this.field_5974.method_43059() * 0.02;
                    this.method_37908().method_8406((class_2394)class_2398.field_11201, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d0, d1, d2);
                }
            }
        } else {
            super.method_5711(eventId);
        }
    }

    public boolean method_6481(@Nonnull class_1799 stack) {
        return stack.method_31574(class_1802.field_8209) || stack.method_31574(class_1802.field_8429);
    }

    @Override
    public void method_5652(@NotNull class_2487 tag) {
        super.method_5652(tag);
        this.saveRideableData(tag);
        tag.method_10569("TimeFlying", this.timeFlying);
        tag.method_10556("UsingAirNav", this.usingAirNav);
        tag.method_10569("RiderTakeoffTicks", this.riderTakeoffTicks);
        tag.method_10544("LastLandingGameTime", this.lastLandingGameTime);
        tag.method_10556("LandingFlag", this.landingFlag);
        tag.method_10569("LandingTimer", this.landingTimer);
        this.combatManager.saveToNBT(tag);
        tag.method_10569("SuperchargeTicks", Math.max(0, this.superchargeTicks));
        tag.method_10569("TempInvulnTicks", Math.max(0, this.tempInvulnTicks));
        tag.method_10556("AllowGroundBeamStorm", this.allowGroundBeamDuringStorm);
        tag.method_10556("Sleeping", this.method_6113());
        tag.method_10569("SleepTransitionTicks", Math.max(0, this.sleepTransitionTicks));
        tag.method_10569("SleepAmbientCooldownTicks", Math.max(0, this.sleepAmbientCooldownTicks));
        tag.method_10569("SleepReentryCooldownTicks", Math.max(0, this.sleepReentryCooldownTicks));
        tag.method_10569("SleepCancelTicks", Math.max(0, this.sleepCancelTicks));
        tag.method_10556("SleepLock", this.sleepLocked);
        tag.method_10569("SleepCommandSnapshot", this.sleepCommandSnapshot);
        tag.method_10556("ManualSitCommand", this.manualSitCommand);
        this.restManager.save(tag);
        this.animationController.writeToNBT(tag);
    }

    @Override
    public void method_5749(@NotNull class_2487 tag) {
        super.method_5749(tag);
        this.loadRideableData(tag);
        this.timeFlying = tag.method_10550("TimeFlying");
        this.usingAirNav = tag.method_10577("UsingAirNav");
        this.riderTakeoffTicks = tag.method_10545("RiderTakeoffTicks") ? tag.method_10550("RiderTakeoffTicks") : 0;
        this.lastLandingGameTime = tag.method_10545("LastLandingGameTime") ? tag.method_10537("LastLandingGameTime") : Long.MIN_VALUE;
        this.landingFlag = tag.method_10545("LandingFlag") && tag.method_10577("LandingFlag");
        this.landingTimer = tag.method_10545("LandingTimer") ? tag.method_10550("LandingTimer") : 0;
        this.riderControlLockTicks = 0;
        this.takeoffLockTicks = 0;
        this.combatManager.loadFromNBT(tag);
        if (tag.method_10545("SuperchargeTicks")) {
            this.superchargeTicks = Math.max(0, tag.method_10550("SuperchargeTicks"));
        }
        if (tag.method_10545("TempInvulnTicks")) {
            this.tempInvulnTicks = Math.max(0, tag.method_10550("TempInvulnTicks"));
            if (this.tempInvulnTicks > 0) {
                this.method_5684(true);
            }
        }
        if (tag.method_10545("AllowGroundBeamStorm")) {
            this.allowGroundBeamDuringStorm = tag.method_10577("AllowGroundBeamStorm");
        }
        if (tag.method_10545("Sleeping")) {
            this.setSleeping(tag.method_10577("Sleeping"));
        }
        this.sleepTransitionTicks = Math.max(0, tag.method_10550("SleepTransitionTicks"));
        this.sleepAmbientCooldownTicks = Math.max(0, tag.method_10550("SleepAmbientCooldownTicks"));
        this.sleepReentryCooldownTicks = Math.max(0, tag.method_10550("SleepReentryCooldownTicks"));
        this.sleepCancelTicks = Math.max(0, tag.method_10550("SleepCancelTicks"));
        this.sleepLocked = tag.method_10577("SleepLock");
        this.sleepCommandSnapshot = tag.method_10550("SleepCommandSnapshot");
        this.restManager.load(tag);
        DragonRestState restState = this.restManager.getCurrentState();
        switch (restState) {
            case SLEEPING: {
                this.method_24346(true);
                this.animationHandler.triggerSleepAnimation();
                break;
            }
            case SITTING_DOWN: 
            case SITTING: 
            case SITTING_AFTER: {
                this.method_24346(true);
                break;
            }
            case FALLING_ASLEEP: {
                this.method_24346(true);
                this.startSleepEnter();
                break;
            }
            case WAKING_UP: {
                this.method_24346(true);
                this.startSleepExit();
                break;
            }
            case STANDING_UP: {
                this.method_24346(false);
            }
        }
        this.animationController.readFromNBT(tag);
        boolean bl = this.manualSitCommand = tag.method_10545("ManualSitCommand") && tag.method_10577("ManualSitCommand");
        if (this.usingAirNav) {
            this.switchToAirNavigation();
        } else {
            this.switchToGroundNavigation();
        }
        if (this.getCommand() != 1 && this.method_24345()) {
            this.method_24346(false);
        }
        if (this.sleepLocked || this.isSleepingEntering() || this.isSleepingExiting() || ((Boolean)this.field_6011.method_12789(DATA_SLEEPING)).booleanValue()) {
            this.releaseSleepLock();
            this.wakeUpImmediately();
            this.suppressSleep(200);
        }
        this.setSleepingEntering(false);
        this.setSleepingExiting(false);
        this.sleepTransitionTicks = 0;
        this.field_6011.method_12778(DATA_SLEEPING, (Object)false);
        this.sleepCommandSnapshot = -1;
        this.followFailsafeCooldown = 0;
        if (tag.method_10577("Flying")) {
            this.postLoadAirStabilizeTicks = 60;
            this.riderTakeoffTicks = Math.max(this.riderTakeoffTicks, 40);
            if (!this.method_37908().field_9236) {
                this.flightController.shouldTakeoff();
                this.setFlying(true);
                this.setTakeoff(true);
                this.setHovering(true);
                this.setLanding(false);
                this.switchToAirNavigation();
            }
        }
        if (this.method_24345()) {
            this.method_5942().method_6340();
            this.method_5980(null);
            this.method_19540(false);
        }
        if (this.getCommand() == 1 && !this.manualSitCommand) {
            this.setCommandAuto(0);
            this.method_24346(false);
        }
    }

    public int getRiderTakeoffTicks() {
        return this.riderTakeoffTicks;
    }

    public void setRiderTakeoffTicks(int ticks) {
        this.riderTakeoffTicks = Math.max(0, ticks);
    }

    public void clearAllStatesForMounting() {
        this.method_5980(null);
        this.setBeaming(false);
        this.setRunning(false);
        this.method_5942().method_6340();
        this.setTakeoff(false);
        this.setLanding(false);
        this.setHovering(false);
        if (this.method_24345()) {
            this.method_24346(false);
            if (this.getCommand() == 1) {
                this.setCommandAuto(0);
            }
        }
        this.riderTakeoffTicks = 0;
        this.postLoadAirStabilizeTicks = 0;
        this.combatManager.clearAllStates();
        this.sleepReentryCooldownTicks = 0;
        this.sleepAmbientCooldownTicks = 0;
    }

    public void triggerDodgeAnimation() {
        this.animationHandler.triggerDodgeAnimation();
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController movementController = new AnimationController((GeoAnimatable)this, "movement", 5, this.animationController::handleMovementAnimation);
        AnimationController actionController = new AnimationController((GeoAnimatable)this, "action", 2, state -> PlayState.STOP);
        movementController.setSoundKeyframeHandler(this::onAnimationSound);
        actionController.setSoundKeyframeHandler(this::onAnimationSound);
        this.animationHandler.setupActionController((AnimationController<Raevyx>)actionController);
        AnimationController HurtController = new AnimationController((GeoAnimatable)this, "hurt", 3, state -> PlayState.STOP);
        HurtController.triggerableAnim("raevyx_hurt", RawAnimation.begin().thenPlay("animation.raevyx.hurt"));
        HurtController.triggerableAnim("baby_raevyx_hurt", RawAnimation.begin().thenPlay("animation.raevyx.hurt"));
        HurtController.setSoundKeyframeHandler(this::onAnimationSound);
        controllers.add(new AnimationController[]{HurtController});
        if (!this.method_6109()) {
            AnimationController bankingController = new AnimationController((GeoAnimatable)this, "banking", 8, this.animationHandler::bankingPredicate);
            AnimationController pitchingController = new AnimationController((GeoAnimatable)this, "pitching", 6, this.animationHandler::pitchingPredicate);
            controllers.add(new AnimationController[]{bankingController});
            controllers.add(new AnimationController[]{pitchingController});
        }
        controllers.add(new AnimationController[]{movementController});
        controllers.add(new AnimationController[]{actionController});
    }

    @Override
    public Map<String, DragonEntity.VocalEntry> getVocalEntries() {
        return VOCAL_ENTRIES;
    }

    @Override
    public DragonSoundProfile getSoundProfile() {
        return RaevyxSoundProfile.INSTANCE;
    }

    @Override
    public DragonAbilityType<?, ?> getPrimaryAttackAbility() {
        return this.getMeleeMode() == 0 ? RaevyxAbilities.RAEVYX_BITE : RaevyxAbilities.RAEVYX_HORN_GORE;
    }

    @Override
    public DragonAbilityType<?, ?> getRoaringAbility() {
        return RaevyxAbilities.RAEVYX_ROAR;
    }

    @Override
    public DragonAbilityType<?, ?> getChannelingAbility() {
        return RaevyxAbilities.RAEVYX_SUMMON_STORM;
    }

    public void onAnimationSound(SoundKeyframeEvent<Raevyx> event) {
        this.getSoundHandler().handleAnimationSound(this, event.getKeyframeData(), event.getController());
    }

    public double getCachedDistanceToOwner() {
        int currentTick = this.field_6012;
        if (currentTick - this.ownerDistanceCacheTime >= 3) {
            class_1309 owner = this.method_35057();
            this.cachedOwnerDistance = owner != null ? this.method_5858((class_1297)owner) : Double.MAX_VALUE;
            this.ownerDistanceCacheTime = currentTick;
        }
        return this.cachedOwnerDistance;
    }

    public List<class_1676> getCachedNearbyProjectiles() {
        if (!(this.method_37908() instanceof class_3218)) {
            return Collections.emptyList();
        }
        if (this.field_6012 - this.nearbyProjectilesCacheTime >= this.projectileCacheIntervalTicks) {
            List<class_1676> found = DragonMathUtil.getEntitiesNearby((class_1297)this, class_1676.class, 30.0);
            this.cachedNearbyProjectiles = found;
            this.nearbyProjectilesCacheTime = this.field_6012;
            if (found.isEmpty()) {
                this.emptyProjectileScans = Math.min(this.emptyProjectileScans + 1, 4);
                this.projectileCacheIntervalTicks = 3 + this.emptyProjectileScans * 2;
            } else {
                this.emptyProjectileScans = 0;
                this.projectileCacheIntervalTicks = 3;
            }
        }
        return this.cachedNearbyProjectiles;
    }

    @Override
    public boolean areRiderControlsLocked() {
        return this.method_37908().field_9236 ? (Boolean)this.field_6011.method_12789(DATA_RIDER_LOCKED) : this.riderControlLockTicks > 0;
    }

    private void tickRiderControlLock() {
        if (this.riderControlLockTicks > 0) {
            --this.riderControlLockTicks;
            if (this.riderControlLockTicks <= 0) {
                this.field_6011.method_12778(DATA_RIDER_LOCKED, (Object)false);
            }
        }
    }

    public void lockRiderControls(int ticks) {
        this.riderControlLockTicks = Math.max(this.riderControlLockTicks, Math.max(0, ticks));
        this.field_6011.method_12778(DATA_RIDER_LOCKED, (Object)true);
        this.setAccelerating(false);
        this.setGoingUp(false);
        this.setGoingDown(false);
        this.method_18799(class_243.field_1353);
        if (!this.method_37908().field_9236) {
            this.method_5942().method_6340();
            this.method_5980(null);
        }
    }

    public boolean isTakeoffLocked() {
        return this.takeoffLockTicks > 0;
    }

    public void lockTakeoff(int ticks) {
        this.takeoffLockTicks = Math.max(this.takeoffLockTicks, Math.max(0, ticks));
    }

    private void tickTakeoffLock() {
        if (this.takeoffLockTicks > 0) {
            --this.takeoffLockTicks;
        }
    }

    public void noteAggroFrom(class_1309 target) {
        if (target == null || target.method_37908().field_9236) {
            return;
        }
        this.recentAggroIds.put(target.method_5628(), this.method_37908().method_8510() + 200L);
    }

    public List<class_1309> getRecentAggro() {
        ArrayList<class_1309> out = new ArrayList<class_1309>();
        long now = this.method_37908().method_8510();
        Iterator<Map.Entry<Integer, Long>> it = this.recentAggroIds.entrySet().iterator();
        while (it.hasNext()) {
            class_1309 le;
            Map.Entry<Integer, Long> e = it.next();
            if (e.getValue() < now) {
                it.remove();
                continue;
            }
            class_1297 ent = this.method_37908().method_8469(e.getKey().intValue());
            if (ent instanceof class_1309 && (le = (class_1309)ent).method_5805()) {
                out.add(le);
                continue;
            }
            it.remove();
        }
        return out;
    }

    public float method_18381(@Nonnull class_4050 pose) {
        class_4048 dimensions = this.method_18377(pose);
        return dimensions.field_18068 * 0.6f;
    }

    protected float method_18394(@Nonnull class_4050 pose, @Nonnull class_4048 dimensions) {
        return dimensions.field_18068 * 0.6f;
    }

    public class_4048 method_18377(@Nonnull class_4050 pose) {
        class_4048 baseDimensions = super.method_18377(pose);
        if (this.method_6109()) {
            return baseDimensions.method_18383(0.4f);
        }
        return baseDimensions;
    }

    public void method_5619() {
        super.method_5619();
        this.method_18382();
    }

    @Override
    public double getCachedHorizontalSpeed() {
        if (this.field_6012 != this.horizontalSpeedCacheTime) {
            class_243 velocity = this.method_18798();
            this.cachedHorizontalSpeed = Math.sqrt(velocity.field_1352 * velocity.field_1352 + velocity.field_1350 * velocity.field_1350);
            this.horizontalSpeedCacheTime = this.field_6012;
        }
        return this.cachedHorizontalSpeed;
    }

    public boolean method_6474(@Nonnull class_1429 otherAnimal) {
        if (!this.method_19184()) {
            return false;
        }
        if (otherAnimal instanceof Raevyx) {
            Raevyx otherDragon = (Raevyx)otherAnimal;
            if (this.isFemale() == otherDragon.isFemale()) {
                return false;
            }
            return otherDragon.method_19184();
        }
        return false;
    }

    public boolean method_19184() {
        return !this.method_6109() && this.method_6032() >= this.method_6063() && this.method_6479();
    }

    @Nullable
    public class_1296 method_5613(@Nonnull class_3218 level, @Nonnull class_1296 otherParent) {
        Raevyx baby = (Raevyx)ModEntities.RAEVYX.get().method_5883((class_1937)level);
        if (baby != null) {
            baby.setGender(this.field_5974.method_43056() ? DragonGender.FEMALE : DragonGender.MALE);
            UUID ownerId = this.method_6139();
            if (ownerId != null) {
                baby.method_6174(ownerId);
                baby.method_6173(true);
            }
            baby.skipRespawnTicks = 5;
            baby.method_5614(-24000);
            class_2338 safePos = this.findSafeBabySpawnPos((class_1936)level, this.method_24515());
            double spawnY = safePos != null ? (double)safePos.method_10264() : this.method_23318();
            baby.method_5808(this.method_23317(), spawnY, this.method_23321(), this.method_36454(), 0.0f);
        }
        return baby;
    }

    @Override
    @NotNull
    public class_243 method_49482(@Nonnull class_1657 player, @Nonnull class_243 deltaIn) {
        if (this.areRiderControlsLocked()) {
            return class_243.field_1353;
        }
        class_243 input = this.riderController.getRiddenInput(player, deltaIn);
        return super.method_49482(player, input);
    }

    protected void method_49481(@Nonnull class_1657 player, @Nonnull class_243 travelVector) {
        super.method_49481(player, travelVector);
        if (!this.method_37908().field_9236) {
            this.tickTakeoffLock();
        }
        if (!this.areRiderControlsLocked()) {
            this.riderController.tickRidden(player, travelVector);
        } else {
            player.field_6017 = 0.0f;
            this.field_6017 = 0.0f;
            this.method_5980(null);
            this.copyRiderLook(player);
            this.setAccelerating(false);
            if (!this.method_6581()) {
                this.setGoingUp(false);
                this.setGoingDown(false);
            }
        }
    }

    protected float method_49485(@Nonnull class_1657 rider) {
        if (this.areRiderControlsLocked()) {
            return 0.0f;
        }
        return this.riderController.getRiddenSpeed(rider);
    }

    @Override
    public void method_5793(@Nonnull class_1297 passenger) {
        if (this.areRiderControlsLocked() && passenger == this.method_5642()) {
            return;
        }
        super.method_5793(passenger);
    }

    public void method_5980(@Nullable class_1309 target) {
        if (this.method_6109()) {
            super.method_5980(null);
            return;
        }
        class_1309 previousTarget = this.method_5968();
        super.method_5980(target);
        if (!this.method_37908().field_9236) {
            if (this.aggroGrowlCooldown > 0) {
                --this.aggroGrowlCooldown;
            }
            if (target != null && previousTarget == null && this.aggroGrowlCooldown <= 0) {
                if (!this.method_5782() && !this.isStayOrSitMuted()) {
                    this.getSoundHandler().playVocal("growl_warning");
                }
                this.aggroGrowlCooldown = this.method_5782() ? 120 : 80;
            }
        }
    }

    @Nullable
    public class_1309 method_5642() {
        return this.riderController.getControllingPassenger();
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, @Nonnull class_1282 source) {
        if (!this.method_37908().field_9236) {
            this.field_6017 = 0.0f;
            for (class_1297 e : this.method_5685()) {
                if (!(e instanceof class_1309)) continue;
                class_1309 le = (class_1309)e;
                le.field_6017 = 0.0f;
            }
        }
        return false;
    }

    @Override
    public float getFlightSpeed() {
        return 1.0f;
    }

    @Override
    public double getPreferredFlightAltitude() {
        return 15.0;
    }

    @Override
    public boolean canTakeoff() {
        return !this.method_5816() && !this.method_5771() && this.method_24828();
    }

    @Override
    public DragonSleepCapable.SleepPreferences getSleepPreferences() {
        return new DragonSleepCapable.SleepPreferences(false, true, true, true, true);
    }

    @Override
    public boolean canSleepNow() {
        return !this.isCharging() && !this.isBeaming() && !this.method_5782();
    }

    public void playLightningEffect(class_243 position) {
        if (this.method_37908().field_9236) {
            this.method_37908().method_8406((class_2394)new RaevyxLightningStormData(1.0f, this.isFemale()), position.field_1352, position.field_1351, position.field_1350, 0.0, 0.0, 0.0);
        }
    }

    public boolean isCharging() {
        return false;
    }

    @Override
    public ElectricalConductivityProfile getConductivityProfile() {
        return CONDUCTIVITY_PROFILE;
    }

    @Override
    public ElectricalConductivityState getConductivityState() {
        return ElectricalConductivityCapable.super.getConductivityState();
    }

    public Raevyx asConductiveEntity() {
        return this;
    }

    public boolean canBeBound() {
        return !this.method_6113() && !this.isDying() && !this.isCharging() && !this.isBeaming();
    }

    @Override
    public float getScreenShakeAmount(float partialTicks) {
        float currentAmount = this.getFloatData(DATA_SCREEN_SHAKE_AMOUNT);
        return this.prevScreenShakeAmount + (currentAmount - this.prevScreenShakeAmount) * partialTicks;
    }

    @Override
    public double getShakeDistance() {
        return 25.0;
    }

    @Override
    public boolean canFeelShake(class_1297 player) {
        return true;
    }

    public void triggerScreenShake(float intensity) {
        this.screenShakeAmount = Math.max(this.screenShakeAmount, intensity);
        this.field_6011.method_12778(DATA_SCREEN_SHAKE_AMOUNT, (Object)Float.valueOf(this.screenShakeAmount));
    }

    private static class RaevyxFamilyData
    extends class_1296.class_4697 {
        public RaevyxFamilyData(boolean shouldSpawnBaby) {
            super(shouldSpawnBaby);
        }
    }
}

