/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.dragons.raevyx.handlers;

import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public record RaevyxAnimationHandler(Raevyx wyvern) {
    public void triggerDodgeAnimation() {
        this.wyvern.triggerAnim("action", "dodge");
    }

    public void triggerSitDownAnimation() {
        this.wyvern.triggerAnim("action", "sit_down");
    }

    public void triggerSitUpAnimation() {
        this.wyvern.triggerAnim("action", "sit_up");
    }

    public void triggerFallAsleepAnimation() {
        this.wyvern.triggerAnim("action", "fall_asleep");
    }

    public void triggerSleepAnimation() {
        this.wyvern.triggerAnim("action", "sleep");
    }

    public void triggerWakeUpAnimation() {
        this.wyvern.triggerAnim("action", "wake_up");
    }

    public void setupActionController(AnimationController<Raevyx> actionController) {
        this.registerVocalTriggers(actionController);
        actionController.triggerableAnim("lightning_bite", RawAnimation.begin().thenPlay("animation.raevyx.lightning_bite"));
        actionController.triggerableAnim("horn_gore", RawAnimation.begin().thenPlay("animation.raevyx.horn_gore"));
        actionController.triggerableAnim("dodge", RawAnimation.begin().thenPlay("animation.raevyx.dodge"));
        actionController.triggerableAnim("lightning_beam_start", RawAnimation.begin().thenPlay("animation.raevyx.lightning_beam_start"));
        actionController.triggerableAnim("lightning_beaming", RawAnimation.begin().thenLoop("animation.raevyx.lightning_beaming"));
        actionController.triggerableAnim("lightning_beam_stop", RawAnimation.begin().thenPlay("animation.raevyx.lightning_beam_stop"));
        actionController.triggerableAnim("eat", RawAnimation.begin().thenPlay("animation.raevyx.eat"));
        actionController.triggerableAnim("summon_storm_ground", RawAnimation.begin().thenPlay("animation.raevyx.summon_storm_ground"));
        actionController.triggerableAnim("summon_storm_air", RawAnimation.begin().thenPlay("animation.raevyx.summon_storm_air"));
        actionController.triggerableAnim("sit_down", RawAnimation.begin().thenPlay("animation.raevyx.down"));
        actionController.triggerableAnim("sit_up", RawAnimation.begin().thenPlay("animation.raevyx.up"));
        actionController.triggerableAnim("fall_asleep", RawAnimation.begin().thenPlay("animation.raevyx.fall_asleep"));
        actionController.triggerableAnim("sleep", RawAnimation.begin().thenLoop("animation.raevyx.sleep"));
        actionController.triggerableAnim("wake_up", RawAnimation.begin().thenPlay("animation.raevyx.wake_up"));
        actionController.triggerableAnim("die", RawAnimation.begin().thenPlay("animation.raevyx.die"));
    }

    private void registerVocalTriggers(AnimationController<Raevyx> action) {
        this.wyvern.getVocalEntries().forEach((key, entry) -> {
            if (entry.animationId() != null && !entry.animationId().isEmpty()) {
                action.triggerableAnim(key, RawAnimation.begin().thenPlay(entry.animationId()));
            }
        });
    }

    public PlayState bankingPredicate(AnimationState<Raevyx> state) {
        state.setAndContinue(RawAnimation.begin().thenLoop("animation.raevyx.banking_off"));
        return PlayState.CONTINUE;
    }

    public PlayState pitchingPredicate(AnimationState<Raevyx> state) {
        double pitchDir = this.wyvern.getPitchDirection();
        if (pitchDir > 0.0) {
            state.setAndContinue(RawAnimation.begin().thenLoop("animation.raevyx.pitching_down"));
        } else if (pitchDir < 0.0) {
            state.setAndContinue(RawAnimation.begin().thenLoop("animation.raevyx.pitching_up"));
        } else {
            state.setAndContinue(RawAnimation.begin().thenLoop("animation.raevyx.pitching_off"));
        }
        return PlayState.CONTINUE;
    }
}

