/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.dragons.raevyx.handlers;

import com.leon.saintsdragons.common.SaintsDragonsCommon;
import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public record RaevyxInteractionHandler(Raevyx wyvern) {
    public class_1269 handleInteraction(class_1657 player, class_1268 hand) {
        if (this.wyvern.isDying()) {
            return class_1269.field_5811;
        }
        class_1799 itemstack = player.method_5998(hand);
        if (!this.wyvern.method_6181()) {
            return this.handleUntamedInteraction(player, itemstack);
        }
        return this.handleTamedInteraction(player, itemstack, hand);
    }

    private class_1269 handleUntamedInteraction(class_1657 player, class_1799 itemstack) {
        if (!this.wyvern.method_6481(itemstack)) {
            return class_1269.field_5811;
        }
        if (!this.wyvern.method_37908().field_9236) {
            if (!player.method_31549().field_7477) {
                itemstack.method_7934(1);
            }
            this.wyvern.triggerAnim("action", "eat");
            if (this.wyvern.method_6051().method_43048(10) == 0) {
                this.wyvern.method_6170(player);
                this.wyvern.method_24346(true);
                this.wyvern.setCommandManual(1);
                this.wyvern.method_37908().method_8421((class_1297)this.wyvern, (byte)7);
                this.triggerTamingAdvancement(player);
            } else {
                this.wyvern.method_37908().method_8421((class_1297)this.wyvern, (byte)6);
            }
        }
        return class_1269.method_29236((boolean)this.wyvern.method_37908().field_9236);
    }

    private class_1269 handleTamedInteraction(class_1657 player, class_1799 itemstack, class_1268 hand) {
        boolean isOwner = player.equals((Object)this.wyvern.method_35057());
        if (this.wyvern.method_6481(itemstack)) {
            if (player.method_18276() && isOwner) {
                return this.handleBreeding(player, itemstack);
            }
            return this.handleFeeding(player, itemstack);
        }
        if (isOwner) {
            boolean isSleeping;
            boolean bl = isSleeping = this.wyvern.method_6113() || this.wyvern.isSleepTransitioning();
            if (this.canOwnerCommand(player) && itemstack.method_7960() && hand == class_1268.field_5808) {
                if (isSleeping) {
                    if (!this.wyvern.method_37908().field_9236 && player instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)player;
                        serverPlayer.method_7353((class_2561)class_2561.method_43469((String)"entity.saintsdragons.raevyx.sleeping", (Object[])new Object[]{this.wyvern.method_5477()}), true);
                    }
                    return class_1269.method_29236((boolean)this.wyvern.method_37908().field_9236);
                }
                return this.handleCommandCycling(player);
            }
            if (!player.method_18276() && itemstack.method_7960() && hand == class_1268.field_5808 && this.canOwnerMount(player)) {
                return this.handleMounting(player);
            }
        }
        return class_1269.field_5811;
    }

    private class_1269 handleBreeding(class_1657 player, class_1799 itemstack) {
        boolean client = this.wyvern.method_37908().field_9236;
        if (this.wyvern.method_6109()) {
            this.sendStatusMessage(player, "entity.saintsdragons.raevyx.breeding_too_young");
            return class_1269.method_29236((boolean)client);
        }
        if (this.wyvern.method_5618() != 0) {
            this.sendStatusMessage(player, "entity.saintsdragons.raevyx.breeding_cooling_down");
            return class_1269.method_29236((boolean)client);
        }
        if (this.wyvern.method_6479()) {
            this.sendStatusMessage(player, "entity.saintsdragons.raevyx.breeding_already_ready");
            return class_1269.method_29236((boolean)client);
        }
        if (!client) {
            if (!player.method_31549().field_7477) {
                itemstack.method_7934(1);
            }
            this.wyvern.triggerAnim("action", "eat");
            this.wyvern.method_6480(player);
            this.sendStatusMessage(player, "entity.saintsdragons.raevyx.breeding_ready");
        }
        return class_1269.method_29236((boolean)client);
    }

    private class_1269 handleFeeding(class_1657 player, class_1799 itemstack) {
        if (!this.wyvern.method_37908().field_9236) {
            if (!player.method_31549().field_7477) {
                itemstack.method_7934(1);
            }
            this.wyvern.triggerAnim("action", "eat");
            if (this.wyvern.method_6109()) {
                int currentAge = this.wyvern.method_5618();
                int newAge = Math.min(0, currentAge + 2400);
                this.wyvern.method_5614(newAge);
                this.wyvern.method_37908().method_8421((class_1297)this.wyvern, (byte)6);
                this.wyvern.method_37908().method_8421((class_1297)this.wyvern, (byte)7);
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    int remainingTicks = Math.abs(newAge);
                    int remainingMinutes = remainingTicks / 1200;
                    String messageKey = newAge == 0 ? "entity.saintsdragons.raevyx.baby_grown" : "entity.saintsdragons.raevyx.baby_fed";
                    serverPlayer.method_7353((class_2561)class_2561.method_43469((String)messageKey, (Object[])new Object[]{this.wyvern.method_5477()}), true);
                }
            } else {
                float healAmount = 10.0f;
                float oldHealth = this.wyvern.method_6032();
                float newHealth = Math.min(oldHealth + healAmount, this.wyvern.method_6063());
                this.wyvern.method_6033(newHealth);
                this.wyvern.method_37908().method_8421((class_1297)this.wyvern, (byte)6);
                this.wyvern.method_37908().method_8421((class_1297)this.wyvern, (byte)7);
                this.sendFeedingMessage(player, newHealth);
            }
        }
        return class_1269.method_29236((boolean)this.wyvern.method_37908().field_9236);
    }

    private class_1269 handleCommandCycling(class_1657 player) {
        boolean isTransitioning = this.wyvern.isInSitTransition();
        if (isTransitioning) {
            if (!this.wyvern.method_37908().field_9236 && player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                boolean sittingDown = this.wyvern.isSittingDownAnimation();
                String messageKey = sittingDown ? "entity.saintsdragons.raevyx.sitting_down" : "entity.saintsdragons.raevyx.standing_up";
                serverPlayer.method_7353((class_2561)class_2561.method_43469((String)messageKey, (Object[])new Object[]{this.wyvern.method_5477()}), true);
            }
            return class_1269.method_29236((boolean)this.wyvern.method_37908().field_9236);
        }
        int currentCommand = this.wyvern.getCommand();
        int nextCommand = (currentCommand + 1) % 3;
        this.wyvern.setCommandManual(nextCommand);
        this.applyCommandState(nextCommand);
        if (!this.wyvern.method_37908().field_9236) {
            player.method_7353((class_2561)class_2561.method_43469((String)("entity.saintsdragons.all.command_" + nextCommand), (Object[])new Object[]{this.wyvern.method_5477()}), true);
        }
        return class_1269.field_5812;
    }

    private void applyCommandState(int command) {
        switch (command) {
            case 0: {
                this.wyvern.method_24346(false);
                break;
            }
            case 1: {
                this.wyvern.method_24346(true);
                break;
            }
            case 2: {
                this.wyvern.method_24346(false);
            }
        }
    }

    private void sendStatusMessage(class_1657 player, String key) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            serverPlayer.method_7353((class_2561)class_2561.method_43469((String)key, (Object[])new Object[]{this.wyvern.method_5477()}), true);
        }
    }

    private class_1269 handleMounting(class_1657 player) {
        if (this.wyvern.method_5782()) {
            return class_1269.method_29236((boolean)this.wyvern.method_37908().field_9236);
        }
        if (this.wyvern.method_24345()) {
            this.wyvern.method_24346(false);
        }
        if (this.wyvern.method_6113() || this.wyvern.isSleepTransitioning()) {
            this.wyvern.wakeUpImmediately();
            this.wyvern.suppressSleep(300);
        }
        this.wyvern.clearAllStatesForMounting();
        if (player.method_5804((class_1297)this.wyvern)) {
            this.wyvern.playExcitedSound();
            return class_1269.method_29236((boolean)this.wyvern.method_37908().field_9236);
        }
        return class_1269.method_29236((boolean)this.wyvern.method_37908().field_9236);
    }

    private void triggerTamingAdvancement(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (this.wyvern.isFemale()) {
                class_161 femaleAdvancement = serverPlayer.field_13995.method_3851().method_12896(SaintsDragonsCommon.rl("tame_raevyx_female"));
                if (femaleAdvancement != null) {
                    serverPlayer.method_14236().method_12878(femaleAdvancement, "tame_raevyx_female");
                }
            } else {
                class_161 advancement = serverPlayer.field_13995.method_3851().method_12896(SaintsDragonsCommon.rl("tame_raevyx"));
                if (advancement != null) {
                    serverPlayer.method_14236().method_12878(advancement, "tame_raevyx");
                }
            }
        }
    }

    private void sendFeedingMessage(class_1657 player, float newHealth) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            String messageKey = newHealth >= this.wyvern.method_6063() ? "entity.saintsdragons.raevyx.fed" : "entity.saintsdragons.raevyx.fed_partial";
            serverPlayer.method_7353((class_2561)class_2561.method_43469((String)messageKey, (Object[])new Object[]{this.wyvern.method_5477()}), true);
        }
    }

    private boolean canOwnerCommand(class_1657 player) {
        return this.wyvern.canOwnerCommand(player);
    }

    private boolean canOwnerMount(class_1657 player) {
        return this.wyvern.canOwnerMount(player);
    }
}

