/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.dragons.raevyx.handlers;

import com.leon.saintsdragons.common.registry.ModSounds;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.handler.DragonSoundHandler;
import com.leon.saintsdragons.server.entity.interfaces.DragonSoundProfile;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3419;

public final class RaevyxSoundProfile
implements DragonSoundProfile {
    public static final RaevyxSoundProfile INSTANCE = new RaevyxSoundProfile();
    private static final Map<String, Integer> VOCAL_WINDOWS = Map.ofEntries(Map.entry("grumble1", 120), Map.entry("grumble2", 180), Map.entry("grumble3", 60), Map.entry("content", 100), Map.entry("purr", 110), Map.entry("snort", 24), Map.entry("chuff", 28), Map.entry("roar", 69), Map.entry("roar_ground", 69), Map.entry("roar_air", 69), Map.entry("raevyx_hurt", 20), Map.entry("raevyx_die", 62), Map.entry("baby_raevyx_hurt", 15), Map.entry("baby_raevyx_die", 40));
    private static final Map<String, String> EFFECT_TO_VOCAL_KEY = Map.ofEntries(Map.entry("raevyx_grumble1", "grumble1"), Map.entry("raevyx_grumble2", "grumble2"), Map.entry("raevyx_grumble3", "grumble3"), Map.entry("raevyx_chuff", "chuff"), Map.entry("raevyx_content", "content"), Map.entry("raevyx_purr", "purr"), Map.entry("raevyx_roar", "roar"), Map.entry("raevyx_hurt", "raevyx_hurt"), Map.entry("raevyx_die", "raevyx_die"), Map.entry("baby_raevyx_hurt", "baby_raevyx_hurt"), Map.entry("baby_raevyx_die", "baby_raevyx_die"));
    private static final Set<String> STEP_KEYS = Set.of("raevyx_step1", "raevyx_step2", "raevyx_run_step1", "raevyx_run_step2");

    private RaevyxSoundProfile() {
    }

    @Override
    public boolean handleAnimationSound(DragonSoundHandler handler, DragonEntity dragon, String key, String locator) {
        if (key.startsWith("raevyx_flap")) {
            this.playWingFlap(handler, dragon, locator);
            return true;
        }
        if (STEP_KEYS.contains(key)) {
            return false;
        }
        String vocalKey = EFFECT_TO_VOCAL_KEY.get(key);
        if (vocalKey != null) {
            if ("roar".equals(vocalKey) || "raevyx_hurt".equals(vocalKey) || "raevyx_die".equals(vocalKey) || "baby_raevyx_hurt".equals(vocalKey) || "baby_raevyx_die".equals(vocalKey)) {
                return true;
            }
            this.playVocalEntry(handler, dragon, vocalKey, locator);
            return true;
        }
        return switch (key) {
            case "raevyx_bite" -> {
                this.playSimpleMouthSound(handler, dragon, locator, ModSounds.RAEVYX_BITE.get(), 1.0f, 0.95f, 0.1f);
                yield true;
            }
            case "raevyx_horngore" -> {
                this.playSimpleMouthSound(handler, dragon, locator, ModSounds.RAEVYX_HORNGORE.get(), 1.3f, 0.9f, 0.2f);
                yield true;
            }
            case "raevyx_summon_storm" -> {
                this.playSummonStorm(handler, dragon, locator);
                yield true;
            }
            default -> false;
        };
    }

    @Override
    public boolean handleSoundByName(DragonSoundHandler handler, DragonEntity dragon, String key) {
        if (key.startsWith("raevyx_flap")) {
            this.playWingFlap(handler, dragon, null);
            return true;
        }
        return false;
    }

    @Override
    public int getVocalAnimationWindowTicks(String key) {
        return VOCAL_WINDOWS.getOrDefault(key, -1);
    }

    @Override
    public boolean handleWingFlapSound(DragonSoundHandler handler, DragonEntity dragon, String key) {
        this.playWingFlap(handler, dragon, null);
        return true;
    }

    @Override
    public boolean handleStepSound(DragonSoundHandler handler, DragonEntity dragon, String key, String locator, double x, double y, double z, float volume, float pitch) {
        dragon.method_37908().method_8486(x, y, z, ModSounds.RAEVYX_STEP.get(), class_3419.field_15254, volume, pitch, false);
        return true;
    }

    private void playWingFlap(DragonSoundHandler handler, DragonEntity dragon, String locator) {
        class_243 bodyPos = handler.resolveLocatorWorldPos(locator != null && !locator.isEmpty() ? locator : "bodyLocator");
        double flightSpeed = dragon.getCachedHorizontalSpeed();
        float pitch = 1.0f + (float)(flightSpeed * (double)0.3f);
        float volume = Math.max(0.6f, 0.9f + (float)(flightSpeed * (double)0.2f));
        this.playClientSound(dragon, bodyPos, ModSounds.RAEVYX_FLAP.get(), volume, pitch);
    }

    private void playVocalEntry(DragonSoundHandler handler, DragonEntity dragon, String vocalKey, String locator) {
        DragonEntity.VocalEntry entry = dragon.getVocalEntries().get(vocalKey);
        if (entry == null) {
            return;
        }
        if (!entry.allowDuringSleep() && (dragon.method_6113() || dragon.isSleepTransitioning())) {
            return;
        }
        if (!entry.allowWhenSitting() && dragon.isStayOrSitMuted()) {
            return;
        }
        class_243 at = handler.resolveLocatorWorldPos(locator != null && !locator.isEmpty() ? locator : "mouth_origin");
        float pitch = entry.basePitch();
        if (entry.pitchVariance() != 0.0f) {
            pitch += dragon.method_6051().method_43057() * entry.pitchVariance();
        }
        this.playClientSound(dragon, at, entry.soundSupplier().get(), entry.volume(), pitch);
    }

    private void playSimpleMouthSound(DragonSoundHandler handler, DragonEntity dragon, String locator, class_3414 sound, float volume, float basePitch, float variance) {
        class_243 at = handler.resolveLocatorWorldPos(locator != null && !locator.isEmpty() ? locator : "mouth_origin");
        float pitch = basePitch;
        if (variance != 0.0f) {
            pitch += dragon.method_6051().method_43057() * variance;
        }
        this.playClientSound(dragon, at, sound, volume, pitch);
    }

    private void playSummonStorm(DragonSoundHandler handler, DragonEntity dragon, String locator) {
        class_243 at = handler.resolveLocatorWorldPos(locator != null && !locator.isEmpty() ? locator : "mouth_origin");
        this.playClientSound(dragon, at, ModSounds.RAEVYX_SUMMON_STORM.get(), 1.6f, 1.0f);
    }

    private void playClientSound(DragonEntity dragon, class_243 position, class_3414 sound, float volume, float pitch) {
        double x = position != null ? position.field_1352 : dragon.method_23317();
        double y = position != null ? position.field_1351 : dragon.method_23318();
        double z = position != null ? position.field_1350 : dragon.method_23321();
        dragon.method_37908().method_8486(x, y, z, sound, class_3419.field_15254, volume, pitch, false);
    }
}

