/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.dragons.stegonaut;

import com.leon.saintsdragons.common.SaintsDragonsCommon;
import com.leon.saintsdragons.common.registry.ModEntities;
import com.leon.saintsdragons.common.registry.ModSounds;
import com.leon.saintsdragons.common.registry.stegonaut.StegonautAbilities;
import com.leon.saintsdragons.server.ai.goals.stegonaut.StegonautFleeFromPredatorsGoal;
import com.leon.saintsdragons.server.ai.goals.stegonaut.StegonautFollowOwnerGoal;
import com.leon.saintsdragons.server.ai.goals.stegonaut.StegonautGroundWanderGoal;
import com.leon.saintsdragons.server.ai.goals.stegonaut.StegonautLeaveWaterGoal;
import com.leon.saintsdragons.server.ai.goals.stegonaut.StegonautLookAtPlayerGoal;
import com.leon.saintsdragons.server.ai.goals.stegonaut.StegonautNapGoal;
import com.leon.saintsdragons.server.ai.goals.stegonaut.StegonautRandomLookAroundGoal;
import com.leon.saintsdragons.server.ai.goals.stegonaut.StegonautSleepGoal;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.ability.abilities.stegonaut.StegonautPassiveBuffAbility;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.dragons.stegonaut.handlers.StegonautAnimationHandler;
import com.leon.saintsdragons.server.entity.dragons.stegonaut.handlers.StegonautSoundProfile;
import com.leon.saintsdragons.server.entity.handler.DragonSoundHandler;
import com.leon.saintsdragons.server.entity.interfaces.DragonSleepCapable;
import com.leon.saintsdragons.server.entity.interfaces.DragonSoundProfile;
import com.leon.saintsdragons.server.entity.interfaces.SoundHandledDragon;
import com.leon.saintsdragons.server.entity.sleep.DragonRestManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1429;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_8111;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.keyframe.event.SoundKeyframeEvent;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Stegonaut
extends DragonEntity
implements DragonSleepCapable,
SoundHandledDragon {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final StegonautAnimationHandler animationController = new StegonautAnimationHandler(this);
    private final DragonSoundHandler soundHandler = new DragonSoundHandler(this);
    private final DragonRestManager restManager = new DragonRestManager((class_1309)this);
    private final StegonautPassiveBuffAbility passiveBuffAbility = new StegonautPassiveBuffAbility(this);
    private final Map<String, class_243> clientLocatorCache = new ConcurrentHashMap<String, class_243>();
    private int ambientSoundTimer;
    private int nextAmbientSoundDelay;
    private static final int MIN_AMBIENT_DELAY = 200;
    private static final int MAX_AMBIENT_DELAY = 600;
    private static final Map<String, DragonEntity.VocalEntry> VOCAL_ENTRIES = new DragonEntity.VocalEntryBuilder().add("grumble1", "action", "animation.stegonaut.grumble1", ModSounds.STEGONAUT_GRUMBLE_1, 0.6f, 1.1f, 0.2f, false, false, true).add("grumble2", "action", "animation.stegonaut.grumble2", ModSounds.STEGONAUT_GRUMBLE_2, 0.6f, 1.1f, 0.2f, false, false, true).add("grumble3", "action", "animation.stegonaut.grumble3", ModSounds.STEGONAUT_GRUMBLE_3, 0.6f, 1.1f, 0.2f, false, false, true).add("hurt", "action", "animation.stegonaut.hurt", ModSounds.STEGONAUT_HURT, 1.0f, 0.95f, 0.1f, false, true, true).add("die", "action", "animation.stegonaut.die", ModSounds.STEGONAUT_DIE, 1.2f, 1.0f, 0.0f, false, true, true).build();
    private boolean sleeping = false;
    private boolean sleepTransitioning = false;
    private int napTicks = 0;
    private int napCooldown = 0;
    private boolean dayNapQueued = false;
    private static final class_2940<Boolean> DATA_SLEEPING = class_2945.method_12791(Stegonaut.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> DATA_GROUND_MOVE_STATE = class_2945.method_12791(Stegonaut.class, (class_2941)class_2943.field_13327);
    private boolean boundToBinder = false;
    private static final int CLIENT_GROUND_STATE_STABLE_TICKS = 3;
    private int clientGroundMoveState = 0;
    private int clientGroundMoveTarget = 0;
    private int clientGroundMoveHold = 0;
    private int walkAnimationHoldTicks = 0;
    private int grumbleCooldown = 0;

    @Override
    public Map<String, DragonEntity.VocalEntry> getVocalEntries() {
        return VOCAL_ENTRIES;
    }

    @Override
    public DragonSoundProfile getSoundProfile() {
        return StegonautSoundProfile.INSTANCE;
    }

    public Stegonaut(class_1299<? extends Stegonaut> entityType, class_1937 level) {
        super(entityType, level);
        this.animationController.initializeAnimation();
        class_5819 rng = this.method_6051();
        this.ambientSoundTimer = rng.method_43048(80);
        this.nextAmbientSoundDelay = 200 + rng.method_43048(400);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_SLEEPING, (Object)false);
        this.field_6011.method_12784(DATA_GROUND_MOVE_STATE, (Object)0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(0, (class_1352)new StegonautSleepGoal(this));
        this.field_6201.method_6277(1, (class_1352)new StegonautLeaveWaterGoal(this, 1.15));
        this.field_6201.method_6277(2, (class_1352)new StegonautFleeFromPredatorsGoal(this, 0.6, 12.0));
        this.field_6201.method_6277(3, (class_1352)new StegonautFollowOwnerGoal(this));
        this.field_6201.method_6277(4, (class_1352)new StegonautNapGoal(this));
        this.field_6201.method_6277(5, (class_1352)new StegonautGroundWanderGoal(this, 0.35, 120));
        this.field_6201.method_6277(6, (class_1352)new StegonautLookAtPlayerGoal(this, class_1657.class, 8.0f));
        this.field_6201.method_6277(7, (class_1352)new StegonautRandomLookAroundGoal(this));
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 100.0).method_26868(class_5134.field_23719, 0.4).method_26868(class_5134.field_23721, 2.0).method_26868(class_5134.field_23724, 15.0).method_26868(class_5134.field_23717, 16.0);
    }

    @Override
    public boolean method_6581() {
        return false;
    }

    @Override
    public boolean isStayOrSitMuted() {
        return this.method_24345() || this.method_6172();
    }

    @Override
    public boolean canOwnerCommand(class_1657 player) {
        return player != null && player.equals((Object)this.method_35057());
    }

    public boolean isTameable() {
        return true;
    }

    public boolean method_6481(@Nonnull class_1799 stack) {
        return stack.method_31574(class_1802.field_8046) || stack.method_31574(class_1802.field_8389) || stack.method_31574(class_1802.field_8726) || stack.method_31574(class_1802.field_8748) || stack.method_31574(class_1802.field_8429) || stack.method_31574(class_1802.field_8209);
    }

    @Override
    public class_243 getHeadPosition() {
        return this.method_33571();
    }

    @Override
    public class_243 getMouthPosition() {
        return this.method_19538().method_1031(0.0, (double)this.method_17682() * 0.8, 0.0);
    }

    @Override
    public DragonAbilityType<?, ?> getPrimaryAttackAbility() {
        return null;
    }

    @Override
    protected DragonAbilityType<?, ?> getHurtAbilityType() {
        return StegonautAbilities.STEGONAUT_HURT;
    }

    @Override
    public int getDeathAnimationDurationTicks() {
        return 75;
    }

    @Override
    public boolean method_5643(@NotNull class_1282 source, float amount) {
        if (this.isDying()) {
            if (source.method_49708(class_8111.field_44869)) {
                return super.method_5643(source, amount);
            }
            return false;
        }
        if (this.handleLethalDamage(source, amount, StegonautAbilities.STEGONAUT_DIE)) {
            return true;
        }
        return super.method_5643(source, amount);
    }

    protected void method_6108() {
        ++this.field_6213;
        if (this.field_6213 >= 20) {
            this.method_5650(class_1297.class_5529.field_26998);
            this.method_23883();
        }
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController movementController = new AnimationController((GeoAnimatable)this, "movement", 1, this.animationController::handleMovementAnimation);
        movementController.setSoundKeyframeHandler(this::onAnimationSound);
        controllers.add(new AnimationController[]{movementController});
        AnimationController actionController = new AnimationController((GeoAnimatable)this, "action", 1, this.animationController::actionPredicate);
        this.animationController.setupActionController((AnimationController<Stegonaut>)actionController);
        actionController.setSoundKeyframeHandler(this::onAnimationSound);
        controllers.add(new AnimationController[]{actionController});
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public class_1296 method_5613(@Nonnull class_3218 level, @Nonnull class_1296 other) {
        Stegonaut baby = (Stegonaut)ModEntities.STEGONAUT.get().method_5883((class_1937)level);
        if (baby != null) {
            class_2338 safePos = this.findSafeBabySpawnPos((class_1936)level, this.method_24515());
            double spawnY = safePos != null ? (double)safePos.method_10264() : this.method_23318();
            baby.method_5808(this.method_23317(), spawnY, this.method_23321(), this.method_36454(), 0.0f);
        }
        return baby;
    }

    public static boolean canSpawnHere(class_1299<? extends Stegonaut> type, class_1936 level, class_3730 spawnType, class_2338 pos, class_5819 random) {
        if (!class_1429.method_20663(type, (class_1936)level, (class_3730)spawnType, (class_2338)pos, (class_5819)random)) {
            return false;
        }
        if (!level.method_8316(pos).method_15769()) {
            return false;
        }
        if (!level.method_8316(pos.method_10074()).method_15769()) {
            return false;
        }
        return level.method_8320(pos.method_10074()).method_26206((class_1922)level, pos.method_10074(), class_2350.field_11036);
    }

    @Override
    @NotNull
    public class_1269 method_5992(@NotNull class_1657 player, @NotNull class_1268 hand) {
        if (hand == class_1268.field_5808 && player.method_5998(hand).method_7960() && player.method_5715()) {
            return class_1269.field_5811;
        }
        if (!this.method_6181()) {
            return this.handleUntamedInteraction(player, hand);
        }
        return this.handleTamedInteraction(player, hand);
    }

    private class_1269 handleUntamedInteraction(class_1657 player, class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);
        if (!this.method_6481(itemstack)) {
            return class_1269.field_5811;
        }
        if (!this.method_37908().field_9236) {
            if (!player.method_31549().field_7477) {
                itemstack.method_7934(1);
            }
            this.triggerAnim("action", "eat");
            this.method_6170(player);
            this.method_24346(true);
            this.setCommand(1);
            this.method_37908().method_8421((class_1297)this, (byte)7);
            player.method_7353((class_2561)class_2561.method_43469((String)"entity.saintsdragons.stegonaut.tamed", (Object[])new Object[]{this.method_5477()}), true);
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                class_161 advancement = serverPlayer.field_13995.method_3851().method_12896(SaintsDragonsCommon.rl("tame_stegonaut"));
                if (advancement != null) {
                    serverPlayer.method_14236().method_12878(advancement, "tame_stegonaut");
                }
            }
        }
        return class_1269.method_29236((boolean)this.method_37908().field_9236);
    }

    private class_1269 handleTamedInteraction(class_1657 player, class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);
        if (this.method_6481(itemstack)) {
            return this.handleFeeding(player, itemstack);
        }
        if (player.equals((Object)this.method_35057()) && this.canOwnerCommand(player) && itemstack.method_7960() && hand == class_1268.field_5808) {
            return this.handleCommandCycling(player);
        }
        return super.method_5992(player, hand);
    }

    private class_1269 handleFeeding(class_1657 player, class_1799 itemstack) {
        if (!this.method_37908().field_9236) {
            if (!player.method_31549().field_7477) {
                itemstack.method_7934(1);
            }
            this.triggerAnim("action", "eat");
            float healAmount = 8.0f;
            float oldHealth = this.method_6032();
            float newHealth = Math.min(oldHealth + healAmount, this.method_6063());
            this.method_6033(newHealth);
            this.method_37908().method_8421((class_1297)this, (byte)6);
            this.method_37908().method_8421((class_1297)this, (byte)7);
            String messageKey = newHealth >= this.method_6063() ? "entity.saintsdragons.stegonaut.fed" : "entity.saintsdragons.stegonaut.fed_partial";
            player.method_7353((class_2561)class_2561.method_43469((String)messageKey, (Object[])new Object[]{this.method_5477()}), true);
        }
        return class_1269.method_29236((boolean)this.method_37908().field_9236);
    }

    private class_1269 handleCommandCycling(class_1657 player) {
        int currentCommand = this.getCommand();
        int nextCommand = (currentCommand + 1) % 3;
        this.setCommand(nextCommand);
        this.applyCommandState(nextCommand);
        if (!this.method_37908().field_9236) {
            player.method_7353((class_2561)class_2561.method_43469((String)("entity.saintsdragons.all.command_" + nextCommand), (Object[])new Object[]{this.method_5477()}), true);
        }
        return class_1269.field_5812;
    }

    private void applyCommandState(int command) {
        switch (command) {
            case 0: {
                this.method_24346(false);
                break;
            }
            case 1: {
                this.method_24346(true);
                break;
            }
            case 2: {
                this.method_24346(false);
            }
        }
    }

    public void refreshCommandState() {
        this.applyCommandState(this.getCommand());
    }

    @Override
    public DragonSoundHandler getSoundHandler() {
        return this.soundHandler;
    }

    public DragonRestManager getRestManager() {
        return this.restManager;
    }

    public void playRandomGrumble() {
        if (this.method_37908().field_9236 || this.isDying()) {
            return;
        }
        float grumbleChance = this.method_6051().method_43057();
        String vocalKey = grumbleChance < 0.4f ? "grumble1" : (grumbleChance < 0.7f ? "grumble2" : "grumble3");
        this.getSoundHandler().playVocal(vocalKey);
    }

    private void playCustomAmbientSound() {
        class_5819 random = this.method_6051();
        if (this.isDying() || this.method_5968() != null) {
            return;
        }
        String vocalKey = null;
        float moodRoll = random.method_43057();
        vocalKey = moodRoll < 0.4f ? "grumble1" : (moodRoll < 0.7f ? "grumble2" : "grumble3");
        if (vocalKey != null) {
            this.getSoundHandler().playVocal(vocalKey);
        }
    }

    private void handleAmbientSounds() {
        if (this.isDying() || this.method_6113() || this.isSleepTransitioning()) {
            return;
        }
        ++this.ambientSoundTimer;
        if (this.ambientSoundTimer >= this.nextAmbientSoundDelay) {
            this.playCustomAmbientSound();
            this.resetAmbientSoundTimer();
        }
    }

    private void resetAmbientSoundTimer() {
        class_5819 random = this.method_6051();
        this.ambientSoundTimer = 0;
        this.nextAmbientSoundDelay = 200 + random.method_43048(400);
    }

    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().field_9236) {
            this.tickAnimationStates();
        }
    }

    @Override
    public boolean method_6113() {
        return this.method_37908().field_9236 ? (Boolean)this.field_6011.method_12789(DATA_SLEEPING) : this.sleeping;
    }

    @Override
    public boolean isSleepTransitioning() {
        return this.sleepTransitioning;
    }

    @Override
    public boolean isSleepSuppressed() {
        return this.method_5968() != null || this.method_5816() || this.method_5782();
    }

    @Override
    public void startSleepEnter() {
        if (!this.sleeping && !this.sleepTransitioning) {
            this.sleepTransitioning = true;
            this.sleeping = true;
            this.field_6011.method_12778(DATA_SLEEPING, (Object)true);
            this.method_24346(true);
        }
    }

    @Override
    public void startSleepExit() {
        if (this.sleeping && !this.sleepTransitioning) {
            this.sleepTransitioning = true;
            this.sleeping = false;
            this.field_6011.method_12778(DATA_SLEEPING, (Object)false);
            this.refreshCommandState();
        }
    }

    @Override
    public DragonSleepCapable.SleepPreferences getSleepPreferences() {
        return new DragonSleepCapable.SleepPreferences(true, true, false, false, false);
    }

    @Override
    public boolean canSleepNow() {
        if (this.method_37908().method_8530()) {
            if (this.napCooldown <= 0 && this.method_6051().method_43057() < 0.01f) {
                this.dayNapQueued = true;
                return true;
            }
            this.dayNapQueued = false;
            return false;
        }
        this.dayNapQueued = false;
        return true;
    }

    @Override
    public void method_5773() {
        super.method_5773();
        this.soundHandler.tick();
        if (!this.method_37908().field_9236) {
            this.handleAmbientSounds();
        }
        if (this.method_5805()) {
            this.passiveBuffAbility.tick();
        } else {
            this.passiveBuffAbility.cleanup();
        }
        if (this.sleepTransitioning) {
            this.sleepTransitioning = false;
        }
        if (this.napTicks > 0) {
            --this.napTicks;
            if (this.napTicks <= 0) {
                if (this.sleeping) {
                    this.startSleepExit();
                }
                this.napCooldown = 1200 + this.method_6051().method_43048(1800);
            }
        }
        if (this.napCooldown > 0) {
            --this.napCooldown;
        }
        if (this.grumbleCooldown > 0) {
            --this.grumbleCooldown;
        }
        if (!this.method_37908().field_9236) {
            if (this.method_24345()) {
                if (this.sitProgress < this.maxSitTicks()) {
                    this.sitProgress += 1.0f;
                    this.field_6011.method_12778(DATA_SIT_PROGRESS, (Object)Float.valueOf(this.sitProgress));
                }
            } else if (this.sitProgress > 0.0f) {
                this.sitProgress -= 1.0f;
                if (this.sitProgress < 0.0f) {
                    this.sitProgress = 0.0f;
                }
                this.field_6011.method_12778(DATA_SIT_PROGRESS, (Object)Float.valueOf(this.sitProgress));
            }
        }
        if (this.method_37908().field_9236) {
            this.prevSitProgress = this.sitProgress;
            this.sitProgress = ((Float)this.field_6011.method_12789(DATA_SIT_PROGRESS)).floatValue();
        }
    }

    public void startNap() {
        if (!this.sleeping && this.napCooldown <= 0) {
            this.napTicks = 1200 + this.method_6051().method_43048(1200);
        }
    }

    public boolean isDayNapQueued() {
        return this.dayNapQueued;
    }

    public boolean consumeDayNapQueued() {
        boolean queued = this.dayNapQueued;
        this.dayNapQueued = false;
        return queued;
    }

    public void onAnimationSound(SoundKeyframeEvent<Stegonaut> event) {
        this.getSoundHandler().handleAnimationSound(this, event.getKeyframeData(), event.getController());
    }

    public void setClientLocatorPosition(String name, class_243 pos) {
        if (this.method_37908().field_9236) {
            this.clientLocatorCache.put(name, pos);
        }
    }

    @Override
    public class_243 getClientLocatorPosition(String name) {
        return this.clientLocatorCache.get(name);
    }

    @Override
    public boolean isWalking() {
        if (this.method_37908().field_9236) {
            int s = this.getEffectiveGroundState();
            return s == 1;
        }
        int s = (Integer)this.field_6011.method_12789(DATA_GROUND_MOVE_STATE);
        return s == 1;
    }

    @Override
    public boolean isRunning() {
        if (this.method_37908().field_9236) {
            int s = this.getEffectiveGroundState();
            return s == 2;
        }
        int s = (Integer)this.field_6011.method_12789(DATA_GROUND_MOVE_STATE);
        return s == 2;
    }

    public int getEffectiveGroundState() {
        if (this.method_37908().field_9236) {
            int syncedState = (Integer)this.field_6011.method_12789(DATA_GROUND_MOVE_STATE);
            if (this.clientGroundMoveTarget != syncedState) {
                this.clientGroundMoveTarget = syncedState;
                this.clientGroundMoveHold = 0;
            } else if (this.clientGroundMoveState != this.clientGroundMoveTarget) {
                ++this.clientGroundMoveHold;
                if (this.clientGroundMoveHold >= 3) {
                    this.clientGroundMoveState = this.clientGroundMoveTarget;
                    this.clientGroundMoveHold = 0;
                }
            } else {
                this.clientGroundMoveHold = 0;
            }
            if (this.method_6113() || this.method_24345()) {
                this.clientGroundMoveState = 0;
                this.clientGroundMoveTarget = 0;
                this.clientGroundMoveHold = 0;
            }
            return this.clientGroundMoveState;
        }
        return (Integer)this.field_6011.method_12789(DATA_GROUND_MOVE_STATE);
    }

    private void tickAnimationStates() {
        int moveState = 0;
        if (!this.method_6113() && !this.method_24345()) {
            boolean isActuallyMoving;
            boolean hasActivePath = this.method_5942().method_23966();
            boolean bl = isActuallyMoving = this.method_18798().method_37268() > 0.001;
            if (hasActivePath || isActuallyMoving) {
                moveState = 1;
                this.walkAnimationHoldTicks = 8;
            } else if (this.walkAnimationHoldTicks > 0) {
                moveState = 1;
                --this.walkAnimationHoldTicks;
            }
        } else {
            this.walkAnimationHoldTicks = 0;
        }
        if ((Integer)this.field_6011.method_12789(DATA_GROUND_MOVE_STATE) != moveState) {
            this.field_6011.method_12778(DATA_GROUND_MOVE_STATE, (Object)moveState);
        }
    }

    @Override
    public void method_5652(@NotNull class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("StegonautCommand", this.getCommand());
        tag.method_10556("StegonautOrderedSit", this.method_24345());
        tag.method_10556("Sleeping", this.sleeping);
        tag.method_10556("SleepTransitioning", this.sleepTransitioning);
        tag.method_10569("NapTicks", this.napTicks);
        tag.method_10569("NapCooldown", this.napCooldown);
        tag.method_10569("GrumbleCooldown", this.grumbleCooldown);
        tag.method_10556("BoundToBinder", this.boundToBinder);
        tag.method_10548("SitProgress", this.sitProgress);
        this.restManager.save(tag);
    }

    @Override
    public void method_5749(@NotNull class_2487 tag) {
        super.method_5749(tag);
        int restoredCommand = this.getCommand();
        if (tag.method_10545("StegonautCommand")) {
            restoredCommand = tag.method_10550("StegonautCommand");
            this.setCommand(restoredCommand);
        }
        boolean restoredOrderedSit = tag.method_10545("StegonautOrderedSit") ? tag.method_10577("StegonautOrderedSit") : restoredCommand == 1;
        this.sleeping = tag.method_10577("Sleeping");
        this.sleepTransitioning = tag.method_10577("SleepTransitioning");
        this.napTicks = tag.method_10550("NapTicks");
        this.napCooldown = tag.method_10550("NapCooldown");
        this.grumbleCooldown = tag.method_10550("GrumbleCooldown");
        this.boundToBinder = tag.method_10577("BoundToBinder");
        this.field_6011.method_12778(DATA_SLEEPING, (Object)this.sleeping);
        if (tag.method_10545("SitProgress")) {
            this.sitProgress = tag.method_10583("SitProgress");
            this.field_6011.method_12778(DragonEntity.DATA_SIT_PROGRESS, (Object)Float.valueOf(this.sitProgress));
        }
        this.refreshCommandState();
        this.method_24346(restoredOrderedSit);
        this.restManager.load(tag);
    }

    public boolean isBoundToBinder() {
        return this.boundToBinder;
    }

    public void setBoundToBinder(boolean bound) {
        this.boundToBinder = bound;
    }

    public boolean canBeBound() {
        return !this.method_6113() && !this.isDying();
    }
}

