/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.effect.raevyx;

import com.leon.saintsdragons.common.particle.raevyx.RaevyxLightningChainData;
import com.leon.saintsdragons.common.particle.raevyx.RaevyxLightningStormData;
import com.leon.saintsdragons.common.registry.ModEntities;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3619;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import org.jetbrains.annotations.NotNull;

public class RaevyxLightningChainEntity
extends class_1297 {
    private static final class_2940<Float> DAMAGE = class_2945.method_12791(RaevyxLightningChainEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> SIZE = class_2945.method_12791(RaevyxLightningChainEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Integer> LIFESPAN = class_2945.method_12791(RaevyxLightningChainEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> DELAY = class_2945.method_12791(RaevyxLightningChainEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> IS_CHAIN = class_2945.method_12791(RaevyxLightningChainEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> CASTER_FEMALE = class_2945.method_12791(RaevyxLightningChainEntity.class, (class_2941)class_2943.field_13323);
    @Nullable
    private class_1309 owner;
    @Nullable
    private UUID ownerUUID;
    private class_243 startPos;
    private class_243 endPos;
    private int chainCount = 0;
    private int maxChains = 3;

    public RaevyxLightningChainEntity(class_1299<? extends RaevyxLightningChainEntity> entityType, class_1937 level) {
        super(entityType, level);
    }

    public RaevyxLightningChainEntity(class_1937 level, double x, double y, double z, float damage, float size, class_1309 caster, boolean isChain) {
        this(ModEntities.RAEVYX_LIGHTNING_CHAIN.get(), level);
        this.method_5814(x, y, z);
        this.setDamage(damage);
        this.setSize(size);
        this.setCaster(caster);
        this.setIsChain(isChain);
        this.setDelay(0);
        this.setLifespan(0);
    }

    public RaevyxLightningChainEntity(class_1937 level, class_243 startPos, class_243 endPos, float damage, float size, class_1309 caster, boolean isChain) {
        this(level, startPos.field_1352, startPos.field_1351, startPos.field_1350, damage, size, caster, isChain);
        this.startPos = startPos;
        this.endPos = endPos;
    }

    @NotNull
    public class_2596<class_2602> method_18002() {
        return new class_2604((class_1297)this);
    }

    protected void method_5693() {
        this.field_6011.method_12784(DAMAGE, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(SIZE, (Object)Float.valueOf(1.0f));
        this.field_6011.method_12784(LIFESPAN, (Object)0);
        this.field_6011.method_12784(DELAY, (Object)0);
        this.field_6011.method_12784(IS_CHAIN, (Object)false);
        this.field_6011.method_12784(CASTER_FEMALE, (Object)false);
    }

    public int getLifespan() {
        return (Integer)this.field_6011.method_12789(LIFESPAN);
    }

    public void setLifespan(int lifespan) {
        this.field_6011.method_12778(LIFESPAN, (Object)lifespan);
    }

    public int getDelay() {
        return (Integer)this.field_6011.method_12789(DELAY);
    }

    public void setDelay(int delay) {
        this.field_6011.method_12778(DELAY, (Object)delay);
    }

    public float getSize() {
        return ((Float)this.field_6011.method_12789(SIZE)).floatValue();
    }

    public void setSize(float size) {
        if (!this.method_37908().field_9236) {
            this.field_6011.method_12778(SIZE, (Object)Float.valueOf(class_3532.method_15363((float)size, (float)0.5f, (float)3.0f)));
        }
    }

    public float getDamage() {
        return ((Float)this.field_6011.method_12789(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.field_6011.method_12778(DAMAGE, (Object)Float.valueOf(damage));
    }

    public boolean getIsChain() {
        return (Boolean)this.field_6011.method_12789(IS_CHAIN);
    }

    public void setIsChain(boolean isChain) {
        this.field_6011.method_12778(IS_CHAIN, (Object)isChain);
    }

    public void setCaster(@Nullable class_1309 caster) {
        this.owner = caster;
        UUID uUID = this.ownerUUID = caster == null ? null : caster.method_5667();
        if (caster instanceof DragonEntity) {
            DragonEntity dragon = (DragonEntity)caster;
            this.field_6011.method_12778(CASTER_FEMALE, (Object)dragon.isFemale());
        }
    }

    @Nullable
    public class_1309 getCaster() {
        class_1297 entity;
        if (this.owner == null && this.ownerUUID != null && this.method_37908() instanceof class_3218 && (entity = ((class_3218)this.method_37908()).method_14190(this.ownerUUID)) instanceof class_1309) {
            this.owner = (class_1309)entity;
        }
        return this.owner;
    }

    private boolean isCasterFemale() {
        return (Boolean)this.field_6011.method_12789(CASTER_FEMALE);
    }

    public boolean method_5640(double distance) {
        double d0 = 64.0 * RaevyxLightningChainEntity.method_5824();
        return distance < d0 * d0;
    }

    @NotNull
    public class_3619 method_5657() {
        return class_3619.field_15975;
    }

    @NotNull
    public class_4048 method_18377(@Nonnull class_4050 pose) {
        return class_4048.method_18384((float)(this.getSize() * 0.5f), (float)this.getSize());
    }

    public void method_5773() {
        super.method_5773();
        this.setLifespan(this.getLifespan() + 1);
        int adjustedLifespan = this.getLifespan() - this.getDelay();
        if (this.method_37908().field_9236) {
            if (adjustedLifespan == 1) {
                this.spawnLightningParticles();
            }
        } else {
            if (adjustedLifespan == 5) {
                this.dealDamage();
                if (this.getIsChain() && this.chainCount < this.maxChains) {
                    this.attemptChainLightning();
                }
            }
            if (adjustedLifespan > 20) {
                this.method_31472();
            }
        }
    }

    private void spawnLightningParticles() {
        boolean female = this.isCasterFemale();
        if (this.startPos != null && this.endPos != null) {
            if (this.getIsChain()) {
                this.method_37908().method_8494((class_2394)new RaevyxLightningChainData(this.getSize(), this.startPos, this.endPos, female), this.startPos.field_1352, this.startPos.field_1351, this.startPos.field_1350, 0.0, 0.0, 0.0);
            } else {
                class_243 delta = this.endPos.method_1020(this.startPos);
                int segments = Math.max(3, (int)(delta.method_1033() * 4.0));
                class_243 step = delta.method_1021(1.0 / (double)segments);
                for (int i = 0; i <= segments; ++i) {
                    class_243 pos = this.startPos.method_1019(step.method_1021((double)i));
                    class_243 dir = step.method_1029();
                    this.method_37908().method_8494((class_2394)new RaevyxLightningStormData(this.getSize(), female), pos.field_1352, pos.field_1351, pos.field_1350, dir.field_1352, dir.field_1351, dir.field_1350);
                }
            }
        } else if (this.getIsChain()) {
            this.method_37908().method_8494((class_2394)new RaevyxLightningStormData(this.getSize(), female), this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
        } else {
            this.method_37908().method_8494((class_2394)new RaevyxLightningStormData(this.getSize(), female), this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
        }
    }

    private void dealDamage() {
        class_238 damageBox = this.method_5829().method_1014((double)this.getSize() * 2.0);
        for (class_1309 entity : this.method_37908().method_18467(class_1309.class, damageBox)) {
            class_1309 caster;
            if (!entity.method_5805() || entity.method_5655() || entity == this.getCaster() || this.isProtectedFromCaster(caster = this.getCaster(), entity)) continue;
            class_1282 damageSource = caster != null ? this.method_48923().method_48812(caster) : this.method_48923().method_48831();
            entity.method_5643(damageSource, this.getDamage());
            this.spawnImpactEffects(entity.method_19538().method_1031(0.0, (double)(entity.method_17682() / 2.0f), 0.0));
        }
    }

    private void spawnImpactEffects(class_243 impactPos) {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 server = (class_3218)class_19372;
        boolean female = this.isCasterFemale();
        float size = this.getSize() * 0.6f;
        for (int layer = 0; layer < 4; ++layer) {
            float layerSize = size * (1.0f + (float)layer * 0.25f);
            float layerOffset = (float)layer * 0.1f;
            for (int i = 0; i < 6; ++i) {
                double angle = (double)i * Math.PI * 2.0 / 6.0;
                double offsetX = Math.cos(angle) * (double)layerOffset;
                double offsetZ = Math.sin(angle) * (double)layerOffset;
                server.method_14199((class_2394)new RaevyxLightningStormData(layerSize, female), impactPos.field_1352 + offsetX, impactPos.field_1351 + (double)layerOffset, impactPos.field_1350 + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private void spawnChainImpactEffects(class_243 chainPos) {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 server = (class_3218)class_19372;
        boolean female = this.isCasterFemale();
        float size = this.getSize() * 0.4f;
        for (int layer = 0; layer < 3; ++layer) {
            float layerSize = size * (1.0f + (float)layer * 0.2f);
            float layerOffset = (float)layer * 0.05f;
            for (int i = 0; i < 4; ++i) {
                double angle = (double)i * Math.PI * 2.0 / 4.0;
                double offsetX = Math.cos(angle) * (double)layerOffset;
                double offsetZ = Math.sin(angle) * (double)layerOffset;
                server.method_14199((class_2394)new RaevyxLightningStormData(layerSize, female), chainPos.field_1352 + offsetX, chainPos.field_1351 + (double)layerOffset, chainPos.field_1350 + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private void attemptChainLightning() {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        class_238 searchBox = this.method_5829().method_1014((double)this.getSize() * 4.0);
        class_1309 nearestTarget = null;
        double nearestDistance = Double.MAX_VALUE;
        for (class_1309 entity : serverLevel.method_18467(class_1309.class, searchBox)) {
            double distance;
            class_1309 caster;
            if (!entity.method_5805() || entity.method_5655() || entity == this.getCaster() || this.isProtectedFromCaster(caster = this.getCaster(), entity) || !((distance = (double)this.method_5739((class_1297)entity)) < nearestDistance)) continue;
            nearestTarget = entity;
            nearestDistance = distance;
        }
        if (nearestTarget != null) {
            class_243 chainStart = this.method_19538();
            class_243 chainEnd = nearestTarget.method_19538().method_1031(0.0, (double)(nearestTarget.method_17682() / 2.0f), 0.0);
            this.spawnChainImpactEffects(chainStart);
            RaevyxLightningChainEntity chainEntity = new RaevyxLightningChainEntity((class_1937)serverLevel, chainStart, chainEnd, this.getDamage() * 0.8f, this.getSize() * 0.9f, this.getCaster(), true);
            chainEntity.chainCount = this.chainCount + 1;
            chainEntity.maxChains = this.maxChains;
            serverLevel.method_8649((class_1297)chainEntity);
        }
    }

    private boolean isProtectedFromCaster(@Nullable class_1309 caster, class_1309 target) {
        DragonEntity dragon;
        if (caster == null) {
            return false;
        }
        if (caster instanceof DragonEntity && (dragon = (DragonEntity)caster).isAlly((class_1297)target)) {
            return true;
        }
        return caster.method_5722((class_1297)target);
    }

    protected void method_5652(@Nonnull class_2487 compound) {
        compound.method_10569("lifespan", this.getLifespan());
        compound.method_10569("delay", this.getDelay());
        compound.method_10548("damage", this.getDamage());
        compound.method_10548("size", this.getSize());
        compound.method_10556("isChain", this.getIsChain());
        compound.method_10556("casterFemale", ((Boolean)this.field_6011.method_12789(CASTER_FEMALE)).booleanValue());
        compound.method_10569("chainCount", this.chainCount);
        compound.method_10569("maxChains", this.maxChains);
        if (this.ownerUUID != null) {
            compound.method_25927("Owner", this.ownerUUID);
        }
        if (this.startPos != null) {
            compound.method_10549("startX", this.startPos.field_1352);
            compound.method_10549("startY", this.startPos.field_1351);
            compound.method_10549("startZ", this.startPos.field_1350);
        }
        if (this.endPos != null) {
            compound.method_10549("endX", this.endPos.field_1352);
            compound.method_10549("endY", this.endPos.field_1351);
            compound.method_10549("endZ", this.endPos.field_1350);
        }
    }

    protected void method_5749(@Nonnull class_2487 compound) {
        this.setLifespan(compound.method_10550("lifespan"));
        this.setDelay(compound.method_10550("delay"));
        this.setDamage(compound.method_10583("damage"));
        this.setSize(compound.method_10583("size"));
        this.setIsChain(compound.method_10577("isChain"));
        if (compound.method_10545("casterFemale")) {
            this.field_6011.method_12778(CASTER_FEMALE, (Object)compound.method_10577("casterFemale"));
        }
        this.chainCount = compound.method_10550("chainCount");
        this.maxChains = compound.method_10550("maxChains");
        if (compound.method_25928("Owner")) {
            this.ownerUUID = compound.method_25926("Owner");
        }
        if (compound.method_10545("startX")) {
            this.startPos = new class_243(compound.method_10574("startX"), compound.method_10574("startY"), compound.method_10574("startZ"));
        }
        if (compound.method_10545("endX")) {
            this.endPos = new class_243(compound.method_10574("endX"), compound.method_10574("endY"), compound.method_10574("endZ"));
        }
    }
}

