/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.handler;

import com.leon.saintsdragons.server.entity.base.DragonEntity;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DragonAllyManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DragonAllyManager.class);
    private final DragonEntity dragon;
    private final Map<UUID, String> allies = new ConcurrentHashMap<UUID, String>();
    private final Map<String, UUID> usernameCache = new ConcurrentHashMap<String, UUID>();
    private static final int MAX_ALLIES = 10;

    public DragonAllyManager(DragonEntity dragon) {
        this.dragon = dragon;
    }

    public AllyResult addAlly(String username) {
        UUID existingUuid;
        String ownerName;
        if (username == null || username.trim().isEmpty()) {
            return AllyResult.INVALID_USERNAME;
        }
        if ((username = username.trim()).length() < 3 || username.length() > 16) {
            return AllyResult.INVALID_USERNAME;
        }
        if (!username.matches("^[a-zA-Z0-9_]+$")) {
            return AllyResult.INVALID_USERNAME;
        }
        if (this.containsInappropriateContent(username)) {
            return AllyResult.INAPPROPRIATE_CONTENT;
        }
        if (username.equalsIgnoreCase("Notch")) {
            return AllyResult.EASTER_EGG;
        }
        if (username.equalsIgnoreCase("jeb_")) {
            return AllyResult.EASTER_EGG;
        }
        if (username.equalsIgnoreCase("Dinnerbone")) {
            return AllyResult.EASTER_EGG;
        }
        if (username.equalsIgnoreCase("Grumm")) {
            return AllyResult.EASTER_EGG;
        }
        if (username.equalsIgnoreCase("Herobrine")) {
            return AllyResult.EASTER_EGG;
        }
        if (this.dragon.method_35057() != null && username.equalsIgnoreCase(ownerName = this.dragon.method_35057().method_5477().getString())) {
            return AllyResult.IS_OWNER;
        }
        if (this.usernameCache.containsKey(username) && this.allies.containsKey(existingUuid = this.usernameCache.get(username))) {
            return AllyResult.ALREADY_ALLY;
        }
        if (this.allies.size() >= 10) {
            return AllyResult.ALLY_LIMIT_REACHED;
        }
        UUID playerUuid = this.resolveUsernameToUuid(username);
        if (playerUuid == null) {
            return AllyResult.PLAYER_NOT_FOUND;
        }
        String resolvedUsername = this.resolveUuidToUsername(playerUuid);
        if (resolvedUsername == null || !resolvedUsername.equalsIgnoreCase(username)) {
            return AllyResult.UUID_MISMATCH;
        }
        this.allies.put(playerUuid, resolvedUsername);
        this.usernameCache.put(resolvedUsername.toLowerCase(), playerUuid);
        LOGGER.info("Added ally '{}' ({}) to wyvern {}", new Object[]{resolvedUsername, playerUuid, this.dragon});
        return AllyResult.SUCCESS;
    }

    public AllyResult removeAlly(String username) {
        if (username == null || username.trim().isEmpty()) {
            return AllyResult.INVALID_USERNAME;
        }
        UUID uuid = this.usernameCache.get(username = username.trim().toLowerCase());
        if (uuid == null) {
            return AllyResult.NOT_ALLY;
        }
        this.allies.remove(uuid);
        this.usernameCache.remove(username);
        LOGGER.info("Removed ally '{}' ({}) from wyvern {}", new Object[]{username, uuid, this.dragon});
        return AllyResult.SUCCESS;
    }

    public boolean removeAlly(UUID uuid) {
        String username = this.allies.remove(uuid);
        if (username != null) {
            this.usernameCache.remove(username.toLowerCase());
            LOGGER.info("Removed ally '{}' ({}) from wyvern {}", new Object[]{username, uuid, this.dragon});
            return true;
        }
        return false;
    }

    public boolean isAlly(class_1657 player) {
        if (player == null) {
            return false;
        }
        return this.allies.containsKey(player.method_5667());
    }

    public boolean isAlly(UUID uuid) {
        return this.allies.containsKey(uuid);
    }

    public List<String> getAllyUsernames() {
        return new ArrayList<String>(this.allies.values());
    }

    public Set<UUID> getAllyUuids() {
        return new HashSet<UUID>(this.allies.keySet());
    }

    public int getAllyCount() {
        return this.allies.size();
    }

    public int getMaxAllies() {
        return 10;
    }

    public void clearAllies() {
        this.allies.clear();
        this.usernameCache.clear();
        LOGGER.info("Cleared all allies from wyvern {}", (Object)this.dragon);
    }

    private UUID resolveUsernameToUuid(String username) {
        class_1937 level = this.dragon.method_37908();
        if (!(level instanceof class_3218)) {
            return null;
        }
        class_3218 serverLevel = (class_3218)level;
        MinecraftServer server = serverLevel.method_8503();
        if (server == null) {
            return null;
        }
        class_3222 onlinePlayer = server.method_3760().method_14566(username);
        if (onlinePlayer != null) {
            return onlinePlayer.method_5667();
        }
        return null;
    }

    private String resolveUuidToUsername(UUID uuid) {
        class_1937 level = this.dragon.method_37908();
        if (!(level instanceof class_3218)) {
            return null;
        }
        class_3218 serverLevel = (class_3218)level;
        MinecraftServer server = serverLevel.method_8503();
        if (server == null) {
            return null;
        }
        class_3222 onlinePlayer = server.method_3760().method_14602(uuid);
        if (onlinePlayer != null) {
            return onlinePlayer.method_7334().getName();
        }
        try {
            return server.method_3793().method_14512(uuid).map(profile -> profile.getName()).orElse(null);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to resolve UUID '{}' to username: {}", (Object)uuid, (Object)e.getMessage());
            return null;
        }
    }

    public void saveToNBT(class_2487 tag) {
        class_2499 allyList = new class_2499();
        for (Map.Entry<UUID, String> entry : this.allies.entrySet()) {
            class_2487 allyTag = new class_2487();
            allyTag.method_25927("UUID", entry.getKey());
            allyTag.method_10582("Username", entry.getValue());
            allyList.add((Object)allyTag);
        }
        tag.method_10566("Allies", (class_2520)allyList);
    }

    public void loadFromNBT(class_2487 tag) {
        this.allies.clear();
        this.usernameCache.clear();
        if (tag.method_10573("Allies", 9)) {
            class_2499 allyList = tag.method_10554("Allies", 10);
            for (int i = 0; i < allyList.size(); ++i) {
                class_2487 allyTag = allyList.method_10602(i);
                if (!allyTag.method_25928("UUID") || !allyTag.method_10573("Username", 8)) continue;
                UUID uuid = allyTag.method_25926("UUID");
                String username = allyTag.method_10558("Username");
                this.allies.put(uuid, username);
                this.usernameCache.put(username.toLowerCase(), uuid);
            }
        }
    }

    private boolean containsInappropriateContent(String username) {
        String[] inappropriatePatterns;
        String lowerUsername = username.toLowerCase();
        for (String pattern : inappropriatePatterns = new String[]{"f[uv]ck", "sh[i1]t", "b[i1]tch", "d[i1]ck", "p[i1]ss", "c[o0]ck", "a[s$][s$]", "f[a@]g", "n[i1]gg[a@]", "r[e3]t[a@]rd", "wh[o0]r[e3]", "f[u]ck", "sh[i]t", "b[i]tch", "d[i]ck", "p[i]ss", "c[o]ck", "a[s]s", "f[a]g", "n[i]gg[a]", "r[e]t[a]rd", "wh[o]r[e]", "f[u]ck", "sh[i]t", "b[i]tch", "d[i]ck", "p[i]ss", "c[o]ck", "fuk", "shyt", "bich", "dik", "pis", "cok", "h[e3]ll", "d[a@]mn", "cr[a@]p", "p[o0]rn", "s[e3]x"}) {
            if (!lowerUsername.matches(".*" + pattern + ".*")) continue;
            return true;
        }
        if (lowerUsername.matches(".*(.)\\1{2,}.*")) {
            return true;
        }
        long numberCount = lowerUsername.chars().filter(Character::isDigit).count();
        return numberCount > (long)(username.length() / 2);
    }

    public static enum AllyResult {
        SUCCESS("Successfully managed ally"),
        INVALID_USERNAME("Invalid username provided"),
        PLAYER_NOT_FOUND("Player not found on server"),
        UUID_MISMATCH("Username-UUID validation failed"),
        ALREADY_ALLY("Player is already an ally"),
        NOT_ALLY("Player is not an ally"),
        ALLY_LIMIT_REACHED("Maximum ally limit reached"),
        EASTER_EGG("Easter egg message"),
        IS_OWNER("You are already the owner of this wyvern!"),
        INAPPROPRIATE_CONTENT("Inappropriate content detected");

        private final String message;

        private AllyResult(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isSuccess() {
            return this == SUCCESS;
        }
    }
}

