/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.handler;

import com.leon.saintsdragons.common.registry.AbilityRegistry;
import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class DragonCombatHandler {
    private final DragonEntity dragon;
    private DragonAbility<?> activeAbility;
    private DragonAbility<?> overlayAbility;
    private int globalCooldown = 0;
    private boolean processingAbility = false;
    private final Map<DragonAbilityType<?, ?>, Integer> abilityCooldowns = new HashMap();
    private final Map<DragonAbilityType<?, ?>, Boolean> overlayAbilityCache = new HashMap();

    public void saveToNBT(class_2487 tag) {
        tag.method_10569("GlobalAbilityCooldown", Math.max(0, this.globalCooldown));
        class_2487 cd = new class_2487();
        for (Map.Entry<DragonAbilityType<?, ?>, Integer> e : this.abilityCooldowns.entrySet()) {
            String name = AbilityRegistry.getName(e.getKey());
            if (name == null || name.isEmpty()) continue;
            cd.method_10569(name, Math.max(0, e.getValue()));
        }
        if (!cd.method_33133()) {
            tag.method_10566("AbilityCooldowns", (class_2520)cd);
        }
    }

    public void loadFromNBT(class_2487 tag) {
        this.globalCooldown = Math.max(0, tag.method_10550("GlobalAbilityCooldown"));
        this.abilityCooldowns.clear();
        if (tag.method_10573("AbilityCooldowns", 10)) {
            class_2487 cd = tag.method_10562("AbilityCooldowns");
            for (String key : cd.method_10541()) {
                int val;
                DragonAbilityType<?, ?> type = AbilityRegistry.get(key);
                if (type == null || (val = Math.max(0, cd.method_10550(key))) <= 0) continue;
                this.abilityCooldowns.put(type, val);
            }
        }
    }

    public DragonCombatHandler(DragonEntity dragon) {
        this.dragon = dragon;
    }

    public DragonAbility<?> getActiveAbility() {
        return this.activeAbility;
    }

    public void setActiveAbility(DragonAbility<?> ability) {
        this.activeAbility = ability;
        this.dragon.setActiveAbility(ability);
    }

    public DragonAbilityType<?, ?> getActiveAbilityType() {
        return this.activeAbility != null ? this.activeAbility.getAbilityType() : null;
    }

    public boolean canUseAbility() {
        return this.globalCooldown == 0 && (this.activeAbility == null || !this.activeAbility.isUsing()) && !this.processingAbility && !this.dragon.areRiderControlsLocked();
    }

    public void lockGlobalCooldown(int ticks) {
        if (ticks <= 0) {
            return;
        }
        this.globalCooldown = Math.max(this.globalCooldown, ticks);
    }

    public boolean isGlobalCooldownActive() {
        return this.globalCooldown > 0;
    }

    public boolean canStart(DragonAbilityType<?, ?> abilityType) {
        if (this.processingAbility) {
            return false;
        }
        if (this.globalCooldown > 0 || this.dragon.areRiderControlsLocked()) {
            return false;
        }
        if (!this.isAbilityCooldownReady(abilityType)) {
            return false;
        }
        if (this.isOverlayAbilityType(abilityType)) {
            return this.overlayAbility == null || !this.overlayAbility.isUsing();
        }
        return this.globalCooldown == 0 && (this.activeAbility == null || !this.activeAbility.isUsing());
    }

    public boolean isAbilityCooldownReady(DragonAbilityType<?, ?> abilityType) {
        return this.abilityCooldowns.getOrDefault(abilityType, 0) <= 0;
    }

    public void setAbilityCooldown(DragonAbilityType<?, ?> abilityType, int cooldownTicks) {
        this.abilityCooldowns.put(abilityType, cooldownTicks);
    }

    public int getCooldownTicks(DragonAbilityType<?, ?> abilityType) {
        return this.abilityCooldowns.getOrDefault(abilityType, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryUseAbility(DragonAbilityType<?, ?> abilityType) {
        if (abilityType == null || this.dragon.method_37908().field_9236) {
            return;
        }
        if (this.dragon.areRiderControlsLocked()) {
            return;
        }
        if (!this.canStart(abilityType)) {
            return;
        }
        boolean overlay = this.isOverlayAbilityType(abilityType);
        this.processingAbility = true;
        try {
            Object ability = abilityType.makeInstance(this.dragon);
            if (!((DragonAbility)ability).tryAbility()) {
                return;
            }
            if (overlay) {
                this.overlayAbility = ability;
            } else {
                this.setActiveAbility((DragonAbility<?>)ability);
            }
            ((DragonAbility)ability).start();
        }
        finally {
            this.processingAbility = false;
        }
    }

    public void forceEndActiveAbility() {
        if (this.activeAbility != null) {
            this.activeAbility.interrupt();
            this.setActiveAbility(null);
        }
        if (this.overlayAbility != null) {
            this.overlayAbility.interrupt();
            this.overlayAbility = null;
        }
    }

    public void forceEndAbility(DragonAbilityType<?, ?> abilityType) {
        if (this.activeAbility != null && this.activeAbility.getAbilityType() == abilityType) {
            this.activeAbility.interrupt();
            this.setActiveAbility(null);
        }
        if (this.overlayAbility != null && this.overlayAbility.getAbilityType() == abilityType) {
            this.overlayAbility.interrupt();
            this.overlayAbility = null;
        }
    }

    public boolean isAbilityActive(DragonAbilityType<?, ?> abilityType) {
        if (this.activeAbility != null && this.activeAbility.getAbilityType() == abilityType && this.activeAbility.isUsing()) {
            return true;
        }
        return this.overlayAbility != null && this.overlayAbility.getAbilityType() == abilityType && this.overlayAbility.isUsing();
    }

    public boolean hasActiveOverlay() {
        return this.overlayAbility != null && this.overlayAbility.isUsing();
    }

    public void clearAllStates() {
        this.forceEndActiveAbility();
        this.globalCooldown = 0;
        this.abilityCooldowns.clear();
        this.processingAbility = false;
    }

    private boolean isOverlayAbilityType(DragonAbilityType<?, ?> abilityType) {
        return this.overlayAbilityCache.computeIfAbsent(abilityType, type -> {
            Object ability = type.makeInstance(this.dragon);
            return ((DragonAbility)ability).isOverlayAbility();
        });
    }

    public void tick() {
        if (this.dragon.method_37908().field_9236) {
            return;
        }
        if (this.globalCooldown > 0) {
            --this.globalCooldown;
        }
        this.abilityCooldowns.entrySet().removeIf(entry -> {
            int newValue = (Integer)entry.getValue() - 1;
            if (newValue <= 0) {
                return true;
            }
            entry.setValue(newValue);
            return false;
        });
        if (this.overlayAbility != null) {
            if (this.overlayAbility.isUsing()) {
                this.overlayAbility.tick();
            } else {
                DragonAbilityType<?, DragonAbility<?>> overlayType = this.overlayAbility.getAbilityType();
                if (overlayType != null) {
                    this.setAbilityCooldown(overlayType, this.overlayAbility.getCooldownTimer());
                }
                this.overlayAbility = null;
            }
        }
        if (this.activeAbility != null) {
            if (this.activeAbility.isUsing()) {
                this.activeAbility.tick();
            } else {
                this.globalCooldown = 6;
                DragonAbilityType<?, ?> finishedType = this.getActiveAbilityType();
                if (finishedType != null) {
                    this.setAbilityCooldown(finishedType, this.activeAbility.getCooldownTimer());
                }
                this.setActiveAbility(null);
            }
        }
    }
}

