/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.handler;

import com.leon.saintsdragons.common.registry.ModSounds;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.interfaces.DragonSoundProfile;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7923;
import software.bernie.geckolib.core.animation.AnimationController;

public class DragonSoundHandler {
    private final DragonEntity dragon;
    private final DragonSoundProfile profile;
    private static final int MIN_OVERLAP_GUARD_TICKS = 5;
    private static final Set<String> DEFAULT_NON_OVERLAPPING_KEYS = Set.of("hurt", "stegonaut_hurt", "cindervane_hurt", "primitive_drake_hurt", "die", "raevyx_hurt", "raevyx_die", "baby_raevyx_hurt", "baby_raevyx_die");
    private static final Map<String, Integer> GENERIC_VOCAL_WINDOWS = Map.of("hurt", 20, "die", 62);
    private final Map<String, Integer> vocalCooldowns = new HashMap<String, Integer>();

    public DragonSoundHandler(DragonEntity dragon) {
        this.dragon = dragon;
        DragonSoundProfile providedProfile = dragon.getSoundProfile();
        this.profile = providedProfile != null ? providedProfile : DragonSoundProfile.EMPTY;
    }

    public void tick() {
    }

    public void handleAnimationSound(DragonEntity entity, Object keyframeData, AnimationController<?> controller) {
        String raw;
        if (this.dragon.isDying()) {
            return;
        }
        if (!this.dragon.method_37908().field_9236) {
            return;
        }
        if (keyframeData == null) {
            return;
        }
        String controllerName = null;
        try {
            if (controller != null && controller.getName() != null) {
                controllerName = controller.getName();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean sittingMuted = this.dragon.isStayOrSitMuted();
        boolean sleeping = this.dragon.method_6113();
        boolean sleepTransitioning = this.dragon.isSleepTransitioning();
        if (sleeping) {
            return;
        }
        if (sleepTransitioning && !"action".equals(controllerName)) {
            return;
        }
        String locator = null;
        try {
            raw = (String)keyframeData.getClass().getMethod("getSound", new Class[0]).invoke(keyframeData, new Object[0]);
            try {
                locator = (String)keyframeData.getClass().getMethod("getLocator", new Class[0]).invoke(keyframeData, new Object[0]);
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            return;
        }
        if (raw == null || raw.isEmpty()) {
            return;
        }
        String sound = raw.toLowerCase(Locale.ROOT);
        if (sound.contains(":")) {
            this.handleAutoSoundSpec(sound);
            return;
        }
        String normalizedForFlap = null;
        if (sound.contains("flap")) {
            normalizedForFlap = sound.substring(sound.indexOf("flap"));
        }
        String normalizedForStep = null;
        if (sound.contains("step")) {
            normalizedForStep = sound.substring(sound.indexOf("step"));
        }
        if (this.profile.handleAnimationSound(this, this.dragon, sound, locator)) {
            return;
        }
        if (sittingMuted) {
            return;
        }
        if (normalizedForFlap != null && normalizedForFlap.startsWith("flap")) {
            this.handleWingFlapSound(normalizedForFlap);
            return;
        }
        if (normalizedForStep != null && (normalizedForStep.startsWith("step") || normalizedForStep.startsWith("run_step"))) {
            this.handleStepSound(normalizedForStep);
            return;
        }
        this.playFallbackSound(sound, locator);
    }

    private void handleAutoSoundSpec(String spec) {
        try {
            String[] parts = spec.split("\\|");
            String soundId = parts[0];
            float volume = parts.length > 1 ? Float.parseFloat(parts[1]) : 1.0f;
            float pitch = parts.length > 2 ? Float.parseFloat(parts[2]) : 1.0f;
            class_2960 rl = class_2960.method_12829((String)soundId);
            if (rl != null) {
                this.dragon.method_37908().method_8486(this.dragon.method_23317(), this.dragon.method_23318(), this.dragon.method_23321(), (class_3414)class_7923.field_41172.method_10223(rl), class_3419.field_15254, volume, pitch, false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void handleWingFlapSound(String key) {
        if (this.profile.handleWingFlapSound(this, this.dragon, key)) {
            return;
        }
        float volume = this.dragon.method_6109() ? 0.6f : 1.0f;
        float pitch = 1.0f;
        if (key.contains("left")) {
            pitch += 0.05f;
        } else if (key.contains("right")) {
            pitch -= 0.05f;
        }
        this.dragon.method_37908().method_8486(this.dragon.method_23317(), this.dragon.method_23318(), this.dragon.method_23321(), ModSounds.RAEVYX_FLAP.get(), class_3419.field_15254, volume, pitch, false);
    }

    private void handleStepSound(String key) {
        class_243 pos = this.dragon.method_19538();
        if (this.profile.handleStepSound(this, this.dragon, key, null, pos.field_1352, pos.field_1351, pos.field_1350, 1.0f, 1.0f)) {
            return;
        }
        this.playFootstepSound(this.dragon.method_37908(), pos, this.dragon);
    }

    private void playFallbackSound(String key, String locator) {
        DragonSoundProfile profile = this.dragon.getSoundProfile();
        if (profile != null && profile.handleAnimationSound(this, this.dragon, key, locator)) {
            return;
        }
        if (DEFAULT_NON_OVERLAPPING_KEYS.contains(key)) {
            if (this.isInCooldown(key)) {
                return;
            }
            this.startCooldown(key);
        }
        this.playClientSound(this.dragon, this.resolveLocator(locator), ModSounds.RAEVYX_CHUFF.get(), 1.0f, 1.0f);
    }

    private boolean isInCooldown(String key) {
        Integer cooldown = this.vocalCooldowns.get(key);
        return cooldown != null && cooldown > this.dragon.field_6012;
    }

    private void startCooldown(String key) {
        int window = GENERIC_VOCAL_WINDOWS.getOrDefault(key, 20);
        this.vocalCooldowns.put(key, this.dragon.field_6012 + Math.max(window, 5));
    }

    private class_243 resolveLocator(String locator) {
        if (locator == null || locator.isEmpty()) {
            return this.dragon.method_19538();
        }
        return this.profile.resolveLocator(this, this.dragon, locator);
    }

    public void playVocal(String vocalKey) {
        if (this.dragon.method_31481() || this.dragon.method_29504()) {
            return;
        }
        if (this.isInCooldown(vocalKey)) {
            return;
        }
        this.startCooldown(vocalKey);
        DragonSoundProfile profile = this.dragon.getSoundProfile();
        if (profile != null && profile.handleVocal(this, this.dragon, vocalKey)) {
            return;
        }
        DragonEntity.VocalEntry entry = this.resolveVocalEntry(profile, vocalKey);
        if (entry == null || entry.soundSupplier() == null) {
            return;
        }
        if (!entry.allowDuringSleep() && (this.dragon.method_6113() || this.dragon.isSleepTransitioning())) {
            return;
        }
        if (!entry.allowWhenSitting() && this.dragon.isStayOrSitMuted()) {
            return;
        }
        if (entry.animationId() != null && !entry.animationId().isEmpty()) {
            String controllerId = entry.controllerId() != null && !entry.controllerId().isEmpty() ? entry.controllerId() : "action";
            this.dragon.triggerAnim(controllerId, vocalKey);
        }
    }

    public void playClientSound(DragonEntity dragon, class_243 position, class_3414 sound, float volume, float pitch) {
        double x = position != null ? position.field_1352 : dragon.method_23317();
        double y = position != null ? position.field_1351 : dragon.method_23318();
        double z = position != null ? position.field_1350 : dragon.method_23321();
        class_1937 level = dragon.method_37908();
        if (level.field_9236) {
            level.method_8486(x, y, z, sound, class_3419.field_15254, volume, pitch, false);
        } else {
            level.method_43128(null, x, y, z, sound, class_3419.field_15254, volume, pitch);
        }
    }

    public void playFootstepSound(class_1937 level, class_243 pos, DragonEntity dragon) {
        level.method_43128(null, pos.field_1352, pos.field_1351, pos.field_1350, class_3417.field_14928, class_3419.field_15254, dragon.method_6109() ? 0.5f : 0.9f, dragon.method_6051().method_43057() * 0.2f + 0.9f);
    }

    private DragonEntity.VocalEntry resolveVocalEntry(DragonSoundProfile profile, String key) {
        DragonEntity.VocalEntry entry = this.dragon.getVocalEntries().get(key);
        if (entry != null) {
            return entry;
        }
        if (profile != null && (entry = profile.getFallbackVocalEntry(key)) != null) {
            return entry;
        }
        int underscore = key.indexOf(95);
        while (underscore > 0) {
            String suffix = key.substring(underscore + 1);
            entry = this.dragon.getVocalEntries().get(suffix);
            if (entry != null) {
                return entry;
            }
            if (profile != null && (entry = profile.getFallbackVocalEntry(suffix)) != null) {
                return entry;
            }
            underscore = key.indexOf(95, underscore + 1);
        }
        return null;
    }

    public DragonSoundProfile getProfile() {
        return this.profile;
    }

    public DragonEntity getDragon() {
        return this.dragon;
    }

    public boolean allowOverlap(String locator) {
        return this.profile.allowOverlap(locator);
    }

    public boolean shouldPreventOverlap(String key) {
        return DEFAULT_NON_OVERLAPPING_KEYS.contains(key);
    }

    public class_243 resolveLocatorWorldPos(String locator) {
        return this.resolveLocator(locator);
    }
}

