/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.sleep;

import com.leon.saintsdragons.server.entity.sleep.DragonRestState;
import net.minecraft.class_1309;
import net.minecraft.class_2487;

public class DragonRestManager {
    private final class_1309 entity;
    private DragonRestState currentState = DragonRestState.IDLE;
    private int stateTimer = 0;
    private int restDuration = 0;
    private int restingTicks = 0;

    public DragonRestManager(class_1309 entity) {
        this.entity = entity;
    }

    public DragonRestState getCurrentState() {
        return this.currentState;
    }

    public boolean isResting() {
        return this.currentState.isRestCycle();
    }

    public boolean isSleepingState() {
        return this.currentState == DragonRestState.SLEEPING;
    }

    public void startRest(int sleepDurationTicks) {
        if (this.currentState != DragonRestState.IDLE) {
            return;
        }
        this.currentState = DragonRestState.SITTING_DOWN;
        this.stateTimer = 0;
        this.restDuration = sleepDurationTicks;
        this.restingTicks = 0;
    }

    public void stopRest() {
        this.currentState = DragonRestState.IDLE;
        this.stateTimer = 0;
        this.restDuration = 0;
        this.restingTicks = 0;
    }

    public boolean tick() {
        if (this.currentState == DragonRestState.IDLE) {
            return false;
        }
        ++this.stateTimer;
        return false;
    }

    public int getStateTimer() {
        return this.stateTimer;
    }

    public void resetStateTimer() {
        this.stateTimer = 0;
    }

    public void advanceState() {
        switch (this.currentState) {
            case SITTING_DOWN: {
                this.currentState = DragonRestState.SITTING;
                break;
            }
            case SITTING: {
                this.currentState = DragonRestState.FALLING_ASLEEP;
                break;
            }
            case FALLING_ASLEEP: {
                this.currentState = DragonRestState.SLEEPING;
                break;
            }
            case SLEEPING: {
                this.currentState = DragonRestState.WAKING_UP;
                break;
            }
            case WAKING_UP: {
                this.currentState = DragonRestState.SITTING_AFTER;
                break;
            }
            case SITTING_AFTER: {
                this.currentState = DragonRestState.STANDING_UP;
                break;
            }
            case STANDING_UP: {
                this.currentState = DragonRestState.IDLE;
                break;
            }
            default: {
                this.currentState = DragonRestState.IDLE;
            }
        }
        this.stateTimer = 0;
    }

    public int getRestingTicks() {
        return this.restingTicks;
    }

    public void incrementRestingTicks() {
        ++this.restingTicks;
    }

    public int getRestDuration() {
        return this.restDuration;
    }

    public boolean isRestCycleComplete() {
        return this.currentState == DragonRestState.IDLE;
    }

    public void save(class_2487 tag) {
        tag.method_10569("RestState", this.currentState.getId());
        tag.method_10569("RestStateTimer", this.stateTimer);
        tag.method_10569("RestDuration", this.restDuration);
        tag.method_10569("RestingTicks", this.restingTicks);
    }

    public void load(class_2487 tag) {
        this.currentState = DragonRestState.fromId(tag.method_10550("RestState"));
        this.stateTimer = tag.method_10550("RestStateTimer");
        this.restDuration = tag.method_10550("RestDuration");
        this.restingTicks = tag.method_10550("RestingTicks");
    }
}

