/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.util;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import org.joml.Quaternionf;

public class DragonMathUtil {
    public static float approachSmooth(float current, float previous, float desired, float desiredSpeed, float deltaSpeed) {
        float prevSpeed = current - previous;
        desiredSpeed = Math.abs(desiredSpeed);
        desiredSpeed = current < desired ? desiredSpeed : -desiredSpeed;
        float speed = class_3532.method_15348((float)prevSpeed, (float)desiredSpeed, (float)deltaSpeed);
        float speedApproachReduction = (float)(1.0 - Math.pow(class_3532.method_15363((float)(-Math.abs(current - desired) / Math.abs(2.0f * desiredSpeed / deltaSpeed) + 1.0f), (float)0.0f, (float)1.0f), 4.0));
        return current < desired ? class_3532.method_15363((float)(current + speed), (float)current, (float)desired) : class_3532.method_15363((float)(current + (speed *= speedApproachReduction)), (float)desired, (float)current);
    }

    public static float approachDegreesSmooth(float current, float previous, float desired, float desiredSpeed, float deltaSpeed) {
        float desiredDifference = class_3532.method_15381((float)current, (float)desired);
        float previousDifference = class_3532.method_15381((float)current, (float)previous);
        return DragonMathUtil.approachSmooth(current, current + previousDifference, current + desiredDifference, desiredSpeed, deltaSpeed);
    }

    public static double getAngleBetweenEntities(class_1297 first, class_1297 second) {
        return Math.atan2(second.method_23321() - first.method_23321(), second.method_23317() - first.method_23317()) * 57.29577951308232 + 90.0;
    }

    public static double getDotProductBodyFacingEntity(class_1297 entity, class_1297 target) {
        class_243 vecBetween = target.method_19538().method_1020(entity.method_19538()).method_1029();
        return vecBetween.method_1026(class_243.method_1030((float)0.0f, (float)entity.method_36454()).method_1029());
    }

    public static class_243 circleEntityPosition(class_1297 target, float radius, float speed, boolean clockwise, int frame, float offset) {
        int direction = clockwise ? 1 : -1;
        double t = (double)(direction * frame) * 0.5 * (double)speed / (double)radius + (double)offset;
        return target.method_19538().method_1031((double)radius * Math.cos(t), 0.0, (double)radius * Math.sin(t));
    }

    public static <T extends class_1297> List<T> getEntitiesNearby(class_1297 entity, Class<T> entityClass, double radius) {
        return entity.method_37908().method_8390(entityClass, entity.method_5829().method_1009(radius, radius, radius), e -> e != entity && (double)entity.method_5739(e) <= radius + (double)(e.method_17681() / 2.0f));
    }

    public static List<class_1309> getAttackableEntitiesNearby(class_1297 entity, double radius) {
        List nearbyEntities = entity.method_37908().method_8335(entity, entity.method_5829().method_1009(radius, radius, radius));
        return nearbyEntities.stream().filter(e -> e instanceof class_1309).map(e -> (class_1309)e).filter(class_1309::method_6102).filter(e -> (double)entity.method_5739((class_1297)e) <= radius + (double)(e.method_17681() / 2.0f)).collect(Collectors.toList());
    }

    public static class_243 calculateFlightVector(class_1297 entity, class_243 target, double speed, double acceleration) {
        class_243 direction = target.method_1020(entity.method_19538()).method_1029();
        class_243 currentVel = entity.method_18798();
        class_243 targetVel = direction.method_1021(speed);
        return currentVel.method_1019(targetVel.method_1020(currentVel).method_1021(acceleration));
    }

    public static void smoothLookAt(class_1309 entity, class_1297 target, float maxYawChange, float maxPitchChange) {
        double dx = target.method_23317() - entity.method_23317();
        double dy = target.method_23320() - entity.method_23320();
        double dz = target.method_23321() - entity.method_23321();
        double horizontalDist = Math.sqrt(dx * dx + dz * dz);
        float targetYaw = (float)(Math.atan2(dz, dx) * 57.29577951308232) - 90.0f;
        float targetPitch = (float)(-(Math.atan2(dy, horizontalDist) * 57.29577951308232));
        float currentYaw = entity.method_36454();
        float prevYaw = entity.field_5982;
        float newYaw = DragonMathUtil.approachDegreesSmooth(currentYaw, prevYaw, targetYaw, maxYawChange, Math.max(1.0f, maxYawChange * 0.5f));
        entity.method_36456(newYaw);
        float currentPitch = entity.method_36455();
        float prevPitch = entity.field_6004;
        float newPitch = DragonMathUtil.approachDegreesSmooth(currentPitch, prevPitch, targetPitch, maxPitchChange, Math.max(1.0f, maxPitchChange * 0.5f));
        entity.method_36457(newPitch);
        entity.field_6283 = entity.method_36454();
    }

    public static boolean hasLineOfSight(class_1309 entity, class_1297 target) {
        if (entity instanceof class_1308) {
            class_1308 mob = (class_1308)entity;
            return mob.method_5985().method_6369(target);
        }
        return (double)entity.method_5739(target) < Objects.requireNonNull(entity.method_5996(class_5134.field_23717)).method_6194();
    }

    public static class_243 calculateDodgeDirection(class_1297 entity, class_1297 projectile) {
        class_243 projectileVel = new class_243(projectile.method_23317() - projectile.field_6014, projectile.method_23318() - projectile.field_6036, projectile.method_23321() - projectile.field_5969);
        if (projectileVel.method_1027() < 0.001) {
            return class_243.field_1353;
        }
        class_243 lateral = projectileVel.method_1029().method_1036(new class_243(0.0, 1.0, 0.0));
        if (lateral.method_1027() < 1.0E-6) {
            return class_243.field_1353;
        }
        lateral = lateral.method_1029();
        class_243 entityPos = entity.method_19538();
        class_243 predictedImpact = projectile.method_19538().method_1019(projectileVel.method_1021(20.0));
        class_243 leftPos = entityPos.method_1019(lateral);
        class_243 rightPos = entityPos.method_1019(lateral.method_1021(-1.0));
        if (rightPos.method_1020(predictedImpact).method_1027() > leftPos.method_1020(predictedImpact).method_1027()) {
            lateral = lateral.method_1021(-1.0);
        }
        return lateral;
    }

    public static float easeInOutCubic(float t) {
        return t < 0.5f ? 4.0f * t * t * t : 1.0f - (float)Math.pow(-2.0f * t + 2.0f, 3.0) / 2.0f;
    }

    public static float easeOutSine(float t) {
        return (float)Math.sin((double)t * Math.PI / 2.0);
    }

    public static float lerpSmooth(float start, float end, float progress, EasingFunction easing) {
        float easedProgress = switch (easing) {
            default -> throw new IncompatibleClassChangeError();
            case EasingFunction.LINEAR -> progress;
            case EasingFunction.EASE_IN_OUT_CUBIC -> DragonMathUtil.easeInOutCubic(progress);
            case EasingFunction.EASE_OUT_SINE -> DragonMathUtil.easeOutSine(progress);
        };
        return class_3532.method_16439((float)easedProgress, (float)start, (float)end);
    }

    public static class_243 clampVectorLength(class_243 vector, double maxLength) {
        double lengthSq = vector.method_1027();
        if (lengthSq > maxLength * maxLength) {
            return vector.method_1029().method_1021(maxLength);
        }
        return vector;
    }

    public static class_243 addHorizontalMovement(class_243 currentVel, class_243 addedVel) {
        return new class_243(currentVel.field_1352 + addedVel.field_1352, currentVel.field_1351, currentVel.field_1350 + addedVel.field_1350);
    }

    public static class_243 calculateRepulsionForce(class_1297 center, class_1297 target, double radius, double strength) {
        class_243 direction = target.method_19538().method_1020(center.method_19538());
        double distance = direction.method_1033();
        if (distance >= radius || distance == 0.0) {
            return class_243.field_1353;
        }
        double force = strength * (1.0 - distance / radius) * (1.0 - distance / radius);
        return direction.method_1029().method_1021(force);
    }

    public static Quaternionf quatFromRotationXYZ(float x, float y, float z, boolean degrees) {
        if (degrees) {
            x = (float)Math.toRadians(x);
            y = (float)Math.toRadians(y);
            z = (float)Math.toRadians(z);
        }
        return new Quaternionf().rotationXYZ(x, y, z);
    }

    public static double clampAltitude(double currentY, double groundY, double minAbove, double maxAbove) {
        return class_3532.method_15350((double)currentY, (double)(groundY + minAbove), (double)(groundY + maxAbove));
    }

    public static float yawErrorToTarget(class_1297 self, class_1297 target) {
        float wantedYaw = (float)(Math.atan2(target.method_23321() - self.method_23321(), target.method_23317() - self.method_23317()) * 180.0 / Math.PI) - 90.0f;
        return Math.abs(class_3532.method_15381((float)self.method_36454(), (float)wantedYaw));
    }

    public static enum EasingFunction {
        LINEAR,
        EASE_IN_OUT_CUBIC,
        EASE_OUT_SINE;

    }
}

