/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.model.cindervane;

import com.leon.saintsdragons.SaintsDragons;
import com.leon.saintsdragons.server.entity.dragons.cindervane.Cindervane;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.state.BoneSnapshot;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;

public class CindervaneModel
extends DefaultedEntityGeoModel<Cindervane> {
    private static final ResourceLocation MALE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"saintsdragons", (String)"textures/entity/cindervane/cindervane.png");
    private static final ResourceLocation FEMALE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"saintsdragons", (String)"textures/entity/cindervane/cindervane_female.png");

    public CindervaneModel() {
        super(SaintsDragons.rl("cindervane"), "head");
    }

    public void setCustomAnimations(Cindervane entity, long instanceId, AnimationState<Cindervane> animationState) {
        super.setCustomAnimations((GeoAnimatable)entity, instanceId, animationState);
        if (entity.m_6084_()) {
            this.applyBankingRoll(entity, animationState);
            this.applyNeckFollow();
        }
    }

    public ResourceLocation getTextureResource(Cindervane entity) {
        return entity.isFemale() ? FEMALE_TEXTURE : MALE_TEXTURE;
    }

    private void applyBankingRoll(Cindervane entity, AnimationState<Cindervane> state) {
        Optional bodyOpt = this.getBone("body");
        if (bodyOpt.isEmpty()) {
            return;
        }
        GeoBone body = (GeoBone)bodyOpt.get();
        BoneSnapshot snap = body.getInitialSnapshot();
        float partialTick = state.getPartialTick();
        float bankAngleDeg = entity.getBankAngleDegrees(partialTick);
        float bankAngleRad = Mth.m_14036_((float)(-bankAngleDeg * ((float)Math.PI / 180)), (float)-1.5707964f, (float)1.5707964f);
        body.setRotZ(snap.getRotZ() + bankAngleRad);
    }

    private void applyNeckFollow() {
        Optional headOpt = this.getBone("head");
        if (headOpt.isEmpty()) {
            return;
        }
        GeoBone head = (GeoBone)headOpt.get();
        BoneSnapshot snapshot = head.getInitialSnapshot();
        float headDeltaX = head.getRotX() - snapshot.getRotX();
        float headDeltaY = head.getRotY() - snapshot.getRotY();
        headDeltaX = Mth.m_14036_((float)headDeltaX, (float)-0.35f, (float)0.35f);
        headDeltaY = Mth.m_14036_((float)headDeltaY, (float)-0.45f, (float)0.45f);
        head.setRotX(snapshot.getRotX());
        head.setRotY(snapshot.getRotY());
        this.applyNeckBoneFollow("neck1LookControl", headDeltaX, headDeltaY, 0.4f);
        this.applyNeckBoneFollow("neck2LookControl", headDeltaX, headDeltaY, 0.6f);
    }

    private void applyNeckBoneFollow(String boneName, float headDeltaX, float headDeltaY, float weight) {
        Optional boneOpt = this.getBone(boneName);
        if (boneOpt.isEmpty()) {
            return;
        }
        GeoBone bone = (GeoBone)boneOpt.get();
        BoneSnapshot snapshot = bone.getInitialSnapshot();
        bone.setRotX(snapshot.getRotX() + headDeltaX * weight);
        bone.setRotY(snapshot.getRotY() + headDeltaY * weight);
    }
}

