/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.model.nulljaw;

import com.leon.saintsdragons.SaintsDragons;
import com.leon.saintsdragons.server.entity.dragons.nulljaw.Nulljaw;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.state.BoneSnapshot;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;

public class NulljawModel
extends DefaultedEntityGeoModel<Nulljaw> {
    private static final ResourceLocation MALE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"saintsdragons", (String)"textures/entity/nulljaw/nulljaw.png");
    private static final ResourceLocation FEMALE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"saintsdragons", (String)"textures/entity/nulljaw/nulljaw_female.png");

    public NulljawModel() {
        super(SaintsDragons.rl("nulljaw"), "head");
    }

    public ResourceLocation getTextureResource(Nulljaw entity) {
        return entity.isFemale() ? FEMALE_TEXTURE : MALE_TEXTURE;
    }

    public void setCustomAnimations(Nulljaw entity, long instanceId, AnimationState<Nulljaw> animationState) {
        super.setCustomAnimations((GeoAnimatable)entity, instanceId, animationState);
        if (entity.m_6084_() && entity.m_6069_()) {
            this.applySwimRoll(entity, animationState);
        }
        this.applyNeckFollow();
        this.applyHeadClamp(entity);
    }

    private void applySwimRoll(Nulljaw entity, AnimationState<Nulljaw> state) {
        Optional bodyOpt = this.getBone("root");
        if (bodyOpt.isEmpty()) {
            return;
        }
        GeoBone body = (GeoBone)bodyOpt.get();
        float partialTick = state.getPartialTick();
        float swimRollDeg = entity.getSwimRollAngleDegrees(partialTick);
        float swimRollRad = Mth.m_14036_((float)(-swimRollDeg * ((float)Math.PI / 180)), (float)-1.5707964f, (float)1.5707964f);
        body.setRotZ(body.getRotZ() + swimRollRad);
    }

    private void applyHeadClamp(Nulljaw entity) {
        Optional headOpt = this.getBone("head");
        if (headOpt.isEmpty()) {
            return;
        }
        GeoBone head = (GeoBone)headOpt.get();
        BoneSnapshot snap = head.getInitialSnapshot();
        float deltaY = head.getRotY() - snap.getRotY();
        float deltaX = head.getRotX() - snap.getRotX();
        float yawClamp = 0.8f;
        float pitchClamp = 0.7f;
        deltaY = Mth.m_14036_((float)deltaY, (float)(-yawClamp), (float)yawClamp);
        deltaX = Mth.m_14036_((float)deltaX, (float)(-pitchClamp), (float)pitchClamp);
        head.setRotY(snap.getRotY() + deltaY);
        head.setRotX(snap.getRotX() + deltaX);
    }

    private void applyNeckFollow() {
        Optional headOpt = this.getBone("head");
        if (headOpt.isEmpty()) {
            return;
        }
        GeoBone head = (GeoBone)headOpt.get();
        float headDeltaX = head.getRotX() - head.getInitialSnapshot().getRotX();
        float headDeltaY = head.getRotY() - head.getInitialSnapshot().getRotY();
        head.setRotX(head.getInitialSnapshot().getRotX());
        head.setRotY(head.getInitialSnapshot().getRotY());
        this.applyNeckBoneFollow("neck1LookControl", headDeltaX, headDeltaY, 0.15f);
        this.applyNeckBoneFollow("neck2LookControl", headDeltaX, headDeltaY, 0.25f);
        this.applyNeckBoneFollow("neck3LookControl", headDeltaX, headDeltaY, 0.35f);
    }

    private void applyNeckBoneFollow(String boneName, float headDeltaX, float headDeltaY, float weight) {
        Optional boneOpt = this.getBone(boneName);
        if (boneOpt.isEmpty()) {
            return;
        }
        GeoBone bone = (GeoBone)boneOpt.get();
        BoneSnapshot snap = bone.getInitialSnapshot();
        float addX = headDeltaX * weight;
        float addY = headDeltaY * weight;
        bone.setRotX(snap.getRotX() + addX);
        bone.setRotY(snap.getRotY() + addY);
    }
}

