/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.model.raevyx;

import com.leon.saintsdragons.SaintsDragons;
import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.state.BoneSnapshot;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;

public class RaevyxModel
extends DefaultedEntityGeoModel<Raevyx> {
    private static final ResourceLocation ADULT_MODEL = ResourceLocation.fromNamespaceAndPath((String)"saintsdragons", (String)"geo/entity/raevyx.geo.json");
    private static final ResourceLocation FEMALE_MODEL = ResourceLocation.fromNamespaceAndPath((String)"saintsdragons", (String)"geo/entity/raevyx.geo.json");
    private static final ResourceLocation BABY_MODEL = ResourceLocation.fromNamespaceAndPath((String)"saintsdragons", (String)"geo/entity/baby_raevyx.geo.json");
    private static final ResourceLocation ADULT_ANIM = ResourceLocation.fromNamespaceAndPath((String)"saintsdragons", (String)"animations/entity/raevyx.animation.json");
    private static final ResourceLocation BABY_ANIM = ResourceLocation.fromNamespaceAndPath((String)"saintsdragons", (String)"animations/entity/baby_raevyx.animation.json");
    private static final ResourceLocation MALE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"saintsdragons", (String)"textures/entity/raevyx/raevyx.png");
    private static final ResourceLocation FEMALE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"saintsdragons", (String)"textures/entity/raevyx/raevyx_female.png");
    private static final ResourceLocation BABY_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"saintsdragons", (String)"textures/entity/raevyx/baby_raevyx.png");
    private final Map<Integer, SmoothedHeadState> headStates = new HashMap<Integer, SmoothedHeadState>();

    public RaevyxModel() {
        super(SaintsDragons.rl("raevyx"), "head");
    }

    public ResourceLocation getModelResource(Raevyx entity) {
        if (entity.m_6162_()) {
            return BABY_MODEL;
        }
        if (entity.isFemale()) {
            return FEMALE_MODEL;
        }
        return ADULT_MODEL;
    }

    public ResourceLocation getTextureResource(Raevyx entity) {
        if (entity.m_6162_()) {
            return BABY_TEXTURE;
        }
        return entity.isFemale() ? FEMALE_TEXTURE : MALE_TEXTURE;
    }

    public ResourceLocation getAnimationResource(Raevyx entity) {
        return entity.m_6162_() ? BABY_ANIM : ADULT_ANIM;
    }

    public void setCustomAnimations(Raevyx entity, long instanceId, AnimationState<Raevyx> animationState) {
        if (!entity.m_20160_()) {
            super.setCustomAnimations((GeoAnimatable)entity, instanceId, animationState);
        }
        if (entity.m_6084_()) {
            this.applyBankingRoll(entity, animationState);
            if (entity.m_20160_()) {
                this.applyManualHeadTracking(entity, animationState);
            }
            this.applyNeckFollow(entity, animationState);
            this.applyHeadClamp(entity);
        }
    }

    private void applyManualHeadTracking(Raevyx entity, AnimationState<Raevyx> state) {
        Optional headOpt = this.getBone("head");
        if (headOpt.isEmpty()) {
            return;
        }
        GeoBone head = (GeoBone)headOpt.get();
        BoneSnapshot headSnap = head.getInitialSnapshot();
        float partialTick = state.getPartialTick();
        float entityYaw = entity.f_20883_;
        float headYaw = Mth.m_14179_((float)partialTick, (float)entity.f_20886_, (float)entity.f_20885_);
        float headPitch = Mth.m_14179_((float)partialTick, (float)entity.f_19860_, (float)entity.m_146909_());
        float targetYaw = Mth.m_14118_((float)entityYaw, (float)headYaw) * ((float)Math.PI / 180);
        float targetPitch = -headPitch * ((float)Math.PI / 180);
        SmoothedHeadState smoothing = this.headStates.computeIfAbsent(entity.m_19879_(), k -> new SmoothedHeadState());
        float alpha = 0.025f;
        smoothing.smoothedYaw = smoothing.smoothedYaw * (1.0f - alpha) + targetYaw * alpha;
        smoothing.smoothedPitch = smoothing.smoothedPitch * (1.0f - alpha) + targetPitch * alpha;
        head.setRotY(headSnap.getRotY() + smoothing.smoothedYaw);
        head.setRotX(headSnap.getRotX() + smoothing.smoothedPitch);
    }

    private void applyBankingRoll(Raevyx entity, AnimationState<Raevyx> state) {
        Optional bodyOpt = this.getBone("body");
        if (bodyOpt.isEmpty()) {
            return;
        }
        GeoBone body = (GeoBone)bodyOpt.get();
        BoneSnapshot snap = body.getInitialSnapshot();
        float partialTick = state.getPartialTick();
        float bankAngleDeg = entity.getBankAngleDegrees(partialTick);
        float bankAngleRad = Mth.m_14036_((float)(-bankAngleDeg * ((float)Math.PI / 180)), (float)-1.5707964f, (float)1.5707964f);
        body.setRotZ(snap.getRotZ() + bankAngleRad);
    }

    private void applyHeadClamp(Raevyx entity) {
        Optional headOpt = this.getBone("head");
        if (headOpt.isEmpty()) {
            return;
        }
        GeoBone head = (GeoBone)headOpt.get();
        BoneSnapshot snap = head.getInitialSnapshot();
        float deltaY = head.getRotY() - snap.getRotY();
        float deltaX = head.getRotX() - snap.getRotX();
        float yawClamp = entity.m_29443_() ? 0.9f : 0.6f;
        float pitchClamp = entity.m_29443_() ? 1.0f : 0.5f;
        deltaY = Mth.m_14036_((float)deltaY, (float)(-yawClamp), (float)yawClamp);
        deltaX = Mth.m_14036_((float)deltaX, (float)(-pitchClamp), (float)pitchClamp);
        head.setRotY(snap.getRotY() + deltaY);
        head.setRotX(snap.getRotX() + deltaX);
    }

    private void applyNeckFollow(Raevyx entity, AnimationState<Raevyx> state) {
        Optional headOpt = this.getBone("head");
        if (headOpt.isEmpty()) {
            return;
        }
        GeoBone head = (GeoBone)headOpt.get();
        BoneSnapshot headSnap = head.getInitialSnapshot();
        float basePitch = head.getRotX() - headSnap.getRotX();
        float baseYaw = head.getRotY() - headSnap.getRotY();
        float targetPitch = basePitch;
        float targetYaw = baseYaw;
        if (entity.isBeaming()) {
            targetPitch -= entity.getBeamPitchOffsetRad();
            targetYaw += entity.getBeamYawOffsetRad();
            float maxPitch = 0.87266463f;
            float maxYaw = 0.6981317f;
            targetPitch = Mth.m_14036_((float)targetPitch, (float)(-maxPitch), (float)maxPitch);
            targetYaw = Mth.m_14036_((float)targetYaw, (float)(-maxYaw), (float)maxYaw);
        }
        head.setRotX(headSnap.getRotX());
        head.setRotY(headSnap.getRotY());
        float[] weights = entity.isBeaming() ? Raevyx.BEAM_NECK_WEIGHTS : Raevyx.IDLE_NECK_WEIGHTS;
        this.applyNeckBoneFollow("neck1LookControl", targetPitch, targetYaw, weights[0]);
        this.applyNeckBoneFollow("neck2LookControl", targetPitch, targetYaw, weights[1]);
        this.applyNeckBoneFollow("neck3LookControl", targetPitch, targetYaw, weights[2]);
        this.applyNeckBoneFollow("neck4LookControl", targetPitch, targetYaw, weights[3]);
        head.setRotX(headSnap.getRotX() + targetPitch);
        head.setRotY(headSnap.getRotY() + targetYaw);
    }

    private void applyNeckBoneFollow(String boneName, float headDeltaX, float headDeltaY, float weight) {
        Optional boneOpt = this.getBone(boneName);
        if (boneOpt.isEmpty()) {
            return;
        }
        GeoBone bone = (GeoBone)boneOpt.get();
        BoneSnapshot snap = bone.getInitialSnapshot();
        float addX = headDeltaX * weight;
        float addY = headDeltaY * weight;
        bone.setRotX(snap.getRotX() + addX);
        bone.setRotY(snap.getRotY() + addY);
    }

    private static class SmoothedHeadState {
        float smoothedYaw = 0.0f;
        float smoothedPitch = 0.0f;

        private SmoothedHeadState() {
        }
    }
}

