/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.renderer.raevyx;

import com.leon.saintsdragons.client.model.raevyx.RaevyxModel;
import com.leon.saintsdragons.client.renderer.layer.raevyx.RaevyxLightningBeamLayer;
import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

@OnlyIn(value=Dist.CLIENT)
public class RaevyxRenderer
extends GeoEntityRenderer<Raevyx> {
    private BakedGeoModel lastBakedModel;
    private static final ResourceLocation TEXTURE_MALE = ResourceLocation.fromNamespaceAndPath((String)"saintsdragons", (String)"textures/entity/raevyx/raevyx.png");
    private static final ResourceLocation TEXTURE_FEMALE = ResourceLocation.fromNamespaceAndPath((String)"saintsdragons", (String)"textures/entity/raevyx/raevyx_female.png");
    private static final ResourceLocation TEXTURE_BABY = ResourceLocation.fromNamespaceAndPath((String)"saintsdragons", (String)"textures/entity/raevyx/baby_raevyx.png");
    private static final float L_LEFT_X = 2.2f;
    private static final float L_LEFT_Y = 0.05f;
    private static final float L_LEFT_Z = 2.85f;
    private static final float L_RIGHT_X = -2.2f;
    private static final float L_RIGHT_Y = 0.05f;
    private static final float L_RIGHT_Z = 2.85f;
    private static final float MOUTH_X = 0.1f;
    private static final float MOUTH_Y = 8.7f;
    private static final float MOUTH_Z = -17.4f;
    private static final float BODY_X = 0.0f;
    private static final float BODY_Y = 10.0f;
    private static final float BODY_Z = 0.0f;
    private static final float PASSENGER_X = 0.0f;
    private static final float PASSENGER_Y = -3.0f;
    private static final float PASSENGER_Z = 0.0f;

    public RaevyxRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new RaevyxModel());
        this.addRenderLayer(new RaevyxLightningBeamLayer());
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull Raevyx entity) {
        if (entity.m_6162_()) {
            return TEXTURE_BABY;
        }
        return entity.isFemale() ? TEXTURE_FEMALE : TEXTURE_MALE;
    }

    protected float getDeathMaxRotation(Raevyx entity) {
        return 0.0f;
    }

    public void preRender(PoseStack poseStack, Raevyx entity, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        float scale = 1.0f;
        poseStack.m_85841_(scale, scale, scale);
        this.f_114477_ = 2.0f * scale;
        this.lastBakedModel = model;
        this.enableTrackingForBones(model);
        super.preRender(poseStack, (Entity)entity, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void render(@NotNull Raevyx entity, float entityYaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        super.m_7392_((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        this.sampleAndStashLocatorsAccurate(entity);
    }

    public RenderType getRenderType(Raevyx animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.m_110458_((ResourceLocation)texture);
    }

    private void enableTrackingForBones(BakedGeoModel model) {
        if (model == null) {
            return;
        }
        model.getBone("leftfeet").ifPresent(b -> b.setTrackingMatrices(true));
        model.getBone("rightfeet").ifPresent(b -> b.setTrackingMatrices(true));
        model.getBone("head").ifPresent(b -> b.setTrackingMatrices(true));
        model.getBone("heightController").ifPresent(b -> b.setTrackingMatrices(true));
        model.getBone("passengerBone").ifPresent(b -> b.setTrackingMatrices(true));
    }

    private void sampleAndStashLocatorsAccurate(Raevyx entity) {
        if (this.lastBakedModel == null || entity == null) {
            return;
        }
        this.lastBakedModel.getBone("leftfeet").ifPresent(b -> {
            Vec3 world = RaevyxRenderer.transformLocator(b, 2.2f, 0.05f, 2.85f);
            if (world != null) {
                entity.setClientLocatorPosition("leftfeetLocator", world);
            }
        });
        this.lastBakedModel.getBone("rightfeet").ifPresent(b -> {
            Vec3 world = RaevyxRenderer.transformLocator(b, -2.2f, 0.05f, 2.85f);
            if (world != null) {
                entity.setClientLocatorPosition("rightfeetLocator", world);
            }
        });
        this.lastBakedModel.getBone("head").ifPresent(b -> {
            Vec3 world = RaevyxRenderer.transformLocator(b, 0.1f, 8.7f, -17.4f);
            if (world != null) {
                entity.setClientLocatorPosition("mouth_origin", world);
            }
        });
        this.lastBakedModel.getBone("heightController").ifPresent(b -> {
            Vec3 world = RaevyxRenderer.transformLocator(b, 0.0f, 10.0f, 0.0f);
            if (world != null) {
                entity.setClientLocatorPosition("bodyLocator", world);
            }
        });
        this.lastBakedModel.getBone("passengerBone").ifPresent(b -> {
            Vec3 world = RaevyxRenderer.transformLocator(b, 0.0f, -3.0f, 0.0f);
            if (world != null) {
                entity.setClientLocatorPosition("passengerLocator", world);
            }
        });
    }

    private static Vec3 transformLocator(GeoBone bone, float px, float py, float pz) {
        if (bone == null) {
            return null;
        }
        float lx = px / 16.0f;
        float ly = py / 16.0f;
        float lz = pz / 16.0f;
        Matrix4f worldMat = new Matrix4f((Matrix4fc)bone.getWorldSpaceMatrix());
        Vector4f in = new Vector4f(lx, ly, lz, 1.0f);
        Vector4f out = worldMat.transform(in);
        return new Vec3((double)out.x(), (double)out.y(), (double)out.z());
    }
}

