/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.screen;

import com.leon.saintsdragons.SaintsDragons;
import com.leon.saintsdragons.common.network.MessageDragonAllyManagement;
import com.leon.saintsdragons.common.network.MessageDragonAllyRequest;
import com.leon.saintsdragons.common.network.ModNetworkHandler;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class DragonAllyScreen
extends Screen {
    private final DragonEntity dragon;
    private static final int GUI_WIDTH = 256;
    private static final int GUI_HEIGHT = 200;
    private int leftPos;
    private int topPos;
    private EditBox usernameInput;
    private List<String> allyList;
    private int scrollOffset = 0;
    private static final int MAX_VISIBLE_ALLIES = 8;

    private int getActualGuiWidth() {
        return Math.min(256, this.f_96543_ - 40);
    }

    private int getActualGuiHeight() {
        return Math.min(200, this.f_96544_ - 40);
    }

    public DragonAllyScreen(DragonEntity dragon) {
        super((Component)Component.m_237115_((String)"saintsdragons.gui.dragon_ally.title"));
        this.dragon = dragon;
        this.allyList = new ArrayList<String>();
    }

    protected void m_7856_() {
        super.m_7856_();
        int actualWidth = this.getActualGuiWidth();
        int actualHeight = this.getActualGuiHeight();
        this.leftPos = Math.max(0, (this.f_96543_ - actualWidth) / 2);
        this.topPos = Math.max(0, (this.f_96544_ - actualHeight) / 2);
        if (this.topPos + actualHeight > this.f_96544_ - 20) {
            this.topPos = this.f_96544_ - actualHeight - 20;
        }
        SaintsDragons.LOGGER.info("GUI positioning - Screen: {}x{}, GUI: {}x{}, Position: ({}, {})", new Object[]{this.f_96543_, this.f_96544_, 256, 200, this.leftPos, this.topPos});
        this.requestAllyListFromServer();
        this.usernameInput = new EditBox(this.f_96547_, this.leftPos + 20, this.topPos + 30, 150, 20, (Component)Component.m_237115_((String)"saintsdragons.gui.dragon_ally.username_input"));
        this.usernameInput.m_94199_(16);
        this.m_142416_((GuiEventListener)this.usernameInput);
        Button addButton = Button.m_253074_((Component)Component.m_237115_((String)"saintsdragons.gui.dragon_ally.add"), button -> this.addAlly()).m_252987_(this.leftPos + 180, this.topPos + 30, 60, 20).m_253136_();
        this.m_142416_((GuiEventListener)addButton);
        Button removeButton = Button.m_253074_((Component)Component.m_237115_((String)"saintsdragons.gui.dragon_ally.remove"), button -> this.removeAlly()).m_252987_(this.leftPos + 180, this.topPos + 55, 60, 20).m_253136_();
        this.m_142416_((GuiEventListener)removeButton);
        Button closeButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.cancel"), button -> this.m_7379_()).m_252987_(this.leftPos + 256 - 60, this.topPos + 200 - 50, 50, 20).m_253136_();
        this.m_142416_((GuiEventListener)closeButton);
        this.m_264313_((GuiEventListener)this.usernameInput);
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        int actualWidth = this.getActualGuiWidth();
        int actualHeight = this.getActualGuiHeight();
        guiGraphics.m_280509_(this.leftPos, this.topPos, this.leftPos + actualWidth, this.topPos + actualHeight, Integer.MIN_VALUE);
        guiGraphics.m_280509_(this.leftPos, this.topPos, this.leftPos + actualWidth, this.topPos + 1, -2838729);
        guiGraphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 1, this.topPos + actualHeight, -2838729);
        guiGraphics.m_280509_(this.leftPos + actualWidth - 1, this.topPos, this.leftPos + actualWidth, this.topPos + actualHeight, -2838729);
        guiGraphics.m_280509_(this.leftPos, this.topPos + actualHeight - 1, this.leftPos + actualWidth, this.topPos + actualHeight, -2838729);
        guiGraphics.m_280509_(this.leftPos + 10, this.topPos + 10, this.leftPos + actualWidth - 10, this.topPos + 12, -4684277);
        guiGraphics.m_280509_(this.leftPos + 10, this.topPos + actualHeight - 12, this.leftPos + actualWidth - 10, this.topPos + actualHeight - 10, -4684277);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.leftPos + 128, this.topPos + 16, 0x404040);
        String allyCountText = Component.m_237110_((String)"saintsdragons.gui.dragon_ally.count", (Object[])new Object[]{this.allyList.size(), this.dragon.allyManager.getMaxAllies()}).getString();
        guiGraphics.m_280488_(this.f_96547_, allyCountText, this.leftPos + 20, this.topPos + 80, 0x404040);
        this.drawAllyList(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void drawAllyList(GuiGraphics guiGraphics) {
        int index;
        int startY = this.topPos + 100;
        int endY = this.topPos + 200 - 40;
        int visibleCount = Math.min(8, this.allyList.size() - this.scrollOffset);
        for (int i = 0; i < visibleCount && (index = i + this.scrollOffset) < this.allyList.size(); ++i) {
            String allyName = this.allyList.get(index);
            int y = startY + i * 12;
            int color = 0x404040;
            guiGraphics.m_280488_(this.f_96547_, allyName, this.leftPos + 20, y, color);
        }
        if (this.allyList.size() > 8) {
            if (this.scrollOffset > 0) {
                guiGraphics.m_280488_(this.f_96547_, "\u2191", this.leftPos + 256 - 20, startY, 0x404040);
            }
            if (this.scrollOffset + 8 < this.allyList.size()) {
                guiGraphics.m_280488_(this.f_96547_, "\u2193", this.leftPos + 256 - 20, endY - 12, 0x404040);
            }
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.allyList.size() > 8) {
            if (delta < 0.0 && this.scrollOffset < this.allyList.size() - 8) {
                ++this.scrollOffset;
            } else if (delta > 0.0 && this.scrollOffset > 0) {
                --this.scrollOffset;
            }
            return true;
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int index;
            int startY = this.topPos + 100;
            for (int i = 0; i < Math.min(8, this.allyList.size() - this.scrollOffset) && (index = i + this.scrollOffset) < this.allyList.size(); ++i) {
                int y = startY + i * 12;
                if (!(mouseX >= (double)(this.leftPos + 20)) || !(mouseX <= (double)(this.leftPos + 256 - 40)) || !(mouseY >= (double)y) || !(mouseY < (double)(y + 12))) continue;
                String allyName = this.allyList.get(index);
                this.usernameInput.m_94144_(allyName);
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private void addAlly() {
        String username = this.usernameInput.m_94155_().trim();
        if (username.isEmpty()) {
            return;
        }
        ModNetworkHandler.sendToServer(new MessageDragonAllyManagement(this.dragon.m_19879_(), MessageDragonAllyManagement.Action.ADD, username));
        this.usernameInput.m_94144_("");
    }

    private void removeAlly() {
        String username = this.usernameInput.m_94155_().trim();
        if (username.isEmpty()) {
            return;
        }
        ModNetworkHandler.sendToServer(new MessageDragonAllyManagement(this.dragon.m_19879_(), MessageDragonAllyManagement.Action.REMOVE, username));
        this.usernameInput.m_94144_("");
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 257) {
            this.addAlly();
            return true;
        }
        return false;
    }

    public boolean m_7043_() {
        return false;
    }

    private void requestAllyListFromServer() {
        ModNetworkHandler.sendToServer(new MessageDragonAllyRequest(this.dragon.m_19879_()));
    }

    public void updateAllyList(List<String> newAllyList) {
        this.allyList = newAllyList;
        this.scrollOffset = Math.min(this.scrollOffset, Math.max(0, this.allyList.size() - 8));
    }
}

