/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.common.network;

import com.leon.saintsdragons.common.network.MessageDragonAllyList;
import com.leon.saintsdragons.common.network.ModNetworkHandler;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.handler.DragonAllyManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class MessageDragonAllyManagement {
    private final int dragonId;
    private final Action action;
    private final String username;

    public MessageDragonAllyManagement(int dragonId, Action action, String username) {
        this.dragonId = dragonId;
        this.action = action;
        this.username = username;
    }

    public MessageDragonAllyManagement(FriendlyByteBuf buffer) {
        this.dragonId = buffer.readInt();
        this.action = (Action)buffer.m_130066_(Action.class);
        this.username = buffer.m_130136_(16);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.dragonId);
        buffer.m_130068_((Enum)this.action);
        buffer.m_130072_(this.username, 16);
    }

    public static void handle(MessageDragonAllyManagement message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            MutableComponent resultMessage;
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            Entity entity = player.m_9236_().m_6815_(message.dragonId);
            if (!(entity instanceof DragonEntity)) {
                player.m_213846_((Component)Component.m_237115_((String)"saintsdragons.message.dragon_not_found"));
                return;
            }
            DragonEntity dragon = (DragonEntity)entity;
            if (!dragon.m_21824_() || !dragon.m_21830_((LivingEntity)player)) {
                player.m_213846_((Component)Component.m_237115_((String)"saintsdragons.message.not_dragon_owner"));
                return;
            }
            DragonAllyManager allyManager = dragon.allyManager;
            DragonAllyManager.AllyResult result = switch (message.action) {
                case Action.ADD -> allyManager.addAlly(message.username);
                case Action.REMOVE -> allyManager.removeAlly(message.username);
                default -> DragonAllyManager.AllyResult.INVALID_USERNAME;
            };
            if (result == DragonAllyManager.AllyResult.EASTER_EGG) {
                switch (message.username.toLowerCase()) {
                    case "notch": {
                        resultMessage = Component.m_237115_((String)"saintsdragons.message.easter_egg.notch");
                        break;
                    }
                    case "jeb_": {
                        resultMessage = Component.m_237115_((String)"saintsdragons.message.easter_egg.jeb_");
                        break;
                    }
                    case "dinnerbone": {
                        resultMessage = Component.m_237115_((String)"saintsdragons.message.easter_egg.dinnerbone");
                        break;
                    }
                    case "grumm": {
                        resultMessage = Component.m_237115_((String)"saintsdragons.message.easter_egg.grumm");
                        break;
                    }
                    case "herobrine": {
                        resultMessage = Component.m_237115_((String)"saintsdragons.message.easter_egg.herobrine");
                        break;
                    }
                    default: {
                        resultMessage = Component.m_237115_((String)"saintsdragons.message.ally.easter_egg");
                        break;
                    }
                }
            } else {
                resultMessage = Component.m_237110_((String)("saintsdragons.message.ally." + result.name().toLowerCase()), (Object[])new Object[]{message.username});
            }
            player.m_213846_((Component)resultMessage);
            ModNetworkHandler.sendToPlayer(player, new MessageDragonAllyList(dragon.m_19879_(), allyManager.getAllyUsernames()));
        });
        context.setPacketHandled(true);
    }

    public static enum Action {
        ADD,
        REMOVE;

    }
}

